/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.callMatcher;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CallMatcher
extends Predicate<PsiMethodCallExpression> {
    public Stream<String> names();

    public boolean methodReferenceMatches(PsiMethodReferenceExpression var1);

    @Override
    @Contract(value="null -> false")
    public boolean test(@Nullable PsiMethodCallExpression var1);

    @Contract(value="null -> false")
    default public boolean matches(@Nullable PsiExpression expression) {
        return (expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiMethodCallExpression && this.test((PsiMethodCallExpression)expression);
    }

    public static CallMatcher anyOf(final CallMatcher ... matchers) {
        return new CallMatcher(){

            @Override
            public Stream<String> names() {
                return Stream.of(matchers).flatMap(CallMatcher::names);
            }

            @Override
            public boolean methodReferenceMatches(PsiMethodReferenceExpression methodRef) {
                for (CallMatcher m : matchers) {
                    if (!m.methodReferenceMatches(methodRef)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean test(PsiMethodCallExpression call) {
                for (CallMatcher m : matchers) {
                    if (!m.test(call)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return Stream.of(matchers).map(Object::toString).collect(Collectors.joining(" or ", "{", "}"));
            }
        };
    }

    public static Simple instanceCall(@NotNull String className, String ... methodNames) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/siyeh/ig/callMatcher/CallMatcher", "instanceCall"));
        }
        return new Simple(className, (Set)ContainerUtil.newTroveSet(methodNames), null, false);
    }

    public static Simple staticCall(@NotNull String className, String ... methodNames) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/siyeh/ig/callMatcher/CallMatcher", "staticCall"));
        }
        return new Simple(className, (Set)ContainerUtil.newTroveSet(methodNames), null, true);
    }

    public static class Simple
    implements CallMatcher {
        @NotNull
        private final String myClassName;
        @NotNull
        private final Set<String> myNames;
        @Nullable
        private final String[] myParameters;
        private final boolean myStatic;

        private Simple(@NotNull String className, @NotNull Set<String> names, @Nullable String[] parameters, boolean aStatic) {
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/siyeh/ig/callMatcher/CallMatcher$Simple", "<init>"));
            }
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/siyeh/ig/callMatcher/CallMatcher$Simple", "<init>"));
            }
            this.myClassName = className;
            this.myNames = names;
            this.myParameters = parameters;
            this.myStatic = aStatic;
        }

        @Override
        public Stream<String> names() {
            return this.myNames.stream();
        }

        public Simple parameterCount(int count) {
            if (this.myParameters != null) {
                throw new IllegalStateException("Parameter count is already set to " + count);
            }
            return new Simple(this.myClassName, this.myNames, count == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : new String[count], this.myStatic);
        }

        public Simple parameterTypes(String ... types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/siyeh/ig/callMatcher/CallMatcher$Simple", "parameterTypes"));
            }
            if (this.myParameters != null) {
                throw new IllegalStateException("Parameters are already registered");
            }
            return new Simple(this.myClassName, this.myNames, types.length == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : (String[])types.clone(), this.myStatic);
        }

        private static boolean parameterTypeMatches(String type, PsiParameter parameter) {
            if (type == null) {
                return true;
            }
            PsiType psiType = parameter.getType();
            return psiType.equalsToText(type) || psiType instanceof PsiClassType && ((PsiClassType)psiType).rawType().equalsToText(type);
        }

        @Override
        public boolean methodReferenceMatches(PsiMethodReferenceExpression methodRef) {
            if (methodRef == null) {
                return false;
            }
            String name = methodRef.getReferenceName();
            if (!this.myNames.contains(name)) {
                return false;
            }
            PsiMethod method = ObjectUtils.tryCast(methodRef.resolve(), PsiMethod.class);
            if (!this.methodMatches(method)) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            return this.parametersMatch(parameterList);
        }

        @Override
        public boolean test(PsiMethodCallExpression call) {
            if (call == null) {
                return false;
            }
            String name = call.getMethodExpression().getReferenceName();
            if (!this.myNames.contains(name)) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (this.myParameters != null && this.myParameters.length > 0 && args.length < this.myParameters.length) {
                return false;
            }
            PsiMethod method = call.resolveMethod();
            if (!this.methodMatches(method)) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() > args.length || !MethodCallUtils.isVarArgCall(call) && parameterList.getParametersCount() < args.length) {
                return false;
            }
            return this.parametersMatch(parameterList);
        }

        private boolean parametersMatch(@NotNull PsiParameterList parameterList) {
            if (parameterList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/siyeh/ig/callMatcher/CallMatcher$Simple", "parametersMatch"));
            }
            if (this.myParameters == null) {
                return true;
            }
            if (this.myParameters.length != parameterList.getParametersCount()) {
                return false;
            }
            return StreamEx.zip((Object[])this.myParameters, (Object[])parameterList.getParameters(), Simple::parameterTypeMatches).allMatch(Boolean.TRUE::equals);
        }

        @Contract(value="null -> false")
        private boolean methodMatches(PsiMethod method) {
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            return this.myStatic == method.getModifierList().hasExplicitModifier("static") && (!this.myStatic || this.myClassName.equals(aClass.getQualifiedName())) && (this.myStatic || InheritanceUtil.isInheritor(aClass, this.myClassName));
        }

        public String toString() {
            return this.myClassName + "." + String.join((CharSequence)"|", this.myNames);
        }
    }
}

