/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.fileEditor.impl.LoadTextUtil");
    @Nls
    private static final String AUTO_DETECTED_FROM_BOM = "auto-detected from BOM";
    private static final int UNLIMITED = -1;
    private static final Charset INTERNAL_SEVEN_BIT_UTF8 = new SevenBitCharset(CharsetToolkit.UTF8_CHARSET);
    private static final Charset INTERNAL_SEVEN_BIT_ISO_8859_1 = new SevenBitCharset(CharsetToolkit.ISO_8859_1_CHARSET);
    private static final Charset INTERNAL_SEVEN_BIT_WIN_1251 = new SevenBitCharset(CharsetToolkit.WIN_1251_CHARSET);
    private static final boolean GUESS_UTF = Boolean.parseBoolean(System.getProperty("idea.guess.utf.encoding", "true"));
    private static final Key<String> CHARSET_WAS_DETECTED_FROM_BYTES = Key.create("CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    @NotNull
    private static Pair<CharSequence, String> convertLineSeparatorsToSlashN(@NotNull CharBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparatorsToSlashN"));
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++lfCount;
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev = c;
        }
        String detectedLineSeparator = LoadTextUtil.guessLineSeparator(crCount, lfCount, crlfCount);
        CharBuffer result = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        Pair<CharSequence, String> pair = Pair.create(result, detectedLineSeparator);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparatorsToSlashN"));
        }
        return pair;
    }

    @NotNull
    private static Pair<CharSequence, String> convertLineSeparatorsToSlashN(@NotNull byte[] charsAsBytes, int startOffset, int endOffset) {
        if (charsAsBytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charsAsBytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparatorsToSlashN"));
        }
        int index = ArrayUtil.indexOf(charsAsBytes, (byte)13, startOffset, endOffset);
        if (index == -1) {
            ByteArrayCharSequence sequence = new ByteArrayCharSequence(charsAsBytes, startOffset, endOffset);
            String detectedLineSeparator = ArrayUtil.indexOf(charsAsBytes, (byte)10, startOffset, endOffset) == -1 ? null : "\n";
            Pair<CharSequence, String> pair = Pair.create(sequence, detectedLineSeparator);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparatorsToSlashN"));
            }
            return pair;
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        byte[] result = new byte[endOffset - startOffset];
        for (int src = startOffset; src < endOffset; ++src) {
            char c = (char)charsAsBytes[src];
            switch (c) {
                case '\r': {
                    result[dst++] = 10;
                    ++crCount;
                    break;
                }
                case '\n': {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    result[dst++] = 10;
                    ++lfCount;
                    break;
                }
                default: {
                    result[dst++] = (byte)c;
                }
            }
            prev = c;
        }
        String detectedLineSeparator = LoadTextUtil.guessLineSeparator(crCount, lfCount, crlfCount);
        ByteArrayCharSequence sequence = new ByteArrayCharSequence(result, 0, dst);
        Pair<CharSequence, String> pair = Pair.create(sequence, detectedLineSeparator);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertLineSeparatorsToSlashN"));
        }
        return pair;
    }

    @Nullable
    private static String guessLineSeparator(int crCount, int lfCount, int crlfCount) {
        String detectedLineSeparator = null;
        if (crlfCount > crCount && crlfCount > lfCount) {
            detectedLineSeparator = "\r\n";
        } else if (crCount > lfCount) {
            detectedLineSeparator = "\r";
        } else if (lfCount > 0) {
            detectedLineSeparator = "\n";
        }
        return detectedLineSeparator;
    }

    @NotNull
    private static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> detectCharset(@NotNull VirtualFile virtualFile, @NotNull byte[] content, int startOffset, int endOffset, @NotNull FileType fileType, @NotNull Function<VirtualFile, Charset> computeCharsetIfNotDetected) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        if (computeCharsetIfNotDetected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computeCharsetIfNotDetected", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        Charset charset = null;
        String charsetName = fileType.getCharset(virtualFile, content);
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = LoadTextUtil.guessFromContent(virtualFile, content, startOffset, endOffset);
        if (charsetName == null) {
            Charset hardCodedCharset;
            Charset charset2 = hardCodedCharset = guessed == null ? null : (Charset)guessed.first;
            if (hardCodedCharset != null) {
                charset = hardCodedCharset;
            }
        } else {
            charset = CharsetToolkit.forName(charsetName);
        }
        if (charset == null) {
            charset = computeCharsetIfNotDetected.apply(virtualFile);
        }
        if (charset == null && guessed != null && guessed.second != null) {
            if (guessed.second == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
                Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> trinity = Trinity.create(CharsetToolkit.UTF8_CHARSET, guessed.getSecond(), guessed.getThird());
                if (trinity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
                }
                return trinity;
            }
            if (guessed.second == CharsetToolkit.GuessedEncoding.SEVEN_BIT) {
                Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> trinity = Trinity.create(CharsetToolkit.US_ASCII_CHARSET, guessed.getSecond(), guessed.getThird());
                if (trinity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
                }
                return trinity;
            }
        }
        Trinity<Charset, CharsetToolkit.GuessedEncoding, Object> trinity = Trinity.create(charset, guessed == null ? null : guessed.getSecond(), guessed == null ? null : guessed.getThird());
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharset"));
        }
        return trinity;
    }

    @NotNull
    public static Charset detectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content, @NotNull FileType fileType) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharsetAndSetBOM"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharsetAndSetBOM"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharsetAndSetBOM"));
        }
        Charset internalCharset = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, content, 0, content.length, true, fileType, virtualFile.isCharsetSet() ? virtualFile.getCharset() : null, LoadTextUtil::getDefaultCharsetFromEncodingManager).getFirst();
        Charset charset = internalCharset instanceof SevenBitCharset ? ((SevenBitCharset)internalCharset).myBaseCharset : internalCharset;
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectCharsetAndSetBOM"));
        }
        return charset;
    }

    @NotNull
    private static Charset getDefaultCharsetFromEncodingManager(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getDefaultCharsetFromEncodingManager"));
        }
        Charset result = null;
        Charset specifiedExplicitly = EncodingRegistry.getInstance().getEncoding(virtualFile, true);
        if (specifiedExplicitly != null) {
            result = specifiedExplicitly;
        }
        if (result == null) {
            result = EncodingRegistry.getInstance().getDefaultCharset();
        }
        Charset charset = result;
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getDefaultCharsetFromEncodingManager"));
        }
        return charset;
    }

    @NotNull
    private static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> doDetectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content, int startOffset, int endOffset, boolean saveBOM, @NotNull FileType fileType, @Nullable Charset initialCharset, @NotNull Function<VirtualFile, Charset> computeCharsetIfNotDetected) {
        Charset fromBOM;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        if (computeCharsetIfNotDetected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computeCharsetIfNotDetected", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> info = LoadTextUtil.detectCharset(virtualFile, content, startOffset, endOffset, fileType, computeCharsetIfNotDetected);
        Charset detectedCharset = info.getFirst();
        CharsetToolkit.GuessedEncoding guessed = info.getSecond();
        byte[] bom = info.getThird();
        Charset charset = initialCharset != null ? initialCharset : detectedCharset;
        Charset charset2 = fromBOM = bom == null ? null : detectedCharset;
        if (!(fromBOM == null || charset.name().startsWith("NATIVE_TO_ASCII_") && charset.name().endsWith(fromBOM.name()))) {
            charset = fromBOM;
        }
        if (saveBOM && bom != null && bom.length != 0) {
            virtualFile.setBOM(bom);
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, AUTO_DETECTED_FROM_BOM);
        }
        virtualFile.setCharset(charset);
        Charset result = charset;
        if (guessed == CharsetToolkit.GuessedEncoding.SEVEN_BIT) {
            if (charset == CharsetToolkit.UTF8_CHARSET) {
                result = INTERNAL_SEVEN_BIT_UTF8;
            } else if (charset == CharsetToolkit.ISO_8859_1_CHARSET) {
                result = INTERNAL_SEVEN_BIT_ISO_8859_1;
            } else if (charset == CharsetToolkit.WIN_1251_CHARSET) {
                result = INTERNAL_SEVEN_BIT_WIN_1251;
            }
        }
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> trinity = Trinity.create(result, guessed, bom);
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "doDetectCharsetAndSetBOM"));
        }
        return trinity;
    }

    @Nullable(value="null means no luck, otherwise it's tuple(guessed encoding, hint about content if was unable to guess, BOM)")
    public static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessFromContent(@NotNull VirtualFile virtualFile, @NotNull byte[] content, int length) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
        }
        return LoadTextUtil.guessFromContent(virtualFile, content, 0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessFromContent(@NotNull VirtualFile virtualFile, @NotNull byte[] content, int startOffset, int endOffset) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromContent"));
        }
        String detectedFromBytes = null;
        try {
            Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> info;
            if (!GUESS_UTF) {
                info = null;
            } else {
                Charset defaultCharset = ObjectUtils.notNull(EncodingManager.getInstance().getEncoding(virtualFile, true), CharsetToolkit.getDefaultSystemCharset());
                info = LoadTextUtil.guessFromBytes(content, startOffset, endOffset, defaultCharset);
                byte[] bom = info.getThird();
                CharsetToolkit.GuessedEncoding guessed = info.getSecond();
                if (bom != null) {
                    detectedFromBytes = AUTO_DETECTED_FROM_BOM;
                } else if (guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
                    detectedFromBytes = "auto-detected from bytes";
                }
            }
            Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> trinity = info;
            return trinity;
        }
        finally {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, detectedFromBytes);
        }
    }

    @NotNull
    private static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessFromBytes(@NotNull byte[] content, int startOffset, int endOffset, @NotNull Charset defaultCharset) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromBytes"));
        }
        if (defaultCharset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCharset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromBytes"));
        }
        CharsetToolkit toolkit = new CharsetToolkit(content, defaultCharset);
        toolkit.setEnforce8Bit(true);
        Charset charset = toolkit.guessFromBOM();
        if (charset != null) {
            byte[] bom = ObjectUtils.notNull(CharsetToolkit.getMandatoryBom(charset), CharsetToolkit.UTF8_BOM);
            Trinity<Charset, Object, byte[]> trinity = Trinity.create(charset, null, bom);
            if (trinity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromBytes"));
            }
            return trinity;
        }
        CharsetToolkit.GuessedEncoding guessed = toolkit.guessFromContent(startOffset, endOffset);
        if (guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
            Trinity<Charset, CharsetToolkit.GuessedEncoding, Object> trinity = Trinity.create(CharsetToolkit.UTF8_CHARSET, CharsetToolkit.GuessedEncoding.VALID_UTF8, null);
            if (trinity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromBytes"));
            }
            return trinity;
        }
        Trinity<Object, CharsetToolkit.GuessedEncoding, Object> trinity = Trinity.create(null, guessed, null);
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "guessFromBytes"));
        }
        return trinity;
    }

    public static String getTextFromBytesOrNull(@NotNull byte[] bytes, int startOffset, int endOffset) {
        Charset charset;
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextFromBytesOrNull"));
        }
        Charset defaultCharset = EncodingManager.getInstance().getDefaultCharset();
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> info = LoadTextUtil.guessFromBytes(bytes, startOffset, endOffset, defaultCharset);
        if (info.getFirst() != null) {
            charset = info.getFirst();
        } else {
            CharsetToolkit.GuessedEncoding guessed = info.getSecond();
            switch (guessed) {
                case SEVEN_BIT: {
                    charset = CharsetToolkit.US_ASCII_CHARSET;
                    break;
                }
                case VALID_UTF8: {
                    charset = CharsetToolkit.UTF8_CHARSET;
                    break;
                }
                case INVALID_UTF8: 
                case BINARY: {
                    return null;
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)guessed));
                }
            }
        }
        byte[] bom = info.getThird();
        Pair<CharSequence, String> result = LoadTextUtil.convertBytes(bytes, Math.min(startOffset + (bom == null ? 0 : bom.length), endOffset), endOffset, charset);
        return result.getFirst().toString();
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> getOverriddenCharsetByBOM(@NotNull byte[] content, @NotNull Charset charset) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getOverriddenCharsetByBOM"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getOverriddenCharsetByBOM"));
        }
        if (charset.name().contains("UTF-8") && CharsetToolkit.hasUTF8Bom(content)) {
            Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(charset, CharsetToolkit.UTF8_BOM);
            if (nonNull == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getOverriddenCharsetByBOM"));
            }
            return nonNull;
        }
        Charset charsetFromBOM = CharsetToolkit.guessFromBOM(content);
        if (charsetFromBOM != null) {
            byte[] bom = ObjectUtils.notNull(CharsetToolkit.getMandatoryBom(charsetFromBOM), ArrayUtil.EMPTY_BYTE_ARRAY);
            Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(charsetFromBOM, bom);
            if (nonNull == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getOverriddenCharsetByBOM"));
            }
            return nonNull;
        }
        Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(charset, ArrayUtil.EMPTY_BYTE_ARRAY);
        if (nonNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getOverriddenCharsetByBOM"));
        }
        return nonNull;
    }

    public static void changeLineSeparators(@Nullable Project project, @NotNull VirtualFile file, @NotNull String newSeparator, @NotNull Object requestor) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "changeLineSeparators"));
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSeparator", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "changeLineSeparators"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "changeLineSeparators"));
        }
        CharSequence currentText = LoadTextUtil.getTextByBinaryPresentation(file.contentsToByteArray(), file, true, false);
        String currentSeparator = LoadTextUtil.detectLineSeparator(file, false);
        if (newSeparator.equals(currentSeparator)) {
            return;
        }
        String newText = StringUtil.convertLineSeparators(currentText.toString(), newSeparator);
        file.setDetectedLineSeparator(newSeparator);
        LoadTextUtil.write(project, file, requestor, newText, -1L);
    }

    public static void write(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull Object requestor, @NotNull String text, long newModificationStamp) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "write"));
        }
        Charset existing = virtualFile.getCharset();
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.charsetForWriting(project, virtualFile, text, existing);
        Charset charset = (Charset)chosen.first;
        byte[] buffer = (byte[])chosen.second;
        if (!charset.equals(existing)) {
            virtualFile.setCharset(charset);
        }
        LoadTextUtil.setDetectedFromBytesFlagBack(virtualFile, buffer);
        virtualFile.setBinaryContent(buffer, newModificationStamp, -1L, requestor);
    }

    @NotNull
    private static Pair.NonNull<Charset, byte[]> charsetForWriting(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text, @NotNull Charset existing) {
        Charset fromBom;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        Charset specified = LoadTextUtil.extractCharsetFromFileContent(project, virtualFile, text);
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified, text);
        Charset charset = (Charset)chosen.first;
        byte[] bom = virtualFile.getBOM();
        Charset charset2 = fromBom = bom == null ? null : CharsetToolkit.guessFromBOM(bom);
        if (fromBom != null && !fromBom.equals(charset)) {
            chosen = Pair.createNonNull(fromBom, text.getBytes(fromBom));
        }
        Pair.NonNull<Charset, byte[]> nonNull = chosen;
        if (nonNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetForWriting"));
        }
        return nonNull;
    }

    private static void setDetectedFromBytesFlagBack(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setDetectedFromBytesFlagBack"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setDetectedFromBytesFlagBack"));
        }
        if (virtualFile.getBOM() == null) {
            LoadTextUtil.guessFromContent(virtualFile, content, content.length);
        } else {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, AUTO_DETECTED_FROM_BOM);
        }
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> chooseMostlyHarmlessCharset(@NotNull Charset existing, @NotNull Charset specified, @NotNull String text) {
        block15: {
            byte[] out;
            block14: {
                block13: {
                    Pair.NonNull<Charset, byte[]> nonNull;
                    if (existing == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    if (specified == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specified", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    try {
                        if (!specified.equals(existing)) break block13;
                        nonNull = Pair.createNonNull(specified, text.getBytes(existing));
                    }
                    catch (RuntimeException e) {
                        Charset defaultCharset = Charset.defaultCharset();
                        Pair.NonNull<Charset, byte[]> nonNull2 = Pair.createNonNull(defaultCharset, text.getBytes(defaultCharset));
                        if (nonNull2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                        }
                        return nonNull2;
                    }
                    if (nonNull == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                    }
                    return nonNull;
                }
                out = LoadTextUtil.isSupported(specified, text);
                if (out == null) break block14;
                Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, out);
                if (nonNull == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
                }
                return nonNull;
            }
            out = LoadTextUtil.isSupported(existing, text);
            if (out == null) break block15;
            Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(existing, out);
            if (nonNull == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
            }
            return nonNull;
        }
        Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, text.getBytes(specified));
        if (nonNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "chooseMostlyHarmlessCharset"));
        }
        return nonNull;
    }

    @Nullable(value="null means not supported, otherwise it is converted byte stream")
    private static byte[] isSupported(@NotNull Charset charset, @NotNull String str) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "isSupported"));
        }
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "isSupported"));
        }
        try {
            if (!charset.canEncode()) {
                return null;
            }
            byte[] bytes = str.getBytes(charset);
            if (!str.equals(new String(bytes, charset))) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Charset extractCharsetFromFileContent(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "extractCharsetFromFileContent"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "extractCharsetFromFileContent"));
        }
        Charset charset = ObjectUtils.notNull(LoadTextUtil.charsetFromContentOrNull(project, virtualFile, text), virtualFile.getCharset());
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "extractCharsetFromFileContent"));
        }
        return charset;
    }

    @Nullable(value="returns null if cannot determine from content")
    public static Charset charsetFromContentOrNull(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetFromContentOrNull"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "charsetFromContentOrNull"));
        }
        return CharsetUtil.extractCharsetFromFileContent(project, virtualFile, virtualFile.getFileType(), text);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        FileType type = file.getFileType();
        if (type.isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.INSTANCE.forFileType(type);
            if (decompiler != null) {
                CharSequence text = decompiler.decompile(file);
                try {
                    StringUtil.assertValidSeparators(text);
                }
                catch (AssertionError e) {
                    LOG.error((Throwable)((Object)e));
                }
                CharSequence charSequence = text;
                if (charSequence == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
                }
                return charSequence;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file which doesn't have a decompiler plugged in: " + file.getPresentableUrl() + ". File type: " + type.getName());
        }
        CharSequence charSequence = LoadTextUtil.loadText(file, -1);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file, int limit) {
        CharSequence charSequence;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        FileType type = file.getFileType();
        if (type.isBinary()) {
            throw new IllegalArgumentException("Attempt to load truncated text for binary file: " + file.getPresentableUrl() + ". File type: " + type.getName());
        }
        if (file instanceof LightVirtualFile) {
            CharSequence charSequence2 = LoadTextUtil.limitCharSequence(((LightVirtualFile)file).getContent(), limit);
            if (charSequence2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
            }
            return charSequence2;
        }
        if (file.isDirectory()) {
            throw new AssertionError((Object)("'" + file.getPresentableUrl() + "' is a directory"));
        }
        try {
            byte[] bytes = limit == -1 ? file.contentsToByteArray() : FileUtil.loadFirstAndClose(file.getInputStream(), limit);
            charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, file);
        }
        catch (IOException e) {
            CharSequence charSequence3 = ArrayUtil.EMPTY_CHAR_SEQUENCE;
            if (charSequence3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
            }
            return charSequence3;
        }
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "loadText"));
        }
        return charSequence;
    }

    @NotNull
    private static CharSequence limitCharSequence(@NotNull CharSequence sequence, int limit) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "limitCharSequence"));
        }
        CharSequence charSequence = limit == -1 ? sequence : sequence.subSequence(0, Math.min(limit, sequence.length()));
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "limitCharSequence"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, true, true);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> info = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, bytes, 0, bytes.length, saveBOM, virtualFile.getFileType(), virtualFile.isCharsetSet() ? virtualFile.getCharset() : null, LoadTextUtil::getDefaultCharsetFromEncodingManager);
        Charset internalCharset = info.getFirst();
        byte[] bom = info.getThird();
        Pair<CharSequence, String> result = LoadTextUtil.convertBytes(bytes, Math.min(bom == null ? 0 : bom.length, bytes.length), bytes.length, internalCharset);
        if (saveDetectedSeparators) {
            virtualFile.setDetectedLineSeparator(result.getSecond());
        }
        CharSequence charSequence = result.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    public static void processTextFromBinaryPresentationOrNull(@NotNull byte[] bytes, int startOffset, int endOffset, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM, @NotNull FileType fileType, @NotNull NullableConsumer<CharSequence> fileTextProcessor) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "processTextFromBinaryPresentationOrNull"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "processTextFromBinaryPresentationOrNull"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "processTextFromBinaryPresentationOrNull"));
        }
        if (fileTextProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTextProcessor", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "processTextFromBinaryPresentationOrNull"));
        }
        Charset initialCharset = EncodingManager.getInstance().getEncoding(virtualFile, true);
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> info = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, bytes, startOffset, endOffset, saveBOM, fileType, initialCharset, __ -> null);
        Charset internalCharset = info.getFirst();
        CharsetToolkit.GuessedEncoding guessed = info.getSecond();
        if (internalCharset == null || guessed == CharsetToolkit.GuessedEncoding.BINARY || guessed == CharsetToolkit.GuessedEncoding.INVALID_UTF8) {
            fileTextProcessor.consume(null);
        } else {
            byte[] bom = info.getThird();
            Pair<CharSequence, String> result = LoadTextUtil.convertBytes(bytes, Math.min(startOffset + (bom == null ? 0 : bom.length), endOffset), endOffset, internalCharset);
            if (saveDetectedSeparators) {
                virtualFile.setDetectedLineSeparator(result.getSecond());
            }
            fileTextProcessor.consume(result.getFirst());
        }
    }

    @Nullable
    public static String detectLineSeparator(@NotNull VirtualFile file, boolean checkFile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "detectLineSeparator"));
        }
        String lineSeparator = LoadTextUtil.getDetectedLineSeparator(file);
        if (lineSeparator == null && checkFile) {
            try {
                LoadTextUtil.getTextByBinaryPresentation(file.contentsToByteArray(), file);
                lineSeparator = LoadTextUtil.getDetectedLineSeparator(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lineSeparator;
    }

    static String getDetectedLineSeparator(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getDetectedLineSeparator"));
        }
        return file.getDetectedLineSeparator();
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull Charset charset) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        Pair.NonNull<Charset, byte[]> pair = LoadTextUtil.getOverriddenCharsetByBOM(bytes, charset);
        byte[] bom = (byte[])pair.getSecond();
        Pair<CharSequence, String> result = LoadTextUtil.convertBytes(bytes, Math.min(bom.length, bytes.length), bytes.length, (Charset)pair.first);
        CharSequence charSequence = result.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "getTextByBinaryPresentation"));
        }
        return charSequence;
    }

    @NotNull
    private static Pair<CharSequence, String> convertBytes(@NotNull byte[] bytes, int startOffset, int endOffset, @NotNull Charset internalCharset) {
        CharBuffer charBuffer;
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
        }
        if (internalCharset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalCharset", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
        }
        assert (startOffset >= 0 && startOffset <= endOffset && endOffset <= bytes.length) : startOffset + "," + endOffset + ": " + bytes.length;
        if (internalCharset instanceof SevenBitCharset || internalCharset == CharsetToolkit.US_ASCII_CHARSET) {
            Pair<CharSequence, String> pair = LoadTextUtil.convertLineSeparatorsToSlashN(bytes, startOffset, endOffset);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
            }
            return pair;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, endOffset - startOffset);
        try {
            charBuffer = internalCharset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtil.EMPTY_CHAR_ARRAY);
        }
        Pair<CharSequence, String> pair = LoadTextUtil.convertLineSeparatorsToSlashN(charBuffer);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "convertBytes"));
        }
        return pair;
    }

    @Nullable(value="null if was not detected, otherwise the reason it was")
    public static String wasCharsetDetectedFromBytes(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "wasCharsetDetectedFromBytes"));
        }
        return virtualFile.getUserData(CHARSET_WAS_DETECTED_FROM_BYTES);
    }

    public static void setCharsetWasDetectedFromBytes(@NotNull VirtualFile virtualFile, @Nullable(value="null if was not detected, otherwise the reason it was") String reason) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/LoadTextUtil", "setCharsetWasDetectedFromBytes"));
        }
        virtualFile.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, reason);
    }

    private static class SevenBitCharset
    extends Charset {
        private final Charset myBaseCharset;

        SevenBitCharset(Charset baseCharset) {
            super("IJ__7BIT_" + baseCharset.name(), ArrayUtil.EMPTY_STRING_ARRAY);
            this.myBaseCharset = baseCharset;
        }

        @Override
        public boolean contains(Charset cs) {
            throw new IllegalStateException();
        }

        @Override
        public CharsetDecoder newDecoder() {
            throw new IllegalStateException();
        }

        @Override
        public CharsetEncoder newEncoder() {
            throw new IllegalStateException();
        }
    }
}

