/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SemVer
implements Comparable<SemVer> {
    public static final SemVer UNKNOWN = new SemVer("?", 0, 0, 0);
    private final String myRawVersion;
    private final int myMajor;
    private final int myMinor;
    private final int myPatch;

    public SemVer(@NotNull String rawVersion, int major, int minor, int patch) {
        if (rawVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawVersion", "com/intellij/util/text/SemVer", "<init>"));
        }
        this.myRawVersion = rawVersion;
        this.myMajor = major;
        this.myMinor = minor;
        this.myPatch = patch;
    }

    @NotNull
    public String getRawVersion() {
        String string = this.myRawVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/SemVer", "getRawVersion"));
        }
        return string;
    }

    public int getMajor() {
        return this.myMajor;
    }

    public int getMinor() {
        return this.myMinor;
    }

    public int getPatch() {
        return this.myPatch;
    }

    @NotNull
    public String getParsedVersion() {
        String string = this.myMajor + "." + this.myMinor + "." + this.myPatch;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/SemVer", "getParsedVersion"));
        }
        return string;
    }

    @Override
    public int compareTo(SemVer other) {
        int diff = this.myMajor - other.myMajor;
        if (diff != 0) {
            return diff;
        }
        diff = this.myMinor - other.myMinor;
        if (diff != 0) {
            return diff;
        }
        return this.myPatch - other.myPatch;
    }

    public boolean isGreaterOrEqualThan(int major, int minor, int patch) {
        if (this.myMajor != major) {
            return this.myMajor > major;
        }
        if (this.myMinor != minor) {
            return this.myMinor > minor;
        }
        return this.myPatch >= patch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemVer semVer = (SemVer)o;
        return this.myMajor == semVer.myMajor && this.myMinor == semVer.myMinor && this.myPatch == semVer.myPatch;
    }

    public int hashCode() {
        int result = this.myMajor;
        result = 31 * result + this.myMinor;
        result = 31 * result + this.myPatch;
        return result;
    }

    public String toString() {
        return this.myRawVersion;
    }

    @Nullable
    public static SemVer parseFromText(@Nullable String text) {
        int minorEndIdx;
        int majorEndIdx;
        if (text != null && (majorEndIdx = text.indexOf(46)) >= 0 && (minorEndIdx = text.indexOf(46, majorEndIdx + 1)) >= 0) {
            int patchEndIdx = text.indexOf(45, minorEndIdx + 1);
            if (patchEndIdx < 0) {
                patchEndIdx = text.length();
            }
            int major = StringUtil.parseInt(text.substring(0, majorEndIdx), -1);
            int minor = StringUtil.parseInt(text.substring(majorEndIdx + 1, minorEndIdx), -1);
            int patch = StringUtil.parseInt(text.substring(minorEndIdx + 1, patchEndIdx), -1);
            if (major >= 0 && minor >= 0 && patch >= 0) {
                return new SemVer(text, major, minor, patch);
            }
        }
        return null;
    }

    public static SemVer parseFromTextNonNullize(@Nullable String text) {
        if (text == null) {
            return UNKNOWN;
        }
        SemVer ver = SemVer.parseFromText(text);
        return ver == null ? UNKNOWN : ver;
    }
}

