/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonProblemDescriptorImpl
implements CommonProblemDescriptor {
    private static final Logger LOG = Logger.getInstance(CommonProblemDescriptorImpl.class);
    private final QuickFix[] myFixes;
    private final String myDescriptionTemplate;

    public CommonProblemDescriptorImpl(QuickFix[] fixes, @NotNull String descriptionTemplate) {
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionTemplate", "com/intellij/codeInspection/CommonProblemDescriptorImpl", "<init>"));
        }
        if (fixes == null) {
            this.myFixes = null;
        } else if (fixes.length == 0) {
            this.myFixes = QuickFix.EMPTY_ARRAY;
        } else {
            QuickFix[] quickFixArray = this.myFixes = ArrayUtil.contains(null, fixes) ? ContainerUtil.mapNotNull(fixes, FunctionUtil.id(), QuickFix.EMPTY_ARRAY) : fixes;
            if (!(this instanceof ProblemDescriptor)) {
                for (QuickFix fix : fixes) {
                    if (!(fix instanceof LocalQuickFix)) continue;
                    LOG.error("Local quick fix expect ProblemDescriptor, but here only CommonProblemDescriptor available");
                }
            }
        }
        this.myDescriptionTemplate = descriptionTemplate;
    }

    @Override
    @NotNull
    public String getDescriptionTemplate() {
        String string = this.myDescriptionTemplate;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/CommonProblemDescriptorImpl", "getDescriptionTemplate"));
        }
        return string;
    }

    @Override
    @Nullable
    public QuickFix[] getFixes() {
        return this.myFixes;
    }

    public String toString() {
        return this.myDescriptionTemplate;
    }
}

