/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.SelectInEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithTernaryOperatorFix
implements LocalQuickFix {
    private final String myText;

    @Override
    @NotNull
    public String getName() {
        String string = InspectionsBundle.message("inspection.replace.ternary.quickfix", this.myText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "getName"));
        }
        return string;
    }

    public ReplaceWithTernaryOperatorFix(@NotNull PsiExpression expressionToAssert) {
        if (expressionToAssert == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToAssert", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "<init>"));
        }
        this.myText = expressionToAssert.getText();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message("inspection.surround.if.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        while ((parent = element.getParent()) instanceof PsiReferenceExpression || parent instanceof PsiMethodCallExpression) {
            element = parent;
        }
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression = (PsiExpression)element;
        PsiFile file = expression.getContainingFile();
        PsiConditionalExpression conditionalExpression = ReplaceWithTernaryOperatorFix.replaceWthConditionalExpression(project, this.myText + "!=null", expression, ReplaceWithTernaryOperatorFix.suggestDefaultValue(expression));
        PsiExpression elseExpression = conditionalExpression.getElseExpression();
        if (elseExpression != null) {
            ((Navigatable)((Object)elseExpression)).navigate(true);
            SelectInEditorManager.getInstance(project).selectInEditor(file.getVirtualFile(), elseExpression.getTextRange().getStartOffset(), elseExpression.getTextRange().getEndOffset(), false, true);
        }
    }

    @NotNull
    private static PsiConditionalExpression replaceWthConditionalExpression(@NotNull Project project, @NotNull String condition, @NotNull PsiExpression expression, @NotNull String defaultValue) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(project).getElementFactory();
        PsiElement parent = expression.getParent();
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)factory.createExpressionFromText(condition + " ? " + expression.getText() + " : " + defaultValue, parent);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project);
        PsiConditionalExpression psiConditionalExpression = (PsiConditionalExpression)expression.replace(codeStyleManager.reformat(conditionalExpression));
        if (psiConditionalExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        return psiConditionalExpression;
    }

    public static boolean isAvailable(@NotNull PsiExpression qualifier, @NotNull PsiExpression expression) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "isAvailable"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "isAvailable"));
        }
        if (!qualifier.isValid() || qualifier.getText() == null) {
            return false;
        }
        return !(expression.getParent() instanceof PsiExpressionStatement) && !PsiUtil.isAccessedForWriting(expression);
    }

    private static String suggestDefaultValue(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "suggestDefaultValue"));
        }
        PsiType type = expression.getType();
        return PsiTypesUtil.getDefaultValueOfType(type);
    }
}

