/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.util.Segment;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface SweepProcessor<T> {
    public boolean process(int var1, @NotNull T var2, boolean var3, @NotNull Collection<T> var4);

    public static <T extends Segment> boolean sweep(@NotNull Generator<T> generator, @NotNull SweepProcessor<T> sweepProcessor) {
        ArrayList starts;
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/openapi/editor/impl/SweepProcessor", "sweep"));
        }
        if (sweepProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sweepProcessor", "com/intellij/openapi/editor/impl/SweepProcessor", "sweep"));
        }
        PriorityQueue<Segment> ends = new PriorityQueue<Segment>(5, Comparator.comparingInt(Segment::getEndOffset));
        if (!generator.generateInStartOffsetOrder(arg_0 -> SweepProcessor.lambda$sweep$0(ends, starts = new ArrayList(), sweepProcessor, arg_0))) {
            return false;
        }
        while (!ends.isEmpty()) {
            if (!1.$assertionsDisabled && ends.size() != starts.size()) {
                throw new AssertionError();
            }
            Segment previous = (Segment)ends.remove();
            int prevEnd = previous.getEndOffset();
            if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                return false;
            }
            boolean removed = starts.remove(previous);
            if (!1.$assertionsDisabled && !removed) {
                throw new AssertionError();
            }
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$sweep$0(Queue ends, List starts, @NotNull SweepProcessor sweepProcessor, Segment marker) {
        int start;
        block5: {
            boolean removed;
            if (sweepProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sweepProcessor", "com/intellij/openapi/editor/impl/SweepProcessor", "lambda$sweep$0"));
            }
            start = marker.getStartOffset();
            do {
                int prevEnd;
                if (!1.$assertionsDisabled && ends.size() != starts.size()) {
                    throw new AssertionError();
                }
                Segment previous = (Segment)ends.peek();
                if (previous == null || (prevEnd = previous.getEndOffset()) > start) break block5;
                if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                    return false;
                }
                ends.remove();
                removed = starts.remove(previous);
            } while (1.$assertionsDisabled || removed);
            throw new AssertionError();
        }
        if (!sweepProcessor.process(start, marker, true, ends)) {
            return false;
        }
        starts.add(marker);
        ends.offer(marker);
        return true;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    @FunctionalInterface
    public static interface Generator<T> {
        public boolean generateInStartOffsetOrder(@NotNull Processor<T> var1);
    }
}

