/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotationMethodReferencesSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        PsiMethod method;
        PsiClass containingClass;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/PsiAnnotationMethodReferencesSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/PsiAnnotationMethodReferencesSearcher", "execute"));
        }
        PsiElement refElement = p.getElementToSearch();
        boolean isAnnotation = ReadAction.compute(() -> PsiUtil.isAnnotationMethod(refElement));
        if (isAnnotation && (containingClass = ReadAction.compute(() -> PsiAnnotationMethodReferencesSearcher.lambda$execute$1(method = (PsiMethod)refElement))) != null) {
            SearchScope scope = ReadAction.compute(() -> {
                if (p == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/PsiAnnotationMethodReferencesSearcher", "lambda$execute$2"));
                }
                return p.getEffectiveSearchScope();
            });
            Query<PsiReference> query = ReferencesSearch.search(containingClass, scope, p.isIgnoreAccessScope());
            return query.forEach(PsiAnnotationMethodReferencesSearcher.createImplicitDefaultAnnotationMethodConsumer(consumer));
        }
        return true;
    }

    @NotNull
    static ReadActionProcessor<PsiReference> createImplicitDefaultAnnotationMethodConsumer(final @NotNull Processor<PsiReference> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/PsiAnnotationMethodReferencesSearcher", "createImplicitDefaultAnnotationMethodConsumer"));
        }
        ReadActionProcessor<PsiReference> readActionProcessor = new ReadActionProcessor<PsiReference>(){

            @Override
            public boolean processInReadAction(PsiReference reference) {
                PsiReference t;
                PsiNameValuePair[] members;
                PsiJavaCodeReferenceElement javaReference;
                return !(reference instanceof PsiJavaCodeReferenceElement) || !((javaReference = (PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiAnnotation) || (members = ((PsiAnnotation)javaReference.getParent()).getParameterList().getAttributes()).length != 1 || members[0].getNameIdentifier() != null || (t = members[0].getReference()) == null || consumer.process(t);
            }
        };
        if (readActionProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiAnnotationMethodReferencesSearcher", "createImplicitDefaultAnnotationMethodConsumer"));
        }
        return readActionProcessor;
    }

    private static /* synthetic */ PsiClass lambda$execute$1(PsiMethod method) throws RuntimeException {
        boolean isValueMethod = "value".equals(method.getName()) && method.getParameterList().getParametersCount() == 0;
        return isValueMethod ? method.getContainingClass() : null;
    }
}

