/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseInputStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseOutputReader
extends BaseDataReader {
    protected final Reader myReader;
    private final Options myOptions;
    private final char[] myInputBuffer;
    private final StringBuilder myLineBuffer;
    private boolean myCarry;

    public BaseOutputReader(@NotNull InputStream inputStream, @Nullable Charset charset) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        this(BaseOutputReader.createInputStreamReader(inputStream, charset));
    }

    public BaseOutputReader(@NotNull InputStream inputStream, @Nullable Charset charset, @NotNull Options options) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        this(BaseOutputReader.createInputStreamReader(inputStream, charset), options);
    }

    public BaseOutputReader(@NotNull Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        this(reader, new Options());
    }

    public BaseOutputReader(@NotNull Reader reader, @NotNull Options options) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        super(options.policy());
        this.myInputBuffer = new char[8192];
        this.myLineBuffer = new StringBuilder();
        if (options.policy() == BaseDataReader.SleepingPolicy.BLOCKING && !(reader instanceof BaseInputStreamReader)) {
            throw new IllegalArgumentException("Blocking policy can be used only with BaseInputStreamReader, that doesn't lock on close");
        }
        if (options.policy() != BaseDataReader.SleepingPolicy.BLOCKING && !options.sendIncompleteLines()) {
            throw new IllegalArgumentException("In non-blocking mode, the reader cannot produce complete lines reliably");
        }
        this.myReader = reader;
        this.myOptions = options;
    }

    private static Reader createInputStreamReader(@NotNull InputStream stream, @Nullable Charset charset) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/util/io/BaseOutputReader", "createInputStreamReader"));
        }
        return charset == null ? new BaseInputStreamReader(stream) : new BaseInputStreamReader(stream, charset);
    }

    @Override
    protected final boolean readAvailableNonBlocking() throws IOException {
        boolean read2 = false;
        try {
            int n;
            while (this.myReader.ready() && (n = this.myReader.read(this.myInputBuffer)) >= 0) {
                if (n <= 0) continue;
                read2 = true;
                this.processInput(this.myInputBuffer, this.myLineBuffer, n);
            }
        }
        finally {
            if (this.myCarry) {
                this.myLineBuffer.append('\r');
                this.myCarry = false;
            }
            if (this.myLineBuffer.length() > 0) {
                this.sendText(this.myLineBuffer);
            }
        }
        return read2;
    }

    @Override
    protected final boolean readAvailableBlocking() throws IOException {
        boolean read2 = false;
        try {
            int n;
            while ((n = this.myReader.read(this.myInputBuffer)) >= 0) {
                if (n <= 0) continue;
                read2 = true;
                this.processInput(this.myInputBuffer, this.myLineBuffer, n);
            }
        }
        finally {
            if (this.myCarry) {
                this.myLineBuffer.append('\r');
                this.myCarry = false;
            }
            if (this.myLineBuffer.length() > 0) {
                this.sendText(this.myLineBuffer);
            }
        }
        return read2;
    }

    private void processInput(char[] buffer, StringBuilder line, int n) {
        if (this.myOptions.splitToLines()) {
            for (int i2 = 0; i2 < n; ++i2) {
                char c;
                if (i2 == 0 && this.myCarry) {
                    c = '\r';
                    --i2;
                    this.myCarry = false;
                } else {
                    c = buffer[i2];
                }
                if (c == '\r') {
                    if (i2 + 1 == n) {
                        this.myCarry = true;
                        continue;
                    }
                    if (buffer[i2 + 1] == '\n') continue;
                }
                if (c != '\n' || this.myOptions.sendIncompleteLines() || this.myOptions.withSeparators()) {
                    line.append(c);
                }
                if (c != 10) continue;
                this.sendText(line);
            }
            if (line.length() > 0 && this.myOptions.sendIncompleteLines()) {
                this.sendText(line);
            }
        } else {
            this.onTextAvailable(new String(buffer, 0, n));
        }
    }

    private void sendText(@NotNull StringBuilder line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/util/io/BaseOutputReader", "sendText"));
        }
        String text2 = line.toString();
        line.setLength(0);
        this.onTextAvailable(text2);
    }

    @Override
    protected void close() throws IOException {
        this.myReader.close();
    }

    protected abstract void onTextAvailable(@NotNull String var1);

    public BaseOutputReader(@NotNull InputStream inputStream, @Nullable Charset charset, @Nullable BaseDataReader.SleepingPolicy policy) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        this(inputStream, charset, Options.withPolicy(policy));
    }

    public BaseOutputReader(@NotNull Reader reader, @Nullable BaseDataReader.SleepingPolicy policy) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/util/io/BaseOutputReader", "<init>"));
        }
        this(reader, Options.withPolicy(policy));
    }

    protected void onBufferExhaustion() {
    }

    public static class Options {
        public static final Options BLOCKING = Options.withPolicy(BaseDataReader.SleepingPolicy.BLOCKING);
        public static final Options NON_BLOCKING = Options.withPolicy(BaseDataReader.SleepingPolicy.SIMPLE);

        public BaseDataReader.SleepingPolicy policy() {
            return null;
        }

        public boolean splitToLines() {
            return true;
        }

        public boolean sendIncompleteLines() {
            return true;
        }

        public boolean withSeparators() {
            return true;
        }

        public static Options withPolicy(final BaseDataReader.SleepingPolicy policy) {
            return new Options(){

                @Override
                public BaseDataReader.SleepingPolicy policy() {
                    return policy;
                }
            };
        }
    }
}

