/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.ReplaceAssertEqualsFix;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.NotNull;

public class AssertEqualsMayBeAssertSameInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assertequals.may.be.assertsame.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertEqualsMayBeAssertSameInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assertequals.may.be.assertsame.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertEqualsMayBeAssertSameInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceAssertEqualsFix("assertSame");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertEqualsMayBeAssertSameVisitor();
    }

    private static class AssertEqualsMayBeAssertSameVisitor
    extends BaseInspectionVisitor {
        private AssertEqualsMayBeAssertSameVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            AssertHint assertHint = AssertHint.createAssertEqualsHint(expression, false);
            if (assertHint == null) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 3 && arguments.length != 2) {
                return;
            }
            int argIndex = assertHint.getArgIndex();
            PsiExpression argument1 = arguments[argIndex];
            if (!AssertEqualsMayBeAssertSameVisitor.couldBeAssertSameArgument(argument1)) {
                return;
            }
            PsiExpression argument2 = arguments[argIndex + 1];
            if (!AssertEqualsMayBeAssertSameVisitor.couldBeAssertSameArgument(argument2)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean couldBeAssertSameArgument(PsiExpression expression) {
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass argumentClass = classType.resolve();
            if (argumentClass == null) {
                return false;
            }
            if (!argumentClass.hasModifierProperty("final")) {
                return false;
            }
            PsiMethod[] methods = argumentClass.findMethodsByName("equals", true);
            PsiManager manager = expression.getManager();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(manager.getProject());
            PsiClass objectClass = psiFacade.findClass("java.lang.Object", argumentClass.getResolveScope());
            if (objectClass == null) {
                return false;
            }
            for (PsiMethod method : methods) {
                PsiClass containingClass = method.getContainingClass();
                if (objectClass.equals(containingClass)) continue;
                return false;
            }
            return true;
        }
    }
}

