/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.SmartStripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilterFactory;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.LockFreeCOWSortedArray;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import gnu.trove.TIntObjectHashMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.DocumentImpl");
    private final LockFreeCOWSortedArray<DocumentListener> myDocumentListeners;
    private final List<DocumentBulkUpdateListener> myBulkDocumentInternalListeners;
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers;
    private final RangeMarkerTree<RangeMarkerEx> myPersistentRangeMarkers;
    private final List<RangeMarker> myGuardedBlocks;
    private ReadonlyFragmentModificationHandler myReadonlyFragmentModificationHandler;
    private final Object myLineSetLock;
    private volatile LineSet myLineSet;
    private volatile ImmutableCharSequence myText;
    private volatile SoftReference<String> myTextString;
    private volatile FrozenDocument myFrozen;
    private boolean myIsReadOnly;
    private volatile boolean isStripTrailingSpacesEnabled;
    private volatile long myModificationStamp;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final List<EditReadOnlyListener> myReadOnlyListeners;
    private int myCheckGuardedBlocks;
    private boolean myGuardsSuppressed;
    private boolean myEventsHandling;
    private final boolean myAssertThreading;
    private volatile boolean myDoingBulkUpdate;
    private volatile Throwable myBulkUpdateEnteringTrace;
    private boolean myUpdatingBulkModeStatus;
    private volatile boolean myAcceptSlashR;
    private boolean myChangeInProgress;
    private volatile int myBufferSize;
    private final CharSequence myMutableCharSequence;
    private final AtomicInteger sequence;

    public DocumentImpl(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(text, false);
    }

    public DocumentImpl(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(chars, false);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean forUseInNonAWTThread) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(chars, false, forUseInNonAWTThread);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean acceptSlashR, boolean forUseInNonAWTThread) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this.myDocumentListeners = new LockFreeCOWSortedArray<DocumentListener>(PrioritizedDocumentListener.COMPARATOR, DocumentListener.ARRAY_FACTORY);
        this.myBulkDocumentInternalListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = new RangeMarkerTree(this);
        this.myPersistentRangeMarkers = new RangeMarkerTree(this);
        this.myGuardedBlocks = new ArrayList<RangeMarker>();
        this.myLineSetLock = new String("line set lock");
        this.isStripTrailingSpacesEnabled = true;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myReadOnlyListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMutableCharSequence = new CharSequence(){

            @Override
            public int length() {
                return DocumentImpl.this.myText.length();
            }

            @Override
            public char charAt(int index) {
                return DocumentImpl.this.myText.charAt(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return DocumentImpl.this.myText.subSequence(start, end);
            }

            @Override
            @NotNull
            public String toString() {
                String string = DocumentImpl.this.doGetText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl$1", "toString"));
                }
                return string;
            }
        };
        this.sequence = new AtomicInteger();
        this.setAcceptSlashR(acceptSlashR);
        this.assertValidSeparators(chars);
        this.myText = CharArrayUtil.createImmutableCharSequence(chars);
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertThreading = !forUseInNonAWTThread;
    }

    public boolean setAcceptSlashR(boolean accept) {
        try {
            boolean bl = this.myAcceptSlashR;
            return bl;
        }
        finally {
            this.myAcceptSlashR = accept;
        }
    }

    public boolean acceptsSlashR() {
        return this.myAcceptSlashR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                lineSet = this.myLineSet;
                if (lineSet == null) {
                    this.myLineSet = lineSet = LineSet.createLineSet(this.myText);
                }
            }
        }
        return lineSet;
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        this.isStripTrailingSpacesEnabled = isEnabled;
    }

    public boolean stripTrailingSpaces(Project project) {
        return this.stripTrailingSpaces(project, false);
    }

    public boolean stripTrailingSpaces(Project project, boolean inChangedLinesOnly) {
        return this.stripTrailingSpaces(project, inChangedLinesOnly, true, new int[0]);
    }

    @Override
    public boolean isLineModified(int line) {
        LineSet lineSet = this.myLineSet;
        return lineSet != null && lineSet.isModified(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean stripTrailingSpaces(@Nullable Project project, boolean inChangedLinesOnly, boolean skipCaretLines, @NotNull int[] caretOffsets) {
        if (caretOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsets", "com/intellij/openapi/editor/impl/DocumentImpl", "stripTrailingSpaces"));
        }
        if (!this.isStripTrailingSpacesEnabled) {
            return true;
        }
        ArrayList<StripTrailingSpacesFilter> filters = new ArrayList<StripTrailingSpacesFilter>();
        for (StripTrailingSpacesFilterFactory filterFactory : StripTrailingSpacesFilterFactory.EXTENSION_POINT.getExtensions()) {
            StripTrailingSpacesFilter filter = filterFactory.createFilter(project, this);
            if (filter == StripTrailingSpacesFilter.NOT_ALLOWED) {
                return true;
            }
            if (filter == StripTrailingSpacesFilter.POSTPONED) {
                return false;
            }
            filters.add(filter);
        }
        boolean markAsNeedsStrippingLater = false;
        ImmutableCharSequence text = this.myText;
        TIntObjectHashMap caretMarkers = new TIntObjectHashMap(caretOffsets.length);
        try {
            if (skipCaretLines) {
                for (Object caretOffset : (StripTrailingSpacesFilterFactory)caretOffsets) {
                    if (caretOffset < 0 || caretOffset > this.getTextLength()) continue;
                    int line = this.getLineNumber((int)caretOffset);
                    ArrayList<RangeMarker> markers = (ArrayList<RangeMarker>)caretMarkers.get(line);
                    if (markers == null) {
                        markers = new ArrayList<RangeMarker>();
                        caretMarkers.put(line, markers);
                    }
                    RangeMarker marker = this.createRangeMarker((int)caretOffset, (int)caretOffset);
                    markers.add(marker);
                }
            }
            block5: for (int line = 0; line < this.getLineCount(); ++line) {
                int finalStart;
                List markers;
                char c;
                LineSet lineSet = this.getLineSet();
                int maxSpacesToLeave = DocumentImpl.getMaxSpacesToLeave(line, filters);
                if (inChangedLinesOnly && !lineSet.isModified(line) || maxSpacesToLeave < 0) continue;
                int whiteSpaceStart = -1;
                final int lineEnd = lineSet.getLineEnd(line) - lineSet.getSeparatorLength(line);
                int lineStart = lineSet.getLineStart(line);
                int offset = lineEnd - 1;
                while (offset >= lineStart && ((c = text.charAt(offset)) == ' ' || c == '\t')) {
                    whiteSpaceStart = offset--;
                }
                if (whiteSpaceStart == -1) continue;
                if (skipCaretLines && (markers = (List)caretMarkers.get(line)) != null) {
                    for (RangeMarker marker : markers) {
                        if (marker.getStartOffset() < 0 || whiteSpaceStart >= marker.getStartOffset()) continue;
                        markAsNeedsStrippingLater = true;
                        continue block5;
                    }
                }
                if ((finalStart = whiteSpaceStart + maxSpacesToLeave) < lineEnd) {
                    DocumentUtil.writeInRunUndoTransparentAction(new DocumentRunnable(this, project){

                        @Override
                        public void run() {
                            DocumentImpl.this.deleteString(finalStart, lineEnd);
                        }
                    });
                }
                text = this.myText;
            }
        }
        finally {
            caretMarkers.forEachValue(markerList -> {
                if (markerList != null) {
                    for (RangeMarker marker : markerList) {
                        try {
                            marker.dispose();
                        }
                        catch (Exception e) {
                            LOG.error(e);
                        }
                    }
                }
                return true;
            });
        }
        return markAsNeedsStrippingLater;
    }

    private static int getMaxSpacesToLeave(int line, @NotNull List<StripTrailingSpacesFilter> filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/openapi/editor/impl/DocumentImpl", "getMaxSpacesToLeave"));
        }
        for (StripTrailingSpacesFilter filter : filters) {
            if (filter instanceof SmartStripTrailingSpacesFilter) {
                return ((SmartStripTrailingSpacesFilter)filter).getTrailingSpacesToLeave(line);
            }
            if (filter.isStripSpacesAllowedForLine(line)) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    ReadonlyFragmentModificationHandler getReadonlyFragmentModificationHandler() {
        return this.myReadonlyFragmentModificationHandler;
    }

    void setReadonlyFragmentModificationHandler(ReadonlyFragmentModificationHandler readonlyFragmentModificationHandler) {
        this.myReadonlyFragmentModificationHandler = readonlyFragmentModificationHandler;
    }

    @Override
    public boolean isWritable() {
        return !this.myIsReadOnly;
    }

    private RangeMarkerTree<RangeMarkerEx> treeFor(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/DocumentImpl", "treeFor"));
        }
        return rangeMarker instanceof PersistentRangeMarker ? this.myPersistentRangeMarkers : this.myRangeMarkers;
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/DocumentImpl", "removeRangeMarker"));
        }
        return this.treeFor(rangeMarker).removeInterval(rangeMarker);
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/DocumentImpl", "registerRangeMarker"));
        }
        this.treeFor(rangeMarker).addInterval(rangeMarker, start, end, greedyToLeft, greedyToRight, layer);
    }

    int getRangeMarkersSize() {
        return this.myRangeMarkers.size() + this.myPersistentRangeMarkers.size();
    }

    int getRangeMarkersNodeSize() {
        return this.myRangeMarkers.nodeSize() + this.myPersistentRangeMarkers.nodeSize();
    }

    @Override
    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        LOG.assertTrue(startOffset <= endOffset, "Should be startOffset <= endOffset");
        RangeMarker block = this.createRangeMarker(startOffset, endOffset, true);
        this.myGuardedBlocks.add(block);
        RangeMarker rangeMarker = block;
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createGuardedBlock"));
        }
        return rangeMarker;
    }

    @Override
    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/openapi/editor/impl/DocumentImpl", "removeGuardedBlock"));
        }
        this.myGuardedBlocks.remove(block);
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        List<RangeMarker> list = this.myGuardedBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getGuardedBlocks"));
        }
        return list;
    }

    @Override
    public RangeMarker getOffsetGuard(int offset) {
        for (int i = 0; i < this.myGuardedBlocks.size(); ++i) {
            RangeMarker block = this.myGuardedBlocks.get(i);
            if (!DocumentImpl.offsetInRange(offset, block.getStartOffset(), block.getEndOffset())) continue;
            return block;
        }
        return null;
    }

    @Override
    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangesIntersect(start, end, true, true, block.getStartOffset(), block.getEndOffset(), block.isGreedyToLeft(), block.isGreedyToRight())) continue;
            return block;
        }
        return null;
    }

    @Override
    public void startGuardedBlockChecking() {
        ++this.myCheckGuardedBlocks;
    }

    @Override
    public void stopGuardedBlockChecking() {
        LOG.assertTrue(this.myCheckGuardedBlocks > 0, "Unpaired start/stopGuardedBlockChecking");
        --this.myCheckGuardedBlocks;
    }

    private static boolean offsetInRange(int offset, int start, int end) {
        return start <= offset && offset < end;
    }

    private static boolean rangesIntersect(int start0, int end0, boolean start0Inclusive, boolean end0Inclusive, int start1, int end1, boolean start1Inclusive, boolean end1Inclusive) {
        if (start0 > start1 || start0 == start1 && !start0Inclusive) {
            if (end1 == start0) {
                return start0Inclusive && end1Inclusive;
            }
            return end1 > start0;
        }
        if (end0 == start1) {
            return start1Inclusive && end0Inclusive;
        }
        return end0 > start1;
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (0 > startOffset || startOffset > endOffset || endOffset > this.getTextLength()) {
            LOG.error("Incorrect offsets: startOffset=" + startOffset + ", endOffset=" + endOffset + ", text length=" + this.getTextLength());
        }
        RangeMarkerImpl rangeMarkerImpl = surviveOnExternalChange ? new PersistentRangeMarker(this, startOffset, endOffset, true) : new RangeMarkerImpl(this, startOffset, endOffset, true);
        if (rangeMarkerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createRangeMarker"));
        }
        return rangeMarkerImpl;
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceText"));
        }
        this.replaceString(0, this.getTextLength(), chars, newModificationStamp, true);
        this.clearLineModificationFlags();
    }

    @Override
    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "insertString"));
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset);
        }
        if (offset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + "; documentLength: " + this.getTextLength() + "; " + s.subSequence(Math.max(0, s.length() - 20), s.length()));
        }
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        if (s.length() == 0) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(offset, offset);
        if (marker != null) {
            this.throwGuardedFragment(marker, offset, "", s);
        }
        ImmutableCharSequence newText = this.myText.insert(offset, s);
        ImmutableCharSequence newString = newText.subtext(offset, offset + s.length());
        this.updateText(newText, offset, "", newString, false, LocalTimeCounter.currentTime(), offset, 0);
        this.trimToSize();
    }

    private void trimToSize() {
        if (this.myBufferSize != 0 && this.getTextLength() > this.myBufferSize) {
            this.deleteString(0, this.getTextLength() - this.myBufferSize);
        }
    }

    @Override
    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        if (startOffset == endOffset) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, this.myText.subSequence(startOffset, endOffset), "");
        }
        ImmutableCharSequence newText = this.myText.delete(startOffset, endOffset);
        ImmutableCharSequence oldString = this.myText.subtext(startOffset, endOffset);
        this.updateText(newText, startOffset, oldString, "", false, LocalTimeCounter.currentTime(), startOffset, endOffset - startOffset);
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        this.assertBounds(srcStart, srcEnd);
        if (dstOffset == srcEnd) {
            return;
        }
        ProperTextRange srcRange = new ProperTextRange(srcStart, srcEnd);
        assert (!srcRange.containsOffset(dstOffset)) : "Can't perform text move from range [" + srcStart + "; " + srcEnd + ") to offset " + dstOffset;
        String replacement = this.getCharsSequence().subSequence(srcStart, srcEnd).toString();
        this.insertString(dstOffset, replacement);
        int shift = 0;
        if (dstOffset < srcStart) {
            shift = srcEnd - srcStart;
        }
        this.fireMoveText(srcStart + shift, srcEnd + shift, dstOffset);
        this.deleteString(srcStart + shift, srcEnd + shift);
    }

    private void fireMoveText(int start, int end, int newBase) {
        for (DocumentListener listener : this.getListeners()) {
            if (!(listener instanceof PrioritizedInternalDocumentListener)) continue;
            ((PrioritizedInternalDocumentListener)listener).moveTextHappened(start, end, newBase);
        }
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceString"));
        }
        this.replaceString(startOffset, endOffset, s, LocalTimeCounter.currentTime(), false);
    }

    private void replaceString(int startOffset, int endOffset, @NotNull CharSequence s, long newModificationStamp, boolean bl) {
        ImmutableCharSequence newText;
        boolean wholeTextReplaced;
        int newEndInString;
        int newStartInString;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceString"));
        }
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        int initialStartOffset = startOffset;
        int initialOldLength = endOffset - startOffset;
        int newStringLength = s.length();
        ImmutableCharSequence chars = this.myText;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        for (newEndInString = newStringLength; endOffset > startOffset && newEndInString > newStartInString && s.charAt(newEndInString - 1) == chars.charAt(endOffset - 1); --newEndInString, --endOffset) {
        }
        if (startOffset == 0 && endOffset == this.getTextLength()) {
            wholeTextReplaced = true;
        }
        CharSequence changedPart = s.subSequence(newStartInString, newEndInString);
        ImmutableCharSequence sToDelete = this.myText.subtext(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, sToDelete, changedPart);
        }
        if (wholeTextReplaced && s instanceof ImmutableCharSequence) {
            newText = (ImmutableCharSequence)s;
        } else {
            newText = this.myText.delete(startOffset, endOffset).insert(startOffset, changedPart);
            changedPart = newText.subtext(startOffset, startOffset + changedPart.length());
        }
        this.updateText(newText, startOffset, sToDelete, changedPart, wholeTextReplaced, newModificationStamp, initialStartOffset, initialOldLength);
        this.trimToSize();
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertThreading && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
            VirtualFile file = FileDocumentManager.getInstance().getFile(this);
            if (file != null && file.isInLocalFileSystem()) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
            }
        }
    }

    private void assertValidSeparators(@NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/DocumentImpl", "assertValidSeparators"));
        }
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators(s);
    }

    private void assertNotNestedModification() throws IllegalStateException {
        if (this.myChangeInProgress) {
            throw new IllegalStateException("Detected document modification from DocumentListener");
        }
    }

    private void throwGuardedFragment(@NotNull RangeMarker guard, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString) {
        if (guard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guard", "com/intellij/openapi/editor/impl/DocumentImpl", "throwGuardedFragment"));
        }
        if (oldString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldString", "com/intellij/openapi/editor/impl/DocumentImpl", "throwGuardedFragment"));
        }
        if (newString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newString", "com/intellij/openapi/editor/impl/DocumentImpl", "throwGuardedFragment"));
        }
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, false);
            throw new ReadOnlyFragmentModificationException(event, guard);
        }
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    @Override
    public void clearLineModificationFlags() {
        this.myLineSet = this.getLineSet().clearModificationFlags();
        this.myFrozen = null;
    }

    public void clearLineModificationFlags(int startLine, int endLine) {
        this.myLineSet = this.getLineSet().clearModificationFlags(startLine, endLine);
        this.myFrozen = null;
    }

    void clearLineModificationFlagsExcept(@NotNull int[] caretLines) {
        if (caretLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretLines", "com/intellij/openapi/editor/impl/DocumentImpl", "clearLineModificationFlagsExcept"));
        }
        IntArrayList modifiedLines = new IntArrayList(caretLines.length);
        LineSet lineSet = this.getLineSet();
        for (int line : caretLines) {
            if (line < 0 || line >= lineSet.getLineCount() || !lineSet.isModified(line)) continue;
            modifiedLines.add(line);
        }
        lineSet = lineSet.clearModificationFlags();
        for (int i = 0; i < modifiedLines.size(); ++i) {
            lineSet = lineSet.setModified(modifiedLines.get(i));
        }
        this.myLineSet = lineSet;
        this.myFrozen = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateText(@NotNull ImmutableCharSequence newText, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString, boolean wholeTextReplaced, long newModificationStamp, int initialStartOffset, int n) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/openapi/editor/impl/DocumentImpl", "updateText"));
        }
        if (oldString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldString", "com/intellij/openapi/editor/impl/DocumentImpl", "updateText"));
        }
        if (newString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newString", "com/intellij/openapi/editor/impl/DocumentImpl", "updateText"));
        }
        this.assertNotNestedModification();
        this.myChangeInProgress = true;
        try {
            void initialOldLength;
            DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, wholeTextReplaced, initialStartOffset, (int)initialOldLength);
            this.beforeChangedUpdate(event);
            this.myTextString = null;
            ImmutableCharSequence prevText = this.myText;
            this.myText = newText;
            this.sequence.incrementAndGet();
            this.changedUpdate(event, newModificationStamp, prevText);
        }
        finally {
            this.myChangeInProgress = false;
        }
    }

    @Override
    public int getModificationSequence() {
        return this.sequence.get();
    }

    private void beforeChangedUpdate(DocumentEvent event) {
        FileDocumentManager manager;
        VirtualFile file;
        Application app = ApplicationManager.getApplication();
        if (app != null && (file = (manager = FileDocumentManager.getInstance()).getFile(this)) != null && !file.isValid()) {
            LOG.error("File of this document has been deleted: " + file);
        }
        this.assertInsideCommand();
        this.getLineSet();
        if (!ShutDownTracker.isShutdownHookRunning()) {
            DocumentListener[] listeners = this.getListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                try {
                    listeners[i].beforeDocumentChange(event);
                    continue;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        this.myEventsHandling = true;
    }

    private void assertInsideCommand() {
        if (!this.myAssertThreading) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (!commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
            throw new IncorrectOperationException("Must not change document outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void changedUpdate(@NotNull DocumentEvent event, long newModificationStamp, @NotNull CharSequence charSequence) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/DocumentImpl", "changedUpdate"));
        }
        if (charSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevText", "com/intellij/openapi/editor/impl/DocumentImpl", "changedUpdate"));
        }
        try {
            void prevText;
            if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            assert (event.getOldFragment().length() == event.getOldLength()) : "event.getOldFragment().length() = " + event.getOldFragment().length() + "; event.getOldLength() = " + event.getOldLength();
            assert (event.getNewFragment().length() == event.getNewLength()) : "event.getNewFragment().length() = " + event.getNewFragment().length() + "; event.getNewLength() = " + event.getNewLength();
            assert (prevText.length() + event.getNewLength() - event.getOldLength() == this.getTextLength()) : "prevText.length() = " + prevText.length() + "; event.getNewLength() = " + event.getNewLength() + "; event.getOldLength() = " + event.getOldLength() + "; getTextLength() = " + this.getTextLength();
            this.myLineSet = this.getLineSet().update((CharSequence)prevText, event.getOffset(), event.getOffset() + event.getOldLength(), event.getNewFragment(), event.isWholeTextReplaced());
            assert (this.getTextLength() == this.myLineSet.getLength()) : "getTextLength() = " + this.getTextLength() + "; myLineSet.getLength() = " + this.myLineSet.getLength();
            this.myFrozen = null;
            this.setModificationStamp(newModificationStamp);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                DocumentListener[] listeners;
                for (DocumentListener listener : listeners = this.getListeners()) {
                    try {
                        listener.documentChanged(event);
                    }
                    catch (ProcessCanceledException e) {
                        if (!this.myAssertThreading) {
                            throw e;
                        }
                        LOG.error("ProcessCanceledException must not be thrown from document listeners for real document", new Throwable(e));
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    @Override
    @NotNull
    public String getText() {
        String string = ReadAction.compute(this::doGetText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getText"));
        }
        return string;
    }

    @NotNull
    private String doGetText() {
        String s = SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference<String>(s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "doGetText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getText(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/DocumentImpl", "getText"));
        }
        String string = ReadAction.compute(() -> {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/DocumentImpl", "lambda$getText$1"));
            }
            return this.myText.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getText"));
        }
        return string;
    }

    @Override
    public int getTextLength() {
        return this.myText.length();
    }

    @Override
    @NotNull
    public CharSequence getCharsSequence() {
        CharSequence charSequence = this.myMutableCharSequence;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getCharsSequence"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getImmutableCharSequence"));
        }
        return immutableCharSequence;
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        if (ArrayUtil.contains(listener, this.getListeners())) {
            LOG.error("Already registered: " + listener);
        }
        this.myDocumentListeners.add(listener);
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        this.addDocumentListener(listener);
        Disposer.register(parentDisposable, new DocumentListenerDisposable(this.myDocumentListeners, listener));
    }

    @Override
    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "removeDocumentListener"));
        }
        boolean success = this.myDocumentListeners.remove(listener);
        if (!success) {
            LOG.error("Can't remove document listener (" + listener + "). Registered listeners: " + Arrays.toString(this.getListeners()));
        }
    }

    void addInternalBulkModeListener(@NotNull DocumentBulkUpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "addInternalBulkModeListener"));
        }
        this.myBulkDocumentInternalListeners.add(listener);
    }

    void removeInternalBulkModeListener(@NotNull DocumentBulkUpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "removeInternalBulkModeListener"));
        }
        this.myBulkDocumentInternalListeners.remove(listener);
    }

    @Override
    public int getLineNumber(int offset) {
        return this.getLineSet().findLineIndex(offset);
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.getLineSet().createIterator();
        if (lineIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createLineIterator"));
        }
        return lineIterator;
    }

    @Override
    public final int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    @Override
    public final int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result >= 0);
        return result;
    }

    @Override
    public final int getLineSeparatorLength(int line) {
        int separatorLength = this.getLineSet().getSeparatorLength(line);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    @Override
    public final int getLineCount() {
        int lineCount = this.getLineSet().getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    @NotNull
    private DocumentListener[] getListeners() {
        DocumentListener[] documentListenerArray = this.myDocumentListeners.getArray();
        if (documentListenerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getListeners"));
        }
        return documentListenerArray;
    }

    @Override
    public void fireReadOnlyModificationAttempt() {
        for (EditReadOnlyListener listener : this.myReadOnlyListeners) {
            listener.readOnlyModificationAttempt(this);
        }
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "addEditReadOnlyListener"));
        }
        this.myReadOnlyListeners.add(listener);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "removeEditReadOnlyListener"));
        }
        this.myReadOnlyListeners.remove(listener);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "addPropertyChangeListener"));
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl", "removePropertyChangeListener"));
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setCyclicBufferSize(int bufferSize) {
        assert (bufferSize >= 0) : bufferSize;
        this.myBufferSize = bufferSize;
    }

    @Override
    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/DocumentImpl", "setText"));
        }
        Runnable runnable = () -> {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/DocumentImpl", "lambda$setText$2"));
            }
            this.replaceString(0, this.getTextLength(), text, LocalTimeCounter.currentTime(), true);
        };
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable, "", DocCommandGroupId.noneGroupId(this));
        }
        this.clearLineModificationFlags();
    }

    @Override
    public final boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    @Override
    public final void setInBulkUpdate(boolean value) {
        if (this.myAssertThreading) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        if (this.myUpdatingBulkModeStatus) {
            throw new IllegalStateException("Detected bulk mode status update from DocumentBulkUpdateListener");
        }
        if (this.myDoingBulkUpdate == value) {
            return;
        }
        this.myUpdatingBulkModeStatus = true;
        try {
            if (value) {
                DocumentImpl.getPublisher().updateStarted(this);
                this.notifyInternalListenersOnBulkModeStarted();
                this.myBulkUpdateEnteringTrace = new Throwable();
                this.myDoingBulkUpdate = true;
            } else {
                this.myDoingBulkUpdate = false;
                this.myBulkUpdateEnteringTrace = null;
                this.notifyInternalListenersOnBulkModeFinished();
                DocumentImpl.getPublisher().updateFinished(this);
            }
        }
        finally {
            this.myUpdatingBulkModeStatus = false;
        }
    }

    private void notifyInternalListenersOnBulkModeStarted() {
        for (DocumentBulkUpdateListener listener : this.myBulkDocumentInternalListeners) {
            listener.updateStarted(this);
        }
    }

    private void notifyInternalListenersOnBulkModeFinished() {
        for (DocumentBulkUpdateListener listener : this.myBulkDocumentInternalListeners) {
            listener.updateFinished(this);
        }
    }

    @NotNull
    private static DocumentBulkUpdateListener getPublisher() {
        DocumentBulkUpdateListener documentBulkUpdateListener = DocumentBulkUpdateListenerHolder.ourBulkChangePublisher;
        if (documentBulkUpdateListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getPublisher"));
        }
        return documentBulkUpdateListener;
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/DocumentImpl", "processRangeMarkers"));
        }
        return this.processRangeMarkersOverlappingWith(0, this.getTextLength(), processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/DocumentImpl", "processRangeMarkersOverlappingWith"));
        }
        TextRangeInterval interval = new TextRangeInterval(start, end);
        MarkupIterator<? super RangeMarker> iterator = IntervalTreeImpl.mergingOverlappingIterator(this.myRangeMarkers, interval, this.myPersistentRangeMarkers, interval, RangeMarker.BY_START_OFFSET);
        try {
            boolean bl = ContainerUtil.process(iterator, processor);
            return bl;
        }
        finally {
            iterator.dispose();
        }
    }

    @NotNull
    String dumpState() {
        StringBuilder result = new StringBuilder();
        result.append(", intervals:\n");
        for (int line = 0; line < this.getLineCount(); ++line) {
            result.append(line).append(": ").append(this.getLineStartOffset(line)).append("-").append(this.getLineEndOffset(line)).append(", ");
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "dumpState"));
        }
        return string;
    }

    public String toString() {
        return "DocumentImpl[" + FileDocumentManager.getInstance().getFile(this) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FrozenDocument freeze() {
        FrozenDocument frozen = this.myFrozen;
        if (frozen == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                frozen = this.myFrozen;
                if (frozen == null) {
                    frozen = new FrozenDocument(this.myText, this.myLineSet, this.myModificationStamp, SoftReference.dereference(this.myTextString));
                }
            }
        }
        FrozenDocument frozenDocument = frozen;
        if (frozenDocument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "freeze"));
        }
        return frozenDocument;
    }

    public void assertNotInBulkUpdate() {
        if (this.myDoingBulkUpdate) {
            throw new UnexpectedBulkUpdateStateException(this.myBulkUpdateEnteringTrace);
        }
    }

    private static class UnexpectedBulkUpdateStateException
    extends RuntimeException
    implements ExceptionWithAttachments {
        private final Attachment[] myAttachments;

        private UnexpectedBulkUpdateStateException(Throwable enteringTrace) {
            Attachment[] attachmentArray;
            if (enteringTrace == null) {
                attachmentArray = Attachment.EMPTY_ARRAY;
            } else {
                Attachment[] attachmentArray2 = new Attachment[1];
                attachmentArray = attachmentArray2;
                attachmentArray2[0] = new Attachment("enteringTrace.txt", enteringTrace);
            }
            this.myAttachments = attachmentArray;
        }

        @Override
        @NotNull
        public Attachment[] getAttachments() {
            if (this.myAttachments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl$UnexpectedBulkUpdateStateException", "getAttachments"));
            }
            return this.myAttachments;
        }
    }

    private static class DocumentBulkUpdateListenerHolder {
        private static final DocumentBulkUpdateListener ourBulkChangePublisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(DocumentBulkUpdateListener.TOPIC);

        private DocumentBulkUpdateListenerHolder() {
        }
    }

    private static class DocumentListenerDisposable
    implements Disposable {
        @NotNull
        private final LockFreeCOWSortedArray<DocumentListener> myList;
        @NotNull
        private final DocumentListener myListener;

        DocumentListenerDisposable(@NotNull LockFreeCOWSortedArray<DocumentListener> list, @NotNull DocumentListener listener) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/editor/impl/DocumentImpl$DocumentListenerDisposable", "<init>"));
            }
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/DocumentImpl$DocumentListenerDisposable", "<init>"));
            }
            this.myList = list;
            this.myListener = listener;
        }

        @Override
        public void dispose() {
            this.myList.remove(this.myListener);
        }
    }
}

