/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NameUtil {
    private static final Function<String, String> LOWERCASE_MAPPING = new Function<String, String>(){

        @Override
        public String fun(String s) {
            return s.toLowerCase();
        }
    };
    private static final int MAX_LENGTH = 40;

    private NameUtil() {
    }

    @NotNull
    public static List<String> nameToWordsLowerCase(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/NameUtil", "nameToWordsLowerCase"));
        }
        List<String> list = ContainerUtil.map(NameUtil.nameToWords(name), LOWERCASE_MAPPING);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "nameToWordsLowerCase"));
        }
        return list;
    }

    @NotNull
    public static String[] nameToWords(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/NameUtil", "nameToWords"));
        }
        ArrayList<String> array = new ArrayList<String>();
        int index = 0;
        while (index < name.length()) {
            String word;
            int wordStart = index;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index < name.length()) {
                char c = name.charAt(index);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index;
            }
            if (StringUtil.isEmptyOrSpaces(word = name.substring(wordStart, index))) continue;
            array.add(word);
        }
        String[] stringArray = ArrayUtil.toStringArray(array);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "nameToWords"));
        }
        return stringArray;
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/codeStyle/NameUtil", "buildRegexp"));
        }
        String string = NameUtil.buildRegexp(pattern, exactPrefixLen, allowToUpper, allowToLower, false, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "buildRegexp"));
        }
        return string;
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords, boolean forCompletion) {
        boolean endsWithSpace;
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/codeStyle/NameUtil", "buildRegexp"));
        }
        int eol = pattern.indexOf(10);
        if (eol != -1) {
            pattern = pattern.substring(0, eol);
        }
        if (pattern.length() >= 40) {
            pattern = pattern.substring(0, 40);
        }
        StringBuilder buffer = new StringBuilder();
        boolean bl = endsWithSpace = !forCompletion && StringUtil.endsWithChar(pattern, ' ');
        if (!forCompletion) {
            pattern = pattern.trim();
        }
        exactPrefixLen = Math.min(exactPrefixLen, pattern.length());
        boolean prevIsUppercase = false;
        if (exactPrefixLen > 0) {
            char c = pattern.charAt(exactPrefixLen - 1);
            prevIsUppercase = Character.isUpperCase(c) || Character.isDigit(c);
        }
        for (int i = 0; i != exactPrefixLen; ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append("\\").append(c);
        }
        if (exactPrefixLen == 0) {
            buffer.append("_*");
        }
        boolean firstIdentifierLetter = exactPrefixLen == 0;
        boolean lastIsUppercase = false;
        for (int i = exactPrefixLen; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            lastIsUppercase = false;
            if (Character.isLetterOrDigit(c)) {
                prevIsUppercase = false;
                if (Character.isUpperCase(c) || Character.isDigit(c)) {
                    prevIsUppercase = true;
                    lastIsUppercase = true;
                    buffer.append('(');
                    if (!firstIdentifierLetter) {
                        buffer.append("[a-z\\s0-9\\$]*");
                    }
                    buffer.append(c);
                    if (allowToLower) {
                        buffer.append('|');
                        buffer.append(Character.toLowerCase(c));
                    }
                    if (!firstIdentifierLetter) {
                        buffer.append("|[A-Za-z\\s0-9\\$]*[_-]+[");
                        buffer.append(c);
                        buffer.append(Character.toLowerCase(c));
                        buffer.append("]");
                    }
                    buffer.append(')');
                } else if (Character.isLowerCase(c) && allowToUpper) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append(Character.toUpperCase(c));
                    buffer.append(']');
                    if (lowerCaseWords) {
                        buffer.append("([a-z\\s0-9\\$]*[-_]+)?");
                    }
                } else {
                    buffer.append(c);
                }
                firstIdentifierLetter = false;
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == '.') {
                if (!firstIdentifierLetter) {
                    buffer.append("[a-z\\s0-9\\$]*\\.");
                } else {
                    buffer.append("\\.");
                }
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ' ') {
                buffer.append("([a-z\\s0-9\\$_-]*[\\ _-]+)+");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ':' || prevIsUppercase) {
                buffer.append("[A-Za-z\\s0-9\\$]*");
            }
            firstIdentifierLetter = true;
            buffer.append("\\").append(c);
        }
        if (!endsWithSpace) {
            buffer.append(".*");
        } else if (lastIsUppercase) {
            buffer.append("[a-z\\s0-9\\$]*");
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "buildRegexp"));
        }
        return string;
    }

    @NotNull
    public static String[] splitNameIntoWords(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/NameUtil", "splitNameIntoWords"));
        }
        String[] underlineDelimited = name.split("_");
        ArrayList<String> result = new ArrayList<String>();
        for (String word : underlineDelimited) {
            NameUtil.addAllWords(word, result);
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "splitNameIntoWords"));
        }
        return stringArray;
    }

    @NotNull
    public static List<String> getSuggestionsByName(@NotNull String name, @NotNull String prefix, @NotNull String suffix, boolean upperCaseStyle, boolean preferLongerNames, boolean isArray) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/NameUtil", "getSuggestionsByName"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/codeStyle/NameUtil", "getSuggestionsByName"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/psi/codeStyle/NameUtil", "getSuggestionsByName"));
        }
        ArrayList<String> answer = new ArrayList<String>();
        String[] words = NameUtil.nameToWords(name);
        for (int step = 0; step < words.length; ++step) {
            int wordCount = preferLongerNames ? words.length - step : step + 1;
            String startWord = words[words.length - wordCount];
            char c = startWord.charAt(0);
            if (c == '_' || !Character.isJavaIdentifierStart(c)) continue;
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, false) + suffix);
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, true) + suffix);
        }
        ArrayList<String> arrayList = answer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "getSuggestionsByName"));
        }
        return arrayList;
    }

    @NotNull
    private static String compoundSuggestion(@NotNull String prefix, boolean upperCaseStyle, @NotNull String[] words, int wordCount, @NotNull String startWord, char c, boolean isArray, boolean skip_) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/codeStyle/NameUtil", "compoundSuggestion"));
        }
        if (words == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/intellij/psi/codeStyle/NameUtil", "compoundSuggestion"));
        }
        if (startWord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startWord", "com/intellij/psi/codeStyle/NameUtil", "compoundSuggestion"));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        startWord = upperCaseStyle ? StringUtil.toUpperCase(startWord) : (prefix.isEmpty() || StringUtil.endsWithChar(prefix, '_') ? startWord.toLowerCase() : Character.toUpperCase(c) + startWord.substring(1));
        buffer.append(startWord);
        for (int i = words.length - wordCount + 1; i < words.length; ++i) {
            String word = words[i];
            String prevWord = words[i - 1];
            if (upperCaseStyle) {
                word = StringUtil.toUpperCase(word);
                if (prevWord.charAt(prevWord.length() - 1) != '_' && word.charAt(0) != '_') {
                    word = "_" + word;
                }
            } else {
                if (prevWord.charAt(prevWord.length() - 1) == '_') {
                    word = word.toLowerCase();
                }
                if (skip_) {
                    if (word.equals("_")) continue;
                    if (prevWord.equals("_")) {
                        word = StringUtil.capitalize(word);
                    }
                }
            }
            buffer.append(word);
        }
        String suggestion = buffer.toString();
        if (isArray) {
            suggestion = StringUtil.pluralize(suggestion);
            if (upperCaseStyle) {
                suggestion = StringUtil.toUpperCase(suggestion);
            }
        }
        String string = suggestion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "compoundSuggestion"));
        }
        return string;
    }

    static int nextWord(@NotNull String text, int start) {
        int i;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/codeStyle/NameUtil", "nextWord"));
        }
        if (!Character.isLetterOrDigit(text.charAt(start))) {
            return start + 1;
        }
        for (i = start; i < text.length() && Character.isDigit(text.charAt(i)); ++i) {
        }
        if (i > start) {
            return i;
        }
        while (i < text.length() && Character.isUpperCase(text.charAt(i))) {
            ++i;
        }
        if (i > start + 1) {
            if (i == text.length() || !Character.isLetter(text.charAt(i))) {
                return i;
            }
            return i - 1;
        }
        if (i == start) {
            ++i;
        }
        while (i < text.length() && Character.isLetter(text.charAt(i)) && !NameUtil.isWordStart(text, i)) {
            ++i;
        }
        return i;
    }

    private static void addAllWords(@NotNull String text, @NotNull List<String> result) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/codeStyle/NameUtil", "addAllWords"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/codeStyle/NameUtil", "addAllWords"));
        }
        int start = 0;
        while (start < text.length()) {
            int next = NameUtil.nextWord(text, start);
            result.add(text.substring(start, next));
            start = next;
        }
    }

    static boolean isWordStart(String text, int i) {
        char c = text.charAt(i);
        if (Character.isUpperCase(c)) {
            if (i > 0 && Character.isUpperCase(text.charAt(i - 1))) {
                return i + 1 < text.length() && Character.isLowerCase(text.charAt(i + 1));
            }
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        if (!Character.isLetter(c)) {
            return false;
        }
        return i == 0 || !Character.isLetterOrDigit(text.charAt(i - 1)) || NameUtil.isHardCodedWordStart(text, i);
    }

    private static boolean isHardCodedWordStart(String text, int i) {
        return text.charAt(i) == 'l' && i < text.length() - 1 && text.charAt(i + 1) == 'n' && (text.length() == i + 2 || NameUtil.isWordStart(text, i + 2));
    }

    @Deprecated
    @NotNull
    public static com.intellij.util.text.Matcher buildCompletionMatcher(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/codeStyle/NameUtil", "buildCompletionMatcher"));
        }
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher(pattern, options);
        if (minusculeMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "buildCompletionMatcher"));
        }
        return minusculeMatcher;
    }

    @NotNull
    public static com.intellij.util.text.Matcher buildMatcher(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/codeStyle/NameUtil", "buildMatcher"));
        }
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher(pattern, options);
        if (minusculeMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "buildMatcher"));
        }
        return minusculeMatcher;
    }

    @Deprecated
    @NotNull
    public static com.intellij.util.text.Matcher buildMatcher(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/codeStyle/NameUtil", "buildMatcher"));
        }
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher(pattern, options);
        if (minusculeMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "buildMatcher"));
        }
        return minusculeMatcher;
    }

    @NotNull
    public static MatcherBuilder buildMatcher(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/codeStyle/NameUtil", "buildMatcher"));
        }
        MatcherBuilder matcherBuilder = new MatcherBuilder(pattern);
        if (matcherBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "buildMatcher"));
        }
        return matcherBuilder;
    }

    @NotNull
    public static MinusculeMatcher buildMatcher(@NotNull String pattern, @NotNull MatchingCaseSensitivity options) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/codeStyle/NameUtil", "buildMatcher"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/codeStyle/NameUtil", "buildMatcher"));
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher(pattern).withCaseSensitivity(options).build();
        if (minusculeMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "buildMatcher"));
        }
        return minusculeMatcher;
    }

    @NotNull
    public static String capitalizeAndUnderscore(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/NameUtil", "capitalizeAndUnderscore"));
        }
        String string = NameUtil.splitWords(name, '_', new Function<String, String>(){

            @Override
            public String fun(String s) {
                return StringUtil.toUpperCase(s);
            }
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "capitalizeAndUnderscore"));
        }
        return string;
    }

    @NotNull
    public static String splitWords(@NotNull String text, char separator, @NotNull Function<String, String> transformWord) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/codeStyle/NameUtil", "splitWords"));
        }
        if (transformWord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformWord", "com/intellij/psi/codeStyle/NameUtil", "splitWords"));
        }
        String[] words = NameUtil.nameToWords(text);
        boolean insertSeparator = false;
        StringBuilder buf = new StringBuilder();
        for (String word : words) {
            if (!Character.isLetterOrDigit(word.charAt(0))) {
                buf.append(separator);
                insertSeparator = false;
                continue;
            }
            if (insertSeparator) {
                buf.append(separator);
            } else {
                insertSeparator = true;
            }
            buf.append(transformWord.fun(word));
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/NameUtil", "splitWords"));
        }
        return string;
    }

    public static enum MatchingCaseSensitivity {
        NONE,
        FIRST_LETTER,
        ALL;

    }

    public static class MatcherBuilder {
        private String pattern;
        private String separators = "";
        private MatchingCaseSensitivity caseSensitivity = MatchingCaseSensitivity.NONE;

        public MatcherBuilder(String pattern) {
            this.pattern = pattern;
        }

        public MatcherBuilder withCaseSensitivity(MatchingCaseSensitivity caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
            return this;
        }

        public MatcherBuilder withSeparators(String separators) {
            this.separators = separators;
            return this;
        }

        public MinusculeMatcher build() {
            return new FixingLayoutMatcher(this.pattern, this.caseSensitivity, this.separators);
        }
    }

    @Deprecated
    public static interface Matcher {
        public boolean matches(@NotNull String var1);
    }
}

