/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.content;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.content.JpsExcludeFolder;
import com.intellij.project.model.impl.module.content.JpsSourceFolder;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsExcludePattern;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JpsContentEntry
implements ContentEntry,
Disposable {
    private final VirtualFilePointer myRoot;
    private final JpsModule myModule;
    private final JpsRootModel myRootModel;
    private final List<JpsSourceFolder> mySourceFolders;
    private final List<JpsExcludeFolder> myExcludeFolders;
    private final List<String> myExcludePatterns;

    public JpsContentEntry(JpsModule module, JpsRootModel rootModel, String rootUrl) {
        this.myModule = module;
        this.myRootModel = rootModel;
        this.myRoot = VirtualFilePointerManager.getInstance().create(rootUrl, (Disposable)this, null);
        this.mySourceFolders = new ArrayList<JpsSourceFolder>();
        String rootPath = VfsUtilCore.urlToPath(this.getUrl());
        for (JpsModuleSourceRoot root : this.myModule.getSourceRoots()) {
            if (!FileUtil.isAncestor(rootPath, VfsUtilCore.urlToPath(root.getUrl()), false)) continue;
            this.mySourceFolders.add(new JpsSourceFolder(root, this));
        }
        this.myExcludeFolders = new ArrayList<JpsExcludeFolder>();
        for (String excludedUrl : this.myModule.getExcludeRootsList().getUrls()) {
            if (!FileUtil.isAncestor(rootPath, VfsUtilCore.urlToPath(excludedUrl), false)) continue;
            this.myExcludeFolders.add(new JpsExcludeFolder(excludedUrl, this));
        }
        this.myExcludePatterns = new SmartList<String>();
        for (JpsExcludePattern pattern : this.myModule.getExcludePatterns()) {
            if (!pattern.getBaseDirUrl().equals(rootUrl)) continue;
            this.myExcludePatterns.add(pattern.getPattern());
        }
    }

    @Override
    public VirtualFile getFile() {
        return this.myRoot.getFile();
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.myRoot.getUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getUrl"));
        }
        return string;
    }

    @Override
    @NotNull
    public SourceFolder[] getSourceFolders() {
        SourceFolder[] sourceFolderArray = this.mySourceFolders.toArray(new SourceFolder[this.mySourceFolders.size()]);
        if (sourceFolderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolders"));
        }
        return sourceFolderArray;
    }

    @Override
    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolders"));
        }
        List<SourceFolder> list = this.getSourceFolders(Collections.singleton(rootType));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolders"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypes", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolders"));
        }
        SmartList<SourceFolder> folders = new SmartList<SourceFolder>();
        for (JpsSourceFolder folder : this.mySourceFolders) {
            if (!rootTypes.contains(folder.getRootType())) continue;
            folders.add(folder);
        }
        SmartList<SourceFolder> smartList = folders;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolders"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public VirtualFile[] getSourceFolderFiles() {
        VirtualFile[] virtualFileArray = JpsContentEntry.getFiles(this.getSourceFolders());
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getSourceFolderFiles"));
        }
        return virtualFileArray;
    }

    private static VirtualFile[] getFiles(ContentFolder[] sourceFolders) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(sourceFolders.length);
        for (ContentFolder sourceFolder : sourceFolders) {
            VirtualFile file = sourceFolder.getFile();
            if (file == null) continue;
            result.add(file);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    @Override
    @NotNull
    public ExcludeFolder[] getExcludeFolders() {
        ExcludeFolder[] excludeFolderArray = this.myExcludeFolders.toArray(new ExcludeFolder[this.myExcludeFolders.size()]);
        if (excludeFolderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getExcludeFolders"));
        }
        return excludeFolderArray;
    }

    @Override
    @NotNull
    public List<String> getExcludeFolderUrls() {
        ArrayList<String> excluded = new ArrayList<String>();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            excluded.add(folder.getUrl());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.myRootModel.getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.myRootModel)) {
                excluded.add(pointer.getUrl());
            }
        }
        ArrayList<String> arrayList = excluded;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getExcludeFolderUrls"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public VirtualFile[] getExcludeFolderFiles() {
        ArrayList excluded = new ArrayList();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            ContainerUtil.addIfNotNull(excluded, folder.getFile());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.myRootModel.getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.myRootModel)) {
                ContainerUtil.addIfNotNull(excluded, pointer.getFile());
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(excluded);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getExcludeFolderFiles"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(file, isTestSource, "");
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource, @NotNull String packagePrefix) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(file.getUrl(), isTestSource, packagePrefix);
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        JpsModuleSourceRoot sourceRoot = this.myModule.addSourceRoot(file.getUrl(), type, properties);
        JpsSourceFolder sourceFolder = new JpsSourceFolder(sourceRoot, this);
        this.mySourceFolders.add(sourceFolder);
        JpsSourceFolder jpsSourceFolder = sourceFolder;
        if (jpsSourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return jpsSourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file, @NotNull JpsModuleSourceRootType<P> type) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(file, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return sourceFolder;
    }

    private SourceFolder addSourceFolder(String url, boolean isTestSource, String packagePrefix) {
        JavaSourceRootType rootType = isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        JavaSourceRootProperties properties = JpsJavaExtensionService.getInstance().createSourceRootProperties(packagePrefix);
        return this.addSourceFolder(url, rootType, properties);
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull String url, boolean isTestSource) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, isTestSource, "");
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        JpsModuleSourceRoot sourceRoot = this.myModule.addSourceRoot(url, type, properties);
        JpsSourceFolder sourceFolder = new JpsSourceFolder(sourceRoot, this);
        this.mySourceFolders.add(sourceFolder);
        JpsSourceFolder jpsSourceFolder = sourceFolder;
        if (jpsSourceFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addSourceFolder"));
        }
        return jpsSourceFolder;
    }

    @Override
    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFolder", "com/intellij/project/model/impl/module/content/JpsContentEntry", "removeSourceFolder"));
        }
        JpsSourceFolder folder = (JpsSourceFolder)sourceFolder;
        this.mySourceFolders.remove(folder);
        this.myModule.removeSourceRoot(folder.getSourceRoot().getUrl(), folder.getSourceRoot().getRootType());
        Disposer.dispose(folder);
    }

    @Override
    public void clearSourceFolders() {
        ArrayList<JpsModuleSourceRoot> toRemove = new ArrayList<JpsModuleSourceRoot>();
        for (JpsSourceFolder folder : this.mySourceFolders) {
            toRemove.add(folder.getSourceRoot());
            Disposer.dispose(folder);
        }
        this.mySourceFolders.clear();
        for (JpsModuleSourceRoot root : toRemove) {
            this.myModule.removeSourceRoot(root.getUrl(), root.getRootType());
        }
    }

    @Override
    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addExcludeFolder"));
        }
        return this.addExcludeFolder(file.getUrl());
    }

    @Override
    public ExcludeFolder addExcludeFolder(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addExcludeFolder"));
        }
        JpsExcludeFolder folder = new JpsExcludeFolder(url, this);
        this.myModule.getExcludeRootsList().addUrl(url);
        this.myExcludeFolders.add(folder);
        return folder;
    }

    @Override
    public void removeExcludeFolder(@NotNull ExcludeFolder excludeFolder) {
        if (excludeFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludeFolder", "com/intellij/project/model/impl/module/content/JpsContentEntry", "removeExcludeFolder"));
        }
        JpsExcludeFolder folder = (JpsExcludeFolder)excludeFolder;
        this.myExcludeFolders.remove(folder);
        this.myModule.getExcludeRootsList().removeUrl(folder.getUrl());
        Disposer.dispose(folder);
    }

    @Override
    public boolean removeExcludeFolder(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/project/model/impl/module/content/JpsContentEntry", "removeExcludeFolder"));
        }
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            if (!folder.getUrl().equals(url)) continue;
            this.myExcludeFolders.remove(folder);
            this.myModule.getExcludeRootsList().removeUrl(url);
            Disposer.dispose(folder);
            return true;
        }
        return false;
    }

    @Override
    public void clearExcludeFolders() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            toRemove.add(folder.getUrl());
            Disposer.dispose(folder);
        }
        this.myExcludeFolders.clear();
        for (String url : toRemove) {
            this.myModule.getExcludeRootsList().removeUrl(url);
        }
    }

    @Override
    @NotNull
    public List<String> getExcludePatterns() {
        List<String> list = this.myExcludePatterns;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/content/JpsContentEntry", "getExcludePatterns"));
        }
        return list;
    }

    @Override
    public void addExcludePattern(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/project/model/impl/module/content/JpsContentEntry", "addExcludePattern"));
        }
        this.myExcludePatterns.add(pattern);
        this.myModule.addExcludePattern(this.getUrl(), pattern);
    }

    @Override
    public void removeExcludePattern(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/project/model/impl/module/content/JpsContentEntry", "removeExcludePattern"));
        }
        this.myExcludePatterns.remove(pattern);
        this.myModule.removeExcludePattern(this.getUrl(), pattern);
    }

    @Override
    public void setExcludePatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/project/model/impl/module/content/JpsContentEntry", "setExcludePatterns"));
        }
        for (String pattern : this.myExcludePatterns) {
            this.myModule.removeExcludePattern(this.getUrl(), pattern);
        }
        this.myExcludePatterns.clear();
        for (String pattern : patterns) {
            this.addExcludePattern(pattern);
        }
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public void dispose() {
        for (JpsSourceFolder jpsSourceFolder : this.mySourceFolders) {
            Disposer.dispose(jpsSourceFolder);
        }
        for (JpsExcludeFolder jpsExcludeFolder : this.myExcludeFolders) {
            Disposer.dispose(jpsExcludeFolder);
        }
    }
}

