/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.CommonClassNames;
import com.intellij.util.CharTable;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringFactory;
import gnu.trove.TIntObjectHashMap;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharTableImpl
implements CharTable {
    private static final int INTERN_THRESHOLD = 40;
    private static final StringHashToCharSequencesMap STATIC_ENTRIES = CharTableImpl.newStaticSet();
    private final StringHashToCharSequencesMap entries = new StringHashToCharSequencesMap(10, 0.9f);

    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        CharSequence charSequence = text2.length() > 40 ? CharTableImpl.createSequence(text2) : this.doIntern(text2);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CharSequence doIntern(@NotNull CharSequence text2, int startOffset, int endOffset) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
        }
        int hashCode = CharTableImpl.subSequenceHashCode(text2, startOffset, endOffset);
        CharSequence interned = CharTableImpl.STATIC_ENTRIES.getSubSequenceWithHashCode(hashCode, text2, startOffset, endOffset);
        if (interned != null) {
            CharSequence charSequence = interned;
            if (charSequence != null) return charSequence;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
        }
        StringHashToCharSequencesMap stringHashToCharSequencesMap = this.entries;
        // MONITORENTER : stringHashToCharSequencesMap
        CharSequence charSequence = this.entries.getOrAddSubSequenceWithHashCode(hashCode, text2, startOffset, endOffset);
        // MONITOREXIT : stringHashToCharSequencesMap
        if (charSequence != null) return charSequence;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
    }

    @NotNull
    public CharSequence doIntern(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
        }
        CharSequence charSequence = this.doIntern(text2, 0, text2.length());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence baseText, int startOffset, int endOffset) {
        if (baseText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseText", "com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        CharSequence result = endOffset - startOffset == baseText.length() ? this.intern(baseText) : (endOffset - startOffset > 40 ? CharTableImpl.createSequence(baseText, startOffset, endOffset) : this.doIntern(baseText, startOffset, endOffset));
        CharSequence charSequence = result;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        return charSequence;
    }

    @NotNull
    private static String createSequence(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
        }
        String string = CharTableImpl.createSequence(text2, 0, text2.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
        }
        return string;
    }

    @NotNull
    private static String createSequence(@NotNull CharSequence text2, int startOffset, int endOffset) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
        }
        if (text2 instanceof String) {
            String string = ((String)text2).substring(startOffset, endOffset);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
            }
            return string;
        }
        char[] buf = new char[endOffset - startOffset];
        CharArrayUtil.getChars(text2, buf, startOffset, 0, buf.length);
        String string = StringFactory.createShared(buf);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
        }
        return string;
    }

    @Nullable
    public static CharSequence getStaticInterned(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/CharTableImpl", "getStaticInterned"));
        }
        return CharTableImpl.STATIC_ENTRIES.get(text2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticIntern(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/CharTableImpl", "staticIntern"));
        }
        StringHashToCharSequencesMap stringHashToCharSequencesMap = STATIC_ENTRIES;
        synchronized (stringHashToCharSequencesMap) {
            CharTableImpl.STATIC_ENTRIES.add(text2);
        }
    }

    @NotNull
    private static StringHashToCharSequencesMap newStaticSet() {
        StringHashToCharSequencesMap r = new StringHashToCharSequencesMap(10, 0.9f);
        r.add("==");
        r.add("!=");
        r.add("||");
        r.add("++");
        r.add("--");
        r.add("<");
        r.add("<=");
        r.add("<<=");
        r.add("<<");
        r.add(">");
        r.add("&");
        r.add("&&");
        r.add("+=");
        r.add("-=");
        r.add("*=");
        r.add("/=");
        r.add("&=");
        r.add("|=");
        r.add("^=");
        r.add("%=");
        r.add("(");
        r.add(")");
        r.add("{");
        r.add("}");
        r.add("[");
        r.add("]");
        r.add(";");
        r.add(",");
        r.add("...");
        r.add(".");
        r.add("=");
        r.add("!");
        r.add("~");
        r.add("?");
        r.add(":");
        r.add("+");
        r.add("-");
        r.add("*");
        r.add("/");
        r.add("|");
        r.add("^");
        r.add("%");
        r.add("@");
        r.add(" ");
        r.add("  ");
        r.add("   ");
        r.add("    ");
        r.add("     ");
        r.add("      ");
        r.add("       ");
        r.add("        ");
        r.add("         ");
        r.add("          ");
        r.add("           ");
        r.add("            ");
        r.add("             ");
        r.add("              ");
        r.add("               ");
        r.add("\n");
        r.add("\n  ");
        r.add("\n    ");
        r.add("\n      ");
        r.add("\n        ");
        r.add("\n          ");
        r.add("\n            ");
        r.add("\n              ");
        r.add("\n                ");
        r.add("<");
        r.add(">");
        r.add("</");
        r.add("/>");
        r.add("\"");
        r.add("'");
        r.add("<![CDATA[");
        r.add("]]>");
        r.add("<!--");
        r.add("-->");
        r.add("<!DOCTYPE");
        r.add("SYSTEM");
        r.add("PUBLIC");
        r.add("<?");
        r.add("?>");
        r.add("<%");
        r.add("%>");
        r.add("<%=");
        r.add("<%@");
        r.add("${");
        r.add("");
        StringHashToCharSequencesMap stringHashToCharSequencesMap = r;
        if (stringHashToCharSequencesMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "newStaticSet"));
        }
        return stringHashToCharSequencesMap;
    }

    public static void addStringsFromClassToStatics(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/source/CharTableImpl", "addStringsFromClassToStatics"));
        }
        for (Field field : aClass.getDeclaredFields()) {
            String typeName;
            if ((field.getModifiers() & 8) == 0 || (field.getModifiers() & 1) == 0 || !String.class.equals(field.getType()) || (typeName = ReflectionUtil.getStaticFieldValue(aClass, String.class, field.getName())) == null) continue;
            CharTableImpl.staticIntern(typeName);
        }
    }

    private static int subSequenceHashCode(@NotNull CharSequence sequence, int startOffset, int endOffset) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/psi/impl/source/CharTableImpl", "subSequenceHashCode"));
        }
        if (startOffset == 0 && endOffset == sequence.length()) {
            return StringUtil.stringHashCode(sequence);
        }
        return StringUtil.stringHashCode(sequence, startOffset, endOffset);
    }

    static {
        CharTableImpl.addStringsFromClassToStatics(CommonClassNames.class);
    }

    private static class StringHashToCharSequencesMap
    extends TIntObjectHashMap<Object> {
        private StringHashToCharSequencesMap(int capacity, float loadFactor) {
            super(capacity, loadFactor);
        }

        private CharSequence get(@NotNull CharSequence sequence, int startOffset, int endOffset) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "get"));
            }
            return this.getSubSequenceWithHashCode(CharTableImpl.subSequenceHashCode(sequence, startOffset, endOffset), sequence, startOffset, endOffset);
        }

        private CharSequence getSubSequenceWithHashCode(int hashCode, @NotNull CharSequence sequence, int startOffset, int endOffset) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "getSubSequenceWithHashCode"));
            }
            Object o = this.get(hashCode);
            if (o == null) {
                return null;
            }
            if (o instanceof CharSequence) {
                if (StringHashToCharSequencesMap.charSequenceSubSequenceEquals((CharSequence)o, sequence, startOffset, endOffset)) {
                    return (CharSequence)o;
                }
                return null;
            }
            if (o instanceof CharSequence[]) {
                for (CharSequence cs : (CharSequence[])o) {
                    if (!StringHashToCharSequencesMap.charSequenceSubSequenceEquals(cs, sequence, startOffset, endOffset)) continue;
                    return cs;
                }
                return null;
            }
            assert (false) : o.getClass();
            return null;
        }

        private static boolean charSequenceSubSequenceEquals(@NotNull CharSequence cs, @NotNull CharSequence baseSequence, int startOffset, int endOffset) {
            if (cs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cs", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "charSequenceSubSequenceEquals"));
            }
            if (baseSequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseSequence", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "charSequenceSubSequenceEquals"));
            }
            if (cs.length() != endOffset - startOffset) {
                return false;
            }
            if (cs == baseSequence && startOffset == 0) {
                return true;
            }
            int len = cs.length();
            for (int i2 = 0; i2 < len; ++i2) {
                if (cs.charAt(i2) == baseSequence.charAt(startOffset + i2)) continue;
                return false;
            }
            return true;
        }

        private CharSequence get(@NotNull CharSequence sequence) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "get"));
            }
            return this.get(sequence, 0, sequence.length());
        }

        @NotNull
        private CharSequence add(@NotNull CharSequence sequence) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "add"));
            }
            CharSequence charSequence = this.add(sequence, 0, sequence.length());
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "add"));
            }
            return charSequence;
        }

        @NotNull
        private CharSequence add(CharSequence sequence, int startOffset, int endOffset) {
            int hashCode = CharTableImpl.subSequenceHashCode(sequence, startOffset, endOffset);
            CharSequence charSequence = this.getOrAddSubSequenceWithHashCode(hashCode, sequence, startOffset, endOffset);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "add"));
            }
            return charSequence;
        }

        @NotNull
        private CharSequence getOrAddSubSequenceWithHashCode(int hashCode, @NotNull CharSequence sequence, int startOffset, int endOffset) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "getOrAddSubSequenceWithHashCode"));
            }
            int index = this.index(hashCode);
            String addedSequence = null;
            if (index < 0) {
                addedSequence = CharTableImpl.createSequence(sequence, startOffset, endOffset);
                this.put(hashCode, addedSequence);
            } else {
                Object value = this._values[index];
                if (value instanceof CharSequence) {
                    CharSequence existingSequence = (CharSequence)value;
                    if (StringHashToCharSequencesMap.charSequenceSubSequenceEquals(existingSequence, sequence, startOffset, endOffset)) {
                        CharSequence charSequence = existingSequence;
                        if (charSequence == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "getOrAddSubSequenceWithHashCode"));
                        }
                        return charSequence;
                    }
                    CharSequence[] charSequenceArray = new CharSequence[2];
                    charSequenceArray[0] = existingSequence;
                    addedSequence = CharTableImpl.createSequence(sequence, startOffset, endOffset);
                    charSequenceArray[1] = addedSequence;
                    this.put(hashCode, charSequenceArray);
                } else if (value instanceof CharSequence[]) {
                    CharSequence[] existingSequenceArray;
                    for (CharSequence cs : existingSequenceArray = (CharSequence[])value) {
                        if (!StringHashToCharSequencesMap.charSequenceSubSequenceEquals(cs, sequence, startOffset, endOffset)) continue;
                        CharSequence charSequence = cs;
                        if (charSequence == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "getOrAddSubSequenceWithHashCode"));
                        }
                        return charSequence;
                    }
                    CharSequence[] newSequenceArray = new CharSequence[existingSequenceArray.length + 1];
                    System.arraycopy(existingSequenceArray, 0, newSequenceArray, 0, existingSequenceArray.length);
                    addedSequence = CharTableImpl.createSequence(sequence, startOffset, endOffset);
                    newSequenceArray[existingSequenceArray.length] = addedSequence;
                    this.put(hashCode, newSequenceArray);
                } else assert (false) : value.getClass();
            }
            String string = addedSequence;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap", "getOrAddSubSequenceWithHashCode"));
            }
            return string;
        }
    }
}

