/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Set;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MismatchedStringBuilderQueryUpdateInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> returnSelfNames = ContainerUtil.set("append", "appendCodePoint", "delete", "deleteCharAt", "insert", "replace", "reverse");

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("MismatchedQueryAndUpdateOfStringBuilder" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection", "getID"));
        }
        return "MismatchedQueryAndUpdateOfStringBuilder";
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.string.builder.query.update.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean updated = (Boolean)infos[0];
        PsiType type = (PsiType)infos[1];
        if (updated) {
            String string = InspectionGadgetsBundle.message("mismatched.string.builder.updated.problem.descriptor", type.getPresentableText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.string.builder.queried.problem.descriptor", type.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedQueryAndUpdateOfStringBuilderVisitor();
    }

    public static boolean isStringBuilderUpdated(PsiVariable variable, PsiElement context) {
        StringBuilderUpdateCalledVisitor visitor = new StringBuilderUpdateCalledVisitor(variable);
        context.accept(visitor);
        return visitor.isUpdated();
    }

    private static boolean isStringBuilderQueried(PsiVariable variable, PsiElement context) {
        StringBuilderQueryCalledVisitor visitor = new StringBuilderQueryCalledVisitor(variable);
        context.accept(visitor);
        return visitor.isQueried();
    }

    private static boolean isVariableValueUsed(PsiExpression expression) {
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)parent;
            return MismatchedStringBuilderQueryUpdateInspection.isVariableValueUsed(parenthesizedExpression);
        }
        if (parent instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            return MismatchedStringBuilderQueryUpdateInspection.isVariableValueUsed(typeCastExpression);
        }
        if (parent instanceof PsiReturnStatement) {
            return true;
        }
        if (parent instanceof PsiExpressionList) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiMethodCallExpression) {
                return true;
            }
        } else {
            if (parent instanceof PsiArrayInitializerExpression) {
                return true;
            }
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression rhs = assignmentExpression.getRExpression();
                return expression.equals(rhs);
            }
            if (parent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)parent;
                PsiExpression initializer = variable.getInitializer();
                return expression.equals(initializer);
            }
        }
        return false;
    }

    private static boolean hasReferenceToVariable(PsiVariable variable, PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            return referenceExpression.isReferenceTo(variable);
        }
        if (element instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
            PsiExpression expression = parenthesizedExpression.getExpression();
            return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, expression);
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (returnSelfNames.contains(name)) {
                return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, methodExpression.getQualifierExpression());
            }
        } else if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, thenExpression)) {
                return true;
            }
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, elseExpression);
        }
        return false;
    }

    private static class StringBuilderQueryCalledVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NonNls
        private static final Set<String> queryNames = ContainerUtil.set("toString", "indexOf", "lastIndexOf", "capacity", "charAt", "codePointAt", "codePointBefore", "codePointCount", "equals", "getChars", "hashCode", "length", "offsetByCodePoints", "subSequence", "substring");
        private final PsiVariable variable;
        private boolean queried;

        private StringBuilderQueryCalledVisitor(PsiVariable variable) {
            this.variable = variable;
        }

        public boolean isQueried() {
            return this.queried;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection$StringBuilderQueryCalledVisitor", "visitElement"));
            }
            if (this.queried) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.queried) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses(expression);
            if (!(parent instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (!JavaTokenType.PLUS.equals(tokenType)) {
                return;
            }
            PsiElement target = expression.resolve();
            if (!this.variable.equals(target)) {
                return;
            }
            PsiType type = polyadicExpression.getType();
            if (type == null || !type.equalsToText("java.lang.String")) {
                return;
            }
            this.queried = true;
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.queried) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!queryNames.contains(name)) {
                if (returnSelfNames.contains(name) && MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, qualifierExpression) && MismatchedStringBuilderQueryUpdateInspection.isVariableValueUsed(expression)) {
                    this.queried = true;
                }
                return;
            }
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, qualifierExpression)) {
                Object parent = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class, PsiLambdaExpression.class);
                if (parent instanceof PsiStatement && !SideEffectChecker.mayHaveSideEffects(parent, this::isSideEffectFreeBuilderMethodCall)) {
                    return;
                }
                this.queried = true;
            }
        }

        private boolean isSideEffectFreeBuilderMethodCall(PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            return !"getChars".equals(methodExpression.getReferenceName()) && ExpressionUtils.isReferenceTo(methodExpression.getQualifierExpression(), this.variable);
        }
    }

    private static class StringBuilderUpdateCalledVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NonNls
        private static final Set<String> updateNames = ContainerUtil.set("append", "appendCodePoint", "delete", "deleteCharAt", "insert", "replace", "reverse", "setCharAt", "setLength");
        private final PsiVariable variable;
        private boolean updated;

        public StringBuilderUpdateCalledVisitor(PsiVariable variable) {
            this.variable = variable;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.updated) {
                return;
            }
            super.visitMethodCallExpression(expression);
            this.checkReferenceExpression(expression.getMethodExpression());
        }

        @Override
        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            if (this.updated) {
                return;
            }
            super.visitMethodReferenceExpression(expression);
            this.checkReferenceExpression(expression);
        }

        private void checkReferenceExpression(PsiReferenceExpression methodExpression) {
            String name = methodExpression.getReferenceName();
            if (!updateNames.contains(name)) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, qualifierExpression)) {
                this.updated = true;
            }
        }
    }

    private static class MismatchedQueryAndUpdateOfStringBuilderVisitor
    extends BaseInspectionVisitor {
        private MismatchedQueryAndUpdateOfStringBuilderVisitor() {
        }

        @Override
        public void visitField(PsiField field) {
            boolean updated;
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass(field);
            if (!MismatchedQueryAndUpdateOfStringBuilderVisitor.checkVariable(field, containingClass)) {
                return;
            }
            boolean queried = MismatchedQueryAndUpdateOfStringBuilderVisitor.stringBuilderContentsAreQueried(field, containingClass);
            if (queried == (updated = MismatchedQueryAndUpdateOfStringBuilderVisitor.stringBuilderContentsAreUpdated(field, containingClass)) || UnusedSymbolUtil.isImplicitWrite(field.getProject(), field, null)) {
                return;
            }
            this.registerFieldError(field, updated, field.getType());
        }

        @Override
        public void visitLocalVariable(PsiLocalVariable variable) {
            boolean updated;
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!MismatchedQueryAndUpdateOfStringBuilderVisitor.checkVariable(variable, codeBlock)) {
                return;
            }
            boolean queried = MismatchedQueryAndUpdateOfStringBuilderVisitor.stringBuilderContentsAreQueried(variable, codeBlock);
            if (queried == (updated = MismatchedQueryAndUpdateOfStringBuilderVisitor.stringBuilderContentsAreUpdated(variable, codeBlock))) {
                return;
            }
            this.registerVariableError(variable, updated, variable.getType());
        }

        private static boolean checkVariable(PsiVariable variable, PsiElement context) {
            if (context == null) {
                return false;
            }
            if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.lang.AbstractStringBuilder")) {
                return false;
            }
            if (!(PsiUtil.skipParenthesizedExprDown(variable.getInitializer()) instanceof PsiNewExpression)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context)) {
                return false;
            }
            return !VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        private static boolean stringBuilderContentsAreUpdated(PsiVariable variable, PsiElement context) {
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !ConstructionUtils.isEmptyStringBuilderInitializer(initializer)) {
                return true;
            }
            return MismatchedStringBuilderQueryUpdateInspection.isStringBuilderUpdated(variable, context);
        }

        private static boolean stringBuilderContentsAreQueried(PsiVariable variable, PsiElement context) {
            return MismatchedStringBuilderQueryUpdateInspection.isStringBuilderQueried(variable, context);
        }
    }
}

