/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class ParameterNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 20;

    @Override
    @NotNull
    public String getID() {
        if ("MethodParameterNamingConvention" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ParameterNamingConventionInspectionBase", "getID"));
        }
        return "MethodParameterNamingConvention";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameter.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ParameterNamingConventionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("parameter.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 20;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitParameter(@NotNull PsiParameter variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/naming/ParameterNamingConventionInspectionBase$NamingConventionsVisitor", "visitParameter"));
            }
            PsiElement scope = variable.getDeclarationScope();
            if (scope instanceof PsiCatchSection || scope instanceof PsiForeachStatement || scope instanceof PsiLambdaExpression) {
                return;
            }
            String name = variable.getName();
            if (name == null || ParameterNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            this.registerVariableError(variable, name);
        }
    }
}

