/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import org.jetbrains.annotations.NotNull;

final class OneElementFMap
implements KeyFMap {
    private final Key myKey;
    private final Object myValue;

    public <V> OneElementFMap(@NotNull Key<V> key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/keyFMap/OneElementFMap", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/keyFMap/OneElementFMap", "<init>"));
        }
        this.myKey = key;
        this.myValue = value;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/keyFMap/OneElementFMap", "plus"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/keyFMap/OneElementFMap", "plus"));
        }
        if (this.myKey == key) {
            OneElementFMap oneElementFMap = value == this.myValue ? this : new OneElementFMap(key, value);
            if (oneElementFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/OneElementFMap", "plus"));
            }
            return oneElementFMap;
        }
        PairElementsFMap pairElementsFMap = new PairElementsFMap(this.myKey, this.myValue, key, value);
        if (pairElementsFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/OneElementFMap", "plus"));
        }
        return pairElementsFMap;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/keyFMap/OneElementFMap", "minus"));
        }
        KeyFMap keyFMap = key == this.myKey ? KeyFMap.EMPTY_MAP : this;
        if (keyFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/OneElementFMap", "minus"));
        }
        return keyFMap;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/keyFMap/OneElementFMap", "get"));
        }
        return (V)(this.myKey == key ? this.myValue : null);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        Key[] keyArray = new Key[]{this.myKey};
        if (keyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/OneElementFMap", "getKeys"));
        }
        return keyArray;
    }

    public String toString() {
        return "{" + this.myKey + "=" + this.myValue + "}";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getValueIdentityHashCode() {
        return this.myKey.hashCode() * 31 + System.identityHashCode(this.myValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OneElementFMap)) {
            return false;
        }
        OneElementFMap map = (OneElementFMap)o;
        return this.myKey == map.myKey && this.myValue.equals(map.myValue);
    }

    @Override
    public boolean equalsByReference(KeyFMap o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OneElementFMap)) {
            return false;
        }
        OneElementFMap map = (OneElementFMap)o;
        return this.myKey == map.myKey && this.myValue == map.myValue;
    }

    public int hashCode() {
        return this.myKey.hashCode() ^ this.myValue.hashCode();
    }
}

