/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyUtil {
    @NonNls
    private static final String IS_PREFIX = "is";
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PropertyUtil");

    private PropertyUtil() {
    }

    @Contract(value="null -> false")
    public static boolean isSimplePropertyGetter(@Nullable PsiMethod method) {
        return PropertyUtil.hasGetterName(method) && method.getParameterList().getParametersCount() == 0;
    }

    public static boolean hasGetterName(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        int methodNameLength = methodName.length();
        if (methodName.startsWith("get") && methodNameLength > "get".length()) {
            if (Character.isLowerCase(methodName.charAt("get".length())) && (methodNameLength == "get".length() + 1 || Character.isLowerCase(methodName.charAt("get".length() + 1)))) {
                return false;
            }
            PsiType returnType = method.getReturnType();
            return returnType == null || !PsiType.VOID.equals(returnType);
        }
        if (methodName.startsWith(IS_PREFIX) && methodNameLength > IS_PREFIX.length()) {
            if (Character.isLowerCase(methodName.charAt(IS_PREFIX.length())) && (methodNameLength == IS_PREFIX.length() + 1 || Character.isLowerCase(methodName.charAt(IS_PREFIX.length() + 1)))) {
                return false;
            }
            PsiType returnType = method.getReturnType();
            return PropertyUtil.isBoolean(returnType);
        }
        return false;
    }

    public static boolean isSimplePropertySetter(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        if (!methodName.startsWith("set") || methodName.length() <= "set".length()) {
            return false;
        }
        if (Character.isLowerCase(methodName.charAt("set".length())) && (methodName.length() == "set".length() + 1 || Character.isLowerCase(methodName.charAt("set".length() + 1)))) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        if (returnType == null || PsiType.VOID.equals(returnType)) {
            return true;
        }
        return Comparing.equal(PsiUtil.resolveClassInType(TypeConversionUtil.erasure(returnType)), method.getContainingClass());
    }

    @Nullable
    public static String getPropertyName(@NotNull PsiMethod method) {
        if (method == null) {
            PropertyUtil.$$$reportNull$$$0(0);
        }
        if (PropertyUtil.isSimplePropertyGetter(method)) {
            return PropertyUtil.getPropertyNameByGetter(method);
        }
        if (PropertyUtil.isSimplePropertySetter(method)) {
            return PropertyUtil.getPropertyNameBySetter(method);
        }
        return null;
    }

    @NotNull
    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        String methodName = getterMethod.getName();
        if (methodName.startsWith("get")) {
            String string = StringUtil.decapitalize(methodName.substring(3));
            if (string == null) {
                PropertyUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (methodName.startsWith(IS_PREFIX)) {
            String string = StringUtil.decapitalize(methodName.substring(2));
            if (string == null) {
                PropertyUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = methodName;
        if (string == null) {
            PropertyUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getPropertyNameBySetter(@NotNull PsiMethod setterMethod) {
        if (setterMethod == null) {
            PropertyUtil.$$$reportNull$$$0(4);
        }
        String methodName = setterMethod.getName();
        String string = Introspector.decapitalize(methodName.substring(3));
        if (string == null) {
            PropertyUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters) {
        if (psiClass == null) {
            PropertyUtil.$$$reportNull$$$0(6);
        }
        Map<String, PsiMethod> map = PropertyUtil.getAllProperties(psiClass, acceptSetters, acceptGetters, true);
        if (map == null) {
            PropertyUtil.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters, boolean includeSuperClass) {
        if (psiClass == null) {
            PropertyUtil.$$$reportNull$$$0(8);
        }
        Map<String, PsiMethod> map = PropertyUtil.getAllProperties(acceptSetters, acceptGetters, includeSuperClass ? psiClass.getAllMethods() : psiClass.getMethods());
        if (map == null) {
            PropertyUtil.$$$reportNull$$$0(9);
        }
        return map;
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(boolean acceptSetters, boolean acceptGetters, PsiMethod[] methods) {
        HashMap<String, PsiMethod> map = new HashMap<String, PsiMethod>();
        for (PsiMethod method : methods) {
            if (PropertyUtil.filterMethods(method) || (!acceptSetters || !PropertyUtil.isSimplePropertySetter(method)) && (!acceptGetters || !PropertyUtil.isSimplePropertyGetter(method))) continue;
            map.put(PropertyUtil.getPropertyName(method), method);
        }
        HashMap<String, PsiMethod> hashMap = map;
        if (hashMap == null) {
            PropertyUtil.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    private static boolean filterMethods(PsiMethod method) {
        if (method.hasModifierProperty("static") || !method.hasModifierProperty("public")) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        String className = psiClass.getQualifiedName();
        return "java.lang.Object".equals(className);
    }

    @NotNull
    public static List<PsiMethod> getSetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            PropertyUtil.$$$reportNull$$$0(11);
        }
        String setterName = PropertyUtil.suggestSetterName(propertyName);
        PsiMethod[] psiMethods = psiClass.findMethodsByName(setterName, true);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>(psiMethods.length);
        for (PsiMethod method : psiMethods) {
            if (PropertyUtil.filterMethods(method) || !PropertyUtil.isSimplePropertySetter(method)) continue;
            list.add(method);
        }
        ArrayList<PsiMethod> arrayList = list;
        if (arrayList == null) {
            PropertyUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiMethod> getGetters(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            PropertyUtil.$$$reportNull$$$0(13);
        }
        String[] names = PropertyUtil.suggestGetterNames(propertyName);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        for (String name : names) {
            PsiMethod[] psiMethods;
            for (PsiMethod method : psiMethods = psiClass.findMethodsByName(name, true)) {
                if (PropertyUtil.filterMethods(method) || !PropertyUtil.isSimplePropertyGetter(method)) continue;
                list.add(method);
            }
        }
        ArrayList<PsiMethod> arrayList = list;
        if (arrayList == null) {
            PropertyUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiMethod> getAccessors(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            PropertyUtil.$$$reportNull$$$0(15);
        }
        List<PsiMethod> list = ContainerUtil.concat(PropertyUtil.getGetters(psiClass, propertyName), PropertyUtil.getSetters(psiClass, propertyName));
        if (list == null) {
            PropertyUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        String[] getterCandidateNames;
        if (propertyName == null) {
            PropertyUtil.$$$reportNull$$$0(17);
        }
        if (aClass == null) {
            return null;
        }
        for (String getterCandidateName : getterCandidateNames = PropertyUtil.suggestGetterNames(propertyName)) {
            PsiMethod[] getterCandidates;
            for (PsiMethod method : getterCandidates = aClass.findMethodsByName(getterCandidateName, checkSuperClasses)) {
                if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertyGetter(method) || !PropertyUtil.getPropertyNameByGetter(method).equals(propertyName)) continue;
                return method;
            }
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertyGetterWithType(String propertyName, boolean isStatic, PsiType type, Iterator<PsiMethod> methods) {
        while (methods.hasNext()) {
            PsiMethod method = methods.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertyGetter(method) || !PropertyUtil.getPropertyNameByGetter(method).equals(propertyName) || !type.equals(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method) {
        return PropertyUtil.isSimplePropertyGetter(method) || PropertyUtil.isSimplePropertySetter(method);
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        PsiMethod[] methods;
        if (propertyName == null) {
            PropertyUtil.$$$reportNull$$$0(18);
        }
        if (aClass == null) {
            return null;
        }
        String setterName = PropertyUtil.suggestSetterName(propertyName);
        for (PsiMethod method : methods = aClass.findMethodsByName(setterName, checkSuperClasses)) {
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertySetter(method) || !PropertyUtil.getPropertyNameBySetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertySetterWithType(String propertyName, boolean isStatic, PsiType type, Iterator<PsiMethod> methods) {
        while (methods.hasNext()) {
            PsiType methodType;
            PsiMethod method = methods.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertySetter(method) || !PropertyUtil.getPropertyNameBySetter(method).equals(propertyName) || !type.equals(methodType = method.getParameterList().getParameters()[0].getType())) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyField(PsiClass aClass, String propertyName, boolean isStatic) {
        PsiField[] fields;
        for (PsiField field : fields = aClass.getAllFields()) {
            if (field.hasModifierProperty("static") != isStatic || !propertyName.equals(PropertyUtil.suggestPropertyName(field))) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static String getPropertyName(@NonNls @NotNull String methodName) {
        if (methodName == null) {
            PropertyUtil.$$$reportNull$$$0(19);
        }
        return StringUtil.getPropertyName(methodName);
    }

    public static String suggestGetterName(@NonNls @NotNull String propertyName, @Nullable PsiType propertyType) {
        if (propertyName == null) {
            PropertyUtil.$$$reportNull$$$0(20);
        }
        return PropertyUtil.suggestGetterName(propertyName, propertyType, null);
    }

    public static String suggestGetterName(@NotNull String propertyName, @Nullable PsiType propertyType, @NonNls String existingGetterName) {
        if (propertyName == null) {
            PropertyUtil.$$$reportNull$$$0(21);
        }
        StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention(StringUtil.sanitizeJavaIdentifier(propertyName)));
        if (PropertyUtil.isBoolean(propertyType)) {
            if (existingGetterName == null || !existingGetterName.startsWith("get")) {
                name.insert(0, IS_PREFIX);
            } else {
                name.insert(0, "get");
            }
        } else {
            name.insert(0, "get");
        }
        return name.toString();
    }

    private static boolean isBoolean(@Nullable PsiType propertyType) {
        return PsiType.BOOLEAN.equals(propertyType);
    }

    @NonNls
    @NotNull
    public static String[] suggestGetterNames(@NotNull String propertyName) {
        if (propertyName == null) {
            PropertyUtil.$$$reportNull$$$0(22);
        }
        String str = StringUtil.capitalizeWithJavaBeanConvention(StringUtil.sanitizeJavaIdentifier(propertyName));
        String[] stringArray = new String[]{IS_PREFIX + str, "get" + str};
        if (stringArray == null) {
            PropertyUtil.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    public static String suggestSetterName(@NonNls @NotNull String propertyName) {
        if (propertyName == null) {
            PropertyUtil.$$$reportNull$$$0(24);
        }
        return PropertyUtil.suggestSetterName(propertyName, "set");
    }

    public static String suggestSetterName(@NonNls @NotNull String propertyName, String setterPrefix) {
        if (propertyName == null) {
            PropertyUtil.$$$reportNull$$$0(25);
        }
        String sanitizeJavaIdentifier = StringUtil.sanitizeJavaIdentifier(propertyName);
        if (StringUtil.isEmpty(setterPrefix)) {
            return sanitizeJavaIdentifier;
        }
        StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention(sanitizeJavaIdentifier));
        name.insert(0, setterPrefix);
        return name.toString();
    }

    @NotNull
    public static String[] getReadableProperties(@NotNull PsiClass aClass, boolean includeSuperClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            PropertyUtil.$$$reportNull$$$0(26);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (PsiMethod method : methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods()) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtil.isSimplePropertyGetter(method)) continue;
            result.add(PropertyUtil.getPropertyName(method));
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            PropertyUtil.$$$reportNull$$$0(27);
        }
        return stringArray;
    }

    @NotNull
    public static String[] getWritableProperties(@NotNull PsiClass aClass, boolean includeSuperClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            PropertyUtil.$$$reportNull$$$0(28);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (PsiMethod method : methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods()) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtil.isSimplePropertySetter(method)) continue;
            result.add(PropertyUtil.getPropertyName(method));
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            PropertyUtil.$$$reportNull$$$0(29);
        }
        return stringArray;
    }

    @Nullable
    public static PsiMethod generateGetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            PropertyUtil.$$$reportNull$$$0(30);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(field.getProject()).getElementFactory();
        Project project = field.getProject();
        String name = field.getName();
        String getName = PropertyUtil.suggestGetterName(field);
        try {
            PsiMethod getMethod = factory.createMethod(getName, field.getType());
            PsiUtil.setModifierProperty(getMethod, "public", true);
            if (field.hasModifierProperty("static")) {
                PsiUtil.setModifierProperty(getMethod, "static", true);
            }
            NullableNotNullManager.getInstance(project).copyNullableOrNotNullAnnotation(field, getMethod);
            PsiCodeBlock body = factory.createCodeBlockFromText("{\nreturn " + name + ";\n}", null);
            getMethod.getBody().replace(body);
            getMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(getMethod);
            return getMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            PropertyUtil.$$$reportNull$$$0(31);
        }
        return PropertyUtil.generateSetterPrototype(field, field.getContainingClass());
    }

    @Nullable
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, @NotNull PsiClass containingClass) {
        if (field == null) {
            PropertyUtil.$$$reportNull$$$0(32);
        }
        if (containingClass == null) {
            PropertyUtil.$$$reportNull$$$0(33);
        }
        return PropertyUtil.generateSetterPrototype(field, containingClass, false);
    }

    @Nullable
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, @NotNull PsiClass containingClass, boolean returnSelf) {
        if (field == null) {
            PropertyUtil.$$$reportNull$$$0(34);
        }
        if (containingClass == null) {
            PropertyUtil.$$$reportNull$$$0(35);
        }
        Project project = field.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
        PsiElementFactory factory = JavaPsiFacade.getInstance(field.getProject()).getElementFactory();
        String name = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String propertyName = codeStyleManager.variableNameToPropertyName(name, kind);
        String setName = PropertyUtil.suggestSetterName(field);
        PsiMethod setMethod = factory.createMethodFromText(factory.createMethod(setName, returnSelf ? factory.createType(containingClass) : PsiType.VOID).getText(), field);
        String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
        PsiParameter param = factory.createParameter(parameterName, field.getType());
        NullableNotNullManager.getInstance(project).copyNullableOrNotNullAnnotation(field, param);
        setMethod.getParameterList().add(param);
        PsiUtil.setModifierProperty(setMethod, "public", true);
        PsiUtil.setModifierProperty(setMethod, "static", isStatic);
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        if (name.equals(parameterName)) {
            if (!isStatic) {
                buffer.append("this.");
            } else {
                String className = containingClass.getName();
                if (className != null) {
                    buffer.append(className);
                    buffer.append(".");
                }
            }
        }
        buffer.append(name);
        buffer.append("=");
        buffer.append(parameterName);
        buffer.append(";\n");
        if (returnSelf) {
            buffer.append("return this;\n");
        }
        buffer.append("}");
        PsiCodeBlock body = factory.createCodeBlockFromText(buffer.toString(), null);
        setMethod.getBody().replace(body);
        setMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(setMethod);
        return setMethod;
    }

    public static void annotateWithNullableStuff(@NotNull PsiModifierListOwner field, @NotNull PsiModifierListOwner listOwner) throws IncorrectOperationException {
        if (field == null) {
            PropertyUtil.$$$reportNull$$$0(36);
        }
        if (listOwner == null) {
            PropertyUtil.$$$reportNull$$$0(37);
        }
        NullableNotNullManager.getInstance(field.getProject()).copyNullableOrNotNullAnnotation(field, listOwner);
    }

    public static String suggestPropertyName(@NotNull PsiField field) {
        if (field == null) {
            PropertyUtil.$$$reportNull$$$0(38);
        }
        return PropertyUtil.suggestPropertyName(field, field.getName());
    }

    @NotNull
    public static String suggestPropertyName(@NotNull PsiField field, @NotNull String fieldName) {
        if (field == null) {
            PropertyUtil.$$$reportNull$$$0(39);
        }
        if (fieldName == null) {
            PropertyUtil.$$$reportNull$$$0(40);
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(field.getProject());
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String name = codeStyleManager.variableNameToPropertyName(fieldName, kind);
        if (!field.hasModifierProperty("static") && PropertyUtil.isBoolean(field.getType()) && name.startsWith(IS_PREFIX) && name.length() > IS_PREFIX.length() && Character.isUpperCase(name.charAt(IS_PREFIX.length()))) {
            name = Introspector.decapitalize(name.substring(IS_PREFIX.length()));
        }
        String string = name;
        if (string == null) {
            PropertyUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    public static String suggestGetterName(PsiField field) {
        String propertyName = PropertyUtil.suggestPropertyName(field);
        return PropertyUtil.suggestGetterName(propertyName, field.getType());
    }

    public static String suggestSetterName(PsiField field) {
        String propertyName = PropertyUtil.suggestPropertyName(field);
        return PropertyUtil.suggestSetterName(propertyName);
    }

    @Nullable
    public static String getPropertyName(PsiMember member) {
        if (member instanceof PsiMethod) {
            return PropertyUtil.getPropertyName((PsiMethod)member);
        }
        if (member instanceof PsiField) {
            return member.getName();
        }
        return null;
    }

    @Nullable
    public static PsiType getPropertyType(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getType();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtil.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnType();
            }
            if (PropertyUtil.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getType();
            }
        }
        return null;
    }

    @Nullable
    public static PsiTypeElement getPropertyTypeElement(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getTypeElement();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtil.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnTypeElement();
            }
            if (PropertyUtil.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getTypeElement();
            }
        }
        return null;
    }

    @Nullable
    public static PsiIdentifier getPropertyNameIdentifier(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getNameIdentifier();
        }
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).getNameIdentifier();
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyFieldByMember(PsiMember psiMember) {
        if (psiMember instanceof PsiField) {
            return (PsiField)psiMember;
        }
        if (psiMember instanceof PsiMethod) {
            PsiElement resolved;
            PsiExpression target;
            PsiStatement statement;
            PsiMethod psiMethod = (PsiMethod)psiMember;
            PsiType returnType = psiMethod.getReturnType();
            if (returnType == null) {
                return null;
            }
            PsiCodeBlock body = psiMethod.getBody();
            PsiStatement[] statements = body == null ? null : body.getStatements();
            PsiStatement psiStatement = statement = statements == null || statements.length != 1 ? null : statements[0];
            if (PsiType.VOID.equals(returnType)) {
                PsiExpression expression = statement instanceof PsiExpressionStatement ? ((PsiExpressionStatement)statement).getExpression() : null;
                target = expression instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)expression).getLExpression() : null;
            } else {
                target = statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null;
            }
            PsiElement psiElement = resolved = target instanceof PsiReferenceExpression ? ((PsiReferenceExpression)target).resolve() : null;
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                if (psiMember.getContainingClass() == field.getContainingClass() || psiMember.getContainingClass().isInheritor(field.getContainingClass(), true)) {
                    return field;
                }
            }
        }
        return null;
    }

    public static PsiMethod findSetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = PropertyUtil.suggestPropertyName(field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtil.findPropertySetter(containingClass, propertyName, isStatic, true);
    }

    public static PsiMethod findGetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = PropertyUtil.suggestPropertyName(field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtil.findPropertyGetter(containingClass, propertyName, isStatic, true);
    }

    @Nullable
    public static PsiExpression getGetterReturnExpression(PsiMethod method) {
        return method != null && PropertyUtil.hasGetterSignature(method) ? PropertyUtil.getSingleReturnValue(method) : null;
    }

    private static boolean hasGetterSignature(@NotNull PsiMethod method) {
        if (method == null) {
            PropertyUtil.$$$reportNull$$$0(42);
        }
        return PropertyUtil.isSimplePropertyGetter(method) && !method.hasModifierProperty("synchronized");
    }

    @Nullable
    public static PsiExpression getSingleReturnValue(@NotNull PsiMethod method) {
        PsiCodeBlock body;
        if (method == null) {
            PropertyUtil.$$$reportNull$$$0(43);
        }
        if ((body = method.getBody()) == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        PsiStatement statement = statements.length != 1 ? null : statements[0];
        return statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null;
    }

    @Nullable
    public static PsiField getFieldOfGetter(PsiMethod method) {
        PsiType returnType;
        PsiField field = PropertyUtil.getSimplyReturnedField(method, PropertyUtil.getGetterReturnExpression(method));
        if (field != null && (returnType = method.getReturnType()) != null && field.getType().equalsToText(returnType.getCanonicalText())) {
            return field;
        }
        return null;
    }

    @Nullable
    public static PsiField getSimplyReturnedField(PsiMethod method, @Nullable PsiExpression value) {
        if (!(value instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)value;
        if (PropertyUtil.hasSubstantialQualifier(reference)) {
            return null;
        }
        PsiElement referent = reference.resolve();
        if (!(referent instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)referent;
        return InheritanceUtil.isInheritorOrSelf(method.getContainingClass(), field.getContainingClass(), true) ? field : null;
    }

    private static boolean hasSubstantialQualifier(PsiReferenceExpression reference) {
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        if (qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
            return false;
        }
        if (qualifier instanceof PsiReferenceExpression) {
            return !(((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass);
        }
        return true;
    }

    public static boolean isSimpleGetter(PsiMethod method) {
        return PropertyUtil.getFieldOfGetter(method) != null;
    }

    @Nullable
    public static PsiField getFieldOfSetter(PsiMethod method) {
        PsiType parameterType;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (method == null) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 1) {
            return null;
        }
        String name = method.getName();
        if (!name.startsWith("set")) {
            return null;
        }
        if (method.hasModifierProperty("synchronized")) {
            return null;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return null;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpressionStatement possibleAssignmentStatement = (PsiExpressionStatement)statement;
        PsiExpression possibleAssignment = possibleAssignmentStatement.getExpression();
        if (!(possibleAssignment instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)possibleAssignment;
        if (!JavaTokenType.EQ.equals(assignment.getOperationTokenType())) {
            return null;
        }
        PsiExpression lhs = assignment.getLExpression();
        if (!(lhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier instanceof PsiReferenceExpression ? !((target = (referenceExpression = (PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass) : qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            return null;
        }
        PsiElement referent = reference.resolve();
        if (referent == null) {
            return null;
        }
        if (!(referent instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)referent;
        PsiClass fieldContainingClass = field.getContainingClass();
        PsiClass methodContainingClass = method.getContainingClass();
        if (!InheritanceUtil.isInheritorOrSelf(methodContainingClass, fieldContainingClass, true)) {
            return null;
        }
        PsiExpression rhs = assignment.getRExpression();
        if (!(rhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression rReference = (PsiReferenceExpression)rhs;
        PsiExpression rQualifier = rReference.getQualifierExpression();
        if (rQualifier != null) {
            return null;
        }
        PsiElement rReferent = rReference.resolve();
        if (rReferent == null) {
            return null;
        }
        if (!(rReferent instanceof PsiParameter)) {
            return null;
        }
        PsiType fieldType = field.getType();
        if (fieldType.equalsToText((parameterType = ((PsiVariable)rReferent).getType()).getCanonicalText())) {
            return field;
        }
        return null;
    }

    public static boolean isSimpleSetter(PsiMethod method) {
        return PropertyUtil.getFieldOfSetter(method) != null;
    }

    @Nullable
    public static PsiMethod getReversePropertyMethod(PsiMethod propertyMethod) {
        PsiField field;
        String prefix;
        if (propertyMethod == null) {
            return null;
        }
        PsiClass aClass = propertyMethod.getContainingClass();
        if (aClass == null) {
            return null;
        }
        String methodName = propertyMethod.getName();
        if (methodName.startsWith("get")) {
            prefix = "get";
        } else if (methodName.startsWith(IS_PREFIX)) {
            prefix = IS_PREFIX;
        } else if (methodName.startsWith("set")) {
            prefix = "set";
        } else {
            return null;
        }
        String name = methodName.substring(prefix.length());
        PsiField psiField = field = prefix.equals("set") ? PropertyUtil.getFieldOfSetter(propertyMethod) : PropertyUtil.getFieldOfGetter(propertyMethod);
        if (field == null) {
            return null;
        }
        if (prefix.equals("set")) {
            PsiMethod result = PropertyUtil.findPropertyMethod(aClass, "get", name, field);
            if (result != null) {
                return result;
            }
            return PropertyUtil.findPropertyMethod(aClass, IS_PREFIX, name, field);
        }
        return PropertyUtil.findPropertyMethod(aClass, "set", name, field);
    }

    private static PsiMethod findPropertyMethod(@NotNull PsiClass aClass, @NotNull String prefix, @NotNull String propertyName, @NotNull PsiField field1) {
        PsiMethod[] methods;
        if (aClass == null) {
            PropertyUtil.$$$reportNull$$$0(44);
        }
        if (prefix == null) {
            PropertyUtil.$$$reportNull$$$0(45);
        }
        if (propertyName == null) {
            PropertyUtil.$$$reportNull$$$0(46);
        }
        if (field1 == null) {
            PropertyUtil.$$$reportNull$$$0(47);
        }
        for (PsiMethod method : methods = aClass.findMethodsByName(prefix + propertyName, true)) {
            PsiField field2;
            PsiField psiField = field2 = prefix.equals("set") ? PropertyUtil.getFieldOfSetter(method) : PropertyUtil.getFieldOfGetter(method);
            if (!field1.equals(field2)) continue;
            return method;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 23: 
            case 27: 
            case 29: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 23: 
            case 27: 
            case 29: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 23: 
            case 27: 
            case 29: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PropertyUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setterMethod";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 26: 
            case 28: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field1";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PropertyUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNameByGetter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNameBySetter";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProperties";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetters";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestGetterNames";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableProperties";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritableProperties";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPropertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 23: 
            case 27: 
            case 29: 
            case 41: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameBySetter";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllProperties";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSetters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGetters";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAccessors";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyGetter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySetter";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "suggestGetterName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "suggestGetterNames";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "suggestSetterName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getReadableProperties";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getWritableProperties";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "generateGetterPrototype";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "generateSetterPrototype";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "annotateWithNullableStuff";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "suggestPropertyName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "hasGetterSignature";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSingleReturnValue";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 23: 
            case 27: 
            case 29: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

