/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ResourceHandle<T>
implements Closeable {
    private final T myResource;
    private final AtomicInteger myRefCount = new AtomicInteger(1);

    public ResourceHandle(T resource) {
        this.myResource = resource;
    }

    public void allocate() {
        this.myRefCount.incrementAndGet();
    }

    public final void release() {
        if (this.myRefCount.decrementAndGet() == 0) {
            this.disposeResource();
        }
    }

    public T get() {
        return this.myResource;
    }

    public int getRefCount() {
        return this.myRefCount.get();
    }

    protected abstract void disposeResource();

    @Override
    public void close() {
        this.release();
    }
}

