/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorFixExtensionPoint;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightControlFlowUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();

    private HighlightControlFlowUtil() {
    }

    @Nullable
    static HighlightInfo checkMissingReturnStatement(@Nullable PsiCodeBlock body, @Nullable PsiType returnType) {
        if (body == null || returnType == null || PsiType.VOID.equals(returnType.getDeepComponentType())) {
            return null;
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate(body);
            if (!ControlFlowUtil.returnPresent(controlFlow)) {
                PsiJavaToken rBrace = body.getRBrace();
                PsiElement context = rBrace == null ? body.getLastChild() : rBrace;
                String message = JavaErrorMessages.message("missing.return.statement", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(context).descriptionAndTooltip(message).create();
                PsiElement parent = body.getParent();
                if (parent instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)parent;
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAddReturnFix(method));
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createMethodReturnFix(method, PsiType.VOID, true));
                }
                return info;
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static ControlFlow getControlFlowNoConstantEvaluate(@NotNull PsiElement body) throws AnalysisCanceledException {
        if (body == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(0);
        }
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        ControlFlow controlFlow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow(body, policy, false, false);
        if (controlFlow == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(1);
        }
        return controlFlow;
    }

    @NotNull
    private static ControlFlow getControlFlow(@NotNull PsiElement context) throws AnalysisCanceledException {
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(2);
        }
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        ControlFlow controlFlow = ControlFlowFactory.getInstance(context.getProject()).getControlFlow(context, policy);
        if (controlFlow == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(3);
        }
        return controlFlow;
    }

    static HighlightInfo checkUnreachableStatement(@Nullable PsiCodeBlock codeBlock) {
        if (codeBlock == null) {
            return null;
        }
        try {
            AllVariablesControlFlowPolicy policy = AllVariablesControlFlowPolicy.getInstance();
            ControlFlow controlFlow = ControlFlowFactory.getInstance(codeBlock.getProject()).getControlFlow(codeBlock, policy, false, false);
            PsiElement unreachableStatement = ControlFlowUtil.getUnreachableStatement(controlFlow);
            if (unreachableStatement != null) {
                String description = JavaErrorMessages.message("unreachable.statement", new Object[0]);
                PsiElement keyword = null;
                if (unreachableStatement instanceof PsiIfStatement || unreachableStatement instanceof PsiSwitchStatement || unreachableStatement instanceof PsiLoopStatement) {
                    keyword = unreachableStatement.getFirstChild();
                }
                PsiElement element = keyword != null ? keyword : unreachableStatement;
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createDeleteFix(unreachableStatement, QuickFixBundle.message("delete.unreachable.statement.fix.text", new Object[0])));
                return info;
            }
        }
        catch (IndexNotReadyException | AnalysisCanceledException exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isFieldInitializedAfterObjectConstruction(@NotNull PsiField field) {
        if (field == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(4);
        }
        if (field.hasInitializer()) {
            return true;
        }
        boolean isFieldStatic = field.hasModifierProperty("static");
        PsiClass aClass = field.getContainingClass();
        if (aClass != null && HighlightControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, isFieldStatic)) {
            return true;
        }
        if (aClass == null) {
            return false;
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        if (HighlightControlFlowUtil.isFieldInitializedInClassInitializer(field, isFieldStatic, Arrays.stream(initializers))) {
            return true;
        }
        if (isFieldStatic) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        block0: for (PsiMethod constructor : constructors) {
            PsiCodeBlock ctrBody = constructor.getBody();
            if (ctrBody == null) {
                return false;
            }
            List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(constructor);
            for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                PsiCodeBlock body = redirectedConstructor.getBody();
                if (body != null && HighlightControlFlowUtil.variableDefinitelyAssignedIn(field, body)) continue block0;
            }
            if (!ctrBody.isValid() || HighlightControlFlowUtil.variableDefinitelyAssignedIn(field, ctrBody)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFieldInitializedInClassInitializer(@NotNull PsiField field, boolean isFieldStatic, Stream<PsiClassInitializer> initializers) {
        if (field == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(5);
        }
        return initializers.anyMatch(initializer -> {
            if (field == null) {
                HighlightControlFlowUtil.$$$reportNull$$$0(53);
            }
            return initializer.hasModifierProperty("static") == isFieldStatic && HighlightControlFlowUtil.variableDefinitelyAssignedIn(field, initializer.getBody());
        });
    }

    private static boolean isFieldInitializedInOtherFieldInitializer(@NotNull PsiClass aClass, @NotNull PsiField field, boolean fieldStatic) {
        PsiField[] fields;
        if (aClass == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(6);
        }
        if (field == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(7);
        }
        for (PsiField psiField : fields = aClass.getFields()) {
            if (psiField == field || psiField.hasModifierProperty("static") != fieldStatic || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(field, psiField)) continue;
            return true;
        }
        return false;
    }

    static boolean isRecursivelyCalledConstructor(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(8);
        }
        JavaHighlightUtil.ConstructorVisitorInfo info = new JavaHighlightUtil.ConstructorVisitorInfo();
        JavaHighlightUtil.visitConstructorChain(constructor, info);
        if (info.recursivelyCalledConstructor == null) {
            return false;
        }
        return info.visitedConstructors.indexOf(info.recursivelyCalledConstructor) <= info.visitedConstructors.indexOf(constructor);
    }

    public static boolean isAssigned(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(9);
        }
        ParamWriteProcessor processor = new ParamWriteProcessor();
        ReferencesSearch.search(parameter, new LocalSearchScope(parameter.getDeclarationScope()), true).forEach(processor);
        return processor.isWriteRefFound();
    }

    public static boolean variableDefinitelyAssignedIn(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(10);
        }
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(11);
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(context);
            return ControlFlowUtil.isVariableDefinitelyAssigned(variable, controlFlow);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    private static boolean variableDefinitelyNotAssignedIn(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(12);
        }
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(13);
        }
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(context);
            return ControlFlowUtil.isVariableDefinitelyNotAssigned(variable, controlFlow);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    @Nullable
    static HighlightInfo checkFinalFieldInitialized(@NotNull PsiField field) {
        if (field == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(14);
        }
        if (!field.hasModifierProperty("final")) {
            return null;
        }
        if (HighlightControlFlowUtil.isFieldInitializedAfterObjectConstruction(field)) {
            return null;
        }
        String description = JavaErrorMessages.message("variable.not.initialized", field.getName());
        TextRange range = HighlightNamesUtil.getFieldDeclarationTextRange(field);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange(field), QUICK_FIX_FACTORY.createCreateConstructorParameterFromFieldFix(field));
        QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange(field), QUICK_FIX_FACTORY.createInitializeFinalFieldInConstructorFix(field));
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && !containingClass.isInterface()) {
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(field, "final", false, false));
        }
        QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAddVariableInitializerFix(field));
        return highlightInfo;
    }

    @Nullable
    public static HighlightInfo checkVariableInitializedBeforeUsage(@NotNull PsiReferenceExpression expression, @NotNull PsiVariable variable, @NotNull Map<PsiElement, Collection<PsiReferenceExpression>> uninitializedVarProblems, @NotNull PsiFile containingFile) {
        PsiElement topBlock;
        if (expression == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(15);
        }
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(16);
        }
        if (uninitializedVarProblems == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(17);
        }
        if (containingFile == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(18);
        }
        if (variable instanceof ImplicitVariable) {
            return null;
        }
        if (!PsiUtil.isAccessedForReading(expression)) {
            return null;
        }
        int startOffset = expression.getTextRange().getStartOffset();
        if (variable.hasInitializer()) {
            topBlock = PsiUtil.getVariableCodeBlock(variable, variable);
            if (topBlock == null) {
                return null;
            }
        } else {
            PsiElement scope;
            PsiElement psiElement = variable instanceof PsiField ? ((PsiField)variable).getContainingClass() : (scope = variable.getParent() != null ? variable.getParent().getParent() : null);
            if (scope instanceof PsiCodeBlock && scope.getParent() instanceof PsiSwitchStatement) {
                scope = PsiTreeUtil.getParentOfType(scope, PsiCodeBlock.class);
            }
            PsiElement psiElement2 = topBlock = FileTypeUtils.isInServerPageFile(scope) && scope instanceof PsiFile ? scope : PsiUtil.getTopLevelEnclosingCodeBlock(expression, scope);
            if (variable instanceof PsiField) {
                PsiClass aClass;
                PsiCodeBlock block;
                if (!variable.hasModifierProperty("final")) {
                    return null;
                }
                if (PsiUtil.findEnclosingConstructorOrInitializer(expression) == null && HighlightUtil.findEnclosingFieldInitializer(expression) == null) {
                    return null;
                }
                if (topBlock == null) {
                    return null;
                }
                PsiElement parent = topBlock.getParent();
                if (HighlightControlFlowUtil.inInnerClass(expression, ((PsiField)variable).getContainingClass())) {
                    return null;
                }
                if (parent instanceof PsiMethod) {
                    PsiMethod constructor = (PsiMethod)parent;
                    if (!containingFile.getManager().areElementsEquivalent(constructor.getContainingClass(), ((PsiField)variable).getContainingClass())) {
                        return null;
                    }
                    if (variable.hasModifierProperty("static")) {
                        return null;
                    }
                    List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(constructor);
                    for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                        PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                        PsiMethod[] body = redirectedConstructor.getBody();
                        if (body == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, (PsiElement)body)) continue;
                        return null;
                    }
                    block = constructor.getBody();
                    aClass = constructor.getContainingClass();
                } else if (parent instanceof PsiClassInitializer) {
                    PsiClassInitializer classInitializer = (PsiClassInitializer)parent;
                    if (!containingFile.getManager().areElementsEquivalent(classInitializer.getContainingClass(), ((PsiField)variable).getContainingClass())) {
                        return null;
                    }
                    block = classInitializer.getBody();
                    aClass = classInitializer.getContainingClass();
                } else {
                    PsiMethod[] constructors;
                    PsiField field = (PsiField)variable;
                    aClass = field.getContainingClass();
                    PsiField anotherField = PsiTreeUtil.getTopmostParentOfType(expression, PsiField.class);
                    if (aClass == null || HighlightControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, field.hasModifierProperty("static"))) {
                        return null;
                    }
                    if (anotherField != null && !anotherField.hasModifierProperty("static") && field.hasModifierProperty("static") && HighlightControlFlowUtil.isFieldInitializedInClassInitializer(field, true, Arrays.stream(aClass.getInitializers()))) {
                        return null;
                    }
                    int offset = startOffset;
                    if (anotherField != null && anotherField.getContainingClass() == aClass && !field.hasModifierProperty("static")) {
                        offset = 0;
                    }
                    block = null;
                    for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                        if (offset < constructor.getTextRange().getStartOffset()) continue;
                        PsiCodeBlock body = constructor.getBody();
                        if (body != null && HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, body)) {
                            return null;
                        }
                        List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(constructor);
                        for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                            PsiCodeBlock redirectedBody;
                            PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                            if (offset < redirectedConstructor.getTextRange().getStartOffset() || (redirectedBody = redirectedConstructor.getBody()) == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, redirectedBody)) continue;
                            return null;
                        }
                    }
                }
                if (aClass != null) {
                    PsiClassInitializer initializer;
                    PsiCodeBlock body;
                    PsiClassInitializer[] initializers;
                    PsiClassInitializer[] psiClassInitializerArray = initializers = aClass.getInitializers();
                    int n = psiClassInitializerArray.length;
                    for (int j = 0; j < n && (body = (initializer = psiClassInitializerArray[j]).getBody()) != block; ++j) {
                        boolean shouldCheckInitializerOrder;
                        boolean bl = shouldCheckInitializerOrder = block == null || block.getParent() instanceof PsiClassInitializer;
                        if (shouldCheckInitializerOrder && startOffset < initializer.getTextRange().getStartOffset() || initializer.hasModifierProperty("static") != variable.hasModifierProperty("static") || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, body)) continue;
                        return null;
                    }
                }
            }
        }
        if (topBlock == null) {
            return null;
        }
        Collection<PsiReferenceExpression> codeBlockProblems = uninitializedVarProblems.get(topBlock);
        if (codeBlockProblems == null) {
            try {
                ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(topBlock);
                codeBlockProblems = ControlFlowUtil.getReadBeforeWriteLocals(controlFlow);
            }
            catch (IndexNotReadyException | AnalysisCanceledException e) {
                codeBlockProblems = Collections.emptyList();
            }
            uninitializedVarProblems.put(topBlock, codeBlockProblems);
        }
        if (codeBlockProblems.contains(expression)) {
            String name = expression.getElement().getText();
            String description = JavaErrorMessages.message("variable.not.initialized", name);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAddVariableInitializerFix(variable));
            if (variable instanceof PsiField) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(variable, "final", false, false));
            }
            return highlightInfo;
        }
        return null;
    }

    private static boolean inInnerClass(@NotNull PsiElement psiElement, @Nullable PsiClass containingClass) {
        if (psiElement == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(19);
        }
        for (PsiElement element = psiElement; element != null; element = element.getParent()) {
            boolean innerClass;
            if (!(element instanceof PsiClass)) continue;
            boolean bl = innerClass = !psiElement.getManager().areElementsEquivalent(element, containingClass);
            if (innerClass) {
                if (element instanceof PsiAnonymousClass) {
                    return !PsiTreeUtil.isAncestor(((PsiAnonymousClass)element).getArgumentList(), psiElement, false) && !HighlightControlFlowUtil.insideClassInitialization(containingClass, (PsiClass)element);
                }
                PsiLambdaExpression lambdaExpression = PsiTreeUtil.getParentOfType(psiElement, PsiLambdaExpression.class);
                return lambdaExpression == null || !HighlightControlFlowUtil.insideClassInitialization(containingClass, (PsiClass)element);
            }
            return false;
        }
        return false;
    }

    private static boolean insideClassInitialization(@Nullable PsiClass containingClass, PsiClass aClass) {
        PsiMember member = aClass;
        while (member != null) {
            if (member.getContainingClass() == containingClass) {
                return member instanceof PsiField || member instanceof PsiMethod && ((PsiMethod)member).isConstructor() || member instanceof PsiClassInitializer;
            }
            member = PsiTreeUtil.getParentOfType((PsiElement)member, PsiMember.class, true);
        }
        return false;
    }

    public static boolean isReassigned(@NotNull PsiVariable variable, @NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(20);
        }
        if (finalVarProblems == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(21);
        }
        if (variable instanceof PsiLocalVariable) {
            PsiElement parent = variable.getParent();
            if (parent == null) {
                return false;
            }
            PsiElement declarationScope = parent.getParent();
            if (declarationScope == null) {
                return false;
            }
            Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = HighlightControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, declarationScope);
            return codeBlockProblems.contains(new ControlFlowUtil.VariableInfo(variable, null));
        }
        if (variable instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)variable;
            return HighlightControlFlowUtil.isAssigned(parameter);
        }
        return false;
    }

    @Nullable
    public static HighlightInfo checkFinalVariableMightAlreadyHaveBeenAssignedTo(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expression, @NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(22);
        }
        if (expression == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(23);
        }
        if (finalVarProblems == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(24);
        }
        if (!PsiUtil.isAccessedForWriting(expression)) {
            return null;
        }
        Object scope = variable instanceof PsiField ? variable.getParent() : (variable.getParent() == null ? null : variable.getParent().getParent());
        PsiElement codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock(expression, (PsiElement)scope);
        if (codeBlock == null) {
            return null;
        }
        Collection<ControlFlowUtil.VariableInfo> codeBlockProblems = HighlightControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, codeBlock);
        boolean alreadyAssigned = false;
        for (ControlFlowUtil.VariableInfo variableInfo : codeBlockProblems) {
            if (variableInfo.expression != expression) continue;
            alreadyAssigned = true;
            break;
        }
        if (!alreadyAssigned) {
            if (!(variable instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)variable;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiField[] fields = aClass.getFields();
            boolean isFieldStatic = field.hasModifierProperty("static");
            for (PsiField psiField : fields) {
                PsiExpression initializer = psiField.getInitializer();
                if (psiField == field || psiField.hasModifierProperty("static") != isFieldStatic || initializer == null || initializer == codeBlock || HighlightControlFlowUtil.variableDefinitelyNotAssignedIn(field, initializer)) continue;
                alreadyAssigned = true;
                break;
            }
            if (!alreadyAssigned) {
                PsiClassInitializer[] initializers;
                PsiMember enclosingConstructorOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer(expression);
                if (enclosingConstructorOrInitializer == null || !aClass.getManager().areElementsEquivalent(enclosingConstructorOrInitializer.getContainingClass(), aClass)) {
                    return null;
                }
                for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                    if (initializer.hasModifierProperty("static") != field.hasModifierProperty("static")) continue;
                    PsiCodeBlock body = initializer.getBody();
                    if (body == codeBlock) {
                        return null;
                    }
                    try {
                        ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlow(body);
                        if (ControlFlowUtil.isVariableDefinitelyNotAssigned(field, controlFlow)) continue;
                        alreadyAssigned = true;
                        break;
                    }
                    catch (AnalysisCanceledException e) {
                        return null;
                    }
                }
            }
            if (!alreadyAssigned && !field.hasModifierProperty("static")) {
                PsiMethod ctr = codeBlock.getParent() instanceof PsiMethod ? (PsiMethod)codeBlock.getParent() : null;
                List<PsiMethod> redirectedConstructors = ctr != null && ctr.isConstructor() ? JavaHighlightUtil.getChainedConstructors(ctr) : null;
                for (int j = 0; redirectedConstructors != null && j < redirectedConstructors.size(); ++j) {
                    PsiMethod redirectedConstructor = redirectedConstructors.get(j);
                    PsiCodeBlock body = redirectedConstructor.getBody();
                    if (body == null || !HighlightControlFlowUtil.variableDefinitelyAssignedIn(variable, body)) continue;
                    alreadyAssigned = true;
                    break;
                }
            }
        }
        if (alreadyAssigned) {
            String description = JavaErrorMessages.message("variable.already.assigned", variable.getName());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(variable, "final", false, false));
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createDeferFinalAssignmentFix(variable, expression));
            return highlightInfo;
        }
        return null;
    }

    @NotNull
    private static Collection<ControlFlowUtil.VariableInfo> getFinalVariableProblemsInBlock(@NotNull Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> finalVarProblems, @NotNull PsiElement codeBlock) {
        Collection<ControlFlowUtil.VariableInfo> codeBlockProblems;
        if (finalVarProblems == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(25);
        }
        if (codeBlock == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(26);
        }
        if ((codeBlockProblems = finalVarProblems.get(codeBlock)) == null) {
            try {
                ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate(codeBlock);
                codeBlockProblems = ControlFlowUtil.getInitializedTwice(controlFlow);
            }
            catch (AnalysisCanceledException e) {
                codeBlockProblems = Collections.emptyList();
            }
            finalVarProblems.put(codeBlock, codeBlockProblems);
        }
        Collection<ControlFlowUtil.VariableInfo> collection = codeBlockProblems;
        if (collection == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(27);
        }
        return collection;
    }

    @Nullable
    static HighlightInfo checkFinalVariableInitializedInLoop(@NotNull PsiReferenceExpression expression, @NotNull PsiElement resolved) {
        if (expression == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(28);
        }
        if (resolved == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(29);
        }
        if (ControlFlowUtil.isVariableAssignedInLoop(expression, resolved)) {
            String description = JavaErrorMessages.message("variable.assigned.in.loop", ((PsiVariable)resolved).getName());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix((PsiVariable)resolved, "final", false, false));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkCannotWriteToFinal(@NotNull PsiExpression expression, @NotNull PsiFile containingFile) {
        boolean canWrite;
        PsiVariable variable;
        IElementType sign;
        PsiExpression operand;
        if (expression == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(30);
        }
        if (containingFile == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(31);
        }
        PsiReference reference = null;
        boolean readBeforeWrite = false;
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            PsiExpression left = PsiUtil.skipParenthesizedExprDown(assignmentExpression.getLExpression());
            if (left instanceof PsiReferenceExpression) {
                reference = (PsiReferenceExpression)left;
            }
            readBeforeWrite = assignmentExpression.getOperationTokenType() != JavaTokenType.EQ;
        } else if (expression instanceof PsiPostfixExpression) {
            operand = PsiUtil.skipParenthesizedExprDown(((PsiPostfixExpression)expression).getOperand());
            sign = ((PsiPostfixExpression)expression).getOperationTokenType();
            if (operand instanceof PsiReferenceExpression && (sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS)) {
                reference = (PsiReferenceExpression)operand;
            }
            readBeforeWrite = true;
        } else if (expression instanceof PsiPrefixExpression) {
            operand = PsiUtil.skipParenthesizedExprDown(((PsiPrefixExpression)expression).getOperand());
            sign = ((PsiPrefixExpression)expression).getOperationTokenType();
            if (operand instanceof PsiReferenceExpression && (sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS)) {
                reference = (PsiReferenceExpression)operand;
            }
            readBeforeWrite = true;
        }
        PsiElement resolved = reference == null ? null : reference.resolve();
        PsiVariable psiVariable = variable = resolved instanceof PsiVariable ? (PsiVariable)resolved : null;
        if (variable == null || !variable.hasModifierProperty("final")) {
            return null;
        }
        boolean bl = canWrite = HighlightControlFlowUtil.canWriteToFinal(variable, expression, (PsiReferenceExpression)reference, containingFile) && HighlightControlFlowUtil.checkWriteToFinalInsideLambda(variable, (PsiJavaCodeReferenceElement)reference) == null;
        if (readBeforeWrite || !canWrite) {
            String name = variable.getName();
            String description = JavaErrorMessages.message(canWrite ? "variable.not.initialized" : "assignment.to.final.variable", name);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(reference.getTextRange()).descriptionAndTooltip(description).create();
            PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, expression);
            if (innerClass == null || variable instanceof PsiField) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createModifierListFix(variable, "final", false, false));
            } else {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, innerClass));
            }
            return highlightInfo;
        }
        return null;
    }

    private static boolean canWriteToFinal(@NotNull PsiVariable variable, @NotNull PsiExpression expression, @NotNull PsiReferenceExpression reference, @NotNull PsiFile containingFile) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(32);
        }
        if (expression == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(33);
        }
        if (reference == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(34);
        }
        if (containingFile == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(35);
        }
        if (variable.hasInitializer()) {
            return false;
        }
        if (variable instanceof PsiParameter) {
            return false;
        }
        PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, expression);
        if (variable instanceof PsiField) {
            if (HighlightUtil.findEnclosingFieldInitializer(expression) != null) {
                return true;
            }
            PsiField field = (PsiField)variable;
            if (innerClass != null && !containingFile.getManager().areElementsEquivalent(innerClass, field.getContainingClass())) {
                return false;
            }
            PsiMember enclosingCtrOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer(expression);
            return enclosingCtrOrInitializer != null && HighlightControlFlowUtil.isSameField(enclosingCtrOrInitializer, field, reference, containingFile);
        }
        if (variable instanceof PsiLocalVariable) {
            boolean isAccessedFromOtherClass;
            boolean bl = isAccessedFromOtherClass = innerClass != null;
            if (isAccessedFromOtherClass) {
                return false;
            }
        }
        return true;
    }

    private static boolean isSameField(@NotNull PsiMember enclosingCtrOrInitializer, @NotNull PsiField field, @NotNull PsiReferenceExpression reference, @NotNull PsiFile containingFile) {
        if (enclosingCtrOrInitializer == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(36);
        }
        if (field == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(37);
        }
        if (reference == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(38);
        }
        if (containingFile == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(39);
        }
        if (!containingFile.getManager().areElementsEquivalent(enclosingCtrOrInitializer.getContainingClass(), field.getContainingClass())) {
            return false;
        }
        PsiExpression qualifierExpression = reference.getQualifierExpression();
        return qualifierExpression == null || qualifierExpression instanceof PsiThisExpression;
    }

    @Nullable
    static HighlightInfo checkVariableMustBeFinal(@NotNull PsiVariable variable, @NotNull PsiJavaCodeReferenceElement context, @NotNull LanguageLevel languageLevel) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(40);
        }
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(41);
        }
        if (languageLevel == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(42);
        }
        if (variable.hasModifierProperty("final")) {
            return null;
        }
        PsiElement innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, context);
        if (innerClass instanceof PsiClass) {
            PsiElement parent;
            if (variable instanceof PsiParameter && (parent = variable.getParent()) instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression && HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(((PsiParameter)variable).getDeclarationScope()))) {
                return null;
            }
            boolean isToBeEffectivelyFinal = languageLevel.isAtLeast(LanguageLevel.JDK_1_8);
            if (isToBeEffectivelyFinal && HighlightControlFlowUtil.isEffectivelyFinal(variable, innerClass, context)) {
                return null;
            }
            String description = JavaErrorMessages.message(isToBeEffectivelyFinal ? "variable.must.be.final.or.effectively.final" : "variable.must.be.final", context.getText());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(context).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, innerClass));
            return highlightInfo;
        }
        return HighlightControlFlowUtil.checkWriteToFinalInsideLambda(variable, context);
    }

    private static HighlightInfo checkWriteToFinalInsideLambda(@NotNull PsiVariable variable, @NotNull PsiJavaCodeReferenceElement context) {
        PsiLambdaExpression lambdaExpression;
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(43);
        }
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(44);
        }
        if ((lambdaExpression = PsiTreeUtil.getParentOfType((PsiElement)context, PsiLambdaExpression.class)) != null && !PsiTreeUtil.isAncestor(lambdaExpression, variable, true)) {
            PsiElement parent = variable.getParent();
            if (parent instanceof PsiParameterList && parent.getParent() == lambdaExpression) {
                return null;
            }
            if (!HighlightControlFlowUtil.isEffectivelyFinal(variable, lambdaExpression, context)) {
                String text2 = JavaErrorMessages.message("lambda.variable.must.be.final", new Object[0]);
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(context).descriptionAndTooltip(text2).create();
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createVariableAccessFromInnerClassFix(variable, lambdaExpression));
                return ErrorFixExtensionPoint.registerFixes(highlightInfo, context, "lambda.variable.must.be.final");
            }
        }
        return null;
    }

    public static boolean isEffectivelyFinal(@NotNull PsiVariable variable, @NotNull PsiElement scope, @Nullable PsiJavaCodeReferenceElement context) {
        boolean effectivelyFinal;
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(45);
        }
        if (scope == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(46);
        }
        if (variable instanceof PsiParameter) {
            effectivelyFinal = HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(((PsiParameter)variable).getDeclarationScope()));
        } else {
            ControlFlow controlFlow;
            try {
                PsiElement codeBlock = PsiUtil.getVariableCodeBlock(variable, context);
                if (codeBlock == null) {
                    return true;
                }
                controlFlow = HighlightControlFlowUtil.getControlFlow(codeBlock);
            }
            catch (AnalysisCanceledException e) {
                return true;
            }
            Collection<ControlFlowUtil.VariableInfo> initializedTwice = ControlFlowUtil.getInitializedTwice(controlFlow);
            boolean bl = effectivelyFinal = !initializedTwice.contains(new ControlFlowUtil.VariableInfo(variable, null));
            if (effectivelyFinal) {
                List<PsiReferenceExpression> readBeforeWriteLocals = ControlFlowUtil.getReadBeforeWriteLocals(controlFlow);
                for (PsiReferenceExpression expression : readBeforeWriteLocals) {
                    if (expression.resolve() != variable) continue;
                    return PsiUtil.isAccessedForReading(expression);
                }
                effectivelyFinal = HighlightControlFlowUtil.notAccessedForWriting(variable, new LocalSearchScope(scope));
                if (effectivelyFinal) {
                    return ReferencesSearch.search(variable).forEach(ref -> {
                        PsiElement element;
                        if (variable == null) {
                            HighlightControlFlowUtil.$$$reportNull$$$0(52);
                        }
                        if ((element = ref.getElement()) instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)element)) {
                            return !ControlFlowUtil.isVariableAssignedInLoop((PsiReferenceExpression)element, variable);
                        }
                        return true;
                    });
                }
            }
        }
        return effectivelyFinal;
    }

    private static boolean notAccessedForWriting(@NotNull PsiVariable variable, @NotNull LocalSearchScope searchScope) {
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(47);
        }
        if (searchScope == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(48);
        }
        for (PsiReference reference : ReferencesSearch.search(variable, searchScope)) {
            PsiElement element = reference.getElement();
            if (!(element instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)element)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiElement getInnerClassVariableReferencedFrom(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        PsiElement parent;
        PsiElement[] scope;
        if (variable == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(49);
        }
        if (context == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(50);
        }
        if (variable instanceof PsiResourceVariable) {
            scope = ((PsiResourceVariable)variable).getDeclarationScope();
        } else if (variable instanceof PsiLocalVariable) {
            parent = variable.getParent();
            scope = new PsiElement[]{parent != null ? parent.getParent() : null};
        } else {
            scope = variable instanceof PsiParameter ? new PsiElement[]{((PsiParameter)variable).getDeclarationScope()} : new PsiElement[]{variable.getParent()};
        }
        if (scope.length < 1 || scope[0] == null || scope[0].getContainingFile() != context.getContainingFile()) {
            return null;
        }
        PsiElement prevParent = context;
        block0: for (parent = context.getParent(); parent != null; parent = parent.getParent()) {
            for (PsiElement scopeElement : scope) {
                if (parent.equals(scopeElement)) break block0;
            }
            if (!(!(parent instanceof PsiClass) || prevParent instanceof PsiExpressionList && parent instanceof PsiAnonymousClass)) {
                return parent;
            }
            if (parent instanceof PsiLambdaExpression) {
                return parent;
            }
            prevParent = parent;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkInitializerCompleteNormally(@NotNull PsiClassInitializer initializer) {
        if (initializer == null) {
            HighlightControlFlowUtil.$$$reportNull$$$0(51);
        }
        PsiCodeBlock body = initializer.getBody();
        try {
            ControlFlow controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate(body);
            int completionReasons = ControlFlowUtil.getCompletionReasons(controlFlow, 0, controlFlow.getSize());
            if (!BitUtil.isSet(completionReasons, 1)) {
                String description = JavaErrorMessages.message("initializer.must.be.able.to.complete.normally", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(body).descriptionAndTooltip(description).create();
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 1: 
            case 3: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 41: 
            case 44: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: 
            case 37: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 20: 
            case 22: 
            case 32: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 15: 
            case 23: 
            case 28: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uninitializedVarProblems";
                break;
            }
            case 18: 
            case 31: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalVarProblems";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingCtrOrInitializer";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightControlFlowUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlowNoConstantEvaluate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalVariableProblemsInBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowNoConstantEvaluate";
                break;
            }
            case 1: 
            case 3: 
            case 27: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedAfterObjectConstruction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedInClassInitializer";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedInOtherFieldInitializer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRecursivelyCalledConstructor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAssigned";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "variableDefinitelyAssignedIn";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "variableDefinitelyNotAssignedIn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkFinalFieldInitialized";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableInitializedBeforeUsage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "inInnerClass";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isReassigned";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkFinalVariableMightAlreadyHaveBeenAssignedTo";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFinalVariableProblemsInBlock";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkFinalVariableInitializedInLoop";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkCannotWriteToFinal";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "canWriteToFinal";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isSameField";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableMustBeFinal";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "checkWriteToFinalInsideLambda";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isEffectivelyFinal";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "notAccessedForWriting";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getInnerClassVariableReferencedFrom";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkInitializerCompleteNormally";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isEffectivelyFinal$1";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isFieldInitializedInClassInitializer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ParamWriteProcessor
    implements Processor<PsiReference> {
        private volatile boolean myIsWriteRefFound;

        private ParamWriteProcessor() {
        }

        @Override
        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            if (element instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)element)) {
                this.myIsWriteRefFound = true;
                return false;
            }
            return true;
        }

        private boolean isWriteRefFound() {
            return this.myIsWriteRefFound;
        }
    }
}

