/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlPathReferenceInspection
extends XmlSuppressableInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlPathReferenceInspection.$$$reportNull$$$0(0);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            @Override
            public void visitXmlAttributeValue(XmlAttributeValue value) {
                XmlPathReferenceInspection.this.checkRefs(value, holder);
            }

            @Override
            public void visitXmlDoctype(XmlDoctype xmlDoctype) {
                XmlPathReferenceInspection.this.checkRefs(xmlDoctype, holder);
            }

            @Override
            public void visitXmlTag(XmlTag tag) {
                XmlPathReferenceInspection.this.checkRefs(tag, holder);
            }
        };
        if (xmlElementVisitor == null) {
            XmlPathReferenceInspection.$$$reportNull$$$0(1);
        }
        return xmlElementVisitor;
    }

    private void checkRefs(PsiElement element, ProblemsHolder holder) {
        PsiReference[] references;
        for (PsiReference reference : references = element.getReferences()) {
            boolean isHtml;
            if (!XmlHighlightVisitor.isUrlReference(reference) || XmlHighlightVisitor.isInjectedWithoutValidation(element) || !this.needToCheckRef(reference) || (isHtml = HtmlUtil.isHtmlTagContainingFile(element)) ^ this.isForHtml() || !isHtml && XmlHighlightVisitor.skipValidation(element) || !XmlHighlightVisitor.hasBadResolve(reference, false)) continue;
            holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage(reference), isHtml ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    protected boolean needToCheckRef(PsiReference reference) {
        return true;
    }

    protected boolean isForHtml() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlPathReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlPathReferenceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

