/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaOptionalValue;
import com.intellij.codeInspection.dataFlow.value.DfaRangeValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfaFactType<T>
extends Key<T> {
    private static final List<DfaFactType<?>> ourFactTypes = new ArrayList();
    public static final DfaFactType<Boolean> CAN_BE_NULL = new DfaFactType<Boolean>("Can be null"){

        @Override
        String toString(Boolean fact) {
            return fact != false ? "Nullable" : "NotNull";
        }

        @Override
        @Nullable
        Boolean fromDfaValue(DfaValue value) {
            if (value instanceof DfaConstValue) {
                return ((DfaConstValue)value).getValue() == null;
            }
            if (value instanceof DfaBoxedValue || value instanceof DfaUnboxedValue || value instanceof DfaRangeValue) {
                return false;
            }
            if (value instanceof DfaTypeValue) {
                return NullnessUtil.toBoolean(((DfaTypeValue)value).getNullness());
            }
            return null;
        }

        @Override
        @Nullable
        Boolean calcFromVariable(@NotNull DfaVariableValue value) {
            if (value == null) {
                1.$$$reportNull$$$0(0);
            }
            return NullnessUtil.calcCanBeNull(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaFactType$1", "calcFromVariable"));
        }
    };
    public static final DfaFactType<Boolean> OPTIONAL_PRESENCE = new DfaFactType<Boolean>("Optional presense"){

        @Override
        String toString(Boolean fact) {
            return fact != false ? "present Optional" : "absent Optional";
        }

        @Override
        @Nullable
        Boolean fromDfaValue(DfaValue value) {
            return value instanceof DfaOptionalValue ? Boolean.valueOf(((DfaOptionalValue)value).isPresent()) : null;
        }
    };
    public static final DfaFactType<LongRangeSet> RANGE = new DfaFactType<LongRangeSet>("Range"){

        @Override
        boolean isSuper(@NotNull LongRangeSet superFact, @NotNull LongRangeSet subFact) {
            if (superFact == null) {
                3.$$$reportNull$$$0(0);
            }
            if (subFact == null) {
                3.$$$reportNull$$$0(1);
            }
            return superFact.contains(subFact);
        }

        @Override
        @Nullable
        LongRangeSet fromDfaValue(DfaValue value) {
            if (value instanceof DfaVariableValue) {
                return this.calcFromVariable((DfaVariableValue)value);
            }
            return LongRangeSet.fromDfaValue(value);
        }

        @Override
        @Nullable
        LongRangeSet calcFromVariable(@NotNull DfaVariableValue var) {
            if (var == null) {
                3.$$$reportNull$$$0(2);
            }
            if (var.getQualifier() != null) {
                for (SpecialField sf : SpecialField.values()) {
                    if (!sf.isMyAccessor(var.getPsiVariable())) continue;
                    return sf.getRange();
                }
            }
            return LongRangeSet.fromType(var.getVariableType());
        }

        @Override
        @Nullable
        LongRangeSet intersectFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            LongRangeSet intersection;
            if (left == null) {
                3.$$$reportNull$$$0(3);
            }
            if (right == null) {
                3.$$$reportNull$$$0(4);
            }
            return (intersection = left.intersect(right)).isEmpty() ? null : intersection;
        }

        @Override
        String toString(LongRangeSet fact) {
            return fact.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superFact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subFact";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcFromVariable";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "intersectFacts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private DfaFactType(String name) {
        super("DfaFactType: " + name);
        ourFactTypes.add(this);
    }

    @Nullable
    T fromDfaValue(DfaValue value) {
        return null;
    }

    @Nullable
    T calcFromVariable(@NotNull DfaVariableValue value) {
        if (value == null) {
            DfaFactType.$$$reportNull$$$0(0);
        }
        return null;
    }

    boolean isSuper(@NotNull T superFact, @NotNull T subFact) {
        if (superFact == null) {
            DfaFactType.$$$reportNull$$$0(1);
        }
        if (subFact == null) {
            DfaFactType.$$$reportNull$$$0(2);
        }
        return false;
    }

    @Nullable
    T intersectFacts(@NotNull T left, @NotNull T right) {
        if (left == null) {
            DfaFactType.$$$reportNull$$$0(3);
        }
        if (right == null) {
            DfaFactType.$$$reportNull$$$0(4);
        }
        return (T)(left.equals(right) ? left : null);
    }

    String toString(T fact) {
        return fact.toString();
    }

    static List<DfaFactType<?>> getTypes() {
        return Collections.unmodifiableList(ourFactTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superFact";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subFact";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calcFromVariable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuper";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "intersectFacts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

