/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.TransferTarget;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaOptionalValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRangeValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.FactoryMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaValueFactory {
    private final List<DfaValue> myValues = ContainerUtil.newArrayList();
    private final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myAssignableCache = ContainerUtil.newHashMap();
    private final Map<Pair<DfaPsiType, DfaPsiType>, Boolean> myConvertibleCache = ContainerUtil.newHashMap();
    private final Map<PsiType, DfaPsiType> myDfaTypes = ContainerUtil.newHashMap();
    private final boolean myHonorFieldInitializers;
    private final boolean myUnknownMembersAreNullable;
    private static final ElementPattern<? extends PsiModifierListOwner> MEMBER_OR_METHOD_PARAMETER = StandardPatterns.or(new ElementPattern[]{PsiJavaPatterns.psiMember(), PsiJavaPatterns.psiParameter().withSuperParent(2, PsiJavaPatterns.psiMember())});
    private final Map<Pair<TransferTarget, FList<Trap>>, DfaControlTransferValue> myControlTransfers = FactoryMap.createMap(p -> new DfaControlTransferValue(this, (TransferTarget)p.first, (FList)p.second));
    private final DfaVariableValue.Factory myVarFactory;
    private final DfaConstValue.Factory myConstFactory;
    private final DfaBoxedValue.Factory myBoxedFactory;
    private final DfaTypeValue.Factory myTypeFactory;
    private final DfaRelationValue.Factory myRelationFactory;
    private final DfaExpressionFactory myExpressionFactory;
    private final DfaOptionalValue.Factory myOptionalFactory;
    private final DfaRangeValue.Factory myRangeFactory;

    public DfaValueFactory(boolean honorFieldInitializers, boolean unknownMembersAreNullable) {
        this.myHonorFieldInitializers = honorFieldInitializers;
        this.myUnknownMembersAreNullable = unknownMembersAreNullable;
        this.myValues.add(null);
        this.myVarFactory = new DfaVariableValue.Factory(this);
        this.myConstFactory = new DfaConstValue.Factory(this);
        this.myBoxedFactory = new DfaBoxedValue.Factory(this);
        this.myTypeFactory = new DfaTypeValue.Factory(this);
        this.myRelationFactory = new DfaRelationValue.Factory(this);
        this.myExpressionFactory = new DfaExpressionFactory(this);
        this.myOptionalFactory = new DfaOptionalValue.Factory(this);
        this.myRangeFactory = new DfaRangeValue.Factory(this);
    }

    public boolean isHonorFieldInitializers() {
        return this.myHonorFieldInitializers;
    }

    @NotNull
    public Nullness suggestNullabilityForNonAnnotatedMember(@NotNull PsiModifierListOwner member) {
        if (member == null) {
            DfaValueFactory.$$$reportNull$$$0(0);
        }
        if (this.myUnknownMembersAreNullable && MEMBER_OR_METHOD_PARAMETER.accepts(member) && AnnotationUtil.getSuperAnnotationOwners(member).isEmpty()) {
            Nullness nullness = Nullness.NULLABLE;
            if (nullness == null) {
                DfaValueFactory.$$$reportNull$$$0(1);
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            DfaValueFactory.$$$reportNull$$$0(2);
        }
        return nullness;
    }

    @NotNull
    public DfaValue createTypeValue(@Nullable PsiType type, @NotNull Nullness nullability) {
        if (nullability == null) {
            DfaValueFactory.$$$reportNull$$$0(3);
        }
        if (type instanceof PsiClassType) {
            type = ((PsiClassType)type).rawType();
        }
        if (type == null) {
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                DfaValueFactory.$$$reportNull$$$0(4);
            }
            return dfaUnknownValue;
        }
        DfaTypeValue dfaTypeValue = this.getTypeFactory().createTypeValue(this.internType(type), nullability);
        if (dfaTypeValue == null) {
            DfaValueFactory.$$$reportNull$$$0(5);
        }
        return dfaTypeValue;
    }

    private DfaPsiType internType(@NotNull PsiType psiType) {
        DfaPsiType dfaType;
        if (psiType == null) {
            DfaValueFactory.$$$reportNull$$$0(6);
        }
        if ((dfaType = this.myDfaTypes.get(psiType)) == null) {
            dfaType = new DfaPsiType(psiType, this.myAssignableCache, this.myConvertibleCache);
            this.myDfaTypes.put(psiType, dfaType);
        }
        return dfaType;
    }

    int registerValue(DfaValue value) {
        this.myValues.add(value);
        return this.myValues.size() - 1;
    }

    public DfaValue getValue(int id) {
        return this.myValues.get(id);
    }

    @Nullable
    public DfaValue createValue(PsiExpression psiExpression) {
        return this.myExpressionFactory.getExpressionDfaValue(psiExpression);
    }

    @Nullable
    public DfaValue createLiteralValue(PsiLiteralExpression literal) {
        return this.getConstFactory().create(literal);
    }

    @NotNull
    public DfaValue createCondition(DfaValue dfaLeft, DfaRelationValue.RelationType relationType, DfaValue dfaRight) {
        DfaConstValue value = this.tryEvaluate(dfaLeft, relationType, dfaRight);
        if (value != null) {
            DfaConstValue dfaConstValue = value;
            if (dfaConstValue == null) {
                DfaValueFactory.$$$reportNull$$$0(7);
            }
            return dfaConstValue;
        }
        DfaRelationValue relation = this.getRelationFactory().createRelation(dfaLeft, relationType, dfaRight);
        if (relation != null) {
            DfaRelationValue dfaRelationValue = relation;
            if (dfaRelationValue == null) {
                DfaValueFactory.$$$reportNull$$$0(8);
            }
            return dfaRelationValue;
        }
        DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
        if (dfaUnknownValue == null) {
            DfaValueFactory.$$$reportNull$$$0(9);
        }
        return dfaUnknownValue;
    }

    @Nullable
    private DfaConstValue tryEvaluate(DfaValue dfaLeft, DfaRelationValue.RelationType relationType, DfaValue dfaRight) {
        if (dfaRight instanceof DfaTypeValue && dfaLeft == this.getConstFactory().getNull()) {
            return this.tryEvaluate(dfaRight, relationType, dfaLeft);
        }
        if (dfaLeft instanceof DfaTypeValue && dfaRight == this.getConstFactory().getNull() && ((DfaTypeValue)dfaLeft).isNotNull()) {
            if (relationType == DfaRelationValue.RelationType.EQ) {
                return this.getConstFactory().getFalse();
            }
            if (relationType == DfaRelationValue.RelationType.NE) {
                return this.getConstFactory().getTrue();
            }
        }
        if (dfaLeft instanceof DfaOptionalValue && dfaRight instanceof DfaOptionalValue) {
            if (relationType == DfaRelationValue.RelationType.IS) {
                return this.getBoolean(dfaLeft == dfaRight);
            }
            if (relationType == DfaRelationValue.RelationType.IS_NOT) {
                return this.getBoolean(dfaLeft != dfaRight);
            }
        }
        LongRangeSet leftRange = LongRangeSet.fromDfaValue(dfaLeft);
        LongRangeSet rightRange = LongRangeSet.fromDfaValue(dfaRight);
        if (leftRange != null && rightRange != null) {
            LongRangeSet constraint = rightRange.fromRelation(relationType);
            if (constraint != null && !constraint.intersects(leftRange)) {
                return this.getConstFactory().getFalse();
            }
            LongRangeSet revConstraint = rightRange.fromRelation(relationType.getNegated());
            if (revConstraint != null && !revConstraint.intersects(leftRange)) {
                return this.getConstFactory().getTrue();
            }
        }
        if (dfaLeft instanceof DfaConstValue && dfaRight instanceof DfaConstValue && (relationType == DfaRelationValue.RelationType.EQ || relationType == DfaRelationValue.RelationType.NE)) {
            return this.getBoolean(dfaLeft == dfaRight ^ !DfaUtil.isNaN(((DfaConstValue)dfaLeft).getValue()) ^ relationType == DfaRelationValue.RelationType.EQ);
        }
        return null;
    }

    public DfaConstValue getBoolean(boolean value) {
        return value ? this.getConstFactory().getTrue() : this.getConstFactory().getFalse();
    }

    public static boolean isEffectivelyUnqualified(PsiReferenceExpression refExpression) {
        PsiExpression qualifier = refExpression.getQualifierExpression();
        if (qualifier == null) {
            return true;
        }
        if (qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
            PsiJavaCodeReferenceElement thisQualifier = ((PsiQualifiedExpression)qualifier).getQualifier();
            if (thisQualifier == null) {
                return true;
            }
            PsiClass innerMostClass = PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiClass.class);
            if (innerMostClass == thisQualifier.resolve()) {
                return true;
            }
        }
        return false;
    }

    public DfaControlTransferValue controlTransfer(TransferTarget kind, FList<Trap> traps) {
        return this.myControlTransfers.get(Pair.create(kind, traps));
    }

    @NotNull
    public DfaVariableValue.Factory getVarFactory() {
        DfaVariableValue.Factory factory = this.myVarFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(10);
        }
        return factory;
    }

    @NotNull
    public DfaConstValue.Factory getConstFactory() {
        DfaConstValue.Factory factory = this.myConstFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(11);
        }
        return factory;
    }

    @NotNull
    public DfaBoxedValue.Factory getBoxedFactory() {
        DfaBoxedValue.Factory factory = this.myBoxedFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(12);
        }
        return factory;
    }

    @NotNull
    public DfaTypeValue.Factory getTypeFactory() {
        DfaTypeValue.Factory factory = this.myTypeFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(13);
        }
        return factory;
    }

    @NotNull
    public DfaRelationValue.Factory getRelationFactory() {
        DfaRelationValue.Factory factory = this.myRelationFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(14);
        }
        return factory;
    }

    @NotNull
    public DfaOptionalValue.Factory getOptionalFactory() {
        DfaOptionalValue.Factory factory = this.myOptionalFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(15);
        }
        return factory;
    }

    @NotNull
    public DfaRangeValue.Factory getRangeFactory() {
        DfaRangeValue.Factory factory = this.myRangeFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(16);
        }
        return factory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNullabilityForNonAnnotatedMember";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCondition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarFactory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstFactory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoxedFactory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFactory";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelationFactory";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalFactory";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestNullabilityForNonAnnotatedMember";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTypeValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "internType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

