/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dependencyViolation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            DependencyInspectionBase.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DEPENDENCY_GROUP_NAME;
        if (string == null) {
            DependencyInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("illegal.package.dependencies", new Object[0]);
        if (string == null) {
            DependencyInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("Dependency" == null) {
            DependencyInspectionBase.$$$reportNull$$$0(3);
        }
        return "Dependency";
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkFile(final @NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            DependencyInspectionBase.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            DependencyInspectionBase.$$$reportNull$$$0(5);
        }
        if (file.getViewProvider().getPsi(JavaLanguage.INSTANCE) == null) {
            return null;
        }
        final DependencyValidationManager validationManager = DependencyValidationManager.getInstance(file.getProject());
        if (!validationManager.hasRules() || validationManager.getApplicableRules(file).length == 0) {
            return null;
        }
        final List<ProblemDescriptor> problems = ContainerUtil.newSmartList();
        DependenciesBuilder.analyzeFileDependencies(file, new DependenciesBuilder.DependencyProcessor(){
            private final Map<PsiFile, DependencyRule[]> violations = FactoryMap.createMap(dependencyFile -> {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return validationManager.getViolatorDependencyRules(file, (PsiFile)dependencyFile);
            });

            @Override
            public void process(PsiElement place, PsiElement dependency) {
                PsiFile dependencyFile = dependency.getContainingFile();
                if (dependencyFile != null && dependencyFile.isPhysical() && dependencyFile.getVirtualFile() != null) {
                    for (DependencyRule dependencyRule : this.violations.get(dependencyFile)) {
                        String message = InspectionsBundle.message("inspection.dependency.violator.problem.descriptor", dependencyRule.getDisplayText());
                        LocalQuickFix[] fixes = DependencyInspectionBase.this.createEditDependencyFixes(dependencyRule);
                        problems.add(manager.createProblemDescriptor(place, message, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase$1", "lambda$$0"));
            }
        });
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    protected LocalQuickFix[] createEditDependencyFixes(DependencyRule dependencyRule) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dependencyViolation/DependencyInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

