/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.redundantCast;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.codeInspection.miscGenerics.SuspiciousMethodCallUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantCastInspection
extends GenericsInspectionToolBase {
    private final LocalQuickFix myQuickFixAction = new AcceptSuggested();
    private static final String DISPLAY_NAME = InspectionsBundle.message("inspection.redundant.cast.display.name", new Object[0]);
    @NonNls
    private static final String SHORT_NAME = "RedundantCast";
    public boolean IGNORE_ANNOTATED_METHODS;
    public boolean IGNORE_SUSPICIOUS_METHOD_CALLS;

    @Override
    @Nullable
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement where, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List<PsiTypeCastExpression> redundantCasts;
        if (where == null) {
            RedundantCastInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            RedundantCastInspection.$$$reportNull$$$0(1);
        }
        if ((redundantCasts = RedundantCastUtil.getRedundantCastsInside(where)).isEmpty()) {
            return null;
        }
        ArrayList<ProblemDescriptor> descriptions = new ArrayList<ProblemDescriptor>(redundantCasts.size());
        for (PsiTypeCastExpression redundantCast : redundantCasts) {
            ProblemDescriptor descriptor = this.createDescription(redundantCast, manager, isOnTheFly);
            if (descriptor == null) continue;
            descriptions.add(descriptor);
        }
        if (descriptions.isEmpty()) {
            return null;
        }
        return descriptions.toArray(new ProblemDescriptor[descriptions.size()]);
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            RedundantCastInspection.$$$reportNull$$$0(2);
        }
        if (this.IGNORE_ANNOTATED_METHODS || this.IGNORE_SUSPICIOUS_METHOD_CALLS) {
            super.writeSettings(node);
        }
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox("Ignore casts in suspicious collections method calls", "IGNORE_SUSPICIOUS_METHOD_CALLS");
        optionsPanel.addCheckbox("Ignore casts to invoke @NotNull method which overrides @Nullable", "IGNORE_ANNOTATED_METHODS");
        return optionsPanel;
    }

    @Nullable
    private ProblemDescriptor createDescription(@NotNull PsiTypeCastExpression cast, @NotNull InspectionManager manager, boolean onTheFly) {
        String message;
        PsiElement gParent;
        if (cast == null) {
            RedundantCastInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            RedundantCastInspection.$$$reportNull$$$0(4);
        }
        PsiExpression operand = cast.getOperand();
        PsiTypeElement castType = cast.getCastType();
        if (operand == null || castType == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(cast.getParent());
        if (parent instanceof PsiReferenceExpression) {
            PsiMethod psiMethod;
            if (this.IGNORE_ANNOTATED_METHODS && (gParent = parent.getParent()) instanceof PsiMethodCallExpression && (psiMethod = ((PsiMethodCallExpression)gParent).resolveMethod()) != null && NullableNotNullManager.isNotNull(psiMethod)) {
                PsiClass superClass = PsiUtil.resolveClassInType(operand.getType());
                PsiClass containingClass = psiMethod.getContainingClass();
                if (containingClass != null && superClass != null && containingClass.isInheritor(superClass, true)) {
                    for (PsiMethod method : psiMethod.findSuperMethods(superClass)) {
                        if (!NullableNotNullManager.isNullable(method)) continue;
                        return null;
                    }
                }
            }
        } else if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiMethodCallExpression && this.IGNORE_SUSPICIOUS_METHOD_CALLS && (message = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage((PsiMethodCallExpression)gParent, operand, operand.getType(), true, new ArrayList<PsiMethod>(), new IntArrayList())) != null) {
            return null;
        }
        String message2 = InspectionsBundle.message("inspection.redundant.cast.problem.descriptor", "<code>" + operand.getText() + "</code>", "<code>#ref</code> #loc");
        return manager.createProblemDescriptor((PsiElement)castType, message2, this.myQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, onTheFly);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            RedundantCastInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VERBOSE_GROUP_NAME;
        if (string == null) {
            RedundantCastInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            RedundantCastInspection.$$$reportNull$$$0(7);
        }
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cast";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDescription";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AcceptSuggested
    implements LocalQuickFix {
        private AcceptSuggested() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message("inspection.redundant.cast.remove.quickfix", new Object[0]);
            if (string == null) {
                AcceptSuggested.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement castTypeElement;
            PsiTypeCastExpression cast;
            if (project == null) {
                AcceptSuggested.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AcceptSuggested.$$$reportNull$$$0(2);
            }
            PsiTypeCastExpression psiTypeCastExpression = cast = (castTypeElement = descriptor.getPsiElement()) == null ? null : (PsiTypeCastExpression)castTypeElement.getParent();
            if (cast != null) {
                RedundantCastUtil.removeCast(cast);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection$AcceptSuggested";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/redundantCast/RedundantCastInspection$AcceptSuggested";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

