/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.BinaryXmlWriterKt;
import com.intellij.configurationStore.TypeMarker;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.io.IOUtil;
import java.io.DataOutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/configurationStore/BinaryXmlWriter;", "", "out", "Ljava/io/DataOutputStream;", "(Ljava/io/DataOutputStream;)V", "strings", "Lcom/intellij/util/containers/ObjectIntHashMap;", "", "isAllWhitespace", "", "obj", "Lorg/jdom/Content;", "write", "", "element", "Lorg/jdom/Element;", "writeAttributes", "attributes", "", "Lorg/jdom/Attribute;", "writeElement", "writeString", "string", "writeUInt29", "v", "", "projectModel-impl"})
public final class BinaryXmlWriter {
    private final ObjectIntHashMap<String> strings;
    private final DataOutputStream out;

    public final void write(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.writeElement(element);
    }

    private final void writeString(String string) {
        if (BinaryXmlWriterKt.access$isEmptySafe(string)) {
            this.out.write(1);
            return;
        }
        int reference = this.strings.get(string);
        if (reference != -1) {
            this.writeUInt29(reference << 1);
            return;
        }
        this.strings.put(string, this.strings.size());
        this.out.write(3);
        IOUtil.writeUTF(this.out, string);
    }

    private final void writeElement(Element element) {
        String string = element.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.name");
        this.writeString(string);
        this.writeAttributes(element.getAttributes());
        List content = element.getContent();
        for (Content item : content) {
            if (item instanceof Element) {
                this.out.writeByte(TypeMarker.ELEMENT.ordinal());
                this.writeElement((Element)item);
                continue;
            }
            if (item instanceof Text) {
                if (this.isAllWhitespace(item)) continue;
                this.out.writeByte(TypeMarker.TEXT.ordinal());
                String string2 = ((Text)item).getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"item.text");
                this.writeString(string2);
                continue;
            }
            if (!(item instanceof CDATA)) continue;
            this.out.writeByte(TypeMarker.CDATA.ordinal());
            String string3 = ((CDATA)item).getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"item.text");
            this.writeString(string3);
        }
        this.out.writeByte(TypeMarker.ELEMENT_END.ordinal());
    }

    private final void writeAttributes(List<? extends Attribute> attributes) {
        List<? extends Attribute> list = attributes;
        int size = list != null ? list.size() : 0;
        this.out.write(size);
        if (size == 0) {
            return;
        }
        if (size > 255) {
            throw (Throwable)new UnsupportedOperationException("attributes size > 255");
        }
        List<? extends Attribute> list2 = attributes;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        for (Attribute attribute : list2) {
            String string = attribute.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attribute.name");
            this.writeString(string);
            String string2 = attribute.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"attribute.value");
            this.writeString(string2);
        }
    }

    private final void writeUInt29(int v) {
        if (v < 128) {
            this.out.write(v);
        } else if (v < 16384) {
            this.out.write(v >> 7 & 0x7F | 0x80);
            this.out.write(v & 0x7F);
        } else if (v < 0x200000) {
            this.out.write(v >> 14 & 0x7F | 0x80);
            this.out.write(v >> 7 & 0x7F | 0x80);
            this.out.write(v & 0x7F);
        } else if (v < 0x40000000) {
            this.out.write(v >> 22 & 0x7F | 0x80);
            this.out.write(v >> 15 & 0x7F | 0x80);
            this.out.write(v >> 8 & 0x7F | 0x80);
            this.out.write(v & 0xFF);
        } else {
            throw (Throwable)new IllegalArgumentException("Integer out of range: " + v);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isAllWhitespace(Content obj) {
        Object object;
        Content content = obj;
        if (!(content instanceof Text)) {
            content = null;
        }
        if ((object = (Text)content) == null || (object = object.getText()) == null) {
            return false;
        }
        Object str = object;
        int n = 0;
        int n2 = ((String)str).length() - 1;
        if (n <= n2) {
            while (true) {
                void i2;
                if (!Verifier.isXMLWhitespace((char)((String)str).charAt((int)i2))) {
                    return false;
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
        return true;
    }

    public BinaryXmlWriter(@NotNull DataOutputStream out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        this.out = out;
        this.strings = new ObjectIntHashMap();
    }
}

