/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIndentParser
implements PsiParser {
    protected PsiBuilder myBuilder;
    protected int myCurrentIndent;
    protected HashMap<PsiBuilder.Marker, Integer> myIndents;
    protected HashMap<PsiBuilder.Marker, Boolean> myNewLines;
    protected boolean myNewLine = true;

    @Override
    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        this.myNewLines = new HashMap();
        this.myIndents = new HashMap();
        this.myBuilder = builder;
        this.parseRoot(root);
        ASTNode aSTNode = this.myBuilder.getTreeBuilt();
        if (aSTNode == null) {
            AbstractIndentParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    protected abstract void parseRoot(IElementType var1);

    public PsiBuilder.Marker mark(boolean couldBeRolledBack) {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (couldBeRolledBack) {
            this.myIndents.put(marker, this.myCurrentIndent);
            this.myNewLines.put(marker, this.myNewLine);
        }
        return marker;
    }

    public PsiBuilder.Marker mark() {
        return this.mark(false);
    }

    public void done(@NotNull PsiBuilder.Marker marker, @NotNull IElementType elementType) {
        if (marker == null) {
            AbstractIndentParser.$$$reportNull$$$0(1);
        }
        if (elementType == null) {
            AbstractIndentParser.$$$reportNull$$$0(2);
        }
        this.myIndents.remove(marker);
        this.myNewLines.remove(marker);
        marker.done(elementType);
    }

    public static void collapse(@NotNull PsiBuilder.Marker marker, @NotNull IElementType elementType) {
        if (marker == null) {
            AbstractIndentParser.$$$reportNull$$$0(3);
        }
        if (elementType == null) {
            AbstractIndentParser.$$$reportNull$$$0(4);
        }
        marker.collapse(elementType);
    }

    protected static void drop(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            AbstractIndentParser.$$$reportNull$$$0(5);
        }
        marker.drop();
    }

    protected void rollbackTo(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            AbstractIndentParser.$$$reportNull$$$0(6);
        }
        if (this.myIndents.get(marker) == null) {
            throw new RuntimeException("Parser can't rollback marker that was created by mark() method, use mark(true) instead");
        }
        this.myCurrentIndent = (Integer)this.myIndents.get(marker);
        this.myNewLine = (Boolean)this.myNewLines.get(marker);
        this.myIndents.remove(marker);
        this.myNewLines.remove(marker);
        marker.rollbackTo();
    }

    protected boolean eof() {
        return this.myBuilder.eof();
    }

    protected int getCurrentOffset() {
        return this.myBuilder.getCurrentOffset();
    }

    public int getCurrentIndent() {
        return this.myCurrentIndent;
    }

    protected void error(String message) {
        this.myBuilder.error(message);
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myBuilder.getTokenType();
    }

    protected static boolean tokenIn(@Nullable IElementType elementType, IElementType ... tokens) {
        for (IElementType token : tokens) {
            if (elementType != token) continue;
            return true;
        }
        return false;
    }

    protected boolean currentTokenIn(IElementType ... tokens) {
        return AbstractIndentParser.tokenIn(this.getTokenType(), tokens);
    }

    protected boolean currentTokenIn(@NotNull TokenSet tokenSet) {
        if (tokenSet == null) {
            AbstractIndentParser.$$$reportNull$$$0(7);
        }
        return tokenSet.contains(this.getTokenType());
    }

    protected static boolean tokenIn(@Nullable IElementType elementType, @NotNull TokenSet tokenSet) {
        if (tokenSet == null) {
            AbstractIndentParser.$$$reportNull$$$0(8);
        }
        return tokenSet.contains(elementType);
    }

    @NotNull
    protected String getTokenText() {
        String result = this.myBuilder.getTokenText();
        if (result == null) {
            result = "";
        }
        String string = result;
        if (string == null) {
            AbstractIndentParser.$$$reportNull$$$0(9);
        }
        return string;
    }

    protected boolean expect(@NotNull IElementType elementType) {
        if (elementType == null) {
            AbstractIndentParser.$$$reportNull$$$0(10);
        }
        return this.expect(elementType, "Expected: " + elementType);
    }

    protected boolean expect(@NotNull IElementType elementType, String expectedMessage) {
        if (elementType == null) {
            AbstractIndentParser.$$$reportNull$$$0(11);
        }
        if (this.getTokenType() == elementType) {
            this.advance();
            return true;
        }
        this.error(expectedMessage);
        return false;
    }

    @Nullable
    public IElementType lookAhead(int step) {
        return this.myBuilder.lookAhead(step);
    }

    @Nullable
    public IElementType rawLookup(int step) {
        return this.myBuilder.rawLookup(step);
    }

    public boolean isNewLine() {
        return this.myNewLine;
    }

    public void advance() {
        String tokenText = this.myBuilder.getTokenText();
        int tokenLength = tokenText == null ? 0 : tokenText.length();
        int whiteSpaceStart = this.getCurrentOffset() + tokenLength;
        this.myBuilder.advanceLexer();
        int whiteSpaceEnd = this.getCurrentOffset();
        String whiteSpaceText = this.myBuilder.getOriginalText().subSequence(whiteSpaceStart, whiteSpaceEnd).toString();
        int i2 = whiteSpaceText.lastIndexOf(10);
        if (i2 >= 0) {
            this.myCurrentIndent = whiteSpaceText.length() - i2 - 1;
            this.myNewLine = true;
        } else {
            this.myNewLine = false;
        }
    }

    public void recalculateCurrentIndent() {
        int i2 = 0;
        int firstIndentOffset = this.myBuilder.getCurrentOffset();
        while (this.myBuilder.rawLookup(i2) != null && this.myBuilder.rawLookup(i2) != this.getEolElementType()) {
            firstIndentOffset = this.myBuilder.rawTokenTypeStart(i2);
            --i2;
        }
        int lastIndentOffset = firstIndentOffset;
        ++i2;
        while (this.myBuilder.rawLookup(i2) == this.getIndentElementType()) {
            lastIndentOffset = this.myBuilder.rawTokenTypeStart(++i2);
        }
        this.myCurrentIndent = lastIndentOffset - firstIndentOffset;
    }

    protected void advanceUntil(TokenSet tokenSet) {
        while (this.getTokenType() != null && !this.isNewLine() && !tokenSet.contains(this.getTokenType())) {
            this.advance();
        }
    }

    protected void advanceUntilEol() {
        this.advanceUntil(TokenSet.EMPTY);
    }

    protected void errorUntil(TokenSet tokenSet, String message) {
        PsiBuilder.Marker errorMarker = this.mark();
        this.advanceUntil(tokenSet);
        errorMarker.error(message);
    }

    protected void errorUntilEol(@NotNull String message) {
        if (message == null) {
            AbstractIndentParser.$$$reportNull$$$0(12);
        }
        PsiBuilder.Marker errorMarker = this.mark();
        this.advanceUntilEol();
        errorMarker.error(message);
    }

    protected void errorUntilEof(@NotNull String message) {
        if (message == null) {
            AbstractIndentParser.$$$reportNull$$$0(13);
        }
        PsiBuilder.Marker errorMarker = this.mark();
        while (!this.eof()) {
            this.advance();
        }
        errorMarker.error(message);
    }

    protected void expectEolOrEof() {
        if (!this.isNewLine() && !this.eof()) {
            this.errorUntilEol("End of line expected");
        }
    }

    protected abstract IElementType getIndentElementType();

    protected abstract IElementType getEolElementType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indentation/AbstractIndentParser";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indentation/AbstractIndentParser";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "done";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collapse";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rollbackTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "currentTokenIn";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tokenIn";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expect";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "errorUntilEol";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "errorUntilEof";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

