/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorStacked;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DoubleArrayList;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractProgressIndicatorBase
extends UserDataHolderBase
implements ProgressIndicatorStacked {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.progress.util.ProgressIndicatorBase");
    private volatile String myText;
    private volatile double myFraction;
    private volatile String myText2;
    private volatile boolean myCanceled;
    private volatile boolean myRunning;
    private volatile boolean myFinished;
    private volatile boolean myIndeterminate;
    private volatile Object myMacActivity;
    private volatile boolean myShouldStartActivity = true;
    private Stack<String> myTextStack;
    private DoubleArrayList myFractionStack;
    private Stack<String> myText2Stack;
    private volatile int myNonCancelableCount;
    protected ProgressIndicator myModalityProgress;
    private volatile ModalityState myModalityState = ModalityState.NON_MODAL;
    private static final Set<Class> ourReportedReuseExceptions = ContainerUtil.newConcurrentSet();

    @Override
    public synchronized void start() {
        LOG.assertTrue(!this.isRunning(), "Attempt to start ProgressIndicator which is already running");
        if (this.myFinished) {
            if (this.myCanceled && !this.isReuseable() && ourReportedReuseExceptions.add(this.getClass())) {
                LOG.error("Attempt to start ProgressIndicator which is cancelled and already stopped:" + this + "," + this.getClass());
            }
            this.myCanceled = false;
            this.myFinished = false;
        }
        this.myText = "";
        this.myFraction = 0.0;
        this.myText2 = "";
        this.startSystemActivity();
        this.myRunning = true;
    }

    protected boolean isReuseable() {
        return false;
    }

    @Override
    public synchronized void stop() {
        LOG.assertTrue(this.myRunning, "stop() should be called only if start() called before");
        this.myRunning = false;
        this.myFinished = true;
        this.stopSystemActivity();
    }

    protected void startSystemActivity() {
        this.myMacActivity = this.myShouldStartActivity ? MacUtil.wakeUpNeo(this.toString()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopSystemActivity() {
        if (this.myMacActivity != null) {
            Object object = this.myMacActivity;
            synchronized (object) {
                MacUtil.matrixHasYou(this.myMacActivity);
                this.myMacActivity = null;
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.myRunning;
    }

    @Override
    public void cancel() {
        this.myCanceled = true;
        this.stopSystemActivity();
        if (ApplicationManager.getApplication() != null) {
            ProgressManager.canceled(this);
        }
    }

    @Override
    public boolean isCanceled() {
        return this.myCanceled;
    }

    @Override
    public void checkCanceled() {
        this.throwIfCanceled();
        if (CoreProgressManager.runCheckCanceledHooks(this)) {
            this.throwIfCanceled();
        }
    }

    private void throwIfCanceled() {
        if (this.isCanceled() && this.isCancelable()) {
            Throwable trace = this.getCancellationTrace();
            throw trace instanceof ProcessCanceledException ? (ProcessCanceledException)trace : new ProcessCanceledException(trace);
        }
    }

    @Nullable
    protected Throwable getCancellationTrace() {
        if (this instanceof Disposable) {
            return ObjectUtils.tryCast(Disposer.getTree().getDisposalInfo((Disposable)((Object)this)), Throwable.class);
        }
        return null;
    }

    @Override
    public void setText(String text2) {
        this.myText = text2;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public void setText2(String text2) {
        this.myText2 = text2;
    }

    @Override
    public String getText2() {
        return this.myText2;
    }

    @Override
    public double getFraction() {
        return this.myFraction;
    }

    @Override
    public void setFraction(double fraction) {
        this.myFraction = fraction;
    }

    @Override
    public synchronized void pushState() {
        this.getTextStack().push(this.myText);
        this.getFractionStack().add(this.myFraction);
        this.getText2Stack().push(this.myText2);
    }

    @Override
    public synchronized void popState() {
        LOG.assertTrue(!this.myTextStack.isEmpty());
        String oldText = this.myTextStack.pop();
        double oldFraction = this.myFractionStack.remove(this.myFractionStack.size() - 1);
        String oldText2 = this.myText2Stack.pop();
        this.setText(oldText);
        this.setFraction(oldFraction);
        this.setText2(oldText2);
    }

    @Override
    public void startNonCancelableSection() {
        ++this.myNonCancelableCount;
    }

    @Override
    public void finishNonCancelableSection() {
        --this.myNonCancelableCount;
    }

    protected boolean isCancelable() {
        return this.myNonCancelableCount == 0;
    }

    @Override
    public final boolean isModal() {
        return this.myModalityProgress != null;
    }

    @Override
    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(0);
        }
        return modalityState;
    }

    @Override
    public void setModalityProgress(ProgressIndicator modalityProgress) {
        LOG.assertTrue(!this.isRunning());
        this.myModalityProgress = modalityProgress;
        ModalityState currentModality = ApplicationManager.getApplication().getCurrentModalityState();
        ModalityState modalityState = this.myModalityState = this.myModalityProgress != null ? ((ModalityStateEx)currentModality).appendProgress(this.myModalityProgress) : currentModality;
        if (modalityProgress != null) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).enteredModality(this.myModalityState);
        }
    }

    @Override
    public boolean isIndeterminate() {
        return this.myIndeterminate;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.myIndeterminate = indeterminate;
    }

    @NonNls
    public String toString() {
        return "ProgressIndicator " + System.identityHashCode(this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }

    @Override
    public boolean isPopupWasShown() {
        return true;
    }

    @Override
    public boolean isShowing() {
        return this.isModal();
    }

    @Override
    public synchronized void initStateFrom(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(1);
        }
        this.myRunning = indicator.isRunning();
        this.myCanceled = indicator.isCanceled();
        this.myFraction = indicator.getFraction();
        this.myIndeterminate = indicator.isIndeterminate();
        this.myText = indicator.getText();
        this.myText2 = indicator.getText2();
        this.myFraction = indicator.getFraction();
        if (indicator instanceof ProgressIndicatorStacked) {
            ProgressIndicatorStacked stacked = (ProgressIndicatorStacked)indicator;
            this.myNonCancelableCount = stacked.getNonCancelableCount();
            this.myTextStack = new Stack<String>((Collection<String>)stacked.getTextStack());
            this.myText2Stack = new Stack<String>((Collection<String>)stacked.getText2Stack());
            this.myFractionStack = new DoubleArrayList(stacked.getFractionStack());
        }
        this.myShouldStartActivity = false;
    }

    @Override
    @NotNull
    public synchronized Stack<String> getTextStack() {
        if (this.myTextStack == null) {
            this.myTextStack = new Stack(2);
        }
        Stack<String> stack = this.myTextStack;
        if (stack == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(2);
        }
        return stack;
    }

    @Override
    @NotNull
    public synchronized DoubleArrayList getFractionStack() {
        if (this.myFractionStack == null) {
            this.myFractionStack = new DoubleArrayList(2);
        }
        DoubleArrayList doubleArrayList = this.myFractionStack;
        if (doubleArrayList == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(3);
        }
        return doubleArrayList;
    }

    @Override
    @NotNull
    public synchronized Stack<String> getText2Stack() {
        if (this.myText2Stack == null) {
            this.myText2Stack = new Stack(2);
        }
        Stack<String> stack = this.myText2Stack;
        if (stack == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(4);
        }
        return stack;
    }

    @Override
    public int getNonCancelableCount() {
        return this.myNonCancelableCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextStack";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFractionStack";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText2Stack";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initStateFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

