/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.ProjectRootListener;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.impl.ProjectRootContainerImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.RootProviderBaseImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkImpl
extends UserDataHolderBase
implements Sdk,
SdkModificator {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.projectRoots.impl.ProjectJdkImpl");
    private final ProjectRootContainerImpl myRootContainer;
    private String myName;
    private String myVersionString;
    private boolean myVersionDefined;
    private String myHomePath = "";
    private final MyRootProvider myRootProvider = new MyRootProvider();
    private ProjectJdkImpl myOrigin;
    private SdkAdditionalData myAdditionalData;
    private SdkTypeId mySdkType;
    @NonNls
    public static final String ELEMENT_NAME = "name";
    @NonNls
    public static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    public static final String ELEMENT_TYPE = "type";
    @NonNls
    private static final String ELEMENT_VERSION = "version";
    @NonNls
    private static final String ELEMENT_ROOTS = "roots";
    @NonNls
    private static final String ELEMENT_HOMEPATH = "homePath";
    @NonNls
    private static final String ELEMENT_ADDITIONAL = "additional";

    public ProjectJdkImpl(String name, SdkTypeId sdkType) {
        this.mySdkType = sdkType;
        this.myRootContainer = new ProjectRootContainerImpl(true);
        this.myName = name;
        this.myRootContainer.addProjectRootContainerListener(this.myRootProvider);
    }

    public ProjectJdkImpl(String name, SdkTypeId sdkType, String homePath, String version) {
        this(name, sdkType);
        this.myHomePath = homePath;
        this.myVersionString = version;
    }

    @Override
    @NotNull
    public SdkTypeId getSdkType() {
        if (this.mySdkType == null) {
            this.mySdkType = ProjectJdkTable.getInstance().getDefaultSdkType();
        }
        SdkTypeId sdkTypeId = this.mySdkType;
        if (sdkTypeId == null) {
            ProjectJdkImpl.$$$reportNull$$$0(0);
        }
        return sdkTypeId;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ProjectJdkImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            ProjectJdkImpl.$$$reportNull$$$0(2);
        }
        this.myName = name;
    }

    @Override
    public final void setVersionString(@Nullable String versionString) {
        this.myVersionString = versionString == null || versionString.isEmpty() ? null : versionString;
        this.myVersionDefined = true;
    }

    @Override
    public String getVersionString() {
        String homePath;
        if (this.myVersionString == null && !this.myVersionDefined && (homePath = this.getHomePath()) != null && !homePath.isEmpty()) {
            this.setVersionString(this.getSdkType().getVersionString(this));
        }
        return this.myVersionString;
    }

    public final void resetVersionString() {
        this.myVersionDefined = false;
        this.myVersionString = null;
    }

    @Override
    public String getHomePath() {
        return this.myHomePath;
    }

    @Override
    public VirtualFile getHomeDirectory() {
        if (this.myHomePath == null) {
            return null;
        }
        return StandardFileSystems.local().findFileByPath(this.myHomePath);
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            ProjectJdkImpl.$$$reportNull$$$0(3);
        }
        this.readExternal(element, null);
    }

    public void readExternal(@NotNull Element element, @Nullable ProjectJdkTable projectJdkTable) throws InvalidDataException {
        Element version;
        String sdkTypeName;
        if (element == null) {
            ProjectJdkImpl.$$$reportNull$$$0(4);
        }
        this.myName = element.getChild(ELEMENT_NAME).getAttributeValue(ATTRIBUTE_VALUE);
        Element typeChild = element.getChild(ELEMENT_TYPE);
        String string = sdkTypeName = typeChild != null ? typeChild.getAttributeValue(ATTRIBUTE_VALUE) : null;
        if (sdkTypeName != null) {
            if (projectJdkTable == null) {
                projectJdkTable = ProjectJdkTable.getInstance();
            }
            this.mySdkType = projectJdkTable.getSdkTypeByName(sdkTypeName);
        }
        if ((version = element.getChild(ELEMENT_VERSION)) != null) {
            this.setVersionString(version.getAttributeValue(ATTRIBUTE_VALUE));
        } else {
            this.myVersionDefined = false;
        }
        this.myRootContainer.changeRoots(() -> {
            String versionValue;
            if (element == null) {
                ProjectJdkImpl.$$$reportNull$$$0(16);
            }
            if ((versionValue = element.getAttributeValue(ELEMENT_VERSION, "")).isEmpty() || !"2".equals(versionValue)) {
                throw new InvalidDataException("Too old version is not supported: " + versionValue);
            }
            this.myHomePath = element.getChild(ELEMENT_HOMEPATH).getAttributeValue(ATTRIBUTE_VALUE);
            this.myRootContainer.readExternal(element.getChild(ELEMENT_ROOTS));
        });
        Element additional = element.getChild(ELEMENT_ADDITIONAL);
        if (additional != null) {
            LOG.assertTrue(this.mySdkType != null);
            this.myAdditionalData = this.mySdkType.loadAdditionalData(this, additional);
        } else {
            this.myAdditionalData = null;
        }
    }

    public void writeExternal(Element element) {
        element.setAttribute(ELEMENT_VERSION, "2");
        Element name = new Element(ELEMENT_NAME);
        name.setAttribute(ATTRIBUTE_VALUE, this.myName);
        element.addContent(name);
        if (this.mySdkType != null) {
            Element sdkType = new Element(ELEMENT_TYPE);
            sdkType.setAttribute(ATTRIBUTE_VALUE, this.mySdkType.getName());
            element.addContent(sdkType);
        }
        if (this.myVersionString != null) {
            Element version = new Element(ELEMENT_VERSION);
            version.setAttribute(ATTRIBUTE_VALUE, this.myVersionString);
            element.addContent(version);
        }
        Element home = new Element(ELEMENT_HOMEPATH);
        home.setAttribute(ATTRIBUTE_VALUE, this.myHomePath);
        element.addContent(home);
        Element roots = new Element(ELEMENT_ROOTS);
        this.myRootContainer.writeExternal(roots);
        element.addContent(roots);
        Element additional = new Element(ELEMENT_ADDITIONAL);
        if (this.myAdditionalData != null) {
            LOG.assertTrue(this.mySdkType != null);
            this.mySdkType.saveAdditionalData(this.myAdditionalData, additional);
        }
        element.addContent(additional);
    }

    @Override
    public void setHomePath(String path) {
        boolean changes = this.myHomePath == null ? path != null : !this.myHomePath.equals(path);
        this.myHomePath = path;
        if (changes) {
            this.resetVersionString();
        }
    }

    @Override
    @NotNull
    public ProjectJdkImpl clone() {
        ProjectJdkImpl newJdk = new ProjectJdkImpl("", this.mySdkType);
        this.copyTo(newJdk);
        ProjectJdkImpl projectJdkImpl = newJdk;
        if (projectJdkImpl == null) {
            ProjectJdkImpl.$$$reportNull$$$0(5);
        }
        return projectJdkImpl;
    }

    @Override
    @NotNull
    public RootProvider getRootProvider() {
        MyRootProvider myRootProvider = this.myRootProvider;
        if (myRootProvider == null) {
            ProjectJdkImpl.$$$reportNull$$$0(6);
        }
        return myRootProvider;
    }

    void copyTo(@NotNull ProjectJdkImpl dest) {
        if (dest == null) {
            ProjectJdkImpl.$$$reportNull$$$0(7);
        }
        String name = this.getName();
        dest.setName(name);
        dest.setHomePath(this.getHomePath());
        dest.myVersionDefined = this.myVersionDefined;
        dest.myVersionString = this.myVersionString;
        dest.setSdkAdditionalData(this.getSdkAdditionalData());
        dest.copyRootsFrom(this.myRootContainer);
    }

    void copyRootsFrom(@NotNull ProjectRootContainerImpl rootContainer) {
        if (rootContainer == null) {
            ProjectJdkImpl.$$$reportNull$$$0(8);
        }
        this.myRootContainer.copyRootsFrom(rootContainer);
    }

    @Override
    @NotNull
    public SdkModificator getSdkModificator() {
        ProjectJdkImpl sdk = this.clone();
        sdk.myOrigin = this;
        sdk.myRootContainer.startChange();
        sdk.update();
        ProjectJdkImpl projectJdkImpl = sdk;
        if (projectJdkImpl == null) {
            ProjectJdkImpl.$$$reportNull$$$0(9);
        }
        return projectJdkImpl;
    }

    @Override
    public void commitChanges() {
        LOG.assertTrue(this.isWritable());
        this.copyTo(this.myOrigin);
        this.myOrigin = null;
    }

    @Override
    public SdkAdditionalData getSdkAdditionalData() {
        return this.myAdditionalData;
    }

    @Override
    public void setSdkAdditionalData(SdkAdditionalData data) {
        this.myAdditionalData = data;
    }

    @Override
    @NotNull
    public VirtualFile[] getRoots(OrderRootType rootType) {
        ProjectRoot[] roots = this.myRootContainer.getRoots(rootType);
        ArrayList files = new ArrayList(roots.length);
        for (ProjectRoot root : roots) {
            ContainerUtil.addAll(files, root.getVirtualFiles());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files);
        if (virtualFileArray == null) {
            ProjectJdkImpl.$$$reportNull$$$0(10);
        }
        return virtualFileArray;
    }

    @Override
    public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        if (root == null) {
            ProjectJdkImpl.$$$reportNull$$$0(11);
        }
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(12);
        }
        this.myRootContainer.addRoot(root, rootType);
    }

    @Override
    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        if (root == null) {
            ProjectJdkImpl.$$$reportNull$$$0(13);
        }
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(14);
        }
        this.myRootContainer.removeRoot(root, rootType);
    }

    @Override
    public void removeRoots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(15);
        }
        this.myRootContainer.removeAllRoots(rootType);
    }

    @Override
    public void removeAllRoots() {
        this.myRootContainer.removeAllRoots();
    }

    @Override
    public boolean isWritable() {
        return this.myOrigin != null;
    }

    public void update() {
        try {
            this.myRootContainer.update();
        }
        finally {
            this.resetVersionString();
        }
    }

    public String toString() {
        return this.myName + (this.myVersionDefined ? ": " + this.myVersionString : "") + " (" + this.myHomePath + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_NAME;
                break;
            }
            case 3: 
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootContainer";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkModificator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyRootsFrom";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeRoots";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$readExternal$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRootProvider
    extends RootProviderBaseImpl
    implements ProjectRootListener {
        private final List<RootProvider.RootSetChangedListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private MyRootProvider() {
        }

        @Override
        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                MyRootProvider.$$$reportNull$$$0(0);
            }
            ProjectRoot[] rootFiles = ProjectJdkImpl.this.myRootContainer.getRoots(rootType);
            ArrayList<String> result = new ArrayList<String>();
            for (ProjectRoot rootFile : rootFiles) {
                ContainerUtil.addAll(result, rootFile.getUrls());
            }
            String[] stringArray = ArrayUtil.toStringArray(result);
            if (stringArray == null) {
                MyRootProvider.$$$reportNull$$$0(1);
            }
            return stringArray;
        }

        @Override
        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                MyRootProvider.$$$reportNull$$$0(2);
            }
            VirtualFile[] virtualFileArray = ProjectJdkImpl.this.myRootContainer.getRootFiles(rootType);
            if (virtualFileArray == null) {
                MyRootProvider.$$$reportNull$$$0(3);
            }
            return virtualFileArray;
        }

        @Override
        public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
            if (listener == null) {
                MyRootProvider.$$$reportNull$$$0(4);
            }
            if (!this.myListeners.contains(listener)) {
                this.myListeners.add(listener);
                super.addRootSetChangedListener(listener);
            }
        }

        @Override
        public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener, @NotNull Disposable parentDisposable) {
            if (listener == null) {
                MyRootProvider.$$$reportNull$$$0(5);
            }
            if (parentDisposable == null) {
                MyRootProvider.$$$reportNull$$$0(6);
            }
            super.addRootSetChangedListener(listener, parentDisposable);
            Disposer.register(parentDisposable, () -> {
                if (listener == null) {
                    MyRootProvider.$$$reportNull$$$0(8);
                }
                this.removeRootSetChangedListener(listener);
            });
        }

        @Override
        public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
            if (listener == null) {
                MyRootProvider.$$$reportNull$$$0(7);
            }
            super.removeRootSetChangedListener(listener);
            this.myListeners.remove(listener);
        }

        @Override
        public void rootsChanged() {
            if (this.myListeners.isEmpty()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(this::fireRootSetChanged);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrls";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getUrls";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addRootSetChangedListener";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRootSetChangedListener";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addRootSetChangedListener$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

