/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final ExtensionPointName<ScopeOptimizer> USE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create("com.intellij.useScopeOptimizer");
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.PsiSearchHelperImpl");
    private final PsiManagerEx myManager;
    private final DumbService myDumbService;

    @Override
    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element) {
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(0);
        }
        SearchScope scope = element.getUseScope();
        for (UseScopeEnlarger enlarger : UseScopeEnlarger.EP_NAME.getExtensions()) {
            ProgressManager.checkCanceled();
            SearchScope additionalScope = enlarger.getAdditionalUseScope(element);
            if (additionalScope == null) continue;
            scope = scope.union(additionalScope);
        }
        SearchScope scopeToRestrict = ScopeOptimizer.calculateScopeToRestrict(USE_SCOPE_OPTIMIZER_EP_NAME.getExtensions(), element);
        if (scopeToRestrict != null) {
            scope = scope.intersectWith(scopeToRestrict);
        }
        SearchScope searchScope = scope;
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(1);
        }
        return searchScope;
    }

    public PsiSearchHelperImpl(@NotNull PsiManagerEx manager) {
        if (manager == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(2);
        }
        this.myManager = manager;
        this.myDumbService = DumbService.getInstance(this.myManager.getProject());
    }

    @Override
    @NotNull
    public PsiElement[] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(4);
        }
        List result = Collections.synchronizedList(new ArrayList());
        Processor<PsiElement> processor = Processors.cancelableCollectProcessor(result);
        this.processCommentsContainingIdentifier(identifier, searchScope, processor);
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    @Override
    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, @NotNull Processor<PsiElement> processor) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(8);
        }
        TextOccurenceProcessor occurrenceProcessor = (element, offsetInElement) -> {
            if (processor == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(155);
            }
            if (CommentUtilCore.isCommentTextElement(element) && element.findReferenceAt(offsetInElement) == null) {
                return processor.process(element);
            }
            return true;
        };
        return this.processElementsWithWord(occurrenceProcessor, searchScope, identifier, (short)2, true);
    }

    @Override
    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text2, short searchContext, boolean caseSensitive) {
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(11);
        }
        return this.processElementsWithWord(processor, searchScope, text2, searchContext, caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
    }

    @Override
    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text2, short searchContext, boolean caseSensitive, boolean processInjectedPsi) {
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(13);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(14);
        }
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (processInjectedPsi) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        return this.processElementsWithWord(processor, searchScope, text2, searchContext, options, null);
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text2, short searchContext, boolean caseSensitively) {
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(16);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(17);
        }
        boolean result = this.processElementsWithWord(processor, searchScope, text2, searchContext, caseSensitively, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(result);
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(18);
        }
        return asyncFuture;
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text2, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName) {
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(19);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(20);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(21);
        }
        if (options == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(22);
        }
        return this.bulkProcessElementsWithWord(searchScope, text2, searchContext, options, containerName, (scope, offsetsInScope, searcher) -> {
            if (options == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(153);
            }
            if (processor == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(154);
            }
            return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, options.contains((Object)Options.PROCESS_INJECTED_PSI), PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, processor);
        });
    }

    private boolean bulkProcessElementsWithWord(@NotNull SearchScope searchScope, @NotNull String text2, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName, final @NotNull BulkOccurrenceProcessor processor) {
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(23);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(24);
        }
        if (options == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(25);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(26);
        }
        if (text2.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        final ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        if (searchScope instanceof GlobalSearchScope) {
            StringSearcher searcher = new StringSearcher(text2, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
            return this.processElementsWithTextInGlobalScope(processor, (GlobalSearchScope)searchScope, searcher, searchContext, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), containerName, progress);
        }
        LocalSearchScope scope = (LocalSearchScope)searchScope;
        PsiElement[] scopeElements = scope.getScope();
        final StringSearcher searcher = new StringSearcher(text2, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
        ReadActionProcessor<PsiElement> localProcessor = new ReadActionProcessor<PsiElement>(){

            @Override
            public boolean processInReadAction(PsiElement scopeElement) {
                if (!scopeElement.isValid()) {
                    return true;
                }
                if (!scopeElement.isPhysical() || scopeElement instanceof PsiCompiledElement) {
                    scopeElement = scopeElement.getNavigationElement();
                }
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                if (scopeElement.getTextRange() == null) {
                    LOG.debug("Element " + scopeElement + " of class " + scopeElement.getClass() + " has null range");
                    return true;
                }
                return processor.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher, progress), searcher);
            }

            public String toString() {
                return processor.toString();
            }
        };
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(scopeElements), progress, true, true, localProcessor);
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator() {
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress == null) {
            progress = new EmptyProgressIndicator();
        }
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(27);
        }
        return progressIndicator;
    }

    static boolean shouldProcessInjectedPsi(@NotNull SearchScope scope) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(28);
        }
        return !(scope instanceof LocalSearchScope) || !((LocalSearchScope)scope).isIgnoreInjectedPsi();
    }

    @NotNull
    private static Processor<PsiElement> localProcessor(final @NotNull BulkOccurrenceProcessor processor, final @NotNull ProgressIndicator progress, final @NotNull StringSearcher searcher) {
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(29);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(30);
        }
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(31);
        }
        ReadActionProcessor<PsiElement> readActionProcessor = new ReadActionProcessor<PsiElement>(){

            @Override
            public boolean processInReadAction(PsiElement scopeElement) {
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                return scopeElement.isValid() && processor.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher, progress), searcher);
            }

            public String toString() {
                return processor.toString();
            }
        };
        if (readActionProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(32);
        }
        return readActionProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processElementsWithTextInGlobalScope(@NotNull BulkOccurrenceProcessor processor, @NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull ProgressIndicator progress) {
        boolean result;
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(33);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(34);
        }
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(35);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(36);
        }
        progress.pushState();
        try {
            progress.setText(PsiBundle.message("psi.scanning.files.progress", new Object[0]));
            String text2 = searcher.getPattern();
            THashSet fileSet = new THashSet();
            this.getFilesWithText(scope, searchContext, caseSensitively, text2, (Collection<VirtualFile>)fileSet);
            progress.setText(PsiBundle.message("psi.search.for.word.progress", text2));
            Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(processor, progress, searcher);
            if (containerName != null) {
                ArrayList<VirtualFile> intersectionWithContainerFiles = new ArrayList<VirtualFile>();
                this.getFilesWithText(scope, searchContext, caseSensitively, text2 + " " + containerName, intersectionWithContainerFiles);
                if (!intersectionWithContainerFiles.isEmpty()) {
                    int totalSize = fileSet.size();
                    boolean result2 = this.processPsiFileRoots(intersectionWithContainerFiles, totalSize, 0, progress, localProcessor);
                    if (result2) {
                        fileSet.removeAll(intersectionWithContainerFiles);
                        if (!fileSet.isEmpty()) {
                            result2 = this.processPsiFileRoots(new ArrayList<VirtualFile>((Collection<VirtualFile>)fileSet), totalSize, intersectionWithContainerFiles.size(), progress, localProcessor);
                        }
                    }
                    boolean bl = result2;
                    return bl;
                }
            }
            result = fileSet.isEmpty() || this.processPsiFileRoots(new ArrayList<VirtualFile>((Collection<VirtualFile>)fileSet), fileSet.size(), 0, progress, localProcessor);
        }
        finally {
            progress.popState();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPsiFileRoots(@NotNull List<VirtualFile> files, int totalSize, int alreadyProcessedFiles, @NotNull ProgressIndicator progress, @NotNull Processor<? super PsiFile> localProcessor) {
        if (files == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(37);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(38);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(39);
        }
        this.myManager.startBatchFilesProcessingMode();
        try {
            AtomicInteger counter = new AtomicInteger(alreadyProcessedFiles);
            AtomicBoolean canceled = new AtomicBoolean(false);
            boolean bl = PsiSearchHelperImpl.processFilesConcurrentlyDespiteWriteActions(this.myManager.getProject(), files, progress, vfile -> {
                if (progress == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(151);
                }
                if (localProcessor == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(152);
                }
                TooManyUsagesStatus.getFrom(progress).pauseProcessingIfTooManyUsages();
                this.processVirtualFile((VirtualFile)vfile, localProcessor, canceled);
                if (progress.isRunning()) {
                    double fraction = (double)counter.incrementAndGet() / (double)totalSize;
                    progress.setFraction(fraction);
                }
                return !canceled.get();
            });
            return bl;
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    public static boolean processFilesConcurrentlyDespiteWriteActions(@NotNull Project project, @NotNull List<VirtualFile> files, @NotNull ProgressIndicator progress, @NotNull Processor<VirtualFile> localProcessor) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(40);
        }
        if (files == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(41);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(42);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(43);
        }
        ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
        AtomicBoolean canceled = new AtomicBoolean(false);
        if (!app.isDispatchThread()) {
            CoreProgressManager.assertUnderProgress(progress);
        }
        while (true) {
            boolean completed;
            ProgressManager.checkCanceled();
            SmartList<VirtualFile> failedList = new SmartList<VirtualFile>();
            List<VirtualFile> failedFiles = Collections.synchronizedList(failedList);
            Processor<VirtualFile> processor = vfile -> {
                if (localProcessor == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(150);
                }
                ProgressManager.checkCanceled();
                try {
                    boolean result = localProcessor.process((VirtualFile)vfile);
                    if (!result) {
                        canceled.set(true);
                    }
                    return result;
                }
                catch (ApplicationUtil.CannotRunReadActionException action) {
                    failedFiles.add((VirtualFile)vfile);
                    return !canceled.get();
                }
            };
            if (app.isWriteAccessAllowed() || app.isReadAccessAllowed() && app.isWriteActionPending()) {
                completed = ContainerUtil.process(files, processor);
            } else if (app.isWriteActionPending()) {
                completed = true;
                failedFiles.addAll(files);
            } else {
                completed = JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files, progress, false, true, processor);
            }
            if (!completed) {
                return false;
            }
            if (failedFiles.isEmpty()) break;
            DumbService.getInstance(project).runReadActionInSmartMode(EmptyRunnable.getInstance());
            files = failedList;
        }
        return true;
    }

    private void processVirtualFile(@NotNull VirtualFile vfile, @NotNull Processor<? super PsiFile> localProcessor, @NotNull AtomicBoolean canceled) throws ApplicationUtil.CannotRunReadActionException {
        PsiFile file;
        if (vfile == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(44);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(45);
        }
        if (canceled == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(46);
        }
        if ((file = ApplicationUtil.tryRunReadAction(() -> {
            if (vfile == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(149);
            }
            return vfile.isValid() ? this.myManager.findFile(vfile) : null;
        })) != null && !(file instanceof PsiBinaryFile)) {
            if (FileDocumentManager.getInstance().getCachedDocument(vfile) == null) {
                try {
                    vfile.contentsToByteArray();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ApplicationUtil.tryRunReadAction(() -> {
                Project project;
                if (localProcessor == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(147);
                }
                if (canceled == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(148);
                }
                if ((project = this.myManager.getProject()).isDisposed()) {
                    throw new ProcessCanceledException();
                }
                if (DumbService.isDumb(project)) {
                    throw new ApplicationUtil.CannotRunReadActionException();
                }
                List<PsiFile> psiRoots = file.getViewProvider().getAllFiles();
                THashSet processed2 = new THashSet(psiRoots.size() * 2, 0.5f);
                for (PsiFile psiRoot : psiRoots) {
                    ProgressManager.checkCanceled();
                    assert (psiRoot != null) : "One of the roots of file " + file + " is null. All roots: " + psiRoots + "; ViewProvider: " + file.getViewProvider() + "; Virtual file: " + file.getViewProvider().getVirtualFile();
                    if (!processed2.add(psiRoot) || !psiRoot.isValid() || localProcessor.process(psiRoot)) continue;
                    canceled.set(true);
                    break;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text2, @NotNull Collection<VirtualFile> result) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(47);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(48);
        }
        if (result == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(49);
        }
        this.myManager.startBatchFilesProcessingMode();
        try {
            Processor<VirtualFile> processor = Processors.cancelableCollectProcessor(result);
            boolean bl = this.processFilesWithText(scope, searchContext, caseSensitively, text2, processor);
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    public boolean processFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text2, @NotNull Processor<VirtualFile> processor) {
        List<IdIndexEntry> entries;
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(50);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(51);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(52);
        }
        if ((entries = PsiSearchHelperImpl.getWordEntries(text2, caseSensitively)).isEmpty()) {
            return true;
        }
        Condition<Integer> contextMatches = integer -> (integer & searchContext) != 0;
        return PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, contextMatches, entries, processor);
    }

    @Override
    @NotNull
    public PsiFile[] findFilesWithPlainTextWords(@NotNull String word) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(53);
        }
        PsiFile[] psiFileArray = CacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope(this.myManager.getProject()), true);
        if (psiFileArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(54);
        }
        return psiFileArray;
    }

    @Override
    public boolean processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor, @NotNull GlobalSearchScope searchScope) {
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(55);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(56);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(57);
        }
        return this.processUsagesInNonJavaFiles(null, qName, processor, searchScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processUsagesInNonJavaFiles(@Nullable PsiElement originalElement, @NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor, @NotNull GlobalSearchScope initialScope) {
        int dollarIndex;
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(58);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(59);
        }
        if (initialScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(60);
        }
        if (qName.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text. Element: " + originalElement + "; " + (originalElement == null ? null : originalElement.getClass()));
        }
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        String wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        GlobalSearchScope theSearchScope = ReadAction.compute(() -> {
            if (initialScope == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(146);
            }
            if (originalElement != null && this.myManager.isInProject(originalElement) && initialScope.isSearchInLibraries()) {
                return initialScope.intersectWith(GlobalSearchScope.projectScope(this.myManager.getProject()));
            }
            return initialScope;
        });
        PsiFile[] files = this.myDumbService.runReadActionInSmartMode(() -> CacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithWord(wordToSearch, (short)16, theSearchScope, true));
        StringSearcher searcher = new StringSearcher(qName, true, true, false);
        progress.pushState();
        Ref<Boolean> cancelled = Ref.create(Boolean.FALSE);
        try {
            progress.setText(PsiBundle.message("psi.search.in.non.java.files.progress", new Object[0]));
            SearchScope useScope = originalElement == null ? null : this.myDumbService.runReadActionInSmartMode(() -> this.getUseScope(originalElement));
            int patternLength = qName.length();
            for (int i2 = 0; i2 < files.length; ++i2) {
                ProgressManager.checkCanceled();
                PsiFile psiFile = files[i2];
                if (psiFile instanceof PsiBinaryFile) continue;
                CharSequence text2 = ReadAction.compute(() -> psiFile.getViewProvider().getContents());
                LowLevelSearchUtil.processTextOccurrences(text2, 0, text2.length(), searcher, progress, index -> {
                    boolean isReferenceOK;
                    if (initialScope == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(143);
                    }
                    if (processor == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(144);
                    }
                    if ((isReferenceOK = this.myDumbService.runReadActionInSmartMode(() -> {
                        PsiReference referenceAt;
                        if (initialScope == null) {
                            PsiSearchHelperImpl.$$$reportNull$$$0(145);
                        }
                        return (referenceAt = psiFile.findReferenceAt(index)) == null || useScope == null || !PsiSearchScopeUtil.isInScope(useScope.intersectWith(initialScope), (PsiElement)psiFile);
                    }).booleanValue()) && !processor.process(psiFile, index, index + patternLength)) {
                        cancelled.set(Boolean.TRUE);
                        return false;
                    }
                    return true;
                });
                if (cancelled.get().booleanValue()) {
                    break;
                }
                progress.setFraction((double)(i2 + 1) / (double)files.length);
            }
        }
        finally {
            progress.popState();
        }
        return cancelled.get() == false;
    }

    @Override
    public boolean processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(61);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(62);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(63);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)1, scope, caseSensitively);
    }

    @Override
    public boolean processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(64);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(65);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(66);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)16, scope, caseSensitively);
    }

    @Override
    public boolean processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(67);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(68);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(69);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)2, scope, true);
    }

    @Override
    public boolean processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(70);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(71);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(72);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)4, scope, true);
    }

    @Override
    public boolean processRequests(@NotNull SearchRequestCollector collector, @NotNull Processor<PsiReference> processor) {
        boolean result;
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(73);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(74);
        }
        HashMap<SearchRequestCollector, Processor<PsiReference>> collectors = ContainerUtil.newHashMap();
        collectors.put(collector, processor);
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        PsiSearchHelperImpl.appendCollectorsFromQueryRequests(collectors);
        do {
            MultiMap<Set<IdIndexEntry>, RequestWithProcessor> globals = new MultiMap<Set<IdIndexEntry>, RequestWithProcessor>();
            ArrayList<Computable<Boolean>> customs = ContainerUtil.newArrayList();
            LinkedHashSet<RequestWithProcessor> locals = ContainerUtil.newLinkedHashSet();
            THashMap localProcessors = new THashMap();
            PsiSearchHelperImpl.distributePrimitives(collectors, locals, globals, customs, (Map<RequestWithProcessor, Processor<PsiElement>>)localProcessors, progress);
            result = this.processGlobalRequestsOptimized(globals, progress, (Map<RequestWithProcessor, Processor<PsiElement>>)localProcessors);
            if (!result) continue;
            for (RequestWithProcessor requestWithProcessor : locals) {
                ProgressManager.checkCanceled();
                result = this.processSingleRequest(requestWithProcessor.request, requestWithProcessor.refProcessor);
                if (result) continue;
                break;
            }
            if (result) {
                for (Computable computable : customs) {
                    ProgressManager.checkCanceled();
                    result = (Boolean)computable.compute();
                    if (result) continue;
                    break;
                }
            }
            if (!result) break;
        } while (PsiSearchHelperImpl.appendCollectorsFromQueryRequests(collectors));
        return result;
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector collector, @NotNull Processor<PsiReference> processor) {
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(75);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(76);
        }
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(this.processRequests(collector, processor));
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(77);
        }
        return asyncFuture;
    }

    private static boolean appendCollectorsFromQueryRequests(@NotNull Map<SearchRequestCollector, Processor<PsiReference>> collectors) {
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(78);
        }
        boolean changed = false;
        LinkedList<SearchRequestCollector> queue = new LinkedList<SearchRequestCollector>(collectors.keySet());
        while (!queue.isEmpty()) {
            SearchRequestCollector each = (SearchRequestCollector)queue.removeFirst();
            for (QuerySearchRequest request : each.takeQueryRequests()) {
                ProgressManager.checkCanceled();
                request.runQuery();
                assert (!collectors.containsKey(request.collector) || collectors.get(request.collector) == request.processor);
                collectors.put(request.collector, request.processor);
                queue.addLast(request.collector);
                changed = true;
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processGlobalRequestsOptimized(@NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, @NotNull ProgressIndicator progress, @NotNull Map<RequestWithProcessor, Processor<PsiElement>> localProcessors) {
        boolean result;
        Collection<RequestWithProcessor> requests;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(79);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(80);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(81);
        }
        if (singles.isEmpty()) {
            return true;
        }
        if (singles.size() == 1 && (requests = singles.values()).size() == 1) {
            RequestWithProcessor theOnly = requests.iterator().next();
            return this.processSingleRequest(theOnly.request, theOnly.refProcessor);
        }
        progress.pushState();
        progress.setText(PsiBundle.message("psi.scanning.files.progress", new Object[0]));
        try {
            MultiMap<VirtualFile, RequestWithProcessor> intersectionCandidateFiles = PsiSearchHelperImpl.createMultiMap();
            MultiMap<VirtualFile, RequestWithProcessor> restCandidateFiles = PsiSearchHelperImpl.createMultiMap();
            this.collectFiles(singles, intersectionCandidateFiles, restCandidateFiles);
            if (intersectionCandidateFiles.isEmpty() && restCandidateFiles.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            TreeSet<String> allWords = new TreeSet<String>();
            for (RequestWithProcessor singleRequest : localProcessors.keySet()) {
                ProgressManager.checkCanceled();
                allWords.add(((RequestWithProcessor)singleRequest).request.word);
            }
            progress.setText(PsiBundle.message("psi.search.for.word.progress", PsiSearchHelperImpl.getPresentableWordsDescription(allWords)));
            if (intersectionCandidateFiles.isEmpty()) {
                result = this.processCandidates(localProcessors, restCandidateFiles, progress, restCandidateFiles.size(), 0);
            } else {
                int totalSize = restCandidateFiles.size() + intersectionCandidateFiles.size();
                result = this.processCandidates(localProcessors, intersectionCandidateFiles, progress, totalSize, 0);
                if (result) {
                    result = this.processCandidates(localProcessors, restCandidateFiles, progress, totalSize, intersectionCandidateFiles.size());
                }
            }
        }
        finally {
            progress.popState();
        }
        return result;
    }

    private boolean processCandidates(@NotNull Map<RequestWithProcessor, Processor<PsiElement>> localProcessors, @NotNull MultiMap<VirtualFile, RequestWithProcessor> candidateFiles, @NotNull ProgressIndicator progress, int totalSize, int alreadyProcessedFiles) {
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(82);
        }
        if (candidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(83);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(84);
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(candidateFiles.keySet());
        return this.processPsiFileRoots(files, totalSize, alreadyProcessedFiles, progress, psiRoot -> {
            if (candidateFiles == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(141);
            }
            if (localProcessors == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(142);
            }
            VirtualFile vfile = psiRoot.getVirtualFile();
            for (RequestWithProcessor singleRequest : candidateFiles.get(vfile)) {
                ProgressManager.checkCanceled();
                Processor localProcessor = (Processor)localProcessors.get(singleRequest);
                if (localProcessor.process(psiRoot)) continue;
                return false;
            }
            return true;
        });
    }

    @NotNull
    private static String getPresentableWordsDescription(@NotNull Set<String> allWords) {
        if (allWords == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(85);
        }
        StringBuilder result = new StringBuilder();
        for (String string : allWords) {
            ProgressManager.checkCanceled();
            if (string == null || string.isEmpty()) continue;
            if (result.length() > 50) {
                result.append("...");
                break;
            }
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(string);
        }
        String string = result.toString();
        if (string == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(86);
        }
        return string;
    }

    @NotNull
    private static BulkOccurrenceProcessor adaptProcessor(@NotNull PsiSearchRequest singleRequest, final @NotNull Processor<PsiReference> consumer) {
        SearchScope searchScope;
        if (singleRequest == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(87);
        }
        if (consumer == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(88);
        }
        final boolean ignoreInjectedPsi = (searchScope = singleRequest.searchScope) instanceof LocalSearchScope && ((LocalSearchScope)searchScope).isIgnoreInjectedPsi();
        final RequestResultProcessor wrapped = singleRequest.processor;
        BulkOccurrenceProcessor bulkOccurrenceProcessor = new BulkOccurrenceProcessor(){

            @Override
            public boolean execute(@NotNull PsiElement scope, @NotNull int[] offsetsInScope, @NotNull StringSearcher searcher) {
                if (scope == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (offsetsInScope == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (searcher == null) {
                    3.$$$reportNull$$$0(2);
                }
                try {
                    ProgressManager.checkCanceled();
                    if (wrapped instanceof RequestResultProcessor.BulkResultProcessor) {
                        return ((RequestResultProcessor.BulkResultProcessor)wrapped).processTextOccurrences(scope, offsetsInScope, consumer);
                    }
                    return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, !ignoreInjectedPsi, PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, (element, offsetInElement) -> {
                        if (consumer == null) {
                            3.$$$reportNull$$$0(3);
                        }
                        if (ignoreInjectedPsi && element instanceof PsiLanguageInjectionHost) {
                            return true;
                        }
                        return wrapped.processTextOccurrence(element, offsetInElement, consumer);
                    });
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Error | Exception e) {
                    LOG.error(e);
                    return true;
                }
            }

            public String toString() {
                return consumer.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "offsetsInScope";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searcher";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$execute$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (bulkOccurrenceProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(89);
        }
        return bulkOccurrenceProcessor;
    }

    private void collectFiles(@NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, @NotNull MultiMap<VirtualFile, RequestWithProcessor> intersectionResult, @NotNull MultiMap<VirtualFile, RequestWithProcessor> restResult) {
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(90);
        }
        if (intersectionResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(91);
        }
        if (restResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(92);
        }
        for (Map.Entry<Set<IdIndexEntry>, Collection<RequestWithProcessor>> entry : singles.entrySet()) {
            ProgressManager.checkCanceled();
            Set<IdIndexEntry> keys = entry.getKey();
            if (keys.isEmpty()) continue;
            Collection<RequestWithProcessor> processors = entry.getValue();
            GlobalSearchScope commonScope = PsiSearchHelperImpl.uniteScopes(processors);
            Set<VirtualFile> intersectionWithContainerNameFiles = this.intersectionWithContainerNameFiles(commonScope, processors, keys);
            ArrayList result = new ArrayList();
            Processor<VirtualFile> processor = Processors.cancelableCollectProcessor(result);
            PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, null, keys, processor);
            for (VirtualFile file : result) {
                ProgressManager.checkCanceled();
                for (IdIndexEntry indexEntry : keys) {
                    ProgressManager.checkCanceled();
                    this.myDumbService.runReadActionInSmartMode(() -> {
                        if (restResult == null) {
                            PsiSearchHelperImpl.$$$reportNull$$$0(137);
                        }
                        if (intersectionResult == null) {
                            PsiSearchHelperImpl.$$$reportNull$$$0(138);
                        }
                        return FileBasedIndex.getInstance().processValues(IdIndex.NAME, indexEntry, file, (file1, value) -> {
                            if (restResult == null) {
                                PsiSearchHelperImpl.$$$reportNull$$$0(139);
                            }
                            if (intersectionResult == null) {
                                PsiSearchHelperImpl.$$$reportNull$$$0(140);
                            }
                            int mask = value;
                            for (RequestWithProcessor single : processors) {
                                ProgressManager.checkCanceled();
                                PsiSearchRequest request = single.request;
                                if ((mask & request.searchContext) == 0 || !request.searchScope.contains(file1)) continue;
                                MultiMap result1 = intersectionWithContainerNameFiles == null || !intersectionWithContainerNameFiles.contains(file1) ? restResult : intersectionResult;
                                result1.putValue(file1, single);
                            }
                            return true;
                        }, commonScope);
                    });
                }
            }
        }
    }

    @Nullable(value="null means we did not find common container files")
    private Set<VirtualFile> intersectionWithContainerNameFiles(@NotNull GlobalSearchScope commonScope, @NotNull Collection<RequestWithProcessor> data, @NotNull Set<IdIndexEntry> keys) {
        if (commonScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(93);
        }
        if (data == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(94);
        }
        if (keys == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(95);
        }
        String commonName = null;
        short searchContext = 0;
        boolean caseSensitive = true;
        for (RequestWithProcessor r : data) {
            ProgressManager.checkCanceled();
            String containerName = ((RequestWithProcessor)r).request.containerName;
            if (containerName == null) continue;
            if (commonName == null) {
                commonName = containerName;
                searchContext = ((RequestWithProcessor)r).request.searchContext;
                caseSensitive = ((RequestWithProcessor)r).request.caseSensitive;
                continue;
            }
            if (commonName.equals(containerName)) {
                searchContext = (short)(searchContext | ((RequestWithProcessor)r).request.searchContext);
                caseSensitive &= ((RequestWithProcessor)r).request.caseSensitive;
                continue;
            }
            return null;
        }
        if (commonName == null) {
            return null;
        }
        List<IdIndexEntry> entries = PsiSearchHelperImpl.getWordEntries(commonName, caseSensitive);
        if (entries.isEmpty()) {
            return null;
        }
        entries.addAll(keys);
        short finalSearchContext = searchContext;
        Condition<Integer> contextMatches = context -> (context & finalSearchContext) != 0;
        THashSet containerFiles = new THashSet();
        Processor<VirtualFile> processor = Processors.cancelableCollectProcessor(containerFiles);
        PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, contextMatches, entries, processor);
        return containerFiles;
    }

    @NotNull
    private static MultiMap<VirtualFile, RequestWithProcessor> createMultiMap() {
        MultiMap<VirtualFile, RequestWithProcessor> multiMap = MultiMap.createSmart();
        if (multiMap == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(96);
        }
        return multiMap;
    }

    @NotNull
    private static GlobalSearchScope uniteScopes(@NotNull Collection<RequestWithProcessor> requests) {
        if (requests == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(97);
        }
        Set<GlobalSearchScope> scopes = ContainerUtil.map2LinkedSet(requests, r -> (GlobalSearchScope)((RequestWithProcessor)r).request.searchScope);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union(scopes.toArray(new GlobalSearchScope[scopes.size()]));
        if (globalSearchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(98);
        }
        return globalSearchScope;
    }

    private static void distributePrimitives(@NotNull Map<SearchRequestCollector, Processor<PsiReference>> collectors, @NotNull Set<RequestWithProcessor> locals, @NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> globals, @NotNull List<Computable<Boolean>> customs, @NotNull Map<RequestWithProcessor, Processor<PsiElement>> localProcessors, @NotNull ProgressIndicator progress) {
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(99);
        }
        if (locals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(100);
        }
        if (globals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(101);
        }
        if (customs == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(102);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(103);
        }
        if (progress == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(104);
        }
        for (Map.Entry<SearchRequestCollector, Processor<PsiReference>> entry : collectors.entrySet()) {
            ProgressManager.checkCanceled();
            Processor<PsiReference> processor = entry.getValue();
            SearchRequestCollector collector = entry.getKey();
            for (PsiSearchRequest psiSearchRequest : collector.takeSearchRequests()) {
                ProgressManager.checkCanceled();
                SearchScope scope = psiSearchRequest.searchScope;
                if (scope instanceof LocalSearchScope) {
                    PsiSearchHelperImpl.registerRequest(locals, psiSearchRequest, processor);
                    continue;
                }
                HashSet<IdIndexEntry> key = new HashSet<IdIndexEntry>(PsiSearchHelperImpl.getWordEntries(psiSearchRequest.word, psiSearchRequest.caseSensitive));
                PsiSearchHelperImpl.registerRequest(globals.getModifiable(key), psiSearchRequest, processor);
            }
            for (Processor processor2 : collector.takeCustomSearchActions()) {
                ProgressManager.checkCanceled();
                customs.add(() -> customAction.process(processor));
            }
        }
        for (Map.Entry<Object, Object> entry : globals.entrySet()) {
            ProgressManager.checkCanceled();
            for (RequestWithProcessor singleRequest : (Collection)entry.getValue()) {
                ProgressManager.checkCanceled();
                PsiSearchRequest primitive = singleRequest.request;
                StringSearcher stringSearcher = new StringSearcher(primitive.word, primitive.caseSensitive, true, false);
                BulkOccurrenceProcessor adapted = PsiSearchHelperImpl.adaptProcessor(primitive, singleRequest.refProcessor);
                Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(adapted, progress, stringSearcher);
                assert (!localProcessors.containsKey(singleRequest) || localProcessors.get(singleRequest) == localProcessor);
                localProcessors.put(singleRequest, localProcessor);
            }
        }
    }

    private static void registerRequest(@NotNull Collection<RequestWithProcessor> collection, @NotNull PsiSearchRequest primitive, @NotNull Processor<PsiReference> processor) {
        if (collection == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(105);
        }
        if (primitive == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(106);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(107);
        }
        RequestWithProcessor singleRequest = new RequestWithProcessor(primitive, processor);
        for (RequestWithProcessor existing : collection) {
            ProgressManager.checkCanceled();
            if (!existing.uniteWith(singleRequest)) continue;
            return;
        }
        collection.add(singleRequest);
    }

    private boolean processSingleRequest(@NotNull PsiSearchRequest single, @NotNull Processor<PsiReference> consumer) {
        if (single == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(108);
        }
        if (consumer == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(109);
        }
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (single.caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (PsiSearchHelperImpl.shouldProcessInjectedPsi(single.searchScope)) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        return this.bulkProcessElementsWithWord(single.searchScope, single.word, single.searchContext, options, single.containerName, PsiSearchHelperImpl.adaptProcessor(single, consumer));
    }

    @Override
    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, final @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress) {
        boolean cheap;
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(110);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(111);
        }
        if (!ReadAction.compute(() -> {
            if (scope == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(136);
            }
            return scope.getUnloadedModulesBelongingToScope().isEmpty();
        }).booleanValue()) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(112);
            }
            return searchCostResult;
        }
        final AtomicInteger filesCount = new AtomicInteger();
        final AtomicLong filesSizeToProcess = new AtomicLong();
        Processor<VirtualFile> processor = new Processor<VirtualFile>(){
            private final VirtualFile virtualFileToIgnoreOccurrencesIn;
            private final int maxFilesToProcess;
            private final int maxFilesSizeToProcess;
            {
                this.virtualFileToIgnoreOccurrencesIn = fileToIgnoreOccurrencesIn == null ? null : fileToIgnoreOccurrencesIn.getVirtualFile();
                this.maxFilesToProcess = Registry.intValue("ide.unused.symbol.calculation.maxFilesToSearchUsagesIn", 10);
                this.maxFilesSizeToProcess = Registry.intValue("ide.unused.symbol.calculation.maxFilesSizeToSearchUsagesIn", 524288);
            }

            @Override
            public boolean process(VirtualFile file) {
                ProgressManager.checkCanceled();
                if (Comparing.equal(file, this.virtualFileToIgnoreOccurrencesIn)) {
                    return true;
                }
                int currentFilesCount = filesCount.incrementAndGet();
                long accumulatedFileSizeToProcess = filesSizeToProcess.addAndGet(file.isDirectory() ? 0L : file.getLength());
                return currentFilesCount < this.maxFilesToProcess && accumulatedFileSizeToProcess < (long)this.maxFilesSizeToProcess;
            }
        };
        List<IdIndexEntry> keys = PsiSearchHelperImpl.getWordEntries(name, true);
        boolean bl = cheap = keys.isEmpty() || PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, null, keys, processor);
        if (!cheap) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(113);
            }
            return searchCostResult;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = filesCount.get() == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
        if (searchCostResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(114);
        }
        return searchCostResult;
    }

    private static boolean processFilesContainingAllKeys(@NotNull Project project, @NotNull GlobalSearchScope scope, @Nullable Condition<Integer> checker, @NotNull Collection<IdIndexEntry> keys, @NotNull Processor<VirtualFile> processor) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(115);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(116);
        }
        if (keys == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(117);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(118);
        }
        FileIndexFacade index = FileIndexFacade.getInstance(project);
        return DumbService.getInstance(project).runReadActionInSmartMode(() -> {
            if (keys == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(131);
            }
            if (scope == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(132);
            }
            if (processor == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(133);
            }
            return FileBasedIndex.getInstance().processFilesContainingAllKeys(IdIndex.NAME, keys, scope, checker, file -> {
                if (scope == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(134);
                }
                if (processor == null) {
                    PsiSearchHelperImpl.$$$reportNull$$$0(135);
                }
                return !index.shouldBeFound(scope, (VirtualFile)file) || processor.process((VirtualFile)file);
            });
        });
    }

    @NotNull
    private static List<IdIndexEntry> getWordEntries(@NotNull String name, boolean caseSensitively) {
        String trimmed;
        List<String> words;
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(119);
        }
        if ((words = StringUtil.getWordsInStringLongestFirst(name)).isEmpty() && StringUtil.isNotEmpty(trimmed = name.trim())) {
            words = Collections.singletonList(trimmed);
        }
        if (words.isEmpty()) {
            List<IdIndexEntry> list = Collections.emptyList();
            if (list == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(120);
            }
            return list;
        }
        List<IdIndexEntry> list = ContainerUtil.map2List(words, word -> new IdIndexEntry((String)word, caseSensitively));
        if (list == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(121);
        }
        return list;
    }

    public static boolean processTextOccurrences(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Processor<UsageInfo> processor, @NotNull UsageInfoFactory factory) {
        if (element == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(122);
        }
        if (stringToSearch == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(123);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(124);
        }
        if (processor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(125);
        }
        if (factory == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(126);
        }
        PsiSearchHelper helper = ReadAction.compute(() -> {
            if (element == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(130);
            }
            return PsiSearchHelper.SERVICE.getInstance(element.getProject());
        });
        return helper.processUsagesInNonJavaFiles(element, stringToSearch, (psiFile, startOffset, endOffset) -> {
            if (factory == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(127);
            }
            if (processor == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(128);
            }
            try {
                UsageInfo usageInfo = ReadAction.compute(() -> {
                    if (factory == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(129);
                    }
                    return factory.createUsageInfo(psiFile, startOffset, endOffset);
                });
                return usageInfo == null || processor.process(usageInfo);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
                return true;
            }
        }, searchScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 54: 
            case 77: 
            case 86: 
            case 89: 
            case 96: 
            case 98: 
            case 112: 
            case 113: 
            case 114: 
            case 120: 
            case 121: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 54: 
            case 77: 
            case 86: 
            case 89: 
            case 96: 
            case 98: 
            case 112: 
            case 113: 
            case 114: 
            case 120: 
            case 121: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 54: 
            case 77: 
            case 86: 
            case 89: 
            case 96: 
            case 98: 
            case 112: 
            case 113: 
            case 114: 
            case 120: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: 
            case 57: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 26: 
            case 29: 
            case 33: 
            case 52: 
            case 56: 
            case 59: 
            case 63: 
            case 66: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 107: 
            case 118: 
            case 125: 
            case 128: 
            case 133: 
            case 135: 
            case 144: 
            case 154: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 24: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 22: 
            case 25: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 28: 
            case 34: 
            case 47: 
            case 50: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 111: 
            case 116: 
            case 132: 
            case 134: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 30: 
            case 36: 
            case 38: 
            case 42: 
            case 80: 
            case 84: 
            case 104: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 39: 
            case 43: 
            case 45: 
            case 147: 
            case 150: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 40: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 44: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 46: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canceled";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 53: 
            case 61: 
            case 64: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 60: 
            case 143: 
            case 145: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialScope";
                break;
            }
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 78: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectors";
                break;
            }
            case 79: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singles";
                break;
            }
            case 81: 
            case 82: 
            case 103: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessors";
                break;
            }
            case 83: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFiles";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allWords";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleRequest";
                break;
            }
            case 88: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 91: 
            case 138: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intersectionResult";
                break;
            }
            case 92: 
            case 137: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restResult";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonScope";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 95: 
            case 117: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locals";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globals";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customs";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitive";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "single";
                break;
            }
            case 110: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToSearch";
                break;
            }
            case 126: 
            case 127: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommentsContainingIdentifier";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "processElementsWithWordAsync";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIndicator";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "localProcessor";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithPlainTextWords";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "processRequestsAsync";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableWordsDescription";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptProcessor";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "createMultiMap";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteScopes";
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "isCheapEnoughToSearch";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 54: 
            case 77: 
            case 86: 
            case 89: 
            case 96: 
            case 98: 
            case 112: 
            case 113: 
            case 114: 
            case 120: 
            case 121: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findCommentsContainingIdentifier";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processCommentsContainingIdentifier";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWord";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWordAsync";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "bulkProcessElementsWithWord";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessInjectedPsi";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "localProcessor";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithTextInGlobalScope";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processPsiFileRoots";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processFilesConcurrentlyDespiteWriteActions";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFile";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithText";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithText";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithPlainTextWords";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInNonJavaFiles";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWord";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInText";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInComments";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInLiterals";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "processRequests";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "processRequestsAsync";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequestsOptimized";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableWordsDescription";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "adaptProcessor";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "intersectionWithContainerNameFiles";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "uniteScopes";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "distributePrimitives";
                break;
            }
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "registerRequest";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "processSingleRequest";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isCheapEnoughToSearch";
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getWordEntries";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "processTextOccurrences";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processTextOccurrences$25";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$24";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processTextOccurrences$23";
                break;
            }
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFilesContainingAllKeys$21";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$20";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isCheapEnoughToSearch$19";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectFiles$15";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$14";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCandidates$13";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUsagesInNonJavaFiles$12";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$11";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUsagesInNonJavaFiles$7";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processVirtualFile$5";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processVirtualFile$4";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFilesConcurrentlyDespiteWriteActions$3";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processPsiFileRoots$2";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementsWithWord$1";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCommentsContainingIdentifier$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 18: 
            case 27: 
            case 32: 
            case 54: 
            case 77: 
            case 86: 
            case 89: 
            case 96: 
            case 98: 
            case 112: 
            case 113: 
            case 114: 
            case 120: 
            case 121: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RequestWithProcessor {
        @NotNull
        private final PsiSearchRequest request;
        @NotNull
        private Processor<PsiReference> refProcessor;

        private RequestWithProcessor(@NotNull PsiSearchRequest request, @NotNull Processor<PsiReference> processor) {
            if (request == null) {
                RequestWithProcessor.$$$reportNull$$$0(0);
            }
            if (processor == null) {
                RequestWithProcessor.$$$reportNull$$$0(1);
            }
            this.request = request;
            this.refProcessor = processor;
        }

        private boolean uniteWith(@NotNull RequestWithProcessor another) {
            if (another == null) {
                RequestWithProcessor.$$$reportNull$$$0(2);
            }
            if (this.request.equals(another.request)) {
                Processor<PsiReference> myProcessor = this.refProcessor;
                if (myProcessor != another.refProcessor) {
                    this.refProcessor = psiReference -> {
                        if (another == null) {
                            RequestWithProcessor.$$$reportNull$$$0(3);
                        }
                        return myProcessor.process((PsiReference)psiReference) && another.refProcessor.process((PsiReference)psiReference);
                    };
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this.request.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "another";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uniteWith";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$uniteWith$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Options {
        PROCESS_INJECTED_PSI,
        CASE_SENSITIVE_SEARCH,
        PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE;

    }
}

