/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassReferencesSubclassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.references.subclass.display.name", new Object[0]);
        if (string == null) {
            ClassReferencesSubclassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiNamedElement element = (PsiNamedElement)infos[0];
        String containingClassName = element.getName();
        Boolean isAnonymous = (Boolean)infos[1];
        if (isAnonymous.booleanValue()) {
            String string = InspectionGadgetsBundle.message("class.references.subclass.problem.descriptor.anonymous", containingClassName);
            if (string == null) {
                ClassReferencesSubclassInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("class.references.subclass.problem.descriptor", containingClassName);
        if (string == null) {
            ClassReferencesSubclassInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassReferencesSubclassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/ClassReferencesSubclassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ClassReferencesSubclassVisitor
    extends BaseInspectionVisitor {
        private ClassReferencesSubclassVisitor() {
        }

        @Override
        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                ClassReferencesSubclassVisitor.$$$reportNull$$$0(0);
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            this.checkTypeElement(typeElement);
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                ClassReferencesSubclassVisitor.$$$reportNull$$$0(1);
            }
            PsiTypeElement typeElement = method.getReturnTypeElement();
            this.checkTypeElement(typeElement);
        }

        @Override
        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            if (expression == null) {
                ClassReferencesSubclassVisitor.$$$reportNull$$$0(2);
            }
            PsiTypeElement typeElement = expression.getCheckType();
            this.checkTypeElement(typeElement);
        }

        @Override
        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                ClassReferencesSubclassVisitor.$$$reportNull$$$0(3);
            }
            PsiTypeElement typeElement = expression.getCastType();
            this.checkTypeElement(typeElement);
        }

        @Override
        public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression) {
            if (expression == null) {
                ClassReferencesSubclassVisitor.$$$reportNull$$$0(4);
            }
            PsiTypeElement typeElement = expression.getOperand();
            this.checkTypeElement(typeElement);
        }

        private void checkTypeElement(PsiTypeElement typeElement) {
            if (typeElement == null) {
                return;
            }
            PsiType type = typeElement.getType();
            PsiType componentType = type.getDeepComponentType();
            if (!(componentType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)componentType;
            PsiClass aClass = classType.resolve();
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiClass parentClass = ClassUtils.getContainingClass(typeElement);
            if (!ClassReferencesSubclassVisitor.isSubclass(aClass, parentClass)) {
                return;
            }
            this.registerError((PsiElement)typeElement, parentClass, Boolean.FALSE);
        }

        private static boolean isSubclass(@Nullable PsiClass childClass, @Nullable PsiClass parent) {
            if (childClass == null) {
                return false;
            }
            if (parent == null) {
                return false;
            }
            return childClass.isInheritor(parent, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/abstraction/ClassReferencesSubclassInspection$ClassReferencesSubclassVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInstanceOfExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeCastExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassObjectAccessExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

