/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExceptionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowCaughtLocallyInspection
extends BaseInspection {
    public boolean ignoreRethrownExceptions = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("throw.caught.locally.display.name", new Object[0]);
        if (string == null) {
            ThrowCaughtLocallyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("throw.caught.locally.problem.descriptor", new Object[0]);
        if (string == null) {
            ThrowCaughtLocallyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("throw.caught.locally.ignore.option", new Object[0]), this, "ignoreRethrownExceptions");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowCaughtLocallyVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/ThrowCaughtLocallyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ThrowCaughtLocallyVisitor
    extends BaseInspectionVisitor {
        private ThrowCaughtLocallyVisitor() {
        }

        @Override
        public void visitThrowStatement(PsiThrowStatement statement) {
            super.visitThrowStatement(statement);
            PsiExpression exception = statement.getException();
            if (exception == null) {
                return;
            }
            PsiType exceptionType = exception.getType();
            if (exceptionType == null) {
                return;
            }
            PsiTryStatement containingTryStatement = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiTryStatement.class, true, PsiLambdaExpression.class, PsiClass.class);
            while (containingTryStatement != null) {
                PsiCodeBlock tryBlock = containingTryStatement.getTryBlock();
                if (tryBlock == null) {
                    return;
                }
                if (PsiTreeUtil.isAncestor(tryBlock, statement, true)) {
                    PsiParameter[] catchBlockParameters;
                    for (PsiParameter parameter : catchBlockParameters = containingTryStatement.getCatchBlockParameters()) {
                        PsiCatchSection section;
                        PsiCodeBlock catchBlock;
                        PsiType parameterType = parameter.getType();
                        if (!parameterType.isAssignableFrom(exceptionType)) continue;
                        if (ThrowCaughtLocallyInspection.this.ignoreRethrownExceptions && ExceptionUtils.isThrowableRethrown(parameter, catchBlock = (section = (PsiCatchSection)parameter.getParent()).getCatchBlock())) {
                            return;
                        }
                        this.registerStatementError(statement, new Object[0]);
                    }
                }
                containingTryStatement = PsiTreeUtil.getParentOfType((PsiElement)containingTryStatement, PsiTryStatement.class, true, PsiLambdaExpression.class, PsiClass.class);
            }
        }
    }
}

