/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.TestUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class TestMethodWithoutAssertionInspectionBase
extends BaseInspection {
    protected final MethodMatcher methodMatcher = new MethodMatcher(true, "assertionMethods").add("org.junit.Assert", "assert.*|fail.*").add("junit.framework.Assert", "assert.*|fail.*").add("org.junit.jupiter.api.Assertions", "assert.*|fail.*").add("org.assertj.core.api.Assertions", "assertThat").add("com.google.common.truth.Truth", "assert.*").add("com.google.common.truth.Truth8", "assert.*").add("org.mockito.Mockito", "verify.*").add("org.mockito.InOrder", "verify").add("org.junit.rules.ExpectedException", "expect.*").add("org.hamcrest.MatcherAssert", "assertThat").finishDefault();
    public boolean assertKeywordIsAssertion;

    @Override
    @NotNull
    public String getID() {
        if ("JUnitTestMethodWithNoAssertions" == null) {
            TestMethodWithoutAssertionInspectionBase.$$$reportNull$$$0(0);
        }
        return "JUnitTestMethodWithNoAssertions";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.method.without.assertion.display.name", new Object[0]);
        if (string == null) {
            TestMethodWithoutAssertionInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("test.method.without.assertion.problem.descriptor", new Object[0]);
        if (string == null) {
            TestMethodWithoutAssertionInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            TestMethodWithoutAssertionInspectionBase.$$$reportNull$$$0(3);
        }
        super.readSettings(element);
        this.methodMatcher.readSettings(element);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            TestMethodWithoutAssertionInspectionBase.$$$reportNull$$$0(4);
        }
        this.methodMatcher.writeSettings(element);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestMethodWithoutAssertionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ContainsAssertionVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsAssertion;

        private ContainsAssertionVisitor() {
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ContainsAssertionVisitor.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiCompiledElement) {
                return;
            }
            if (!this.containsAssertion) {
                super.visitElement(element);
            }
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                ContainsAssertionVisitor.$$$reportNull$$$0(1);
            }
            if (this.containsAssertion) {
                return;
            }
            super.visitMethodCallExpression(call);
            if (TestMethodWithoutAssertionInspectionBase.this.methodMatcher.matches(call)) {
                this.containsAssertion = true;
            }
        }

        @Override
        public void visitAssertStatement(PsiAssertStatement statement) {
            if (this.containsAssertion) {
                return;
            }
            super.visitAssertStatement(statement);
            if (!TestMethodWithoutAssertionInspectionBase.this.assertKeywordIsAssertion) {
                return;
            }
            this.containsAssertion = true;
        }

        boolean containsAssertion() {
            return this.containsAssertion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase$ContainsAssertionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class TestMethodWithoutAssertionVisitor
    extends BaseInspectionVisitor {
        private TestMethodWithoutAssertionVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                TestMethodWithoutAssertionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            if (this.hasExpectedExceptionAnnotation(method)) {
                return;
            }
            if (this.containsAssertion(method)) {
                return;
            }
            if (this.lastStatementIsCallToMethodWithAssertion(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean lastStatementIsCallToMethodWithAssertion(PsiMethod method) {
            PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(method.getBody());
            if (!(lastStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)lastStatement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null && !(qualifierExpression instanceof PsiThisExpression)) {
                return false;
            }
            PsiMethod targetMethod = methodCallExpression.resolveMethod();
            return this.containsAssertion(targetMethod);
        }

        private boolean containsAssertion(PsiElement element) {
            if (element == null) {
                return false;
            }
            ContainsAssertionVisitor visitor = new ContainsAssertionVisitor();
            element.accept(visitor);
            return visitor.containsAssertion();
        }

        private boolean hasExpectedExceptionAnnotation(PsiMethod method) {
            PsiNameValuePair[] nameValuePairs;
            PsiModifierList modifierList = method.getModifierList();
            PsiAnnotation testAnnotation = modifierList.findAnnotation("org.junit.Test");
            if (testAnnotation == null) {
                return false;
            }
            PsiAnnotationParameterList parameterList = testAnnotation.getParameterList();
            for (PsiNameValuePair nameValuePair : nameValuePairs = parameterList.getAttributes()) {
                String parameterName = nameValuePair.getName();
                if (!"expected".equals(parameterName)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/TestMethodWithoutAssertionInspectionBase$TestMethodWithoutAssertionVisitor", "visitMethod"));
        }
    }
}

