/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParenthesesUtils {
    public static final int PARENTHESIZED_PRECEDENCE = 0;
    public static final int LITERAL_PRECEDENCE = 0;
    public static final int METHOD_CALL_PRECEDENCE = 1;
    public static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int MULTIPLICATIVE_PRECEDENCE = 5;
    public static final int ADDITIVE_PRECEDENCE = 6;
    public static final int SHIFT_PRECEDENCE = 7;
    public static final int RELATIONAL_PRECEDENCE = 8;
    public static final int EQUALITY_PRECEDENCE = 9;
    public static final int BINARY_AND_PRECEDENCE = 10;
    public static final int BINARY_XOR_PRECEDENCE = 11;
    public static final int BINARY_OR_PRECEDENCE = 12;
    public static final int AND_PRECEDENCE = 13;
    public static final int OR_PRECEDENCE = 14;
    public static final int CONDITIONAL_PRECEDENCE = 15;
    public static final int ASSIGNMENT_PRECEDENCE = 16;
    public static final int NUM_PRECEDENCES = 17;
    private static final Map<IElementType, Integer> s_binaryOperatorPrecedence = new HashMap<IElementType, Integer>(17);

    private ParenthesesUtils() {
    }

    public static String getText(@NotNull PsiExpression expression, int precedence) {
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(0);
        }
        if (ParenthesesUtils.getPrecedence(expression) >= precedence) {
            return '(' + expression.getText() + ')';
        }
        return expression.getText();
    }

    @Nullable
    public static PsiElement getParentSkipParentheses(PsiElement element) {
        PsiElement parent = element.getParent();
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression) {
            parent = parent.getParent();
        }
        return parent;
    }

    @Contract(value="null -> null")
    public static PsiExpression stripParentheses(@Nullable PsiExpression expression) {
        while (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            expression = parenthesizedExpression.getExpression();
        }
        return expression;
    }

    public static boolean isCommutativeOperator(@NotNull IElementType token) {
        if (token == null) {
            ParenthesesUtils.$$$reportNull$$$0(1);
        }
        return !token.equals(JavaTokenType.MINUS) && !token.equals(JavaTokenType.DIV) && !token.equals(JavaTokenType.PERC) && !token.equals(JavaTokenType.LTLT) && !token.equals(JavaTokenType.GTGT) && !token.equals(JavaTokenType.GTGTGT);
    }

    public static boolean isAssociativeOperation(PsiPolyadicExpression expression) {
        PsiPrimitiveType primitiveType;
        IElementType tokenType = expression.getOperationTokenType();
        PsiType type = expression.getType();
        if (type instanceof PsiClassType) {
            primitiveType = PsiPrimitiveType.getUnboxedType(type);
            if (primitiveType == null) {
                return false;
            }
        } else if (type instanceof PsiPrimitiveType) {
            primitiveType = (PsiPrimitiveType)type;
        } else {
            return false;
        }
        if (JavaTokenType.PLUS == tokenType || JavaTokenType.ASTERISK == tokenType) {
            return !PsiType.FLOAT.equals(primitiveType) && !PsiType.DOUBLE.equals(primitiveType);
        }
        if (JavaTokenType.EQEQ == tokenType || JavaTokenType.NE == tokenType) {
            return PsiType.BOOLEAN.equals(primitiveType);
        }
        if (JavaTokenType.AND == tokenType || JavaTokenType.OR == tokenType || JavaTokenType.XOR == tokenType) {
            return true;
        }
        return JavaTokenType.OROR == tokenType || JavaTokenType.ANDAND == tokenType;
    }

    public static int getPrecedence(PsiExpression expression) {
        if (expression instanceof PsiThisExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiSuperExpression || expression instanceof PsiClassObjectAccessExpression || expression instanceof PsiArrayAccessExpression || expression instanceof PsiArrayInitializerExpression) {
            return 0;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            if (referenceExpression.getQualifier() != null) {
                return 1;
            }
            return 0;
        }
        if (expression instanceof PsiMethodCallExpression || expression instanceof PsiNewExpression) {
            return 1;
        }
        if (expression instanceof PsiTypeCastExpression) {
            return 4;
        }
        if (expression instanceof PsiPrefixExpression) {
            return 3;
        }
        if (expression instanceof PsiPostfixExpression) {
            return 2;
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            return ParenthesesUtils.getPrecedenceForOperator(polyadicExpression.getOperationTokenType());
        }
        if (expression instanceof PsiInstanceOfExpression) {
            return 8;
        }
        if (expression instanceof PsiConditionalExpression) {
            return 15;
        }
        if (expression instanceof PsiAssignmentExpression) {
            return 16;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return 0;
        }
        return -1;
    }

    public static int getPrecedenceForOperator(@NotNull IElementType operator) {
        Integer precedence;
        if (operator == null) {
            ParenthesesUtils.$$$reportNull$$$0(2);
        }
        if ((precedence = s_binaryOperatorPrecedence.get(operator)) == null) {
            throw new IllegalArgumentException("unknown operator: " + operator);
        }
        return precedence;
    }

    public static void removeParentheses(@NotNull PsiExpression expression, boolean ignoreClarifyingParentheses) {
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(3);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
            ParenthesesUtils.removeParensFromMethodCallExpression(methodCall, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            ParenthesesUtils.removeParensFromReferenceExpression(referenceExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            ParenthesesUtils.removeParensFromNewExpression(newExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            ParenthesesUtils.removeParensFromAssignmentExpression(assignmentExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression;
            ParenthesesUtils.removeParensFromArrayInitializerExpression(arrayInitializerExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            ParenthesesUtils.removeParensFromTypeCastExpression(typeCastExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression;
            ParenthesesUtils.removeParensFromArrayAccessExpression(arrayAccessExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            ParenthesesUtils.removeParensFromPrefixExpression(prefixExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression;
            ParenthesesUtils.removeParensFromPostfixExpression(postfixExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            ParenthesesUtils.removeParensFromPolyadicExpression(polyadicExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceofExpression = (PsiInstanceOfExpression)expression;
            ParenthesesUtils.removeParensFromInstanceOfExpression(instanceofExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            ParenthesesUtils.removeParensFromConditionalExpression(conditionalExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            ParenthesesUtils.removeParensFromParenthesizedExpression(parenthesizedExpression, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromReferenceExpression(@NotNull PsiReferenceExpression referenceExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression qualifier;
        if (referenceExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(4);
        }
        if ((qualifier = referenceExpression.getQualifierExpression()) != null) {
            ParenthesesUtils.removeParentheses(qualifier, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromParenthesizedExpression(@NotNull PsiParenthesizedExpression parenthesizedExpression, boolean ignoreClarifyingParentheses) {
        int childPrecedence;
        PsiArrayAccessExpression arrayAccessExpression;
        PsiExpression body;
        if (parenthesizedExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(5);
        }
        if ((body = parenthesizedExpression.getExpression()) == null) {
            parenthesizedExpression.delete();
            return;
        }
        PsiElement parent = parenthesizedExpression.getParent();
        if (!(parent instanceof PsiExpression) || parent instanceof PsiParenthesizedExpression || parent instanceof PsiArrayInitializerExpression || parent instanceof PsiLambdaExpression) {
            PsiExpression newExpression = (PsiExpression)parenthesizedExpression.replace(body);
            ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
            return;
        }
        if (parent instanceof PsiArrayAccessExpression && parenthesizedExpression == (arrayAccessExpression = (PsiArrayAccessExpression)parent).getIndexExpression()) {
            PsiExpression newExpression = (PsiExpression)parent.addAfter(body, parenthesizedExpression);
            parenthesizedExpression.delete();
            ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
            return;
        }
        PsiExpression parentExpression = (PsiExpression)parent;
        int parentPrecedence = ParenthesesUtils.getPrecedence(parentExpression);
        if (parentPrecedence < (childPrecedence = ParenthesesUtils.getPrecedence(body))) {
            PsiElement bodyParent = body.getParent();
            PsiParenthesizedExpression newParenthesizedExpression = (PsiParenthesizedExpression)parenthesizedExpression.replace(bodyParent);
            PsiExpression expression = newParenthesizedExpression.getExpression();
            if (expression != null) {
                ParenthesesUtils.removeParentheses(expression, ignoreClarifyingParentheses);
            }
        } else if (parentPrecedence == childPrecedence) {
            if (parentExpression instanceof PsiPolyadicExpression && body instanceof PsiPolyadicExpression) {
                PsiExpression[] parentOperands;
                PsiPolyadicExpression parentPolyadicExpression = (PsiPolyadicExpression)parentExpression;
                IElementType parentOperator = parentPolyadicExpression.getOperationTokenType();
                PsiPolyadicExpression bodyPolyadicExpression = (PsiPolyadicExpression)body;
                IElementType bodyOperator = bodyPolyadicExpression.getOperationTokenType();
                PsiType parentType = parentPolyadicExpression.getType();
                PsiType bodyType = body.getType();
                if (parentType != null && parentType.equals(bodyType) && parentOperator.equals(bodyOperator) && (PsiTreeUtil.isAncestor((parentOperands = parentPolyadicExpression.getOperands())[0], body, true) || ParenthesesUtils.isCommutativeOperator(bodyOperator))) {
                    PsiExpression newExpression = (PsiExpression)parent.addAfter(body, parenthesizedExpression);
                    parenthesizedExpression.delete();
                    ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
                    return;
                }
                if (ignoreClarifyingParentheses) {
                    if (parentOperator.equals(bodyOperator)) {
                        ParenthesesUtils.removeParentheses(body, ignoreClarifyingParentheses);
                    }
                } else {
                    PsiExpression newExpression = (PsiExpression)parenthesizedExpression.replace(body);
                    ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
                }
            } else {
                PsiExpression newExpression = (PsiExpression)parenthesizedExpression.replace(body);
                ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
            }
        } else if (ignoreClarifyingParentheses && parent instanceof PsiPolyadicExpression && (body instanceof PsiPolyadicExpression || body instanceof PsiInstanceOfExpression)) {
            ParenthesesUtils.removeParentheses(body, ignoreClarifyingParentheses);
        } else {
            PsiExpression newExpression = (PsiExpression)parenthesizedExpression.replace(body);
            ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromConditionalExpression(@NotNull PsiConditionalExpression conditionalExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression elseBranch;
        if (conditionalExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(6);
        }
        PsiExpression condition = conditionalExpression.getCondition();
        ParenthesesUtils.removeParentheses(condition, ignoreClarifyingParentheses);
        PsiExpression thenBranch = conditionalExpression.getThenExpression();
        if (thenBranch != null) {
            ParenthesesUtils.removeParentheses(thenBranch, ignoreClarifyingParentheses);
        }
        if ((elseBranch = conditionalExpression.getElseExpression()) != null) {
            ParenthesesUtils.removeParentheses(elseBranch, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromInstanceOfExpression(@NotNull PsiInstanceOfExpression instanceofExpression, boolean ignoreClarifyingParentheses) {
        if (instanceofExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(7);
        }
        PsiExpression operand = instanceofExpression.getOperand();
        ParenthesesUtils.removeParentheses(operand, ignoreClarifyingParentheses);
    }

    private static void removeParensFromPolyadicExpression(@NotNull PsiPolyadicExpression polyadicExpression, boolean ignoreClarifyingParentheses) {
        if (polyadicExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(8);
        }
        for (PsiExpression operand : polyadicExpression.getOperands()) {
            ParenthesesUtils.removeParentheses(operand, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromPostfixExpression(@NotNull PsiPostfixExpression postfixExpression, boolean ignoreClarifyingParentheses) {
        if (postfixExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(9);
        }
        PsiExpression operand = postfixExpression.getOperand();
        ParenthesesUtils.removeParentheses(operand, ignoreClarifyingParentheses);
    }

    private static void removeParensFromPrefixExpression(@NotNull PsiPrefixExpression prefixExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression operand;
        if (prefixExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(10);
        }
        if ((operand = prefixExpression.getOperand()) != null) {
            ParenthesesUtils.removeParentheses(operand, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromArrayAccessExpression(@NotNull PsiArrayAccessExpression arrayAccessExpression, boolean ignoreClarifyingParentheses) {
        if (arrayAccessExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(11);
        }
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        ParenthesesUtils.removeParentheses(arrayExpression, ignoreClarifyingParentheses);
        PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
        if (indexExpression != null) {
            ParenthesesUtils.removeParentheses(indexExpression, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromTypeCastExpression(@NotNull PsiTypeCastExpression typeCastExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression operand;
        if (typeCastExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(12);
        }
        if ((operand = typeCastExpression.getOperand()) != null) {
            ParenthesesUtils.removeParentheses(operand, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromArrayInitializerExpression(@NotNull PsiArrayInitializerExpression arrayInitializerExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression[] initializers;
        if (arrayInitializerExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(13);
        }
        for (PsiExpression initializer : initializers = arrayInitializerExpression.getInitializers()) {
            ParenthesesUtils.removeParentheses(initializer, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromAssignmentExpression(@NotNull PsiAssignmentExpression assignment, boolean ignoreClarifyingParentheses) {
        if (assignment == null) {
            ParenthesesUtils.$$$reportNull$$$0(14);
        }
        PsiExpression lhs = assignment.getLExpression();
        PsiExpression rhs = assignment.getRExpression();
        ParenthesesUtils.removeParentheses(lhs, ignoreClarifyingParentheses);
        if (rhs != null) {
            ParenthesesUtils.removeParentheses(rhs, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromNewExpression(@NotNull PsiNewExpression newExpression, boolean ignoreClarifyingParentheses) {
        PsiExpressionList argumentList;
        PsiArrayInitializerExpression arrayInitializer;
        PsiExpression[] dimensions;
        if (newExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(15);
        }
        for (PsiExpression dimension : dimensions = newExpression.getArrayDimensions()) {
            ParenthesesUtils.removeParentheses(dimension, ignoreClarifyingParentheses);
        }
        PsiExpression qualifier = newExpression.getQualifier();
        if (qualifier != null) {
            ParenthesesUtils.removeParentheses(qualifier, ignoreClarifyingParentheses);
        }
        if ((arrayInitializer = newExpression.getArrayInitializer()) != null) {
            ParenthesesUtils.removeParentheses(arrayInitializer, ignoreClarifyingParentheses);
        }
        if ((argumentList = newExpression.getArgumentList()) != null) {
            PsiExpression[] arguments;
            for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                ParenthesesUtils.removeParentheses(argument, ignoreClarifyingParentheses);
            }
        }
    }

    private static void removeParensFromMethodCallExpression(@NotNull PsiMethodCallExpression methodCallExpression, boolean ignoreClarifyingParentheses) {
        if (methodCallExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(16);
        }
        PsiReferenceExpression target = methodCallExpression.getMethodExpression();
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        ParenthesesUtils.removeParentheses(target, ignoreClarifyingParentheses);
        for (PsiExpression argument : arguments) {
            ParenthesesUtils.removeParentheses(argument, ignoreClarifyingParentheses);
        }
    }

    public static boolean areParenthesesNeeded(PsiParenthesizedExpression expression, boolean ignoreClarifyingParentheses) {
        PsiArrayAccessExpression arrayAccessExpression;
        PsiExpression indexExpression;
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiLambdaExpression) {
            return false;
        }
        if (!(parent instanceof PsiExpression)) {
            return false;
        }
        PsiExpression child = expression.getExpression();
        if (child == null) {
            return true;
        }
        if (parent instanceof PsiArrayAccessExpression && expression == (indexExpression = (arrayAccessExpression = (PsiArrayAccessExpression)parent).getIndexExpression())) {
            return false;
        }
        return ParenthesesUtils.areParenthesesNeeded(child, (PsiExpression)parent, ignoreClarifyingParentheses);
    }

    public static boolean areParenthesesNeeded(PsiExpression expression, PsiExpression parentExpression, boolean ignoreClarifyingParentheses) {
        int childPrecedence;
        if (parentExpression instanceof PsiParenthesizedExpression || parentExpression instanceof PsiArrayInitializerExpression) {
            return false;
        }
        int parentPrecedence = ParenthesesUtils.getPrecedence(parentExpression);
        if (parentPrecedence > (childPrecedence = ParenthesesUtils.getPrecedence(expression))) {
            return ignoreClarifyingParentheses && (expression instanceof PsiPolyadicExpression ? parentExpression instanceof PsiPolyadicExpression || parentExpression instanceof PsiConditionalExpression || parentExpression instanceof PsiInstanceOfExpression : expression instanceof PsiInstanceOfExpression);
        }
        if (parentExpression instanceof PsiPolyadicExpression && expression instanceof PsiPolyadicExpression) {
            PsiExpression[] operands;
            PsiPolyadicExpression parentPolyadicExpression = (PsiPolyadicExpression)parentExpression;
            PsiType parentType = parentPolyadicExpression.getType();
            if (parentType == null) {
                return true;
            }
            PsiPolyadicExpression childPolyadicExpression = (PsiPolyadicExpression)expression;
            PsiType childType = childPolyadicExpression.getType();
            if (!parentType.equals(childType)) {
                return true;
            }
            if (childType.equalsToText("java.lang.String") && !PsiTreeUtil.isAncestor(parentPolyadicExpression.getOperands()[0], childPolyadicExpression, true)) {
                for (PsiExpression operand : operands = childPolyadicExpression.getOperands()) {
                    if (childType.equals(operand.getType())) continue;
                    return true;
                }
            } else if (childType.equals(PsiType.BOOLEAN)) {
                for (PsiExpression operand : operands = childPolyadicExpression.getOperands()) {
                    if (PsiType.BOOLEAN.equals(operand.getType())) continue;
                    return true;
                }
            }
            IElementType parentOperator = parentPolyadicExpression.getOperationTokenType();
            IElementType childOperator = childPolyadicExpression.getOperationTokenType();
            if (ignoreClarifyingParentheses && !childOperator.equals(parentOperator)) {
                return true;
            }
            PsiExpression[] parentOperands = parentPolyadicExpression.getOperands();
            if (!(PsiTreeUtil.isAncestor(parentOperands[0], expression, false) || ParenthesesUtils.isAssociativeOperation(parentPolyadicExpression) && JavaTokenType.DIV != childOperator && JavaTokenType.PERC != childOperator)) {
                return true;
            }
        } else if (parentExpression instanceof PsiConditionalExpression && expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parentExpression;
            PsiExpression condition = conditionalExpression.getCondition();
            return PsiTreeUtil.isAncestor(condition, expression, true);
        }
        return parentPrecedence < childPrecedence;
    }

    public static boolean areParenthesesNeeded(PsiJavaToken compoundAssignmentToken, PsiExpression rhs) {
        if (rhs instanceof PsiPolyadicExpression) {
            IElementType signTokenType;
            IElementType newOperatorToken;
            int precedence2;
            PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)rhs;
            int precedence1 = ParenthesesUtils.getPrecedenceForOperator(binaryExpression.getOperationTokenType());
            return precedence1 >= (precedence2 = ParenthesesUtils.getPrecedenceForOperator(newOperatorToken = TypeConversionUtil.convertEQtoOperation(signTokenType = compoundAssignmentToken.getTokenType()))) || !ParenthesesUtils.isCommutativeOperator(newOperatorToken);
        }
        return rhs instanceof PsiConditionalExpression;
    }

    static {
        s_binaryOperatorPrecedence.put(JavaTokenType.PLUS, 6);
        s_binaryOperatorPrecedence.put(JavaTokenType.MINUS, 6);
        s_binaryOperatorPrecedence.put(JavaTokenType.ASTERISK, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.DIV, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.PERC, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.ANDAND, 13);
        s_binaryOperatorPrecedence.put(JavaTokenType.OROR, 14);
        s_binaryOperatorPrecedence.put(JavaTokenType.AND, 10);
        s_binaryOperatorPrecedence.put(JavaTokenType.OR, 12);
        s_binaryOperatorPrecedence.put(JavaTokenType.XOR, 11);
        s_binaryOperatorPrecedence.put(JavaTokenType.LTLT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GTGT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GTGTGT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GT, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.GE, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.LT, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.LE, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.EQEQ, 9);
        s_binaryOperatorPrecedence.put(JavaTokenType.NE, 9);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesizedExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceofExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "polyadicExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCastExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayInitializerExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/ParenthesesUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCommutativeOperator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrecedenceForOperator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParentheses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromReferenceExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromParenthesizedExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromConditionalExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromInstanceOfExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPolyadicExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPostfixExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPrefixExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromArrayAccessExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromTypeCastExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromArrayInitializerExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromAssignmentExpression";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromNewExpression";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromMethodCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

