/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryToStringCallInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.tostring.call.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryToStringCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String text2 = (String)infos[0];
        String string = InspectionGadgetsBundle.message("unnecessary.tostring.call.problem.descriptor", text2);
        if (string == null) {
            UnnecessaryToStringCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String text2 = (String)infos[0];
        return new UnnecessaryToStringCallFix(text2);
    }

    @NonNls
    static String calculateReplacementText(PsiExpression expression) {
        if (expression == null) {
            return "this";
        }
        return expression.getText();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryToStringCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryToStringCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryToStringCallVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryToStringCallVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"toString".equals(referenceName)) {
                return;
            }
            PsiElement referenceNameElement = methodExpression.getReferenceNameElement();
            if (referenceNameElement == null) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (qualifier.getType() instanceof PsiArrayType) {
                return;
            }
            if (qualifier instanceof PsiSuperExpression) {
                return;
            }
            boolean throwable = TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.Throwable");
            if (ExpressionUtils.isConversionToStringNecessary(expression, throwable)) {
                return;
            }
            this.registerError(referenceNameElement, ProblemHighlightType.LIKE_UNUSED_SYMBOL, UnnecessaryToStringCallInspection.calculateReplacementText(qualifier));
        }
    }

    private static class UnnecessaryToStringCallFix
    extends InspectionGadgetsFix {
        private final String replacementText;

        private UnnecessaryToStringCallFix(String replacementText) {
            this.replacementText = replacementText;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.call.to.string.valueof.quickfix", this.replacementText);
            if (string == null) {
                UnnecessaryToStringCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                UnnecessaryToStringCallFix.$$$reportNull$$$0(1);
            }
            return "Simplify";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)descriptor.getPsiElement().getParent().getParent();
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                PsiReplacementUtil.replaceExpression(methodCallExpression, "this");
            } else {
                methodCallExpression.replace(qualifier);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/UnnecessaryToStringCallInspection$UnnecessaryToStringCallFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

