/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.ValuableDataFlowRunner;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaUtil {
    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    public static Collection<PsiExpression> getCachedVariableValues(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        Collection<FList<PsiExpression>> concatenations;
        if (variable == null || context == null) {
            return Collections.emptyList();
        }
        PsiElement codeBlock = DfaPsiUtil.getEnclosingCodeBlock(variable, context);
        if (codeBlock == null) {
            return Collections.emptyList();
        }
        Map<PsiElement, ValuableInstructionVisitor.PlaceResult> value = DfaUtil.getCachedPlaceResults(codeBlock);
        if (value == null) {
            return null;
        }
        ValuableInstructionVisitor.PlaceResult placeResult = value.get(context);
        Collection<FList<PsiExpression>> collection = concatenations = placeResult == null ? null : placeResult.myValues.get(variable);
        if (concatenations != null) {
            return ContainerUtil.map(concatenations, DfaUtil::concatenateExpressions);
        }
        return Collections.emptyList();
    }

    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    private static Map<PsiElement, ValuableInstructionVisitor.PlaceResult> getCachedPlaceResults(@NotNull PsiElement codeBlock) {
        if (codeBlock == null) {
            DfaUtil.$$$reportNull$$$0(0);
        }
        return (Map)CachedValuesManager.getCachedValue(codeBlock, () -> {
            ValuableInstructionVisitor visitor;
            RunnerResult runnerResult;
            if (codeBlock == null) {
                DfaUtil.$$$reportNull$$$0(25);
            }
            return CachedValueProvider.Result.create((runnerResult = new ValuableDataFlowRunner().analyzeMethod(codeBlock, visitor = new ValuableInstructionVisitor())) == RunnerResult.OK ? visitor.myResults : null, codeBlock);
        });
    }

    @NotNull
    public static Nullness checkNullness(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        Nullness nullness = DfaUtil.checkNullness(variable, context, null);
        if (nullness == null) {
            DfaUtil.$$$reportNull$$$0(1);
        }
        return nullness;
    }

    @NotNull
    public static Nullness checkNullness(@Nullable PsiVariable variable, @Nullable PsiElement context, @Nullable PsiElement outerBlock) {
        ValuableInstructionVisitor.PlaceResult placeResult;
        if (variable == null || context == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                DfaUtil.$$$reportNull$$$0(2);
            }
            return nullness;
        }
        PsiElement codeBlock = outerBlock == null ? DfaPsiUtil.getEnclosingCodeBlock(variable, context) : outerBlock;
        Map<PsiElement, ValuableInstructionVisitor.PlaceResult> results = codeBlock == null ? null : DfaUtil.getCachedPlaceResults(codeBlock);
        ValuableInstructionVisitor.PlaceResult placeResult2 = placeResult = results == null ? null : results.get(context);
        if (placeResult == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                DfaUtil.$$$reportNull$$$0(3);
            }
            return nullness;
        }
        if (placeResult.myNulls.contains(variable) && !placeResult.myNotNulls.contains(variable)) {
            Nullness nullness = Nullness.NULLABLE;
            if (nullness == null) {
                DfaUtil.$$$reportNull$$$0(4);
            }
            return nullness;
        }
        if (placeResult.myNotNulls.contains(variable) && !placeResult.myNulls.contains(variable)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                DfaUtil.$$$reportNull$$$0(5);
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            DfaUtil.$$$reportNull$$$0(6);
        }
        return nullness;
    }

    @NotNull
    public static Collection<PsiExpression> getPossibleInitializationElements(@NotNull PsiElement qualifierExpression) {
        if (qualifierExpression == null) {
            DfaUtil.$$$reportNull$$$0(7);
        }
        if (qualifierExpression instanceof PsiMethodCallExpression) {
            List<PsiExpression> list = Collections.singletonList((PsiMethodCallExpression)qualifierExpression);
            if (list == null) {
                DfaUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (qualifierExpression instanceof PsiReferenceExpression) {
            PsiElement targetElement = ((PsiReferenceExpression)qualifierExpression).resolve();
            if (!(targetElement instanceof PsiVariable)) {
                List<PsiExpression> list = Collections.emptyList();
                if (list == null) {
                    DfaUtil.$$$reportNull$$$0(9);
                }
                return list;
            }
            Collection<PsiExpression> variableValues = DfaUtil.getCachedVariableValues((PsiVariable)targetElement, qualifierExpression);
            if (variableValues == null || variableValues.isEmpty()) {
                Collection<PsiExpression> collection = DfaPsiUtil.getVariableAssignmentsInFile((PsiVariable)targetElement, false, qualifierExpression);
                if (collection == null) {
                    DfaUtil.$$$reportNull$$$0(10);
                }
                return collection;
            }
            Collection<PsiExpression> collection = variableValues;
            if (collection == null) {
                DfaUtil.$$$reportNull$$$0(11);
            }
            return collection;
        }
        if (qualifierExpression instanceof PsiLiteralExpression) {
            List<PsiExpression> list = Collections.singletonList((PsiLiteralExpression)qualifierExpression);
            if (list == null) {
                DfaUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<PsiExpression> list = Collections.emptyList();
        if (list == null) {
            DfaUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    static PsiElement getClosureInside(Instruction instruction) {
        if (instruction instanceof MethodCallInstruction) {
            PsiCall anchor = ((MethodCallInstruction)instruction).getCallExpression();
            if (anchor instanceof PsiNewExpression) {
                return ((PsiNewExpression)anchor).getAnonymousClass();
            }
        } else {
            PsiElement anchor;
            if (instruction instanceof LambdaInstruction) {
                return ((LambdaInstruction)instruction).getLambdaExpression();
            }
            if (instruction instanceof EmptyInstruction && (anchor = ((EmptyInstruction)instruction).getAnchor()) instanceof PsiClass) {
                return anchor;
            }
        }
        return null;
    }

    @NotNull
    public static Nullness inferMethodNullity(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null || PsiUtil.resolveClassInType(method.getReturnType()) == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                DfaUtil.$$$reportNull$$$0(14);
            }
            return nullness;
        }
        Nullness nullness = DfaUtil.inferBlockNullity(body, InferenceFromSourceUtil.suppressNullable(method));
        if (nullness == null) {
            DfaUtil.$$$reportNull$$$0(15);
        }
        return nullness;
    }

    @NotNull
    public static Nullness inferLambdaNullity(PsiLambdaExpression lambda2) {
        PsiElement body = lambda2.getBody();
        if (body == null || LambdaUtil.getFunctionalInterfaceReturnType(lambda2) == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                DfaUtil.$$$reportNull$$$0(16);
            }
            return nullness;
        }
        Nullness nullness = DfaUtil.inferBlockNullity(body, false);
        if (nullness == null) {
            DfaUtil.$$$reportNull$$$0(17);
        }
        return nullness;
    }

    @NotNull
    private static Nullness inferBlockNullity(final PsiElement body, boolean suppressNullable) {
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner();
        final AtomicBoolean hasNulls = new AtomicBoolean();
        final AtomicBoolean hasNotNulls = new AtomicBoolean();
        final AtomicBoolean hasUnknowns = new AtomicBoolean();
        RunnerResult rc = dfaRunner.analyzeMethod(body, new StandardInstructionVisitor(){

            @Override
            public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                if (PsiTreeUtil.isAncestor(body, instruction.getReturn(), false)) {
                    DfaValue returned = memState.peek();
                    if (memState.isNull(returned)) {
                        hasNulls.set(true);
                    } else if (memState.isNotNull(returned)) {
                        hasNotNulls.set(true);
                    } else {
                        hasUnknowns.set(true);
                    }
                }
                return super.visitCheckReturnValue(instruction, runner, memState);
            }
        });
        if (rc == RunnerResult.OK) {
            if (hasNulls.get()) {
                Nullness nullness = suppressNullable ? Nullness.UNKNOWN : Nullness.NULLABLE;
                if (nullness == null) {
                    DfaUtil.$$$reportNull$$$0(18);
                }
                return nullness;
            }
            if (hasNotNulls.get() && !hasUnknowns.get()) {
                Nullness nullness = Nullness.NOT_NULL;
                if (nullness == null) {
                    DfaUtil.$$$reportNull$$$0(19);
                }
                return nullness;
            }
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            DfaUtil.$$$reportNull$$$0(20);
        }
        return nullness;
    }

    static DfaValue getPossiblyNonInitializedValue(@NotNull DfaValueFactory factory, @NotNull PsiField target, @NotNull PsiElement context) {
        if (factory == null) {
            DfaUtil.$$$reportNull$$$0(21);
        }
        if (target == null) {
            DfaUtil.$$$reportNull$$$0(22);
        }
        if (context == null) {
            DfaUtil.$$$reportNull$$$0(23);
        }
        PsiMember placeMember = PsiTreeUtil.getParentOfType(context, PsiMember.class, false, PsiClass.class, PsiLambdaExpression.class);
        PsiType type = target.getType();
        if (placeMember == null || type instanceof PsiPrimitiveType && !(placeMember instanceof PsiField)) {
            return null;
        }
        PsiClass placeClass = placeMember.getContainingClass();
        if (placeClass != null && placeClass == target.getContainingClass()) {
            if (!placeMember.hasModifier(JvmModifier.STATIC) && target.hasModifier(JvmModifier.STATIC)) {
                return null;
            }
            if (DfaUtil.getAccessOffset(placeMember) >= DfaUtil.getWriteOffset(target)) {
                return null;
            }
            return placeMember instanceof PsiField ? factory.getConstFactory().createFromValue(PsiTypesUtil.getDefaultValue(type), type, null) : factory.createTypeValue(type, Nullness.NULLABLE);
        }
        return null;
    }

    private static int getWriteOffset(PsiField target) {
        boolean isFinal = target.hasModifier(JvmModifier.FINAL);
        int offset = Integer.MAX_VALUE;
        if (target.getInitializer() != null) {
            offset = target.getInitializer().getTextRange().getStartOffset();
            if (isFinal) {
                return offset;
            }
        }
        PsiClass aClass = Objects.requireNonNull(target.getContainingClass());
        PsiClassInitializer[] initializers = aClass.getInitializers();
        Predicate<PsiElement> writesToTarget = element -> !ReferencesSearch.search(target, new LocalSearchScope((PsiElement)element)).forEach(e -> !(e instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((Object)e)));
        Predicate<PsiElement> hasSideEffectCall = element -> !PsiTreeUtil.findChildrenOfType(element, PsiMethodCallExpression.class).stream().map(PsiCall::resolveMethod).allMatch(method -> method != null && ControlFlowAnalyzer.isPure(method));
        for (PsiClassInitializer psiClassInitializer : initializers) {
            if (psiClassInitializer.hasModifier(JvmModifier.STATIC) != target.hasModifier(JvmModifier.STATIC)) continue;
            if (!isFinal && hasSideEffectCall.test(psiClassInitializer)) {
                offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
                break;
            }
            if (!writesToTarget.test(psiClassInitializer)) continue;
            offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
            if (!isFinal) break;
            return offset;
        }
        if (!isFinal) {
            for (PsiMember psiMember : aClass.getFields()) {
                if (psiMember.hasModifier(JvmModifier.STATIC) != target.hasModifier(JvmModifier.STATIC) || !hasSideEffectCall.test(psiMember.getInitializer()) && !writesToTarget.test(psiMember)) continue;
                offset = Math.min(offset, psiMember.getTextRange().getStartOffset());
                break;
            }
        }
        return offset;
    }

    private static int getAccessOffset(PsiMember referrer) {
        if (referrer instanceof PsiField) {
            return referrer.getTextRange().getStartOffset();
        }
        PsiClass aClass = Objects.requireNonNull(referrer.getContainingClass());
        if (referrer instanceof PsiMethod) {
            boolean isStatic = referrer.hasModifier(JvmModifier.STATIC);
            for (PsiField field : aClass.getFields()) {
                Predicate<PsiExpression> callToMethod;
                PsiExpression initializer;
                if (field.hasModifier(JvmModifier.STATIC) != isStatic || !ExpressionUtils.isMatchingChildAlwaysExecuted(initializer = field.getInitializer(), callToMethod = e -> {
                    if (!(e instanceof PsiMethodCallExpression)) {
                        return false;
                    }
                    PsiMethodCallExpression call = (PsiMethodCallExpression)e;
                    return call.getMethodExpression().isReferenceTo(referrer) && (isStatic || DfaValueFactory.isEffectivelyUnqualified(call.getMethodExpression()));
                })) continue;
                return field.getTextRange().getStartOffset();
            }
        }
        return Integer.MAX_VALUE;
    }

    public static boolean hasInitializationHacks(@NotNull PsiField field) {
        PsiClass containingClass;
        if (field == null) {
            DfaUtil.$$$reportNull$$$0(24);
        }
        return (containingClass = field.getContainingClass()) != null && System.class.getName().equals(containingClass.getQualifiedName());
    }

    private static PsiExpression concatenateExpressions(FList<PsiExpression> concatenation) {
        if (concatenation.size() == 1) {
            return concatenation.getHead();
        }
        String text2 = StringUtil.join(ContainerUtil.reverse(new ArrayList<PsiExpression>(concatenation)), expression -> expression.getText(), "+");
        try {
            return JavaPsiFacade.getElementFactory(concatenation.getHead().getProject()).createExpressionFromText(text2, concatenation.getHead());
        }
        catch (IncorrectOperationException e) {
            return concatenation.getHead();
        }
    }

    public static boolean isNaN(Object value) {
        if (value instanceof Double && ((Double)value).isNaN()) {
            return true;
        }
        return value instanceof Float && ((Float)value).isNaN();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierExpression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "checkNullness";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleInitializationElements";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMethodNullity";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "inferLambdaNullity";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "inferBlockNullity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPlaceResults";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleInitializationElements";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPossiblyNonInitializedValue";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasInitializationHacks";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCachedPlaceResults$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ValuableInstructionVisitor
    extends StandardInstructionVisitor {
        final Map<PsiElement, PlaceResult> myResults = ContainerUtil.newHashMap();

        private ValuableInstructionVisitor() {
        }

        @Override
        public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiExpression place = instruction.getPlace();
            if (place != null) {
                PsiModifierListOwner element;
                PlaceResult result = this.myResults.computeIfAbsent(place, __ -> new PlaceResult());
                Map<DfaVariableValue, DfaVariableState> map = ((ValuableDataFlowRunner.MyDfaMemoryState)memState).getVariableStates();
                for (Map.Entry<DfaVariableValue, DfaVariableState> entry : map.entrySet()) {
                    PsiModifierListOwner element2;
                    ValuableDataFlowRunner.ValuableDfaVariableState state = (ValuableDataFlowRunner.ValuableDfaVariableState)entry.getValue();
                    DfaVariableValue variableValue = entry.getKey();
                    FList<PsiExpression> concatenation = state.myConcatenation;
                    if (concatenation.isEmpty() || variableValue.getQualifier() != null || !((element2 = variableValue.getPsiVariable()) instanceof PsiVariable)) continue;
                    result.myValues.put((PsiVariable)element2, concatenation);
                }
                DfaValue value = instruction.getValue();
                if (value instanceof DfaVariableValue && ((DfaVariableValue)value).getQualifier() == null && (element = ((DfaVariableValue)value).getPsiVariable()) instanceof PsiVariable) {
                    if (memState.isNotNull(value)) {
                        result.myNotNulls.add((PsiVariable)element);
                    }
                    if (memState.isNull(value)) {
                        result.myNulls.add((PsiVariable)element);
                    }
                }
            }
            return super.visitPush(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState _memState) {
            Instruction nextInstruction = runner.getInstruction(instruction.getIndex() + 1);
            ValuableDataFlowRunner.MyDfaMemoryState memState = (ValuableDataFlowRunner.MyDfaMemoryState)_memState;
            DfaValue dfaSource = memState.pop();
            DfaValue dfaDest = memState.pop();
            if (dfaDest instanceof DfaVariableValue) {
                DfaVariableValue var = (DfaVariableValue)dfaDest;
                PsiExpression rightValue = instruction.getRExpression();
                PsiElement parent = rightValue == null ? null : rightValue.getParent();
                IElementType type = parent instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)parent).getOperationTokenType() : JavaTokenType.EQ;
                FList<PsiExpression> prevValue = ((ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState((DfaVariableValue)var)).myConcatenation;
                memState.setVarValue(var, dfaSource);
                ValuableDataFlowRunner.ValuableDfaVariableState curState = (ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState(var);
                FList<PsiExpression> curValue = curState.myConcatenation;
                FList<PsiExpression> nextValue = type == JavaTokenType.PLUSEQ && !prevValue.isEmpty() && rightValue != null ? prevValue.prepend(rightValue) : (curValue.isEmpty() && rightValue != null ? curValue.prepend(rightValue) : curValue);
                memState.setVariableState(var, curState.withExpression(nextValue));
            }
            memState.push(dfaDest);
            return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, memState)};
        }

        static class PlaceResult {
            final MultiValuesMap<PsiVariable, FList<PsiExpression>> myValues = new MultiValuesMap(true);
            final Set<PsiVariable> myNulls = new THashSet();
            final Set<PsiVariable> myNotNulls = new THashSet();

            PlaceResult() {
            }
        }
    }
}

