/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DfaVariableState {
    @NotNull
    final Set<DfaPsiType> myInstanceofValues;
    @NotNull
    final Set<DfaPsiType> myNotInstanceofValues;
    @NotNull
    final DfaFactMap myFactMap;
    private final int myHash;

    DfaVariableState(@NotNull DfaVariableValue dfaVar) {
        if (dfaVar == null) {
            DfaVariableState.$$$reportNull$$$0(0);
        }
        this(Collections.emptySet(), Collections.emptySet(), dfaVar.getInherentFacts());
    }

    public boolean isSuperStateOf(DfaVariableState that) {
        if (!this.myNotInstanceofValues.equals(that.myNotInstanceofValues)) {
            return false;
        }
        if (!this.myInstanceofValues.equals(that.myNotInstanceofValues)) {
            return false;
        }
        return this.myFactMap.isSuperStateOf(that.myFactMap);
    }

    DfaVariableState(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues, @NotNull DfaFactMap factMap) {
        if (instanceofValues == null) {
            DfaVariableState.$$$reportNull$$$0(1);
        }
        if (notInstanceofValues == null) {
            DfaVariableState.$$$reportNull$$$0(2);
        }
        if (factMap == null) {
            DfaVariableState.$$$reportNull$$$0(3);
        }
        this.myInstanceofValues = instanceofValues;
        this.myNotInstanceofValues = notInstanceofValues;
        this.myFactMap = factMap;
        this.myHash = Objects.hash(this.myInstanceofValues, this.myNotInstanceofValues, this.myFactMap);
    }

    private boolean checkInstanceofValue(@NotNull DfaPsiType dfaType) {
        if (dfaType == null) {
            DfaVariableState.$$$reportNull$$$0(4);
        }
        if (this.myInstanceofValues.contains(dfaType)) {
            return true;
        }
        for (DfaPsiType dfaTypeValue : this.myNotInstanceofValues) {
            if (!dfaTypeValue.isAssignableFrom(dfaType)) continue;
            return false;
        }
        for (DfaPsiType dfaTypeValue : this.myInstanceofValues) {
            if (dfaType.isConvertibleFrom(dfaTypeValue)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    DfaVariableState withInstanceofValue(@NotNull DfaTypeValue dfaType) {
        if (dfaType == null) {
            DfaVariableState.$$$reportNull$$$0(5);
        }
        if (dfaType.getDfaType().getPsiType() instanceof PsiPrimitiveType) {
            return this;
        }
        if (this.checkInstanceofValue(dfaType.getDfaType())) {
            DfaVariableState result = dfaType.isNullable() ? this.withFact(DfaFactType.CAN_BE_NULL, true) : this;
            ArrayList moreGeneric = ContainerUtil.newArrayList();
            for (DfaPsiType alreadyInstanceof : this.myInstanceofValues) {
                if (dfaType.getDfaType().isAssignableFrom(alreadyInstanceof)) {
                    return result;
                }
                if (!alreadyInstanceof.isAssignableFrom(dfaType.getDfaType())) continue;
                moreGeneric.add(alreadyInstanceof);
            }
            HashSet<DfaPsiType> newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.removeAll(moreGeneric);
            newInstanceof.add(dfaType.getDfaType());
            result = this.createCopy(newInstanceof, this.myNotInstanceofValues, result.myFactMap);
            return result;
        }
        return null;
    }

    @Nullable
    DfaVariableState withNotInstanceofValue(@NotNull DfaTypeValue dfaType) {
        if (dfaType == null) {
            DfaVariableState.$$$reportNull$$$0(6);
        }
        if (this.myNotInstanceofValues.contains(dfaType.getDfaType())) {
            return this;
        }
        for (DfaPsiType dfaPsiType : this.myInstanceofValues) {
            if (!dfaType.getDfaType().isAssignableFrom(dfaPsiType)) continue;
            return null;
        }
        ArrayList moreSpecific = ContainerUtil.newArrayList();
        for (DfaPsiType alreadyNotInstanceof : this.myNotInstanceofValues) {
            if (alreadyNotInstanceof.isAssignableFrom(dfaType.getDfaType())) {
                return this;
            }
            if (!dfaType.getDfaType().isAssignableFrom(alreadyNotInstanceof)) continue;
            moreSpecific.add(alreadyNotInstanceof);
        }
        HashSet<DfaPsiType> hashSet = ContainerUtil.newHashSet(this.myNotInstanceofValues);
        hashSet.removeAll(moreSpecific);
        hashSet.add(dfaType.getDfaType());
        return this.createCopy(this.myInstanceofValues, hashSet, this.myFactMap);
    }

    @NotNull
    DfaVariableState withoutType(@NotNull DfaPsiType type) {
        if (type == null) {
            DfaVariableState.$$$reportNull$$$0(7);
        }
        if (this.myInstanceofValues.contains(type)) {
            HashSet<DfaPsiType> newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.remove(type);
            DfaVariableState dfaVariableState = this.createCopy(newInstanceof, this.myNotInstanceofValues, this.myFactMap);
            if (dfaVariableState == null) {
                DfaVariableState.$$$reportNull$$$0(8);
            }
            return dfaVariableState;
        }
        if (this.myNotInstanceofValues.contains(type)) {
            HashSet<DfaPsiType> newNotInstanceof = ContainerUtil.newHashSet(this.myNotInstanceofValues);
            newNotInstanceof.remove(type);
            DfaVariableState dfaVariableState = this.createCopy(this.myInstanceofValues, newNotInstanceof, this.myFactMap);
            if (dfaVariableState == null) {
                DfaVariableState.$$$reportNull$$$0(9);
            }
            return dfaVariableState;
        }
        DfaVariableState dfaVariableState = this;
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(10);
        }
        return dfaVariableState;
    }

    public int hashCode() {
        return this.myHash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaVariableState)) {
            return false;
        }
        DfaVariableState aState = (DfaVariableState)obj;
        return this.myHash == aState.myHash && this.myInstanceofValues.equals(aState.myInstanceofValues) && this.myNotInstanceofValues.equals(aState.myNotInstanceofValues) && Objects.equals(this.myFactMap, aState.myFactMap);
    }

    @NotNull
    protected DfaVariableState createCopy(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues, @NotNull DfaFactMap factMap) {
        if (instanceofValues == null) {
            DfaVariableState.$$$reportNull$$$0(11);
        }
        if (notInstanceofValues == null) {
            DfaVariableState.$$$reportNull$$$0(12);
        }
        if (factMap == null) {
            DfaVariableState.$$$reportNull$$$0(13);
        }
        DfaVariableState dfaVariableState = new DfaVariableState(instanceofValues, notInstanceofValues, factMap);
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(14);
        }
        return dfaVariableState;
    }

    public String toString() {
        String factString;
        StringBuilder buf = new StringBuilder("State:");
        if (!this.myInstanceofValues.isEmpty()) {
            buf.append(" instanceof ").append(StringUtil.join(this.myInstanceofValues, ","));
        }
        if (!this.myNotInstanceofValues.isEmpty()) {
            buf.append(" not instanceof ").append(StringUtil.join(this.myNotInstanceofValues, ","));
        }
        if (!(factString = this.myFactMap.toString()).isEmpty()) {
            buf.append(" ").append(factString);
        }
        return buf.toString();
    }

    @NotNull
    Nullness getNullability() {
        Nullness nullness = NullnessUtil.fromBoolean(this.myFactMap.get(DfaFactType.CAN_BE_NULL));
        if (nullness == null) {
            DfaVariableState.$$$reportNull$$$0(15);
        }
        return nullness;
    }

    public boolean isNotNull() {
        return this.getNullability() == Nullness.NOT_NULL;
    }

    @NotNull
    DfaVariableState withNotNull() {
        DfaVariableState dfaVariableState = this.getNullability() == Nullness.NOT_NULL ? this : this.withoutFact(DfaFactType.CAN_BE_NULL);
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(16);
        }
        return dfaVariableState;
    }

    @NotNull
    <T> DfaVariableState withFact(DfaFactType<T> type, T value) {
        DfaFactMap factMap = this.myFactMap.with(type, value);
        DfaVariableState dfaVariableState = this.myFactMap.equals(factMap) ? this : this.createCopy(this.myInstanceofValues, this.myNotInstanceofValues, factMap);
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(17);
        }
        return dfaVariableState;
    }

    <T> DfaVariableState withoutFact(DfaFactType<T> type) {
        return this.withFact(type, null);
    }

    @Nullable
    <T> DfaVariableState intersectFact(DfaFactType<T> type, T value) {
        DfaFactMap factMap = this.myFactMap.intersect(type, value);
        return factMap == null ? null : (this.myFactMap.equals(factMap) ? this : this.createCopy(this.myInstanceofValues, this.myNotInstanceofValues, factMap));
    }

    @NotNull
    public DfaVariableState withValue(DfaValue value) {
        DfaVariableState dfaVariableState = this;
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(18);
        }
        return dfaVariableState;
    }

    @Nullable
    public DfaValue getValue() {
        return null;
    }

    @NotNull
    public Set<DfaPsiType> getInstanceofValues() {
        Set<DfaPsiType> set = this.myInstanceofValues;
        if (set == null) {
            DfaVariableState.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    public Set<DfaPsiType> getNotInstanceofValues() {
        Set<DfaPsiType> set = this.myNotInstanceofValues;
        if (set == null) {
            DfaVariableState.$$$reportNull$$$0(20);
        }
        return set;
    }

    @Nullable
    public <T> T getFact(@NotNull DfaFactType<T> factType) {
        if (factType == null) {
            DfaVariableState.$$$reportNull$$$0(21);
        }
        return this.myFactMap.get(factType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaVar";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceofValues";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notInstanceofValues";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factMap";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaVariableState";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaVariableState";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "withNotNull";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "withFact";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "withValue";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceofValues";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotInstanceofValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkInstanceofValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withInstanceofValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withNotInstanceofValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withoutType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFact";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

