/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inconsistentLanguageLevel;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.unnecessaryModuleDependency.UnnecessaryModuleDependencyInspection;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InconsistentLanguageLevelInspection
extends GlobalInspectionTool {
    @Override
    public boolean isGraphNeeded() {
        return false;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            InconsistentLanguageLevelInspection.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            InconsistentLanguageLevelInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            InconsistentLanguageLevelInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            InconsistentLanguageLevelInspection.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            InconsistentLanguageLevelInspection.$$$reportNull$$$0(4);
        }
        if (refEntity instanceof RefModule) {
            Module module = ((RefModule)refEntity).getModule();
            if (module.isDisposed() || !scope.containsModule(module)) {
                return null;
            }
            LanguageLevel projectLanguageLevel = LanguageLevelProjectExtension.getInstance(manager.getProject()).getLanguageLevel();
            LanguageLevel languageLevel = LanguageLevelModuleExtensionImpl.getInstance(module).getLanguageLevel();
            if (languageLevel == null) {
                languageLevel = projectLanguageLevel;
            }
            for (OrderEntry entry : ModuleRootManager.getInstance(module).getOrderEntries()) {
                Module dependantModule;
                if (!(entry instanceof ModuleOrderEntry) || (dependantModule = ((ModuleOrderEntry)entry).getModule()) == null) continue;
                LanguageLevel dependantLanguageLevel = LanguageLevelModuleExtensionImpl.getInstance(dependantModule).getLanguageLevel();
                if (dependantLanguageLevel == null) {
                    dependantLanguageLevel = projectLanguageLevel;
                }
                if (languageLevel.compareTo(dependantLanguageLevel) >= 0) continue;
                CommonProblemDescriptor problemDescriptor = manager.createProblemDescriptor("Module " + module.getName() + " with language level " + (Object)((Object)languageLevel) + " depends on module " + dependantModule.getName() + " with language level " + (Object)((Object)dependantLanguageLevel), new UnnecessaryModuleDependencyInspection.RemoveModuleDependencyFix(module, dependantModule), (QuickFix)((Object)QuickFixFactory.getInstance().createShowModulePropertiesFix(module)));
                return new CommonProblemDescriptor[]{problemDescriptor};
            }
        }
        return null;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.MODULARIZATION_GROUP_NAME;
        if (string == null) {
            InconsistentLanguageLevelInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("Inconsistent language level settings" == null) {
            InconsistentLanguageLevelInspection.$$$reportNull$$$0(6);
        }
        return "Inconsistent language level settings";
    }

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        if ("InconsistentLanguageLevel" == null) {
            InconsistentLanguageLevelInspection.$$$reportNull$$$0(7);
        }
        return "InconsistentLanguageLevel";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/inconsistentLanguageLevel/InconsistentLanguageLevelInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

