/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.util.Condition;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemeManager<T extends Scheme> {
    public static final String EDITABLE_COPY_PREFIX = "_@user_";

    @NotNull
    public abstract Collection<T> loadSchemes();

    public void reload() {
    }

    public abstract void addNewScheme(@NotNull T var1, boolean var2);

    public void addScheme(@NotNull T scheme) {
        if (scheme == null) {
            SchemeManager.$$$reportNull$$$0(0);
        }
        this.addNewScheme(scheme, true);
    }

    public abstract void clearAllSchemes();

    @NotNull
    public abstract List<T> getAllSchemes();

    public boolean isEmpty() {
        return this.getAllSchemes().isEmpty();
    }

    @Nullable
    public abstract T findSchemeByName(@NotNull String var1);

    public final void setCurrentSchemeName(@Nullable String schemeName) {
        this.setCurrentSchemeName(schemeName, true);
    }

    public abstract void setCurrentSchemeName(@Nullable String var1, boolean var2);

    public final void setCurrent(@Nullable T scheme) {
        this.setCurrent(scheme, true);
    }

    public void setCurrent(@Nullable T scheme, boolean notify2) {
        this.setCurrentSchemeName(scheme == null ? null : scheme.getName());
    }

    @Nullable
    public abstract T getCurrentScheme();

    @Nullable
    public String getCurrentSchemeName() {
        T scheme = this.getCurrentScheme();
        return scheme == null ? null : scheme.getName();
    }

    public abstract boolean removeScheme(@NotNull T var1);

    @Nullable
    public T removeScheme(@NotNull String name) {
        T scheme;
        if (name == null) {
            SchemeManager.$$$reportNull$$$0(1);
        }
        if ((scheme = this.findSchemeByName(name)) != null) {
            this.removeScheme(scheme);
            return scheme;
        }
        return null;
    }

    @NotNull
    public abstract Collection<String> getAllSchemeNames();

    public abstract File getRootDirectory();

    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor) {
        if (resourceName == null) {
            SchemeManager.$$$reportNull$$$0(2);
        }
        if (requestor == null) {
            SchemeManager.$$$reportNull$$$0(3);
        }
    }

    public final void setSchemes(@NotNull List<T> newSchemes) {
        if (newSchemes == null) {
            SchemeManager.$$$reportNull$$$0(4);
        }
        this.setSchemes(newSchemes, null, null);
    }

    public final void setSchemes(@NotNull List<T> newSchemes, @Nullable T newCurrentScheme) {
        if (newSchemes == null) {
            SchemeManager.$$$reportNull$$$0(5);
        }
        this.setSchemes(newSchemes, newCurrentScheme, null);
    }

    public void setSchemes(@NotNull List<T> newSchemes, @Nullable T newCurrentScheme, @Nullable Condition<T> removeCondition) {
        if (newSchemes == null) {
            SchemeManager.$$$reportNull$$$0(6);
        }
    }

    public boolean isMetadataEditable(@NotNull T scheme) {
        if (scheme == null) {
            SchemeManager.$$$reportNull$$$0(7);
        }
        return true;
    }

    public static String getDisplayName(@NotNull Scheme scheme) {
        String schemeName;
        if (scheme == null) {
            SchemeManager.$$$reportNull$$$0(8);
        }
        return (schemeName = scheme.getName()).startsWith(EDITABLE_COPY_PREFIX) ? schemeName.substring(EDITABLE_COPY_PREFIX.length()) : schemeName;
    }

    public void save(@NotNull List<Throwable> errors) {
        if (errors == null) {
            SchemeManager.$$$reportNull$$$0(9);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSchemes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/options/SchemeManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addScheme";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeScheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadBundledScheme";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setSchemes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isMetadataEditable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getDisplayName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

