/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ClonableContentEntry;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.InheritedJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.LibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ModuleSourceOrderEntryImpl;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.RootModelBase;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootModelImpl
extends RootModelBase
implements ModifiableRootModel {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.RootModelImpl");
    private final Set<ContentEntry> myContent;
    private final List<OrderEntry> myOrderEntries;
    @Nullable
    private OrderEntry[] myCachedOrderEntries;
    @NotNull
    private final ModuleLibraryTable myModuleLibraryTable;
    final ModuleRootManagerImpl myModuleRootManager;
    private boolean myWritable;
    private final VirtualFilePointerManager myFilePointerManager;
    private boolean myDisposed;
    private final Set<ModuleExtension> myExtensions;
    @Nullable
    private final Map<ModuleExtension, byte[]> myExtensionToStateDigest;
    private final RootConfigurationAccessor myConfigurationAccessor;
    private final ProjectRootManagerImpl myProjectRootManager;
    private final CompositeDisposable myDisposable;

    RootModelImpl(@NotNull ModuleRootManagerImpl moduleRootManager, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        if (moduleRootManager == null) {
            RootModelImpl.$$$reportNull$$$0(0);
        }
        if (projectRootManager == null) {
            RootModelImpl.$$$reportNull$$$0(1);
        }
        if (filePointerManager == null) {
            RootModelImpl.$$$reportNull$$$0(2);
        }
        this.myContent = new TreeSet<ContentEntry>(ContentComparator.INSTANCE);
        this.myOrderEntries = new Order();
        this.myExtensions = new TreeSet<ModuleExtension>((o1, o2) -> Comparing.compare(o1.getClass().getName(), o2.getClass().getName()));
        this.myDisposable = new CompositeDisposable();
        this.myModuleRootManager = moduleRootManager;
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myWritable = false;
        this.addSourceOrderEntries();
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        for (ModuleExtension extension : Extensions.getExtensions(ModuleExtension.EP_NAME, (AreaInstance)moduleRootManager.getModule())) {
            ModuleExtension model = extension.getModifiableModel(false);
            this.registerOnDispose(model);
            this.myExtensions.add(model);
        }
        this.myConfigurationAccessor = new RootConfigurationAccessor();
        this.myExtensionToStateDigest = null;
    }

    private void addSourceOrderEntries() {
        this.myOrderEntries.add(new ModuleSourceOrderEntryImpl(this));
    }

    RootModelImpl(@NotNull Element element, @NotNull ModuleRootManagerImpl moduleRootManager, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager, boolean writable) throws InvalidDataException {
        if (element == null) {
            RootModelImpl.$$$reportNull$$$0(3);
        }
        if (moduleRootManager == null) {
            RootModelImpl.$$$reportNull$$$0(4);
        }
        if (projectRootManager == null) {
            RootModelImpl.$$$reportNull$$$0(5);
        }
        if (filePointerManager == null) {
            RootModelImpl.$$$reportNull$$$0(6);
        }
        this.myContent = new TreeSet<ContentEntry>(ContentComparator.INSTANCE);
        this.myOrderEntries = new Order();
        this.myExtensions = new TreeSet<ModuleExtension>((o1, o2) -> Comparing.compare(o1.getClass().getName(), o2.getClass().getName()));
        this.myDisposable = new CompositeDisposable();
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myModuleRootManager = moduleRootManager;
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        for (Object child : element.getChildren("content")) {
            this.myContent.add(new ContentEntryImpl((Element)child, this));
        }
        boolean moduleSourceAdded = false;
        for (Element child : element.getChildren("orderEntry")) {
            OrderEntry orderEntry = OrderEntryFactory.createOrderEntryByElement(child, this, this.myProjectRootManager);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                if (moduleSourceAdded) continue;
                moduleSourceAdded = true;
            }
            this.myOrderEntries.add(orderEntry);
        }
        if (!moduleSourceAdded) {
            this.myOrderEntries.add(new ModuleSourceOrderEntryImpl(this));
        }
        this.myWritable = writable;
        RootModelImpl originalRootModel = moduleRootManager.getRootModel();
        for (ModuleExtension extension : originalRootModel.myExtensions) {
            ModuleExtension model = extension.getModifiableModel(false);
            if (model instanceof PersistentStateComponent) {
                XmlSerializer.deserializeAndLoadState((PersistentStateComponent)((Object)model), element);
            } else {
                model.readExternal(element);
            }
            this.registerOnDispose(model);
            this.myExtensions.add(model);
        }
        this.myConfigurationAccessor = new RootConfigurationAccessor();
        this.myExtensionToStateDigest = null;
    }

    @Override
    public boolean isWritable() {
        return this.myWritable;
    }

    @NotNull
    RootConfigurationAccessor getConfigurationAccessor() {
        RootConfigurationAccessor rootConfigurationAccessor = this.myConfigurationAccessor;
        if (rootConfigurationAccessor == null) {
            RootModelImpl.$$$reportNull$$$0(7);
        }
        return rootConfigurationAccessor;
    }

    RootModelImpl(@NotNull RootModelImpl rootModel, @NotNull ModuleRootManagerImpl moduleRootManager, boolean writable, @NotNull RootConfigurationAccessor rootConfigurationAccessor, @NotNull VirtualFilePointerManager filePointerManager, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (rootModel == null) {
            RootModelImpl.$$$reportNull$$$0(8);
        }
        if (moduleRootManager == null) {
            RootModelImpl.$$$reportNull$$$0(9);
        }
        if (rootConfigurationAccessor == null) {
            RootModelImpl.$$$reportNull$$$0(10);
        }
        if (filePointerManager == null) {
            RootModelImpl.$$$reportNull$$$0(11);
        }
        if (projectRootManager == null) {
            RootModelImpl.$$$reportNull$$$0(12);
        }
        this.myContent = new TreeSet<ContentEntry>(ContentComparator.INSTANCE);
        this.myOrderEntries = new Order();
        this.myExtensions = new TreeSet<ModuleExtension>((o1, o2) -> Comparing.compare(o1.getClass().getName(), o2.getClass().getName()));
        this.myDisposable = new CompositeDisposable();
        this.myFilePointerManager = filePointerManager;
        this.myModuleRootManager = moduleRootManager;
        this.myProjectRootManager = projectRootManager;
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        this.myWritable = writable;
        this.myConfigurationAccessor = rootConfigurationAccessor;
        for (ContentEntry contentEntry : rootModel.myContent) {
            if (!(contentEntry instanceof ClonableContentEntry)) continue;
            ContentEntry cloned = ((ClonableContentEntry)((Object)contentEntry)).cloneEntry(this);
            this.myContent.add(cloned);
        }
        this.setOrderEntriesFrom(rootModel);
        this.myExtensionToStateDigest = writable ? new THashMap() : null;
        for (ModuleExtension extension : rootModel.myExtensions) {
            ModuleExtension model = extension.getModifiableModel(writable);
            this.registerOnDispose(model);
            this.myExtensions.add(model);
            if (this.myExtensionToStateDigest == null || extension instanceof PersistentStateComponentWithModificationTracker) continue;
            Element state = new Element("state");
            try {
                extension.writeExternal(state);
                this.myExtensionToStateDigest.put(extension, Scheme_implKt.digest(state));
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }
    }

    private void setOrderEntriesFrom(@NotNull RootModelImpl rootModel) {
        if (rootModel == null) {
            RootModelImpl.$$$reportNull$$$0(13);
        }
        this.removeAllOrderEntries();
        for (OrderEntry orderEntry : rootModel.myOrderEntries) {
            if (!(orderEntry instanceof ClonableOrderEntry)) continue;
            this.myOrderEntries.add(((ClonableOrderEntry)((Object)orderEntry)).cloneEntry(this, this.myProjectRootManager, this.myFilePointerManager));
        }
    }

    private void removeAllOrderEntries() {
        for (OrderEntry entry : this.myOrderEntries) {
            Disposer.dispose((OrderEntryBaseImpl)entry);
        }
        this.myOrderEntries.clear();
    }

    @Override
    @NotNull
    public OrderEntry[] getOrderEntries() {
        OrderEntry[] cachedOrderEntries = this.myCachedOrderEntries;
        if (cachedOrderEntries == null) {
            cachedOrderEntries = this.myOrderEntries.toArray(new OrderEntry[this.myOrderEntries.size()]);
            this.myCachedOrderEntries = cachedOrderEntries;
        }
        if (cachedOrderEntries == null) {
            RootModelImpl.$$$reportNull$$$0(14);
        }
        return cachedOrderEntries;
    }

    @NotNull
    Iterator<OrderEntry> getOrderIterator() {
        Iterator<OrderEntry> iterator = Collections.unmodifiableList(this.myOrderEntries).iterator();
        if (iterator == null) {
            RootModelImpl.$$$reportNull$$$0(15);
        }
        return iterator;
    }

    @Override
    public void removeContentEntry(@NotNull ContentEntry entry) {
        if (entry == null) {
            RootModelImpl.$$$reportNull$$$0(16);
        }
        this.assertWritable();
        LOG.assertTrue(this.myContent.contains(entry));
        if (entry instanceof RootModelComponentBase) {
            Disposer.dispose((RootModelComponentBase)((Object)entry));
            RootModelImpl entryModel = ((RootModelComponentBase)((Object)entry)).getRootModel();
            LOG.assertTrue(entryModel == this, "Removing from " + this + " content entry obtained from " + entryModel);
        }
        this.myContent.remove(entry);
    }

    @Override
    public void addOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            RootModelImpl.$$$reportNull$$$0(17);
        }
        this.assertWritable();
        LOG.assertTrue(!this.myOrderEntries.contains(entry));
        this.myOrderEntries.add(entry);
    }

    @Override
    @NotNull
    public LibraryOrderEntry addLibraryEntry(@NotNull Library library) {
        if (library == null) {
            RootModelImpl.$$$reportNull$$$0(18);
        }
        this.assertWritable();
        LibraryOrderEntryImpl libraryOrderEntry = new LibraryOrderEntryImpl(library, this, this.myProjectRootManager);
        if (!libraryOrderEntry.isValid()) {
            LibraryEx libraryEx = ObjectUtils.tryCast(library, LibraryEx.class);
            boolean libraryDisposed = libraryEx != null ? libraryEx.isDisposed() : Disposer.isDisposed(library);
            throw new AssertionError((Object)("Invalid libraryOrderEntry, library: " + library + " of type " + library.getClass() + ", disposed: " + libraryDisposed + ", kind: " + (libraryEx != null ? libraryEx.getKind() : "<undefined>")));
        }
        this.myOrderEntries.add(libraryOrderEntry);
        LibraryOrderEntryImpl libraryOrderEntryImpl = libraryOrderEntry;
        if (libraryOrderEntryImpl == null) {
            RootModelImpl.$$$reportNull$$$0(19);
        }
        return libraryOrderEntryImpl;
    }

    @Override
    @NotNull
    public LibraryOrderEntry addInvalidLibrary(@NotNull String name, @NotNull String level) {
        if (name == null) {
            RootModelImpl.$$$reportNull$$$0(20);
        }
        if (level == null) {
            RootModelImpl.$$$reportNull$$$0(21);
        }
        this.assertWritable();
        LibraryOrderEntryImpl libraryOrderEntry = new LibraryOrderEntryImpl(name, level, this, this.myProjectRootManager);
        this.myOrderEntries.add(libraryOrderEntry);
        LibraryOrderEntryImpl libraryOrderEntryImpl = libraryOrderEntry;
        if (libraryOrderEntryImpl == null) {
            RootModelImpl.$$$reportNull$$$0(22);
        }
        return libraryOrderEntryImpl;
    }

    @Override
    @NotNull
    public ModuleOrderEntry addModuleOrderEntry(@NotNull Module module) {
        if (module == null) {
            RootModelImpl.$$$reportNull$$$0(23);
        }
        this.assertWritable();
        LOG.assertTrue(!module.equals(this.getModule()));
        LOG.assertTrue(Comparing.equal(this.myModuleRootManager.getModule().getProject(), module.getProject()));
        ModuleOrderEntryImpl moduleOrderEntry = new ModuleOrderEntryImpl(module, this);
        this.myOrderEntries.add(moduleOrderEntry);
        ModuleOrderEntryImpl moduleOrderEntryImpl = moduleOrderEntry;
        if (moduleOrderEntryImpl == null) {
            RootModelImpl.$$$reportNull$$$0(24);
        }
        return moduleOrderEntryImpl;
    }

    @Override
    @NotNull
    public ModuleOrderEntry addInvalidModuleEntry(@NotNull String name) {
        if (name == null) {
            RootModelImpl.$$$reportNull$$$0(25);
        }
        this.assertWritable();
        LOG.assertTrue(!name.equals(this.getModule().getName()));
        ModuleOrderEntryImpl moduleOrderEntry = new ModuleOrderEntryImpl(name, this);
        this.myOrderEntries.add(moduleOrderEntry);
        ModuleOrderEntryImpl moduleOrderEntryImpl = moduleOrderEntry;
        if (moduleOrderEntryImpl == null) {
            RootModelImpl.$$$reportNull$$$0(26);
        }
        return moduleOrderEntryImpl;
    }

    @Override
    @Nullable
    public LibraryOrderEntry findLibraryOrderEntry(@NotNull Library library) {
        if (library == null) {
            RootModelImpl.$$$reportNull$$$0(27);
        }
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)orderEntry).getLibrary())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @Override
    public void removeOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            RootModelImpl.$$$reportNull$$$0(28);
        }
        this.assertWritable();
        this.removeOrderEntryInternal(entry);
    }

    private void removeOrderEntryInternal(@NotNull OrderEntry entry) {
        if (entry == null) {
            RootModelImpl.$$$reportNull$$$0(29);
        }
        LOG.assertTrue(this.myOrderEntries.contains(entry));
        Disposer.dispose((OrderEntryBaseImpl)entry);
        this.myOrderEntries.remove(entry);
    }

    @Override
    public void rearrangeOrderEntries(@NotNull OrderEntry[] newEntries) {
        if (newEntries == null) {
            RootModelImpl.$$$reportNull$$$0(30);
        }
        this.assertWritable();
        this.assertValidRearrangement(newEntries);
        this.myOrderEntries.clear();
        ContainerUtil.addAll(this.myOrderEntries, newEntries);
    }

    private void assertValidRearrangement(@NotNull OrderEntry[] newEntries) {
        String error;
        if (newEntries == null) {
            RootModelImpl.$$$reportNull$$$0(31);
        }
        LOG.assertTrue((error = this.checkValidRearrangement(newEntries)) == null, error);
    }

    @Nullable
    private String checkValidRearrangement(@NotNull OrderEntry[] newEntries) {
        if (newEntries == null) {
            RootModelImpl.$$$reportNull$$$0(32);
        }
        if (newEntries.length != this.myOrderEntries.size()) {
            return "Size mismatch: old size=" + this.myOrderEntries.size() + "; new size=" + newEntries.length;
        }
        HashSet<OrderEntry> set = new HashSet<OrderEntry>();
        for (OrderEntry newEntry : newEntries) {
            if (!this.myOrderEntries.contains(newEntry)) {
                return "Trying to add nonexisting order entry " + newEntry;
            }
            if (set.contains(newEntry)) {
                return "Trying to add duplicate order entry " + newEntry;
            }
            set.add(newEntry);
        }
        return null;
    }

    @Override
    public void clear() {
        Sdk jdk = this.getSdk();
        this.removeAllContentEntries();
        this.removeAllOrderEntries();
        this.setSdk(jdk);
        this.addSourceOrderEntries();
    }

    private void removeAllContentEntries() {
        for (ContentEntry entry : this.myContent) {
            if (!(entry instanceof RootModelComponentBase)) continue;
            Disposer.dispose((RootModelComponentBase)((Object)entry));
        }
        this.myContent.clear();
    }

    @Override
    public void commit() {
        this.myModuleRootManager.commitModel(this);
        this.myWritable = false;
    }

    void docommit() {
        assert (this.isWritable());
        if (this.areOrderEntriesChanged()) {
            this.getSourceModel().setOrderEntriesFrom(this);
        }
        for (ModuleExtension extension : this.myExtensions) {
            if (!extension.isChanged()) continue;
            extension.commit();
        }
        if (this.areContentEntriesChanged()) {
            this.getSourceModel().removeAllContentEntries();
            for (ContentEntry contentEntry : this.myContent) {
                ContentEntry cloned = ((ClonableContentEntry)((Object)contentEntry)).cloneEntry(this.getSourceModel());
                this.getSourceModel().myContent.add(cloned);
            }
        }
    }

    @Override
    @NotNull
    public LibraryTable getModuleLibraryTable() {
        ModuleLibraryTable moduleLibraryTable = this.myModuleLibraryTable;
        if (moduleLibraryTable == null) {
            RootModelImpl.$$$reportNull$$$0(33);
        }
        return moduleLibraryTable;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProjectRootManager.getProject();
        if (project == null) {
            RootModelImpl.$$$reportNull$$$0(34);
        }
        return project;
    }

    @Override
    @NotNull
    public ContentEntry addContentEntry(@NotNull VirtualFile file) {
        if (file == null) {
            RootModelImpl.$$$reportNull$$$0(35);
        }
        ContentEntry contentEntry = this.addContentEntry(new ContentEntryImpl(file, this));
        if (contentEntry == null) {
            RootModelImpl.$$$reportNull$$$0(36);
        }
        return contentEntry;
    }

    @Override
    @NotNull
    public ContentEntry addContentEntry(@NotNull String url) {
        if (url == null) {
            RootModelImpl.$$$reportNull$$$0(37);
        }
        ContentEntry contentEntry = this.addContentEntry(new ContentEntryImpl(url, this));
        if (contentEntry == null) {
            RootModelImpl.$$$reportNull$$$0(38);
        }
        return contentEntry;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    private ContentEntry addContentEntry(@NotNull ContentEntry e) {
        if (e == null) {
            RootModelImpl.$$$reportNull$$$0(39);
        }
        if (this.myContent.contains(e)) {
            for (ContentEntry contentEntry : this.getContentEntries()) {
                if (ContentComparator.INSTANCE.compare(contentEntry, e) != 0) continue;
                ContentEntry contentEntry2 = contentEntry;
                if (contentEntry2 == null) {
                    RootModelImpl.$$$reportNull$$$0(40);
                }
                return contentEntry2;
            }
        }
        this.myContent.add(e);
        ContentEntry contentEntry = e;
        if (contentEntry == null) {
            RootModelImpl.$$$reportNull$$$0(41);
        }
        return contentEntry;
    }

    long getStateModificationCount() {
        long result = 0L;
        for (ModuleExtension extension : this.myExtensions) {
            if (!(extension instanceof PersistentStateComponentWithModificationTracker)) continue;
            result += ((PersistentStateComponentWithModificationTracker)((Object)extension)).getStateModificationCount();
        }
        return result;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            RootModelImpl.$$$reportNull$$$0(42);
        }
        for (ModuleExtension extension : this.myExtensions) {
            if (extension instanceof PersistentStateComponent) {
                XmlSerializer.serializeStateInto((PersistentStateComponent)((Object)extension), element);
                continue;
            }
            extension.writeExternal(element);
        }
        for (ContentEntry contentEntry : this.getContent()) {
            if (!(contentEntry instanceof ContentEntryImpl)) continue;
            Element subElement = new Element("content");
            ((ContentEntryImpl)contentEntry).writeExternal(subElement);
            element.addContent(subElement);
        }
        for (Iterator<ModuleExtension> iterator : this.getOrderEntries()) {
            if (!(iterator instanceof WritableOrderEntry)) continue;
            ((WritableOrderEntry)((Object)iterator)).writeExternal(element);
        }
    }

    @Override
    public void setSdk(@Nullable Sdk jdk) {
        this.assertWritable();
        ModuleJdkOrderEntryImpl jdkLibraryEntry = jdk == null ? null : new ModuleJdkOrderEntryImpl(jdk, this, this.myProjectRootManager);
        this.replaceEntryOfType(JdkOrderEntry.class, jdkLibraryEntry);
    }

    @Override
    public void setInvalidSdk(@NotNull String jdkName, String jdkType) {
        if (jdkName == null) {
            RootModelImpl.$$$reportNull$$$0(43);
        }
        this.assertWritable();
        this.replaceEntryOfType(JdkOrderEntry.class, new ModuleJdkOrderEntryImpl(jdkName, jdkType, this, this.myProjectRootManager));
    }

    @Override
    public void inheritSdk() {
        this.assertWritable();
        this.replaceEntryOfType(JdkOrderEntry.class, new InheritedJdkOrderEntryImpl(this, this.myProjectRootManager));
    }

    @Override
    public <T extends OrderEntry> void replaceEntryOfType(@NotNull Class<T> entryClass, @Nullable T entry) {
        if (entryClass == null) {
            RootModelImpl.$$$reportNull$$$0(44);
        }
        this.assertWritable();
        for (int i2 = 0; i2 < this.myOrderEntries.size(); ++i2) {
            OrderEntry orderEntry = this.myOrderEntries.get(i2);
            if (!entryClass.isInstance(orderEntry)) continue;
            this.myOrderEntries.remove(i2);
            if (entry != null) {
                this.myOrderEntries.add(i2, entry);
            }
            return;
        }
        if (entry != null) {
            this.myOrderEntries.add(0, entry);
        }
    }

    @Override
    public String getSdkName() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry).getJdkName();
        }
        return null;
    }

    void assertWritable() {
        LOG.assertTrue(this.myWritable);
    }

    boolean isDependsOn(Module module) {
        for (OrderEntry entry : this.getOrderEntries()) {
            Module module1;
            if (!(entry instanceof ModuleOrderEntry) || (module1 = ((ModuleOrderEntry)entry).getModule()) != module) continue;
            return true;
        }
        return false;
    }

    boolean isOrderEntryDisposed() {
        for (OrderEntry entry : this.myOrderEntries) {
            if (!(entry instanceof RootModelComponentBase) || !((RootModelComponentBase)((Object)entry)).isDisposed()) continue;
            return true;
        }
        return false;
    }

    protected Set<ContentEntry> getContent() {
        return this.myContent;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModuleRootManager.getModule();
        if (module == null) {
            RootModelImpl.$$$reportNull$$$0(45);
        }
        return module;
    }

    @Override
    public boolean isChanged() {
        if (!this.myWritable) {
            return false;
        }
        for (ModuleExtension moduleExtension : this.myExtensions) {
            if (!moduleExtension.isChanged()) continue;
            return true;
        }
        return this.areOrderEntriesChanged() || this.areContentEntriesChanged();
    }

    private boolean areContentEntriesChanged() {
        return ArrayUtil.lexicographicCompare(this.getContentEntries(), this.getSourceModel().getContentEntries()) != 0;
    }

    private boolean areOrderEntriesChanged() {
        OrderEntry[] sourceOrderEntries;
        OrderEntry[] orderEntries = this.getOrderEntries();
        if (orderEntries.length != (sourceOrderEntries = this.getSourceModel().getOrderEntries()).length) {
            return true;
        }
        for (int i2 = 0; i2 < orderEntries.length; ++i2) {
            OrderEntry orderEntry = orderEntries[i2];
            OrderEntry sourceOrderEntry = sourceOrderEntries[i2];
            if (RootModelImpl.orderEntriesEquals(orderEntry, sourceOrderEntry)) continue;
            return true;
        }
        return false;
    }

    private static boolean orderEntriesEquals(@NotNull OrderEntry orderEntry1, @NotNull OrderEntry orderEntry2) {
        OrderRootType[] allTypes;
        if (orderEntry1 == null) {
            RootModelImpl.$$$reportNull$$$0(46);
        }
        if (orderEntry2 == null) {
            RootModelImpl.$$$reportNull$$$0(47);
        }
        if (!((OrderEntryBaseImpl)orderEntry1).sameType(orderEntry2)) {
            return false;
        }
        if (orderEntry1 instanceof JdkOrderEntry) {
            String name2;
            String name1;
            if (!(orderEntry2 instanceof JdkOrderEntry)) {
                return false;
            }
            if (orderEntry1 instanceof InheritedJdkOrderEntry && orderEntry2 instanceof ModuleJdkOrderEntry) {
                return false;
            }
            if (orderEntry2 instanceof InheritedJdkOrderEntry && orderEntry1 instanceof ModuleJdkOrderEntry) {
                return false;
            }
            if (orderEntry1 instanceof ModuleJdkOrderEntry && orderEntry2 instanceof ModuleJdkOrderEntry && !Comparing.strEqual(name1 = ((ModuleJdkOrderEntry)orderEntry1).getJdkName(), name2 = ((ModuleJdkOrderEntry)orderEntry2).getJdkName())) {
                return false;
            }
        }
        if (orderEntry1 instanceof ExportableOrderEntry) {
            if (((ExportableOrderEntry)orderEntry1).isExported() != ((ExportableOrderEntry)orderEntry2).isExported()) {
                return false;
            }
            if (((ExportableOrderEntry)orderEntry1).getScope() != ((ExportableOrderEntry)orderEntry2).getScope()) {
                return false;
            }
        }
        if (orderEntry1 instanceof ModuleOrderEntry) {
            LOG.assertTrue(orderEntry2 instanceof ModuleOrderEntry);
            ModuleOrderEntryImpl entry1 = (ModuleOrderEntryImpl)orderEntry1;
            ModuleOrderEntryImpl entry2 = (ModuleOrderEntryImpl)orderEntry2;
            return entry1.isProductionOnTestDependency() == entry2.isProductionOnTestDependency() && Comparing.equal(entry1.getModuleName(), entry2.getModuleName());
        }
        if (orderEntry1 instanceof LibraryOrderEntry) {
            boolean equal;
            LOG.assertTrue(orderEntry2 instanceof LibraryOrderEntry);
            LibraryOrderEntry libraryOrderEntry1 = (LibraryOrderEntry)orderEntry1;
            LibraryOrderEntry libraryOrderEntry2 = (LibraryOrderEntry)orderEntry2;
            boolean bl = equal = Comparing.equal(libraryOrderEntry1.getLibraryName(), libraryOrderEntry2.getLibraryName()) && Comparing.equal(libraryOrderEntry1.getLibraryLevel(), libraryOrderEntry2.getLibraryLevel());
            if (!equal) {
                return false;
            }
            Library library1 = libraryOrderEntry1.getLibrary();
            Library library2 = libraryOrderEntry2.getLibrary();
            if (library1 != null && library2 != null && !Arrays.equals(((LibraryEx)library1).getExcludedRootUrls(), ((LibraryEx)library2).getExcludedRootUrls())) {
                return false;
            }
        }
        for (OrderRootType type : allTypes = OrderRootType.getAllTypes()) {
            Object[] orderedRootUrls2;
            Object[] orderedRootUrls1 = orderEntry1.getUrls(type);
            if (Arrays.equals(orderedRootUrls1, orderedRootUrls2 = orderEntry2.getUrls(type))) continue;
            return false;
        }
        return true;
    }

    void makeExternalChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            RootModelImpl.$$$reportNull$$$0(48);
        }
        if (this.myWritable || this.myDisposed) {
            return;
        }
        this.myModuleRootManager.makeRootsChange(runnable);
    }

    @Override
    public void dispose() {
        assert (!this.myDisposed);
        Disposer.dispose(this.myDisposable);
        this.myExtensions.clear();
        if (this.myExtensionToStateDigest != null) {
            this.myExtensionToStateDigest.clear();
        }
        this.myWritable = false;
        this.myDisposed = true;
    }

    private RootModelImpl getSourceModel() {
        this.assertWritable();
        return this.myModuleRootManager.getRootModel();
    }

    public String toString() {
        return "RootModelImpl{module=" + this.getModule().getName() + ", writable=" + this.myWritable + ", disposed=" + this.myDisposed + '}';
    }

    @Override
    @Nullable
    public <T> T getModuleExtension(@NotNull Class<T> klass) {
        if (klass == null) {
            RootModelImpl.$$$reportNull$$$0(49);
        }
        for (ModuleExtension extension : this.myExtensions) {
            if (!klass.isAssignableFrom(extension.getClass())) continue;
            return (T)extension;
        }
        return null;
    }

    void registerOnDispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            RootModelImpl.$$$reportNull$$$0(50);
        }
        this.myDisposable.add(disposable);
    }

    void checkModuleExtensionModification() {
        if (this.myExtensionToStateDigest == null || this.myExtensionToStateDigest.isEmpty()) {
            return;
        }
        for (Map.Entry<ModuleExtension, byte[]> entry : this.myExtensionToStateDigest.entrySet()) {
            Element state = new Element("state");
            try {
                ModuleExtension extension = entry.getKey();
                extension.writeExternal(state);
                byte[] newDigest = Scheme_implKt.digest(state);
                if (Arrays.equals(newDigest, entry.getValue())) continue;
                this.myModuleRootManager.stateChanged();
                return;
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }
    }

    static /* synthetic */ OrderEntry[] access$102(RootModelImpl x0, OrderEntry[] x1) {
        x0.myCachedOrderEntries = x1;
        return x1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRootManager";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointerManager";
                break;
            }
            case 3: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/RootModelImpl";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootConfigurationAccessor";
                break;
            }
            case 16: 
            case 17: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntries";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryClass";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry1";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry2";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/RootModelImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationAccessor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderIterator";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "addLibraryEntry";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addInvalidLibrary";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "addModuleOrderEntry";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "addInvalidModuleEntry";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleLibraryTable";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "addContentEntry";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 45: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setOrderEntriesFrom";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeContentEntry";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addOrderEntry";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryEntry";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addInvalidLibrary";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addModuleOrderEntry";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addInvalidModuleEntry";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryOrderEntry";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeOrderEntry";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeOrderEntryInternal";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "rearrangeOrderEntries";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "assertValidRearrangement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkValidRearrangement";
                break;
            }
            case 35: 
            case 37: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addContentEntry";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setInvalidSdk";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "replaceEntryOfType";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "orderEntriesEquals";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "makeExternalChange";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExtension";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "registerOnDispose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Order
    extends ArrayList<OrderEntry> {
        private Order() {
        }

        @Override
        public void clear() {
            super.clear();
            this.clearCachedEntries();
        }

        @Override
        @NotNull
        public OrderEntry set(int i2, @NotNull OrderEntry orderEntry) {
            if (orderEntry == null) {
                Order.$$$reportNull$$$0(0);
            }
            super.set(i2, orderEntry);
            ((OrderEntryBaseImpl)orderEntry).setIndex(i2);
            this.clearCachedEntries();
            OrderEntry orderEntry2 = orderEntry;
            if (orderEntry2 == null) {
                Order.$$$reportNull$$$0(1);
            }
            return orderEntry2;
        }

        @Override
        public boolean add(@NotNull OrderEntry orderEntry) {
            if (orderEntry == null) {
                Order.$$$reportNull$$$0(2);
            }
            super.add(orderEntry);
            ((OrderEntryBaseImpl)orderEntry).setIndex(this.size() - 1);
            this.clearCachedEntries();
            return true;
        }

        @Override
        public void add(int i2, OrderEntry orderEntry) {
            super.add(i2, orderEntry);
            this.clearCachedEntries();
            this.setIndicies(i2);
        }

        @Override
        public OrderEntry remove(int i2) {
            OrderEntry entry = (OrderEntry)super.remove(i2);
            this.setIndicies(i2);
            this.clearCachedEntries();
            return entry;
        }

        @Override
        public boolean remove(Object o) {
            int index = this.indexOf(o);
            if (index < 0) {
                return false;
            }
            this.remove(index);
            this.clearCachedEntries();
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends OrderEntry> collection) {
            int startSize = this.size();
            boolean result = super.addAll(collection);
            this.setIndicies(startSize);
            this.clearCachedEntries();
            return result;
        }

        @Override
        public boolean addAll(int i2, Collection<? extends OrderEntry> collection) {
            boolean result = super.addAll(i2, collection);
            this.setIndicies(i2);
            this.clearCachedEntries();
            return result;
        }

        @Override
        public void removeRange(int i2, int i1) {
            super.removeRange(i2, i1);
            this.clearCachedEntries();
            this.setIndicies(i2);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean result = super.removeAll(collection);
            this.setIndicies(0);
            this.clearCachedEntries();
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean result = super.retainAll(collection);
            this.setIndicies(0);
            this.clearCachedEntries();
            return result;
        }

        private void clearCachedEntries() {
            RootModelImpl.access$102(RootModelImpl.this, null);
        }

        private void setIndicies(int startIndex) {
            for (int j = startIndex; j < this.size(); ++j) {
                ((OrderEntryBaseImpl)this.get(j)).setIndex(j);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/RootModelImpl$Order";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/RootModelImpl$Order";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "set";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "set";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ContentComparator
    implements Comparator<ContentEntry> {
        public static final ContentComparator INSTANCE = new ContentComparator();

        private ContentComparator() {
        }

        @Override
        public int compare(@NotNull ContentEntry o1, @NotNull ContentEntry o2) {
            if (o1 == null) {
                ContentComparator.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                ContentComparator.$$$reportNull$$$0(1);
            }
            return o1.getUrl().compareTo(o2.getUrl());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/impl/RootModelImpl$ContentComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

