/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URLReference
implements PsiReference,
EmptyResolveMessageProvider {
    @NonNls
    public static final String TARGET_NAMESPACE_ATTR_NAME = "targetNamespace";
    private final PsiElement myElement;
    private final TextRange myRange;
    private final boolean mySoft;
    private boolean myIncorrectResourceMapped;

    public URLReference(PsiElement element) {
        this(element, null, false);
    }

    public URLReference(PsiElement element, @Nullable TextRange range, boolean soft) {
        this.myElement = element;
        this.myRange = range;
        this.mySoft = soft;
    }

    @Override
    public PsiElement getElement() {
        return this.myElement;
    }

    @Override
    public TextRange getRangeInElement() {
        return this.myRange != null ? this.myRange : ElementManipulators.getValueTextRange(this.myElement);
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        PsiFile file;
        this.myIncorrectResourceMapped = false;
        String canonicalText = this.getCanonicalText();
        if (canonicalText.isEmpty()) {
            XmlAttribute attr = PsiTreeUtil.getParentOfType(this.getElement(), XmlAttribute.class);
            if (attr != null && attr.isNamespaceDeclaration() && attr.getNamespacePrefix().isEmpty() || ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(canonicalText)) {
                return this.myElement;
            }
            return null;
        }
        if (ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(canonicalText)) {
            return this.myElement;
        }
        XmlTag tag = PsiTreeUtil.getParentOfType(this.myElement, XmlTag.class);
        if (tag != null && canonicalText.equals(tag.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME))) {
            return tag;
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        if (tag != null && tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance") == null && (file = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, containingFile, tag.getAttributeValue("version"))) != null) {
            return file;
        }
        if (containingFile instanceof XmlFile) {
            XmlDocument document = ((XmlFile)containingFile).getDocument();
            assert (document != null);
            XmlTag rootTag = document.getRootTag();
            if (rootTag == null) {
                return ExternalResourceManager.getInstance().getResourceLocation(canonicalText, containingFile, null);
            }
            XmlNSDescriptor nsDescriptor = rootTag.getNSDescriptor(canonicalText, true);
            if (nsDescriptor != null) {
                return nsDescriptor.getDescriptorFile();
            }
            String url = ExternalResourceManager.getInstance().getResourceLocation(canonicalText, this.myElement.getProject());
            if (!url.equals(canonicalText)) {
                this.myIncorrectResourceMapped = true;
                return null;
            }
            if (tag == rootTag && (tag.getNamespace().equals("http://www.w3.org/2001/XMLSchema") || tag.getNamespace().equals("http://schemas.xmlsoap.org/wsdl/"))) {
                for (XmlTag t2 : tag.getSubTags()) {
                    String name = t2.getLocalName();
                    if ("import".equals(name)) {
                        if (!canonicalText.equals(t2.getAttributeValue("namespace"))) continue;
                        return t2;
                    }
                    if (!"include".equals(name) && !"redefine".equals(name) && !"annotation".equals(name)) break;
                }
            }
            PsiElement[] result = new PsiElement[1];
            URLReference.processWsdlSchemas(rootTag, t -> {
                if (canonicalText.equals(t.getAttributeValue(TARGET_NAMESPACE_ATTR_NAME))) {
                    result[0] = t;
                    return false;
                }
                for (XmlTag anImport : t.findSubTags("import", t.getNamespace())) {
                    XmlAttribute location;
                    if (!canonicalText.equals(anImport.getAttributeValue("namespace")) || (location = anImport.getAttribute("schemaLocation")) == null) continue;
                    result[0] = FileReferenceUtil.findFile(location.getValueElement());
                }
                return true;
            });
            return result[0];
        }
        return null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String text2 = this.myElement.getText();
        if (text2.length() > 1) {
            String string = this.myRange == null ? text2.substring(1, text2.length() - 1) : this.myRange.substring(text2);
            if (string == null) {
                URLReference.$$$reportNull$$$0(0);
            }
            return string;
        }
        if ("" == null) {
            URLReference.$$$reportNull$$$0(1);
        }
        return "";
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        TextRange textRangeInElement = this.getRangeInElement();
        PsiElement elementToChange = this.myElement.findElementAt(textRangeInElement.getStartOffset());
        assert (elementToChange != null);
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getManipulator(elementToChange);
        assert (manipulator != null);
        int offsetFromStart = this.myElement.getTextRange().getStartOffset() + textRangeInElement.getStartOffset() - elementToChange.getTextOffset();
        manipulator.handleContentChange(elementToChange, new TextRange(offsetFromStart, offsetFromStart + textRangeInElement.getLength()), newElementName);
        return this.myElement;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            URLReference.$$$reportNull$$$0(2);
        }
        assert (element instanceof PsiFile);
        if (!XmlUtil.isUrlText(this.getCanonicalText(), element.getProject())) {
            VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
            assert (virtualFile != null);
            this.handleElementRename(VfsUtilCore.fixIDEAUrl(virtualFile.getPresentableUrl()));
        }
        return this.myElement;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            URLReference.$$$reportNull$$$0(3);
        }
        return EMPTY_ARRAY;
    }

    public boolean isSchemaLocation() {
        return false;
    }

    @Override
    public boolean isSoft() {
        return this.mySoft;
    }

    @Override
    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = XmlErrorMessages.message(this.myIncorrectResourceMapped ? "registered.resource.is.not.recognized" : "uri.is.not.registered", new Object[0]);
        if (string == null) {
            URLReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void processWsdlSchemas(XmlTag rootTag, Processor<XmlTag> processor) {
        String nsPrefix;
        String types;
        XmlTag subTag;
        if ("definitions".equals(rootTag.getLocalName()) && (subTag = rootTag.findFirstSubTag(types = (nsPrefix = rootTag.getNamespacePrefix()).isEmpty() ? "types" : nsPrefix + ":types")) != null) {
            for (int i2 = 0; i2 < XmlUtil.SCHEMA_URIS.length; ++i2) {
                XmlTag[] tags;
                for (XmlTag t : tags = subTag.findSubTags("schema", XmlUtil.SCHEMA_URIS[i2])) {
                    if (processor.process(t)) continue;
                    return;
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/URLReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

