/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class StubProcessingHelperBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.StubProcessingHelperBase");

    private static IElementType stubType(@NotNull StubElement<?> stub) {
        if (stub == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(0);
        }
        if (stub instanceof PsiFileStub) {
            return ((PsiFileStub)stub).getType();
        }
        return stub.getStubType();
    }

    public <Psi extends PsiElement> boolean processStubsInFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull StubIdList value, @NotNull Processor<? super Psi> processor, @NotNull Class<Psi> requiredClass) {
        if (project == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(1);
        }
        if (file == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(2);
        }
        if (value == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(4);
        }
        if (requiredClass == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(5);
        }
        return this.processStubsInFile(project, file, value, processor, requiredClass, false);
    }

    public <Psi extends PsiElement> boolean processStubsInFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull StubIdList value, @NotNull Processor<? super Psi> processor, @NotNull Class<Psi> requiredClass, boolean skipOnErrors) {
        FileViewProvider viewProvider;
        PsiFile stubBindingRoot;
        if (project == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(6);
        }
        if (file == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(7);
        }
        if (value == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(9);
        }
        if (requiredClass == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(10);
        }
        StubTree stubTree = null;
        PsiFile candidatePsiFile = PsiManager.getInstance(project).findFile(file);
        PsiFileWithStubSupport psiFile = null;
        boolean customStubs = false;
        if (candidatePsiFile != null && !(candidatePsiFile instanceof PsiPlainTextFile) && (stubBindingRoot = (viewProvider = candidatePsiFile.getViewProvider()).getStubBindingRoot()) instanceof PsiFileWithStubSupport && (stubTree = (psiFile = (PsiFileWithStubSupport)stubBindingRoot).getStubTree()) == null && psiFile instanceof PsiFileImpl) {
            IStubFileElementType elementType = ((PsiFileImpl)psiFile).getElementTypeForStubBuilder();
            if (elementType != null) {
                stubTree = ((PsiFileImpl)psiFile).calcStubTree();
            } else {
                customStubs = true;
                if (BinaryFileStubBuilders.INSTANCE.forFileType(psiFile.getFileType()) == null) {
                    LOG.error("unable to get stub builder for " + psiFile.getFileType() + ", " + StubTreeLoader.getFileViewProviderMismatchDiagnostics(viewProvider));
                }
            }
        }
        if (stubTree == null && psiFile == null) {
            return true;
        }
        if (stubTree == null) {
            ObjectStubTree objectStubTree = StubTreeLoader.getInstance().readFromVFile(project, file);
            if (objectStubTree == null) {
                return true;
            }
            if (customStubs && !(objectStubTree instanceof StubTree)) {
                if (!skipOnErrors && !requiredClass.isInstance(psiFile)) {
                    this.inconsistencyDetected(objectStubTree, psiFile);
                    return true;
                }
                return processor.process(psiFile);
            }
            stubTree = (StubTree)objectStubTree;
            List<StubElement<?>> plained = stubTree.getPlainListFromAllRoots();
            int size = value.size();
            for (int i2 = 0; i2 < size; ++i2) {
                int stubTreeIndex = value.get(i2);
                if (stubTreeIndex >= plained.size()) {
                    if (skipOnErrors) break;
                    this.onInternalError(file);
                    break;
                }
                ProgressManager.checkCanceled();
                StubElement<?> stub = plained.get(stubTreeIndex);
                PsiUtilCore.ensureValid(psiFile);
                ASTNode tree = psiFile.findTreeForStub(stubTree, stub);
                if (tree == null) continue;
                if (tree.getElementType() == StubProcessingHelperBase.stubType(stub)) {
                    PsiElement psi = tree.getPsi();
                    PsiUtilCore.ensureValid(psi);
                    if (!skipOnErrors && !requiredClass.isInstance(psi)) {
                        this.inconsistencyDetected(stubTree, psiFile);
                        break;
                    }
                    if (processor.process(psi)) continue;
                    return false;
                }
                if (skipOnErrors) continue;
                String persistedStubTree = ((PsiFileStubImpl)stubTree.getRoot()).printTree();
                String stubTreeJustBuilt = ((PsiFileStubImpl)((PsiFileImpl)psiFile).getElementTypeForStubBuilder().getBuilder().buildStubTree(psiFile)).printTree();
                StringBuilder builder = new StringBuilder();
                builder.append("Oops\n");
                builder.append("Recorded stub:-----------------------------------\n");
                builder.append(persistedStubTree);
                builder.append("\nAST built stub: ------------------------------------\n");
                builder.append(stubTreeJustBuilt);
                builder.append("\n");
                LOG.info(builder.toString());
                this.onInternalError(file);
            }
        } else {
            List<StubElement<?>> plained = stubTree.getPlainListFromAllRoots();
            int size = value.size();
            for (int i3 = 0; i3 < size; ++i3) {
                int stubTreeIndex = value.get(i3);
                if (stubTreeIndex >= plained.size()) {
                    if (skipOnErrors) break;
                    this.inconsistencyDetected(stubTree, psiFile);
                    break;
                }
                Object psi = plained.get(stubTreeIndex).getPsi();
                PsiUtilCore.ensureValid(psi);
                if (!skipOnErrors && !requiredClass.isInstance(psi)) {
                    this.inconsistencyDetected(stubTree, psiFile);
                    break;
                }
                if (processor.process(psi)) continue;
                return false;
            }
        }
        return true;
    }

    private void inconsistencyDetected(@NotNull ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile) {
        if (stubTree == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(11);
        }
        if (psiFile == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(12);
        }
        LOG.error(StubTreeLoader.getInstance().stubTreeAndIndexDoNotMatch("PSI and index do not match.", stubTree, psiFile));
        this.onInternalError(psiFile.getVirtualFile());
    }

    protected abstract void onInternalError(VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubTree";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/stubs/StubProcessingHelperBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "stubType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processStubsInFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "inconsistencyDetected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

