/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedName
implements Comparable<QualifiedName> {
    @NotNull
    private final List<String> myComponents;

    private QualifiedName(int count) {
        this.myComponents = new ArrayList<String>(count);
    }

    public static QualifiedName fromComponents(Collection<String> components) {
        for (String component : components) {
            QualifiedName.assertNoDots(component);
        }
        QualifiedName qName = new QualifiedName(components.size());
        qName.myComponents.addAll(components);
        return qName;
    }

    @NotNull
    public static QualifiedName fromComponents(String ... components) {
        for (String component : components) {
            QualifiedName.assertNoDots(component);
        }
        QualifiedName result = new QualifiedName(components.length);
        Collections.addAll(result.myComponents, components);
        QualifiedName qualifiedName = result;
        if (qualifiedName == null) {
            QualifiedName.$$$reportNull$$$0(0);
        }
        return qualifiedName;
    }

    public QualifiedName append(String name) {
        QualifiedName result = new QualifiedName(this.myComponents.size() + 1);
        result.myComponents.addAll(this.myComponents);
        result.myComponents.add(name);
        return result;
    }

    public QualifiedName append(QualifiedName qName) {
        QualifiedName result = new QualifiedName(this.myComponents.size() + qName.getComponentCount());
        result.myComponents.addAll(this.myComponents);
        result.myComponents.addAll(qName.getComponents());
        return result;
    }

    @NotNull
    public QualifiedName removeLastComponent() {
        QualifiedName qualifiedName = this.removeTail(1);
        if (qualifiedName == null) {
            QualifiedName.$$$reportNull$$$0(1);
        }
        return qualifiedName;
    }

    @NotNull
    public QualifiedName removeTail(int count) {
        int size = this.myComponents.size();
        QualifiedName result = new QualifiedName(size);
        result.myComponents.addAll(this.myComponents);
        for (int i2 = 0; i2 < count && !result.myComponents.isEmpty(); ++i2) {
            result.myComponents.remove(result.myComponents.size() - 1);
        }
        QualifiedName qualifiedName = result;
        if (qualifiedName == null) {
            QualifiedName.$$$reportNull$$$0(2);
        }
        return qualifiedName;
    }

    @NotNull
    public QualifiedName removeHead(int count) {
        int size = this.myComponents.size();
        QualifiedName result = new QualifiedName(size);
        result.myComponents.addAll(this.myComponents);
        for (int i2 = 0; i2 < count && !result.myComponents.isEmpty(); ++i2) {
            result.myComponents.remove(0);
        }
        QualifiedName qualifiedName = result;
        if (qualifiedName == null) {
            QualifiedName.$$$reportNull$$$0(3);
        }
        return qualifiedName;
    }

    @NotNull
    public List<String> getComponents() {
        List<String> list = this.myComponents;
        if (list == null) {
            QualifiedName.$$$reportNull$$$0(4);
        }
        return list;
    }

    public int getComponentCount() {
        return this.myComponents.size();
    }

    public boolean matches(String ... components) {
        if (this.myComponents.size() != components.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.myComponents.size(); ++i2) {
            if (this.myComponents.get(i2).equals(components[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean matchesPrefix(QualifiedName prefix) {
        if (this.getComponentCount() < prefix.getComponentCount()) {
            return false;
        }
        for (int i2 = 0; i2 < prefix.getComponentCount(); ++i2) {
            String component = this.getComponents().get(i2);
            if (component != null && component.equals(prefix.getComponents().get(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(@NotNull String suffix) {
        if (suffix == null) {
            QualifiedName.$$$reportNull$$$0(5);
        }
        return suffix.equals(this.getLastComponent());
    }

    public static void serialize(@Nullable QualifiedName qName, StubOutputStream dataStream) throws IOException {
        if (qName == null) {
            dataStream.writeVarInt(0);
        } else {
            dataStream.writeVarInt(qName.getComponentCount());
            for (String s : qName.myComponents) {
                dataStream.writeName(s);
            }
        }
    }

    @Nullable
    public static QualifiedName deserialize(StubInputStream dataStream) throws IOException {
        QualifiedName qName;
        int size = dataStream.readVarInt();
        if (size == 0) {
            qName = null;
        } else {
            qName = new QualifiedName(size);
            for (int i2 = 0; i2 < size; ++i2) {
                StringRef name = dataStream.readName();
                qName.myComponents.add(name == null ? null : name.getString());
            }
        }
        return qName;
    }

    @Nullable
    public String getFirstComponent() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        return this.myComponents.get(0);
    }

    @Nullable
    public String getLastComponent() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        return this.myComponents.get(this.myComponents.size() - 1);
    }

    public String toString() {
        return this.join(".");
    }

    public String join(String separator) {
        return StringUtil.join(this.myComponents, separator);
    }

    @NotNull
    public static QualifiedName fromDottedString(@NotNull String refName) {
        if (refName == null) {
            QualifiedName.$$$reportNull$$$0(6);
        }
        QualifiedName qualifiedName = QualifiedName.fromComponents(refName.split("\\."));
        if (qualifiedName == null) {
            QualifiedName.$$$reportNull$$$0(7);
        }
        return qualifiedName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return this.myComponents.equals(that.myComponents);
    }

    public int hashCode() {
        return this.myComponents.hashCode();
    }

    public QualifiedName subQualifiedName(int fromIndex, int toIndex) {
        return QualifiedName.fromComponents(this.myComponents.subList(fromIndex, toIndex));
    }

    @Override
    public int compareTo(@NotNull QualifiedName other) {
        if (other == null) {
            QualifiedName.$$$reportNull$$$0(8);
        }
        return this.toString().compareTo(other.toString());
    }

    private static void assertNoDots(@NotNull String component) {
        if (component == null) {
            QualifiedName.$$$reportNull$$$0(9);
        }
        if (component.contains(".")) {
            throw new IllegalArgumentException("Components of QualifiedName cannot contain dots inside them, but got: " + component);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/QualifiedName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromComponents";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTail";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHead";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/QualifiedName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDottedString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromDottedString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertNoDots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

