/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.IntArrayList;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ByteTrie {
    private static final String EMPTY_STRING = "";
    private final ArrayList<Node> myAllNodes = new ArrayList();

    public ByteTrie() {
        Node root = new Node(-1, 0);
        this.myAllNodes.add(root);
    }

    public int size() {
        return this.myAllNodes.size();
    }

    public int getHashCode(String s) {
        return this.getHashCode(s.getBytes(CharsetToolkit.UTF8_CHARSET));
    }

    public String getString(int hashCode) {
        return new String(this.getBytes(hashCode), CharsetToolkit.UTF8_CHARSET);
    }

    public int getHashCodeForReversedString(String s) {
        return this.getHashCodeForReversedBytes(s.getBytes(CharsetToolkit.UTF8_CHARSET));
    }

    public String getReversedString(int hashCode) {
        return new String(this.getReversedBytes(hashCode), CharsetToolkit.UTF8_CHARSET);
    }

    public int getHashCode(byte[] bytes) {
        return this.getHashCode(bytes, 0, bytes.length);
    }

    public int getHashCode(byte[] bytes, int offset, int length) {
        int index = 0;
        while (length-- > 0) {
            index = this.getSubNode(index, bytes[offset++]);
        }
        return index;
    }

    public long getMaximumMatch(byte[] bytes, int offset, int length) {
        int nextIndex;
        int index = 0;
        int resultingLength = 0;
        while (length-- > 0 && (nextIndex = this.searchForSubNode(index, bytes[offset++])) != 0) {
            index = nextIndex;
            ++resultingLength;
        }
        return (long)index + ((long)resultingLength << 32);
    }

    @NotNull
    public byte[] getBytes(int hashCode) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        while (hashCode > 0) {
            Node node = this.myAllNodes.get(hashCode);
            this.writeByte(stream, node.myChar);
            hashCode = node.myParent;
        }
        byte[] bytes = stream.toByteArray();
        int i2 = 0;
        for (int j = bytes.length - 1; i2 < j; ++i2, --j) {
            byte swap = bytes[i2];
            bytes[i2] = bytes[j];
            bytes[j] = swap;
        }
        if (bytes == null) {
            ByteTrie.$$$reportNull$$$0(0);
        }
        return bytes;
    }

    public int getHashCodeForReversedBytes(byte[] bytes) {
        return this.getHashCodeForReversedBytes(bytes, bytes.length - 1, bytes.length);
    }

    public int getHashCodeForReversedBytes(byte[] bytes, int offset, int length) {
        int index = 0;
        while (length-- > 0) {
            index = this.getSubNode(index, bytes[offset--]);
        }
        return index;
    }

    @NotNull
    public byte[] getReversedBytes(int hashCode) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        while (hashCode > 0) {
            Node node = this.myAllNodes.get(hashCode);
            this.writeByte(stream, node.myChar);
            hashCode = node.myParent;
        }
        byte[] byArray = stream.toByteArray();
        if (byArray == null) {
            ByteTrie.$$$reportNull$$$0(1);
        }
        return byArray;
    }

    private int getSubNode(int parentIndex, byte b) {
        int index;
        Node parentNode = this.myAllNodes.get(parentIndex);
        if (parentNode.myChildren == null) {
            parentNode.myChildren = new IntArrayList(1);
        }
        IntArrayList children = parentNode.myChildren;
        int left = 0;
        int right = children.size() - 1;
        while (left <= right) {
            int middle = left + right >> 1;
            index = children.get(middle);
            Node node = this.myAllNodes.get(index);
            int comp = node.myChar - b;
            if (comp == 0) {
                return index;
            }
            if (comp < 0) {
                left = middle + 1;
                continue;
            }
            right = middle - 1;
        }
        index = this.myAllNodes.size();
        children.add(left, index);
        this.myAllNodes.add(new Node(parentIndex, b));
        return index;
    }

    private int searchForSubNode(int parentIndex, byte b) {
        Node parentNode = this.myAllNodes.get(parentIndex);
        IntArrayList children = parentNode.myChildren;
        if (children == null) {
            return 0;
        }
        int left = 0;
        int right = children.size() - 1;
        while (left <= right) {
            int middle = left + right >> 1;
            int index = children.get(middle);
            Node node = this.myAllNodes.get(index);
            int comp = node.myChar - b;
            if (comp == 0) {
                return index;
            }
            if (comp < 0) {
                left = middle + 1;
                continue;
            }
            right = middle - 1;
        }
        return 0;
    }

    void writeByte(ByteArrayOutputStream stream, byte b) {
        int out = b;
        if (out < 0) {
            out += 256;
        }
        stream.write(out);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/containers/ByteTrie";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReversedBytes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Node {
        private final byte myChar;
        private final int myParent;
        private IntArrayList myChildren;

        Node(int parent, byte b) {
            this.myChar = b;
            this.myParent = parent;
        }
    }
}

