/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.SLRUCache;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class RecentStringInterner {
    private final int myStripeMask;
    private final SLRUCache<String, String>[] myInterns;
    private final Lock[] myStripeLocks;

    public RecentStringInterner(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RecentStringInterner.$$$reportNull$$$0(0);
        }
        int stripes = 16;
        this.myInterns = new SLRUCache[16];
        this.myStripeLocks = new Lock[this.myInterns.length];
        int capacity = 8192;
        for (int i2 = 0; i2 < this.myInterns.length; ++i2) {
            this.myInterns[i2] = new SLRUCache<String, String>(capacity / 16, capacity / 16){

                @Override
                @NotNull
                public String createValue(String key) {
                    String string = key;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                protected void putToProtectedQueue(String key, String value) {
                    super.putToProtectedQueue(value, value);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/RecentStringInterner$1", "createValue"));
                }
            };
            this.myStripeLocks[i2] = new ReentrantLock();
        }
        assert (Integer.highestOneBit(16) == 16);
        this.myStripeMask = 15;
        LowMemoryWatcher.register(new Runnable(){

            @Override
            public void run() {
                RecentStringInterner.this.clear();
            }
        }, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String s) {
        if (s == null) {
            return null;
        }
        int stripe = Math.abs(s.hashCode()) & this.myStripeMask;
        try {
            this.myStripeLocks[stripe].lock();
            String string = this.myInterns[stripe].get(s);
            return string;
        }
        finally {
            this.myStripeLocks[stripe].unlock();
        }
    }

    public void clear() {
        for (int i2 = 0; i2 < this.myInterns.length; ++i2) {
            try {
                this.myStripeLocks[i2].lock();
                this.myInterns[i2].clear();
                continue;
            }
            finally {
                this.myStripeLocks[i2].unlock();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/containers/RecentStringInterner", "<init>"));
    }
}

