/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class EmptyStatementBodyInspection
extends BaseInspection {
    public boolean m_reportEmptyBlocks = true;
    public boolean commentsAreContent = false;

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            EmptyStatementBodyInspection.$$$reportNull$$$0(0);
        }
        node.addContent(new Element("option").setAttribute("name", "m_reportEmptyBlocks").setAttribute("value", String.valueOf(this.m_reportEmptyBlocks)));
        if (this.commentsAreContent) {
            node.addContent(new Element("option").setAttribute("name", "commentsAreContent").setAttribute("value", "true"));
        }
    }

    @Override
    @NotNull
    public String getID() {
        if ("StatementWithEmptyBody" == null) {
            EmptyStatementBodyInspection.$$$reportNull$$$0(1);
        }
        return "StatementWithEmptyBody";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("statement.with.empty.body.display.name", new Object[0]);
        if (string == null) {
            EmptyStatementBodyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("statement.with.empty.body.problem.descriptor", new Object[0]);
        if (string == null) {
            EmptyStatementBodyInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("statement.with.empty.body.include.option", new Object[0]), "m_reportEmptyBlocks");
        panel.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.comments.option", new Object[0]), "commentsAreContent");
        return panel;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/EmptyStatementBodyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/EmptyStatementBodyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EmptyStatementVisitor
    extends BaseInspectionVisitor {
        private EmptyStatementVisitor() {
        }

        @Override
        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitDoWhileStatement(statement);
            this.checkLoopStatement(statement);
        }

        @Override
        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(1);
            }
            super.visitWhileStatement(statement);
            this.checkLoopStatement(statement);
        }

        @Override
        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(2);
            }
            super.visitForStatement(statement);
            this.checkLoopStatement(statement);
        }

        @Override
        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(3);
            }
            super.visitForeachStatement(statement);
            this.checkLoopStatement(statement);
        }

        private void checkLoopStatement(PsiLoopStatement statement) {
            PsiStatement body = statement.getBody();
            if (body == null || !this.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        @Override
        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(4);
            }
            super.visitIfStatement(statement);
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch != null && this.isEmpty(thenBranch)) {
                this.registerStatementError(statement, new Object[0]);
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch != null && this.isEmpty(elseBranch)) {
                PsiKeyword elseToken = statement.getElseElement();
                if (elseToken == null) {
                    return;
                }
                this.registerError((PsiElement)elseToken, new Object[0]);
            }
        }

        @Override
        public void visitSwitchStatement(PsiSwitchStatement statement) {
            super.visitSwitchStatement(statement);
            PsiCodeBlock body = statement.getBody();
            if (body == null || !this.isEmpty(body)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private boolean isEmpty(PsiElement element) {
            if (!EmptyStatementBodyInspection.this.commentsAreContent && element instanceof PsiComment) {
                return true;
            }
            if (element instanceof PsiEmptyStatement) {
                return !EmptyStatementBodyInspection.this.commentsAreContent || PsiTreeUtil.getChildOfType(element, PsiComment.class) == null && !(PsiTreeUtil.skipWhitespacesBackward(element) instanceof PsiComment);
            }
            if (element instanceof PsiWhiteSpace) {
                return true;
            }
            if (element instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)element;
                return this.isEmpty(block.getCodeBlock());
            }
            if (EmptyStatementBodyInspection.this.m_reportEmptyBlocks && element instanceof PsiCodeBlock) {
                PsiCodeBlock codeBlock = (PsiCodeBlock)element;
                PsiElement[] children = codeBlock.getChildren();
                if (children.length == 2) {
                    return true;
                }
                for (int i2 = 1; i2 < children.length - 1; ++i2) {
                    PsiElement child = children[i2];
                    if (this.isEmpty(child)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

