/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessNullCheckInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.nullcheck.display.name", new Object[0]);
        if (string == null) {
            PointlessNullCheckInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression parent = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)infos[1], PsiInstanceOfExpression.class, PsiMethodCallExpression.class);
        if (parent instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("pointless.nullcheck.problem.descriptor.call", ((PsiMethodCallExpression)parent).getMethodExpression().getReferenceName());
            if (string == null) {
                PointlessNullCheckInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("pointless.nullcheck.problem.descriptor.instanceof", new Object[0]);
        if (string == null) {
            PointlessNullCheckInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessNullCheckVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        return new PointlessNullCheckFix(expression.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/PointlessNullCheckInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PointlessNullCheckVisitor
    extends BaseInspectionVisitor {
        private PointlessNullCheckVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            IElementType operationTokenType = expression.getOperationTokenType();
            if (operationTokenType.equals(JavaTokenType.ANDAND)) {
                this.checkAndChain(expression);
            } else if (operationTokenType.equals(JavaTokenType.OROR)) {
                this.checkOrChain(expression);
            }
        }

        private void checkOrChain(PsiPolyadicExpression expression) {
            PsiExpression[] operands = expression.getOperands();
            for (int i2 = 0; i2 < operands.length - 1; ++i2) {
                IElementType tokenType;
                PsiBinaryExpression binaryExpression = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(operands[i2]), PsiBinaryExpression.class);
                if (binaryExpression == null || !(tokenType = binaryExpression.getOperationTokenType()).equals(JavaTokenType.EQEQ)) continue;
                for (int j = i2 + 1; j < operands.length; ++j) {
                    PsiExpression implicitCheckCandidate = BoolUtils.getNegated(PsiUtil.skipParenthesizedExprDown(operands[j]));
                    if (!this.checkExpressions(operands, i2, j, binaryExpression, implicitCheckCandidate)) continue;
                    return;
                }
            }
        }

        private void checkAndChain(PsiPolyadicExpression expression) {
            PsiExpression[] operands = expression.getOperands();
            for (int i2 = 0; i2 < operands.length - 1; ++i2) {
                IElementType tokenType;
                PsiBinaryExpression binaryExpression = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(operands[i2]), PsiBinaryExpression.class);
                if (binaryExpression == null || !(tokenType = binaryExpression.getOperationTokenType()).equals(JavaTokenType.NE)) continue;
                for (int j = i2 + 1; j < operands.length; ++j) {
                    PsiExpression implicitCheckCandidate = PsiUtil.skipParenthesizedExprDown(operands[j]);
                    if (!this.checkExpressions(operands, i2, j, binaryExpression, implicitCheckCandidate)) continue;
                    return;
                }
            }
        }

        private boolean checkExpressions(PsiExpression[] operands, int i2, int j, PsiBinaryExpression binaryExpression, PsiExpression implicitCheckCandidate) {
            PsiReferenceExpression explicitCheckReference = PointlessNullCheckVisitor.getReferenceFromNullCheck(binaryExpression);
            if (explicitCheckReference == null) {
                return false;
            }
            PsiVariable variable = ObjectUtils.tryCast(explicitCheckReference.resolve(), PsiVariable.class);
            PsiReferenceExpression implicitCheckReference = PointlessNullCheckVisitor.getReferenceFromImplicitNullCheckExpression(implicitCheckCandidate);
            if (implicitCheckReference == null || !implicitCheckReference.isReferenceTo(variable)) {
                return false;
            }
            if (PointlessNullCheckVisitor.isVariableUsed(operands, i2, j, variable)) {
                return false;
            }
            this.registerError((PsiElement)binaryExpression, binaryExpression, implicitCheckReference);
            return true;
        }

        private static boolean isVariableUsed(PsiExpression[] operands, int i2, int j, PsiVariable variable) {
            return Arrays.stream(operands, i2 + 1, j).anyMatch(op -> VariableAccessUtils.variableIsUsed(variable, op));
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromNullCheck(PsiBinaryExpression expression) {
            PsiExpression comparedWithNull = ExpressionUtils.getValueComparedWithNull(expression);
            return ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(comparedWithNull), PsiReferenceExpression.class);
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromImplicitNullCheckExpression(PsiExpression expression) {
            PsiReferenceExpression checked = PointlessNullCheckVisitor.getReferenceFromInstanceofExpression(expression = PsiUtil.skipParenthesizedExprDown(expression));
            if (checked == null) {
                checked = PointlessNullCheckVisitor.getReferenceFromBooleanCall(expression);
            }
            if (checked == null) {
                checked = PointlessNullCheckVisitor.getReferenceFromOrChain(expression);
            }
            return checked;
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromInstanceofExpression(PsiExpression expression) {
            if (!(expression instanceof PsiInstanceOfExpression)) {
                return null;
            }
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown(((PsiInstanceOfExpression)expression).getOperand());
            return ObjectUtils.tryCast(operand, PsiReferenceExpression.class);
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromBooleanCall(PsiExpression expression) {
            if (!(expression instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (!PsiType.BOOLEAN.equals(call.getType())) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return null;
            }
            List<? extends MethodContract> contracts2 = ControlFlowAnalyzer.getMethodCallContracts(method, call);
            if (contracts2.isEmpty()) {
                return null;
            }
            StandardMethodContract contract = ObjectUtils.tryCast(contracts2.get(0), StandardMethodContract.class);
            if (contract == null || contract.getReturnValue() != MethodContract.ValueConstraint.FALSE_VALUE) {
                return null;
            }
            MethodContract.ValueConstraint[] arguments = contract.arguments;
            int idx = -1;
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                if (arguments[i2] == MethodContract.ValueConstraint.NULL_VALUE) {
                    if (idx != -1) {
                        return null;
                    }
                    idx = i2;
                    continue;
                }
                if (arguments[i2] == MethodContract.ValueConstraint.ANY_VALUE) continue;
                return null;
            }
            if (idx == -1) {
                return null;
            }
            PsiExpression[] args = ((PsiMethodCallExpression)expression).getArgumentList().getExpressions();
            if (args.length <= idx || method.isVarArgs() && idx == args.length - 1) {
                return null;
            }
            PsiReferenceExpression reference = ObjectUtils.tryCast(args[idx], PsiReferenceExpression.class);
            if (reference == null) {
                return null;
            }
            PsiVariable target = ObjectUtils.tryCast(reference.resolve(), PsiVariable.class);
            if (target == null) {
                return null;
            }
            if (!SyntaxTraverser.psiTraverser(call).filter(PsiReference.class).filter(ref -> !reference.equals(ref) && ref.isReferenceTo(target)).isEmpty()) {
                return null;
            }
            return reference;
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromOrChain(PsiExpression expression) {
            if (!(expression instanceof PsiPolyadicExpression)) {
                return null;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.OROR != tokenType) {
                return null;
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            PsiReferenceExpression referenceExpression = PointlessNullCheckVisitor.getReferenceFromImplicitNullCheckExpression(operands[0]);
            if (referenceExpression == null) {
                return null;
            }
            PsiVariable variable = ObjectUtils.tryCast(referenceExpression.resolve(), PsiVariable.class);
            int operandsLength = operands.length;
            for (int i2 = 1; i2 < operandsLength; ++i2) {
                PsiReferenceExpression reference2 = PointlessNullCheckVisitor.getReferenceFromImplicitNullCheckExpression(operands[i2]);
                if (reference2 != null && reference2.isReferenceTo(variable)) continue;
                return null;
            }
            return referenceExpression;
        }
    }

    private static class PointlessNullCheckFix
    extends InspectionGadgetsFix {
        private final String myExpressionText;

        public PointlessNullCheckFix(String expressionText) {
            this.myExpressionText = expressionText;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("pointless.nullcheck.simplify.quickfix", this.myExpressionText);
            if (string == null) {
                PointlessNullCheckFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                PointlessNullCheckFix.$$$reportNull$$$0(1);
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiPolyadicExpression polyadicExpression = PsiTreeUtil.getParentOfType(element, PsiPolyadicExpression.class);
            if (polyadicExpression == null) {
                return;
            }
            Object[] children = polyadicExpression.getChildren();
            int start = IntStreamEx.ofIndices((Object[])children, child -> PsiTreeUtil.isAncestor(child, element, false)).findFirst().orElse(-1);
            if (start == -1) {
                return;
            }
            int end = IntStreamEx.range((int)(start + 1), (int)children.length).findFirst(arg_0 -> PointlessNullCheckFix.lambda$doFix$1((PsiElement[])children, arg_0)).orElse(-1);
            if (end == -1) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = IntStreamEx.range((int)0, (int)start).append((IntStream)IntStreamEx.range((int)end, (int)children.length)).elements(children).map(ct::text).joining();
            ct.replaceAndRestoreComments((PsiElement)polyadicExpression, replacement);
        }

        private static /* synthetic */ boolean lambda$doFix$1(PsiElement[] children, int idx) {
            return children[idx] instanceof PsiExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/controlflow/PointlessNullCheckInspection$PointlessNullCheckFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

