/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class LocalVariableNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 20;
    public boolean m_ignoreForLoopParameters = false;
    public boolean m_ignoreCatchParameters = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("local.variable.naming.convention.display.name", new Object[0]);
        if (string == null) {
            LocalVariableNamingConventionInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("local.variable.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 20;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/LocalVariableNamingConventionInspectionBase", "getDisplayName"));
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            PsiForStatement forLoop;
            PsiStatement initialization;
            PsiElement grandparent;
            PsiElement parent;
            if (variable == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            super.visitLocalVariable(variable);
            if (LocalVariableNamingConventionInspectionBase.this.m_ignoreForLoopParameters && (parent = variable.getParent()) != null && (grandparent = parent.getParent()) instanceof PsiForStatement && parent.equals(initialization = (forLoop = (PsiForStatement)grandparent).getInitialization())) {
                return;
            }
            String name = variable.getName();
            if (name == null) {
                return;
            }
            if (LocalVariableNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            this.registerVariableError(variable, name);
        }

        @Override
        public void visitParameter(@NotNull PsiParameter variable) {
            if (variable == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(1);
            }
            PsiElement scope = variable.getDeclarationScope();
            boolean isCatchParameter = scope instanceof PsiCatchSection;
            boolean isForeachParameter = scope instanceof PsiForeachStatement;
            if (!isCatchParameter && !isForeachParameter) {
                return;
            }
            if (LocalVariableNamingConventionInspectionBase.this.m_ignoreCatchParameters && isCatchParameter) {
                return;
            }
            if (LocalVariableNamingConventionInspectionBase.this.m_ignoreForLoopParameters && isForeachParameter) {
                return;
            }
            String name = variable.getName();
            if (name == null) {
                return;
            }
            if (LocalVariableNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            this.registerVariableError(variable, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "variable";
            objectArray2[1] = "com/siyeh/ig/naming/LocalVariableNamingConventionInspectionBase$NamingConventionsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

