/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeUtils {
    private ExpectedTypeUtils() {
    }

    @Nullable
    public static PsiType findExpectedType(@NotNull PsiExpression expression, boolean calculateTypeForComplexReferences) {
        if (expression == null) {
            ExpectedTypeUtils.$$$reportNull$$$0(0);
        }
        return ExpectedTypeUtils.findExpectedType(expression, calculateTypeForComplexReferences, false);
    }

    public static PsiType findExpectedType(PsiExpression expression, boolean calculateTypeForComplexReferences, boolean reportCasts) {
        PsiElement context = expression.getParent();
        PsiExpression wrappedExpression = expression;
        while (context instanceof PsiParenthesizedExpression) {
            wrappedExpression = (PsiExpression)context;
            context = context.getParent();
        }
        if (context == null) {
            return null;
        }
        ExpectedTypeVisitor visitor = new ExpectedTypeVisitor(wrappedExpression, calculateTypeForComplexReferences, reportCasts);
        context.accept(visitor);
        return visitor.getExpectedType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ExpectedTypeUtils", "findExpectedType"));
    }

    private static class ExpectedTypeVisitor
    extends JavaElementVisitor {
        private static final Set<IElementType> arithmeticOps = new THashSet(5);
        private static final Set<IElementType> booleanOps = new THashSet(5);
        private static final Set<IElementType> shiftOps = new THashSet(3);
        private static final Set<IElementType> operatorAssignmentOps = new THashSet(11);
        @NotNull
        private final PsiExpression wrappedExpression;
        private final boolean calculateTypeForComplexReferences;
        private final boolean reportCasts;
        private PsiType expectedType;

        ExpectedTypeVisitor(@NotNull PsiExpression wrappedExpression, boolean calculateTypeForComplexReferences, boolean reportCasts) {
            if (wrappedExpression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(0);
            }
            this.expectedType = null;
            this.wrappedExpression = wrappedExpression;
            this.calculateTypeForComplexReferences = calculateTypeForComplexReferences;
            this.reportCasts = reportCasts;
        }

        public PsiType getExpectedType() {
            return this.expectedType;
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            PsiExpression initializer;
            if (field == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(1);
            }
            if (this.wrappedExpression.equals(initializer = field.getInitializer())) {
                this.expectedType = field.getType();
            }
        }

        @Override
        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(2);
            }
            this.expectedType = variable.getType();
        }

        @Override
        public void visitAssertStatement(PsiAssertStatement statement) {
            PsiExpression condition = statement.getAssertCondition();
            this.expectedType = this.wrappedExpression == condition ? PsiType.BOOLEAN : TypeUtils.getStringType(statement);
        }

        @Override
        public void visitArrayInitializerExpression(PsiArrayInitializerExpression initializer) {
            PsiType type = initializer.getType();
            if (!(type instanceof PsiArrayType)) {
                this.expectedType = null;
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            this.expectedType = arrayType.getComponentType();
        }

        @Override
        public void visitArrayAccessExpression(PsiArrayAccessExpression accessExpression) {
            PsiExpression indexExpression = accessExpression.getIndexExpression();
            if (this.wrappedExpression.equals(indexExpression)) {
                this.expectedType = PsiType.INT;
            }
        }

        @Override
        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression polyadicExpression) {
            PsiExpression[] operands;
            if (polyadicExpression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(3);
            }
            if ((operands = polyadicExpression.getOperands()).length < 2) {
                this.expectedType = null;
                return;
            }
            for (PsiExpression operand : operands) {
                if (operand != null && operand.getType() != null) continue;
                this.expectedType = null;
                return;
            }
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            PsiType type = polyadicExpression.getType();
            PsiType wrappedExpressionType = this.wrappedExpression.getType();
            if (TypeUtils.isJavaLangString(type) || ExpectedTypeVisitor.isArithmeticOperation(tokenType) || ExpectedTypeVisitor.isBooleanOperation(tokenType)) {
                this.expectedType = type;
            } else if (ExpectedTypeVisitor.isShiftOperation(tokenType)) {
                this.expectedType = TypeUtils.unaryNumericPromotion(wrappedExpressionType);
            } else if (ComparisonUtils.isEqualityComparison(polyadicExpression)) {
                PsiExpression operand1 = operands[0];
                PsiExpression operand2 = operands[1];
                if (operand1 == this.wrappedExpression || operand2 == this.wrappedExpression) {
                    PsiType type1 = operand1.getType();
                    PsiType type2 = operand2.getType();
                    this.expectedType = type1 instanceof PsiPrimitiveType ? this.expectedPrimitiveType((PsiPrimitiveType)type1, type2) : (type2 instanceof PsiPrimitiveType ? this.expectedPrimitiveType((PsiPrimitiveType)type2, type1) : TypeUtils.getObjectType(this.wrappedExpression));
                } else {
                    this.expectedType = TypeConversionUtil.isBooleanType(wrappedExpressionType) ? PsiType.BOOLEAN : null;
                }
            } else if (ComparisonUtils.isComparisonOperation(tokenType)) {
                if (operands.length != 2) {
                    this.expectedType = null;
                    return;
                }
                if (!TypeConversionUtil.isPrimitiveAndNotNull(wrappedExpressionType) && PsiPrimitiveType.getUnboxedType(wrappedExpressionType) == null) {
                    return;
                }
                this.expectedType = TypeConversionUtil.binaryNumericPromotion(operands[0].getType(), operands[1].getType());
            } else {
                this.expectedType = null;
            }
        }

        private PsiType expectedPrimitiveType(PsiPrimitiveType type1, PsiType type2) {
            if (TypeConversionUtil.isNumericType(type1)) {
                return TypeConversionUtil.isNumericType(type2) ? TypeConversionUtil.binaryNumericPromotion(type1, type2) : null;
            }
            if (PsiType.BOOLEAN.equals(type1)) {
                return TypeConversionUtil.isBooleanType(type2) ? PsiType.BOOLEAN : null;
            }
            if (PsiType.NULL.equals(type1)) {
                return TypeUtils.getObjectType(this.wrappedExpression);
            }
            return null;
        }

        @Override
        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            PsiType type;
            if (expression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(4);
            }
            this.expectedType = (type = expression.getType()) instanceof PsiPrimitiveType ? type : PsiPrimitiveType.getUnboxedType(type);
        }

        @Override
        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            PsiType type;
            if (expression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(5);
            }
            this.expectedType = (type = expression.getType()) instanceof PsiPrimitiveType ? type : PsiPrimitiveType.getUnboxedType(type);
        }

        @Override
        public void visitSwitchStatement(PsiSwitchStatement statement) {
            PsiExpression expression = statement.getExpression();
            if (expression == null) {
                return;
            }
            PsiType type = expression.getType();
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(type);
            this.expectedType = unboxedType != null ? unboxedType : type;
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            if (this.reportCasts) {
                this.expectedType = expression.getType();
            }
        }

        @Override
        public void visitWhileStatement(@NotNull PsiWhileStatement whileStatement) {
            if (whileStatement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(6);
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        @Override
        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(7);
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        @Override
        public void visitForeachStatement(PsiForeachStatement statement) {
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null) {
                this.expectedType = null;
                return;
            }
            PsiType iteratedValueType = iteratedValue.getType();
            if (!(iteratedValueType instanceof PsiClassType)) {
                this.expectedType = null;
                return;
            }
            PsiClassType classType = (PsiClassType)iteratedValueType;
            PsiType[] parameters = classType.getParameters();
            PsiClass iterableClass = ClassUtils.findClass("java.lang.Iterable", statement);
            this.expectedType = iterableClass == null ? null : JavaPsiFacade.getElementFactory(statement.getProject()).createType(iterableClass, parameters);
        }

        @Override
        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(8);
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        @Override
        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(9);
            }
            this.expectedType = PsiType.BOOLEAN;
        }

        @Override
        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(10);
            }
            this.expectedType = TypeUtils.getObjectType(statement);
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(11);
            }
            PsiExpression rExpression = assignment.getRExpression();
            IElementType tokenType = assignment.getOperationTokenType();
            PsiExpression lExpression = assignment.getLExpression();
            PsiType lType = lExpression.getType();
            this.expectedType = rExpression != null && this.wrappedExpression.equals(rExpression) ? (lType == null ? null : (TypeUtils.isJavaLangString(lType) ? (JavaTokenType.PLUSEQ.equals(tokenType) ? rExpression.getType() : lType) : (ExpectedTypeVisitor.isOperatorAssignmentOperation(tokenType) ? (lType instanceof PsiPrimitiveType ? lType : PsiPrimitiveType.getUnboxedType(lType)) : lType))) : (ExpectedTypeVisitor.isOperatorAssignmentOperation(tokenType) && !(lType instanceof PsiPrimitiveType) ? PsiPrimitiveType.getUnboxedType(lType) : lType);
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression conditional) {
            PsiExpression condition = conditional.getCondition();
            this.expectedType = condition.equals(this.wrappedExpression) ? PsiType.BOOLEAN : conditional.getType();
        }

        @Override
        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (returnStatement == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(12);
            }
            this.expectedType = PsiTypesUtil.getMethodReturnType(returnStatement);
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression expression) {
            this.expectedType = LambdaUtil.getFunctionalInterfaceReturnType(expression);
        }

        @Override
        public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
            this.expectedType = TypeUtils.getObjectType(expression);
        }

        @Override
        public void visitDeclarationStatement(PsiDeclarationStatement declaration) {
            PsiElement[] declaredElements;
            for (PsiElement declaredElement : declaredElements = declaration.getDeclaredElements()) {
                PsiVariable variable;
                PsiExpression initializer;
                if (!(declaredElement instanceof PsiVariable) || !this.wrappedExpression.equals(initializer = (variable = (PsiVariable)declaredElement).getInitializer())) continue;
                this.expectedType = variable.getType();
                return;
            }
        }

        @Override
        public void visitExpressionList(PsiExpressionList expressionList) {
            JavaResolveResult result = ExpectedTypeVisitor.findCalledMethod(expressionList);
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) {
                this.expectedType = null;
            } else {
                int parameterPosition = ExpectedTypeVisitor.getParameterPosition(expressionList, this.wrappedExpression);
                this.expectedType = ExpectedTypeVisitor.getTypeOfParameter(result, parameterPosition);
            }
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression) {
            PsiExpression[] arrayDimensions;
            for (PsiExpression arrayDimension : arrayDimensions = expression.getArrayDimensions()) {
                if (!this.wrappedExpression.equals(arrayDimension)) continue;
                this.expectedType = PsiType.INT;
            }
        }

        @NotNull
        private static JavaResolveResult findCalledMethod(PsiExpressionList expressionList) {
            PsiElement grandParent;
            PsiElement parent = expressionList.getParent();
            if (parent instanceof PsiCall) {
                PsiCall call = (PsiCall)parent;
                JavaResolveResult javaResolveResult = call.resolveMethodGenerics();
                if (javaResolveResult == null) {
                    ExpectedTypeVisitor.$$$reportNull$$$0(13);
                }
                return javaResolveResult;
            }
            if (parent instanceof PsiAnonymousClass && (grandParent = parent.getParent()) instanceof PsiCallExpression) {
                PsiCallExpression callExpression = (PsiCallExpression)grandParent;
                JavaResolveResult javaResolveResult = callExpression.resolveMethodGenerics();
                if (javaResolveResult == null) {
                    ExpectedTypeVisitor.$$$reportNull$$$0(14);
                }
                return javaResolveResult;
            }
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(15);
            }
            return javaResolveResult;
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(16);
            }
            if (this.calculateTypeForComplexReferences) {
                Project project = referenceExpression.getProject();
                JavaResolveResult resolveResult = referenceExpression.advancedResolve(false);
                PsiElement element = resolveResult.getElement();
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    if (!ExpectedTypeVisitor.isAccessibleFrom(field, referenceExpression)) {
                        return;
                    }
                    PsiClass aClass = field.getContainingClass();
                    if (aClass == null) {
                        return;
                    }
                    PsiElementFactory factory = psiFacade.getElementFactory();
                    this.expectedType = factory.createType(aClass, substitutor);
                } else if (element instanceof PsiMethod) {
                    PsiClass aClass;
                    PsiMethodCallExpression methodCallExpression;
                    PsiType type;
                    PsiElement parent = referenceExpression.getParent();
                    PsiType returnType = parent instanceof PsiMethodCallExpression ? (!PsiType.VOID.equals(type = (methodCallExpression = (PsiMethodCallExpression)parent).getType()) ? ExpectedTypeUtils.findExpectedType(methodCallExpression, true) : null) : null;
                    PsiMethod method = (PsiMethod)element;
                    PsiMethod superMethod = ExpectedTypeVisitor.findDeepestVisibleSuperMethod(method, returnType, referenceExpression);
                    if (superMethod != null) {
                        aClass = superMethod.getContainingClass();
                        if (aClass == null) {
                            return;
                        }
                        substitutor = TypeConversionUtil.getSuperClassSubstitutor(aClass, method.getContainingClass(), substitutor);
                    } else {
                        aClass = method.getContainingClass();
                        if (aClass == null) {
                            return;
                        }
                    }
                    PsiElementFactory factory = psiFacade.getElementFactory();
                    this.expectedType = factory.createType(aClass, substitutor);
                } else {
                    this.expectedType = null;
                }
            }
        }

        @Nullable
        private static PsiMethod findDeepestVisibleSuperMethod(PsiMethod method, PsiType returnType, PsiElement element) {
            if (method.isConstructor()) {
                return null;
            }
            if (method.hasModifierProperty("static")) {
                return null;
            }
            if (method.hasModifierProperty("private")) {
                return null;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            HashSet<PsiClassType> thrownTypes = ContainerUtil.newHashSet(throwsList.getReferencedTypes());
            PsiMethod[] superMethods = aClass.findMethodsBySignature(method, true);
            PsiMethod topSuper = null;
            PsiClass topSuperContainingClass = null;
            block0: for (PsiMethod superMethod : superMethods) {
                PsiClassType[] superThrownTypes;
                PsiType superReturnType;
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null || aClass.equals(superClass) || !ExpectedTypeVisitor.isAccessibleFrom(superMethod, element) || returnType != null && ((superReturnType = superMethod.getReturnType()) == null || !returnType.isAssignableFrom(superReturnType)) || topSuper != null && superClass.isInheritor(topSuperContainingClass, true)) continue;
                PsiReferenceList superThrowsList = superMethod.getThrowsList();
                for (PsiClassType superThrownType : superThrownTypes = superThrowsList.getReferencedTypes()) {
                    if (!ExceptionUtil.isUncheckedException(superThrownType) && !thrownTypes.contains(superThrownType)) continue block0;
                }
                topSuper = superMethod;
                topSuperContainingClass = superClass;
            }
            return topSuper;
        }

        private static boolean isAccessibleFrom(PsiMember member, PsiElement referencingLocation) {
            if (member.hasModifierProperty("public")) {
                return true;
            }
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            PsiClass referencingClass = ClassUtils.getContainingClass(referencingLocation);
            if (referencingClass == null) {
                return false;
            }
            if (referencingClass.equals(containingClass)) {
                return true;
            }
            if (member.hasModifierProperty("private")) {
                return false;
            }
            return ClassUtils.inSamePackage(containingClass, referencingLocation);
        }

        private static boolean isArithmeticOperation(@NotNull IElementType sign) {
            if (sign == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(17);
            }
            return arithmeticOps.contains(sign);
        }

        private static boolean isBooleanOperation(@NotNull IElementType sign) {
            if (sign == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(18);
            }
            return booleanOps.contains(sign);
        }

        private static boolean isShiftOperation(@NotNull IElementType sign) {
            if (sign == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(19);
            }
            return shiftOps.contains(sign);
        }

        private static boolean isOperatorAssignmentOperation(@NotNull IElementType sign) {
            if (sign == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(20);
            }
            return operatorAssignmentOps.contains(sign);
        }

        private static int getParameterPosition(@NotNull PsiExpressionList expressionList, PsiExpression expression) {
            if (expressionList == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(21);
            }
            return ArrayUtil.indexOf(expressionList.getExpressions(), expression);
        }

        @Nullable
        private static PsiType getTypeOfParameter(@NotNull JavaResolveResult result, int parameterPosition) {
            if (result == null) {
                ExpectedTypeVisitor.$$$reportNull$$$0(22);
            }
            if (parameterPosition < 0) {
                return null;
            }
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) {
                return null;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length == 0) {
                return null;
            }
            boolean isVarargs = result instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).getApplicabilityLevel() == 2;
            PsiType parameterType = PsiTypesUtil.getParameterType(parameters, parameterPosition, isVarargs);
            PsiSubstitutor substitutor = result.getSubstitutor();
            PsiType type = GenericsUtil.getVariableTypeByExpressionType(substitutor.substitute(parameterType));
            if (type == null) {
                return null;
            }
            TypeStringCreator typeStringCreator = new TypeStringCreator();
            type.accept(typeStringCreator);
            if (typeStringCreator.isModified()) {
                PsiManager manager = method.getManager();
                Project project = manager.getProject();
                PsiElementFactory factory = JavaPsiFacade.getInstance(project).getElementFactory();
                try {
                    String typeString = typeStringCreator.getTypeString();
                    return factory.createTypeFromText(typeString, method);
                }
                catch (IncorrectOperationException e) {
                    throw new AssertionError((Object)("incorrect type string generated from " + type + ": " + e.getMessage()));
                }
            }
            return type;
        }

        static {
            arithmeticOps.add(JavaTokenType.PLUS);
            arithmeticOps.add(JavaTokenType.MINUS);
            arithmeticOps.add(JavaTokenType.ASTERISK);
            arithmeticOps.add(JavaTokenType.DIV);
            arithmeticOps.add(JavaTokenType.PERC);
            booleanOps.add(JavaTokenType.ANDAND);
            booleanOps.add(JavaTokenType.AND);
            booleanOps.add(JavaTokenType.XOR);
            booleanOps.add(JavaTokenType.OROR);
            booleanOps.add(JavaTokenType.OR);
            shiftOps.add(JavaTokenType.LTLT);
            shiftOps.add(JavaTokenType.GTGT);
            shiftOps.add(JavaTokenType.GTGTGT);
            operatorAssignmentOps.add(JavaTokenType.PLUSEQ);
            operatorAssignmentOps.add(JavaTokenType.MINUSEQ);
            operatorAssignmentOps.add(JavaTokenType.ASTERISKEQ);
            operatorAssignmentOps.add(JavaTokenType.DIVEQ);
            operatorAssignmentOps.add(JavaTokenType.ANDEQ);
            operatorAssignmentOps.add(JavaTokenType.OREQ);
            operatorAssignmentOps.add(JavaTokenType.XOREQ);
            operatorAssignmentOps.add(JavaTokenType.PERCEQ);
            operatorAssignmentOps.add(JavaTokenType.LTLTEQ);
            operatorAssignmentOps.add(JavaTokenType.GTGTEQ);
            operatorAssignmentOps.add(JavaTokenType.GTGTGTEQ);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappedExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "polyadicExpression";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "whileStatement";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatement";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sign";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionList";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/ExpectedTypeUtils$ExpectedTypeVisitor";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findCalledMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitField";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPolyadicExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPrefixExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPostfixExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitWhileStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitForStatement";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitIfStatement";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitDoWhileStatement";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitSynchronizedStatement";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAssignmentExpression";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReturnStatement";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReferenceExpression";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "isArithmeticOperation";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "isBooleanOperation";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "isShiftOperation";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "isOperatorAssignmentOperation";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getParameterPosition";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeOfParameter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class TypeStringCreator
        extends PsiTypeVisitor<Object> {
            private final StringBuilder typeString = new StringBuilder();
            private boolean modified = false;

            private TypeStringCreator() {
            }

            @Override
            public Object visitType(PsiType type) {
                this.typeString.append(type.getCanonicalText());
                return super.visitType(type);
            }

            @Override
            public Object visitWildcardType(PsiWildcardType wildcardType) {
                PsiClassType classType;
                PsiClass aClass;
                PsiType extendsBound;
                if (wildcardType.isExtends() && (extendsBound = wildcardType.getExtendsBound()) instanceof PsiClassType && (aClass = (classType = (PsiClassType)extendsBound).resolve()) != null && aClass.hasModifierProperty("final")) {
                    this.modified = true;
                    return super.visitClassType(classType);
                }
                return super.visitWildcardType(wildcardType);
            }

            @Override
            public Object visitClassType(PsiClassType classType) {
                PsiClassType rawType = classType.rawType();
                this.typeString.append(rawType.getCanonicalText());
                PsiType[] parameterTypes = classType.getParameters();
                if (parameterTypes.length > 0) {
                    this.typeString.append('<');
                    PsiType parameterType1 = parameterTypes[0];
                    if (parameterType1 != null) {
                        parameterType1.accept(this);
                    }
                    for (int i2 = 1; i2 < parameterTypes.length; ++i2) {
                        this.typeString.append(',');
                        PsiType parameterType = parameterTypes[i2];
                        if (parameterType == null) continue;
                        parameterType.accept(this);
                    }
                    this.typeString.append('>');
                }
                return null;
            }

            public String getTypeString() {
                return this.typeString.toString();
            }

            public boolean isModified() {
                return this.modified;
            }
        }
    }
}

