/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryUtil {
    private LibraryUtil() {
    }

    public static boolean isTypeInLibrary(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        return LibraryUtil.classIsInLibrary(aClass);
    }

    public static boolean classIsInLibrary(@Nullable PsiClass aClass) {
        return aClass instanceof PsiCompiledElement;
    }

    public static boolean callOnLibraryMethod(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            LibraryUtil.$$$reportNull$$$0(0);
        }
        PsiMethod method = expression.resolveMethod();
        return method instanceof PsiCompiledElement;
    }

    public static boolean isOverrideOfLibraryMethod(@NotNull PsiMethod method) {
        PsiMethod[] superMethods;
        if (method == null) {
            LibraryUtil.$$$reportNull$$$0(1);
        }
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            PsiClass containingClass = superMethod.getContainingClass();
            if (LibraryUtil.classIsInLibrary(containingClass)) {
                return true;
            }
            if (!LibraryUtil.isOverrideOfLibraryMethod(superMethod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverrideOfLibraryMethodParameter(@Nullable PsiVariable variable) {
        if (!(variable instanceof PsiParameter)) {
            return false;
        }
        PsiParameter parameter = (PsiParameter)variable;
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)scope;
        return LibraryUtil.isOverrideOfLibraryMethod(method);
    }

    public static boolean isOnlyLibraryCodeUsed(PsiElement element) {
        if (element == null) {
            return false;
        }
        final Ref<Boolean> libraryCode = Ref.create(Boolean.TRUE);
        element.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (!((Boolean)libraryCode.get()).booleanValue()) {
                    return;
                }
                super.visitReferenceExpression(expression);
                PsiElement target = expression.resolve();
                if (!(target instanceof PsiCompiledElement)) {
                    libraryCode.set(Boolean.FALSE);
                }
            }
        });
        return libraryCode.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/LibraryUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "callOnLibraryMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isOverrideOfLibraryMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

