/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddSerialVersionUIDFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class SerializableHasSerialVersionUIDFieldInspectionBase
extends SerializableInspectionBase {
    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("serial" == null) {
            SerializableHasSerialVersionUIDFieldInspectionBase.$$$reportNull$$$0(0);
        }
        return "serial";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.class.without.serialversionuid.display.name", new Object[0]);
        if (string == null) {
            SerializableHasSerialVersionUIDFieldInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("serializable.class.without.serialversionuid.problem.descriptor", new Object[0]);
        if (string == null) {
            SerializableHasSerialVersionUIDFieldInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddSerialVersionUIDFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableHasSerialVersionUIDFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/SerializableHasSerialVersionUIDFieldInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SerializableHasSerialVersionUIDFieldVisitor
    extends BaseInspectionVisitor {
        private SerializableHasSerialVersionUIDFieldVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                SerializableHasSerialVersionUIDFieldVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            if (SerializableHasSerialVersionUIDFieldInspectionBase.this.ignoreAnonymousInnerClasses && aClass instanceof PsiAnonymousClass) {
                return;
            }
            PsiField serialVersionUIDField = aClass.findFieldByName("serialVersionUID", false);
            if (serialVersionUIDField != null) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            if (SerializationUtils.hasWriteReplace(aClass)) {
                return;
            }
            if (SerializableHasSerialVersionUIDFieldInspectionBase.this.isIgnoredSubclass(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/SerializableHasSerialVersionUIDFieldInspectionBase$SerializableHasSerialVersionUIDFieldVisitor", "visitClass"));
        }
    }
}

